/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.archive;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.NoSuchElementException;
import uk.gov.nationalarchives.droid.core.interfaces.archive.ArchiveIterationException;

public abstract class ArchiveInputStreamIterator<T, U extends InputStream>
implements Iterator<T> {
    private final U in;
    private T next;

    protected ArchiveInputStreamIterator(U in) {
        this.in = in;
    }

    @Override
    public final boolean hasNext() {
        if (this.next == null) {
            try {
                this.next = this.getNextEntry();
            }
            catch (IOException e) {
                throw new ArchiveIterationException(e.getMessage(), e);
            }
        }
        return this.next != null;
    }

    protected final U getInputStream() {
        return this.in;
    }

    protected abstract T getNextEntry() throws IOException;

    @Override
    public final T next() {
        T nextEntry;
        if (this.next != null) {
            nextEntry = this.next;
            this.next = null;
        } else {
            try {
                nextEntry = this.getNextEntry();
            }
            catch (IOException e) {
                throw new ArchiveIterationException(e.getMessage(), e);
            }
        }
        if (nextEntry == null) {
            throw new NoSuchElementException();
        }
        return nextEntry;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException("Remove is not supported.");
    }
}

