/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.security.UserPrincipalRetriever;
import com.exlibris.core.infra.svc.api.security.RemoteAuthenticationException;
import com.exlibris.core.infra.svc.api.utils.AuthenticationUtil;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import java.util.Set;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.UsernamePasswordAuthenticationFilter;

public class JwtAuthenticationFilter
extends UsernamePasswordAuthenticationFilter {
    private static final ExLogger logger = ExLogger.getExLogger(JwtAuthenticationFilter.class);
    public static final String REPORT = "/report";
    public static final String DEPOSIT = "/deposit";

    protected String obtainUsername(HttpServletRequest request) {
        return ":JwtAuthentication:";
    }

    protected String obtainPassword(HttpServletRequest request) {
        return request.getParameter("Authorization");
    }

    protected boolean requiresAuthentication(HttpServletRequest request, HttpServletResponse response) {
        return StringUtils.isNotBlank((String)request.getParameter("Authorization"));
    }

    public Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) throws AuthenticationException {
        boolean isAuthenticated = UserPrincipalRetriever.getUserPrincipal() != null;
        boolean isReportLink = REPORT.equalsIgnoreCase(request.getContextPath());
        boolean isDepositLink = DEPOSIT.equalsIgnoreCase(request.getContextPath());
        if (isAuthenticated && !isDepositLink && !isReportLink) {
            this.redirectWithoutJwt(request, response);
            return null;
        }
        this.setPostOnly(false);
        return super.attemptAuthentication(request, response);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(authResult);
        this.redirectWithoutJwt(request, response);
    }

    protected void unsuccessfulAuthentication(HttpServletRequest request, HttpServletResponse response, AuthenticationException exception) throws IOException, ServletException {
        if (exception.getCause() instanceof RemoteAuthenticationException) {
            response.setStatus(((RemoteAuthenticationException)exception.getCause()).getResponseCode());
            request.getRequestDispatcher("/views/remoteReportsError.jsp").forward((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.redirectWithoutJwt(request, response);
    }

    protected void setDetails(HttpServletRequest request, UsernamePasswordAuthenticationToken authRequest) {
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        if (REPORT.equalsIgnoreCase(request.getContextPath())) {
            parameters.put("authentication_mode", "remotereports");
        }
        HashMap<String, String> authenticationParameters = new HashMap<String, String>();
        authenticationParameters.put("userIp", AuthenticationUtil.getUserIp(request));
        parameters.put("authenticationParameters", authenticationParameters);
        authRequest.setDetails(parameters);
    }

    private void redirectWithoutJwt(HttpServletRequest request, HttpServletResponse response) {
        try {
            String urlParams = "?";
            Set keySet = request.getParameterMap().keySet();
            for (String parameter : keySet) {
                if ("Authorization".equalsIgnoreCase(parameter)) continue;
                urlParams = urlParams + parameter + "=" + request.getParameter(parameter) + "&";
            }
            String baseUrl = StringUtils.substringBefore((String)AuthenticationUtil.getServerUrl(request), (String)request.getContextPath());
            String urlWithoutJwt = baseUrl + request.getRequestURI() + urlParams.substring(0, urlParams.length() - 1);
            response.sendRedirect(URI.create(urlWithoutJwt).normalize().toString());
        }
        catch (IOException e) {
            logger.error("Failed to redirect", e, new String[0]);
        }
    }
}

