/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.dnx;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.ReflectionUtil;
import com.exlibris.core.infra.svc.api.common.DateHandler;
import com.exlibris.digitool.common.dnx.DnxDocument;
import com.exlibris.digitool.common.dnx.DnxSection;
import com.exlibris.digitool.common.dnx.DnxSectionRecord;
import java.beans.IntrospectionException;
import java.lang.reflect.InvocationTargetException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;

public class DnxDocumentHelper {
    private static ExLogger logger = ExLogger.getExLogger(DnxDocumentHelper.class);
    private DnxDocument document = null;

    public DnxDocumentHelper(DnxDocument document) {
        this.document = document;
    }

    public DnxDocument getDocument() {
        return this.document;
    }

    public void setDocument(DnxDocument document) {
        this.document = document;
    }

    public List<String> getDnxValuesFromPath(String path) {
        String[] splitPath;
        ArrayList<String> v = new ArrayList<String>(2);
        for (String aPath : splitPath = path.split("\\|")) {
            String value;
            try {
                value = ReflectionUtil.property2value((Object)this, aPath);
            }
            catch (IntrospectionException e) {
                logger.error("Skipping, Got Exception while parsing Dnx Metadata for  xpath=" + path, e, new String[0]);
                return v;
            }
            catch (IllegalAccessException e) {
                logger.error("Skipping, Got Exception while parsing Dnx Metadata for  xpath=" + path, e, new String[0]);
                return v;
            }
            catch (InvocationTargetException e) {
                logger.error("Skipping, Got Exception while parsing Dnx Metadata for  xpath=" + path, e, new String[0]);
                return v;
            }
            v.add(value);
        }
        return v;
    }

    public GeneralIECharacteristics getGeneralIECharacteristics() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("generalIECharacteristics");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new GeneralIECharacteristics(recordList.get(0));
    }

    public void setGeneralIECharacteristics(GeneralIECharacteristics obj) {
        this.document.deleteSection("generalIECharacteristics");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("generalIECharacteristics");
            dnxSection.updateSectionKey("submissionReason", obj.getSubmissionReason());
            dnxSection.updateSectionKey("status", obj.getStatus());
            dnxSection.updateSectionKey("statusDate", obj.getInternalStatusDate());
            dnxSection.updateSectionKey("IEEntityType", obj.getIEEntityType());
            dnxSection.updateSectionKey("Version", obj.getVersion());
            dnxSection.updateSectionKey("UserDefinedA", obj.getUserDefinedA());
            dnxSection.updateSectionKey("UserDefinedB", obj.getUserDefinedB());
            dnxSection.updateSectionKey("UserDefinedC", obj.getUserDefinedC());
        }
    }

    public GeneralRepCharacteristics getGeneralRepCharacteristics() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("generalRepCharacteristics");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new GeneralRepCharacteristics(recordList.get(0));
    }

    public void setGeneralRepCharacteristics(GeneralRepCharacteristics obj) {
        this.document.deleteSection("generalRepCharacteristics");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("generalRepCharacteristics");
            dnxSection.updateSectionKey("label", obj.getLabel());
            dnxSection.updateSectionKey("preservationType", obj.getPreservationType());
            dnxSection.updateSectionKey("usageType", obj.getUsageType());
            dnxSection.updateSectionKey("representationEntityType", obj.getRepresentationEntityType());
            dnxSection.updateSectionKey("contentType", obj.getContentType());
            dnxSection.updateSectionKey("contextType", obj.getContextType());
            dnxSection.updateSectionKey("hardwareUsed", obj.getHardwareUsed());
            dnxSection.updateSectionKey("physicalCarrierMedia", obj.getPhysicalCarrierMedia());
            dnxSection.updateSectionKey("derivedFromId", obj.getDerivedFromId());
            dnxSection.updateSectionKey("deliveryPriority", obj.getDeliveryPriority());
            dnxSection.updateSectionKey("orderingSequence", obj.getOrderingSequence());
            dnxSection.updateSectionKey("DigitalOriginal", obj.getDigitalOriginal());
            dnxSection.updateSectionKey("RevisionNumber", obj.getRevisionNumber());
            dnxSection.updateSectionKey("RepresentationCode", obj.getRepresentationCode());
            dnxSection.updateSectionKey("TaskID", obj.getTaskID());
            dnxSection.updateSectionKey("RepresentationOriginalName", obj.getRepresentationOriginalName());
            dnxSection.updateSectionKey("UserDefinedA", obj.getUserDefinedA());
            dnxSection.updateSectionKey("UserDefinedB", obj.getUserDefinedB());
            dnxSection.updateSectionKey("UserDefinedC", obj.getUserDefinedC());
        }
    }

    public GeneralFileCharacteristics getGeneralFileCharacteristics() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("generalFileCharacteristics");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new GeneralFileCharacteristics(recordList.get(0));
    }

    public void setGeneralFileCharacteristics(GeneralFileCharacteristics obj) {
        this.document.deleteSection("generalFileCharacteristics");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("generalFileCharacteristics");
            dnxSection.updateSectionKey("label", obj.getLabel());
            dnxSection.updateSectionKey("note", obj.getNote());
            dnxSection.updateSectionKey("fileCreationDate", obj.getInternalFileCreationDate());
            dnxSection.updateSectionKey("fileModificationDate", obj.getInternalFileModificationDate());
            dnxSection.updateSectionKey("FileEntityType", obj.getFileEntityType());
            dnxSection.updateSectionKey("compositionLevel", obj.getCompositionLevel());
            dnxSection.updateSectionKey("fileLocationType", obj.getFileLocationType());
            dnxSection.updateSectionKey("fileLocation", obj.getFileLocation());
            dnxSection.updateSectionKey("fileOriginalName", obj.getFileOriginalName());
            dnxSection.updateSectionKey("fileOriginalPath", obj.getFileOriginalPath());
            dnxSection.updateSectionKey("fileOriginalID", obj.getFileOriginalID());
            dnxSection.updateSectionKey("fileExtension", obj.getFileExtension());
            dnxSection.updateSectionKey("fileMIMEType", obj.getFileMIMEType());
            dnxSection.updateSectionKey("fileSizeBytes", obj.getFileSizeBytes());
            dnxSection.updateSectionKey("formatLibraryId", obj.getFormatLibraryId());
            dnxSection.updateSectionKey("riskLibraryIdentifiers", obj.getRiskLibraryIdentifiers());
        }
    }

    public ObjectCharacteristics getObjectCharacteristics() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("objectCharacteristics");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new ObjectCharacteristics(recordList.get(0));
    }

    public void setObjectCharacteristics(ObjectCharacteristics obj) {
        this.document.deleteSection("objectCharacteristics");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("objectCharacteristics");
            dnxSection.updateSectionKey("objectType", obj.getObjectType());
            dnxSection.updateSectionKey("parentID", obj.getParentID());
            dnxSection.updateSectionKey("groupID", obj.getGroupID());
            dnxSection.updateSectionKey("creationDate", obj.getInternalCreationDate());
            dnxSection.updateSectionKey("createdBy", obj.getCreatedBy());
            dnxSection.updateSectionKey("modificationDate", obj.getInternalModificationDate());
            dnxSection.updateSectionKey("modifiedBy", obj.getModifiedBy());
            dnxSection.updateSectionKey("owner", obj.getOwner());
        }
    }

    public CMS getCMS() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("CMS");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new CMS(recordList.get(0));
    }

    public void setCMS(CMS obj) {
        this.document.deleteSection("CMS");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("CMS");
            dnxSection.updateSectionKey("system", obj.getSystem());
            dnxSection.updateSectionKey("recordId", obj.getRecordId());
            dnxSection.updateSectionKey("mId", obj.getMId());
        }
    }

    public WebHarvesting getWebHarvesting() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("webHarvesting");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new WebHarvesting(recordList.get(0));
    }

    public void setWebHarvesting(WebHarvesting obj) {
        this.document.deleteSection("webHarvesting");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("webHarvesting");
            dnxSection.updateSectionKey("primarySeedURL", obj.getPrimarySeedURL());
            dnxSection.updateSectionKey("WCTIdentifier", obj.getWCTIdentifier());
            dnxSection.updateSectionKey("targetName", obj.getTargetName());
            dnxSection.updateSectionKey("group", obj.getGroup());
            dnxSection.updateSectionKey("harvestDate", obj.getInternalHarvestDate());
            dnxSection.updateSectionKey("harvestTime", obj.getInternalHarvestTime());
        }
    }

    public List<InternalIdentifier> getInternalIdentifiers() {
        ArrayList<InternalIdentifier> internalIdentifiers = new ArrayList<InternalIdentifier>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("internalIdentifier");
        if (recordList == null || recordList.size() == 0) {
            return internalIdentifiers;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            InternalIdentifier internalIdentifier = new InternalIdentifier(dnxSectionRecord);
            internalIdentifiers.add(internalIdentifier);
        }
        return internalIdentifiers;
    }

    public void setInternalIdentifiers(List<InternalIdentifier> list) {
        this.document.deleteSection("internalIdentifier");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("internalIdentifier");
            for (InternalIdentifier obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("internalIdentifierType", obj.getInternalIdentifierType());
                dnxSectionRecord.updateKey("internalIdentifierValue", obj.getInternalIdentifierValue());
            }
        }
    }

    public List<ObjectIdentifier> getObjectIdentifiers() {
        ArrayList<ObjectIdentifier> objectIdentifiers = new ArrayList<ObjectIdentifier>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("objectIdentifier");
        if (recordList == null || recordList.size() == 0) {
            return objectIdentifiers;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            ObjectIdentifier objectIdentifier = new ObjectIdentifier(dnxSectionRecord);
            objectIdentifiers.add(objectIdentifier);
        }
        return objectIdentifiers;
    }

    public void setObjectIdentifiers(List<ObjectIdentifier> list) {
        this.document.deleteSection("objectIdentifier");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("objectIdentifier");
            for (ObjectIdentifier obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("objectIdentifierType", obj.getObjectIdentifierType());
                dnxSectionRecord.updateKey("objectIdentifierValue", obj.getObjectIdentifierValue());
            }
        }
    }

    public PreservationLevel getPreservationLevel() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("preservationLevel");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new PreservationLevel(recordList.get(0));
    }

    public void setPreservationLevel(PreservationLevel obj) {
        this.document.deleteSection("preservationLevel");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("preservationLevel");
            dnxSection.updateSectionKey("preservationLevelValue", obj.getPreservationLevelValue());
            dnxSection.updateSectionKey("preservationLevelRole", obj.getPreservationLevelRole());
            dnxSection.updateSectionKey("preservationLevelRationale", obj.getPreservationLevelRationale());
            dnxSection.updateSectionKey("preservationLevelDateAssigned", obj.getInternalPreservationLevelDateAssigned());
            dnxSection.updateSectionKey("preservationLevelType", obj.getPreservationLevelType());
        }
    }

    public List<SignificantProperties> getSignificantPropertiess() {
        ArrayList<SignificantProperties> significantPropertiess = new ArrayList<SignificantProperties>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("significantProperties");
        if (recordList == null || recordList.size() == 0) {
            return significantPropertiess;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            SignificantProperties significantProperties = new SignificantProperties(dnxSectionRecord);
            significantPropertiess.add(significantProperties);
        }
        return significantPropertiess;
    }

    public void setSignificantPropertiess(List<SignificantProperties> list) {
        this.document.deleteSection("significantProperties");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("significantProperties");
            for (SignificantProperties obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("significantPropertiesType", obj.getSignificantPropertiesType());
                dnxSectionRecord.updateKey("significantPropertiesValue", obj.getSignificantPropertiesValue());
                dnxSectionRecord.updateKey("significantPropertiesExtension", obj.getSignificantPropertiesExtension());
            }
        }
    }

    public List<FileFixity> getFileFixitys() {
        ArrayList<FileFixity> fileFixitys = new ArrayList<FileFixity>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("fileFixity");
        if (recordList == null || recordList.size() == 0) {
            return fileFixitys;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            FileFixity fileFixity = new FileFixity(dnxSectionRecord);
            fileFixitys.add(fileFixity);
        }
        return fileFixitys;
    }

    public void setFileFixitys(List<FileFixity> list) {
        this.document.deleteSection("fileFixity");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("fileFixity");
            for (FileFixity obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("agent", obj.getAgent());
                dnxSectionRecord.updateKey("pluginName", obj.getPluginName());
                dnxSectionRecord.updateKey("fixityType", obj.getFixityType());
                dnxSectionRecord.updateKey("fixityValue", obj.getFixityValue());
            }
        }
    }

    public List<FileFormat> getFileFormats() {
        ArrayList<FileFormat> fileFormats = new ArrayList<FileFormat>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("fileFormat");
        if (recordList == null || recordList.size() == 0) {
            return fileFormats;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            FileFormat fileFormat = new FileFormat(dnxSectionRecord);
            fileFormats.add(fileFormat);
        }
        return fileFormats;
    }

    public void setFileFormats(List<FileFormat> list) {
        this.document.deleteSection("fileFormat");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("fileFormat");
            for (FileFormat obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("agent", obj.getAgent());
                dnxSectionRecord.updateKey("formatRegistry", obj.getFormatRegistry());
                dnxSectionRecord.updateKey("formatRegistryId", obj.getFormatRegistryId());
                dnxSectionRecord.updateKey("formatRegistryRole", obj.getFormatRegistryRole());
                dnxSectionRecord.updateKey("formatName", obj.getFormatName());
                dnxSectionRecord.updateKey("formatVersion", obj.getFormatVersion());
                dnxSectionRecord.updateKey("formatDescription", obj.getFormatDescription());
                dnxSectionRecord.updateKey("formatNote", obj.getFormatNote());
                dnxSectionRecord.updateKey("exactFormatIdentification", obj.getExactFormatIdentification());
                dnxSectionRecord.updateKey("mimeType", obj.getMimeType());
                dnxSectionRecord.updateKey("agentVersion", obj.getAgentVersion());
                dnxSectionRecord.updateKey("agentSignatureVersion", obj.getAgentSignatureVersion());
                dnxSectionRecord.updateKey("identificationMethod", obj.getIdentificationMethod());
                dnxSectionRecord.updateKey("formatLibraryVersion", obj.getFormatLibraryVersion());
            }
        }
    }

    public List<FileVirusCheck> getFileVirusChecks() {
        ArrayList<FileVirusCheck> fileVirusChecks = new ArrayList<FileVirusCheck>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("fileVirusCheck");
        if (recordList == null || recordList.size() == 0) {
            return fileVirusChecks;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            FileVirusCheck fileVirusCheck = new FileVirusCheck(dnxSectionRecord);
            fileVirusChecks.add(fileVirusCheck);
        }
        return fileVirusChecks;
    }

    public void setFileVirusChecks(List<FileVirusCheck> list) {
        this.document.deleteSection("fileVirusCheck");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("fileVirusCheck");
            for (FileVirusCheck obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("agent", obj.getAgent());
                dnxSectionRecord.updateKey("status", obj.getStatus());
                dnxSectionRecord.updateKey("content", obj.getContent());
            }
        }
    }

    public FileValidation getFileValidation() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("fileValidation");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new FileValidation(recordList.get(0));
    }

    public void setFileValidation(FileValidation obj) {
        this.document.deleteSection("fileValidation");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("fileValidation");
            dnxSection.updateSectionKey("agent", obj.getAgent());
            dnxSection.updateSectionKey("pluginName", obj.getPluginName());
            dnxSection.updateSectionKey("status", obj.getStatus());
            dnxSection.updateSectionKey("format", obj.getFormat());
            dnxSection.updateSectionKey("version", obj.getVersion());
            dnxSection.updateSectionKey("mimeType", obj.getMimeType());
            dnxSection.updateSectionKey("profile", obj.getProfile());
            dnxSection.updateSectionKey("isValid", obj.getIsValid());
            dnxSection.updateSectionKey("isWellFormed", obj.getIsWellFormed());
            dnxSection.updateSectionKey("errorMessage", obj.getErrorMessage());
        }
    }

    public List<VsOutcome> getVsOutcomes() {
        ArrayList<VsOutcome> vsOutcomes = new ArrayList<VsOutcome>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("vsOutcome");
        if (recordList == null || recordList.size() == 0) {
            return vsOutcomes;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            VsOutcome vsOutcome = new VsOutcome(dnxSectionRecord);
            vsOutcomes.add(vsOutcome);
        }
        return vsOutcomes;
    }

    public void setVsOutcomes(List<VsOutcome> list) {
        this.document.deleteSection("vsOutcome");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("vsOutcome");
            for (VsOutcome obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("checkDate", obj.getInternalCheckDate());
                dnxSectionRecord.updateKey("vsAgent", obj.getVsAgent());
                dnxSectionRecord.updateKey("type", obj.getType());
                dnxSectionRecord.updateKey("result", obj.getResult());
                dnxSectionRecord.updateKey("resultDetails", obj.getResultDetails());
                dnxSectionRecord.updateKey("vsEvaluation", obj.getVsEvaluation());
                dnxSectionRecord.updateKey("vsEvaluationDetails", obj.getVsEvaluationDetails());
            }
        }
    }

    public List<CreatingApplication> getCreatingApplications() {
        ArrayList<CreatingApplication> creatingApplications = new ArrayList<CreatingApplication>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("creatingApplication");
        if (recordList == null || recordList.size() == 0) {
            return creatingApplications;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            CreatingApplication creatingApplication = new CreatingApplication(dnxSectionRecord);
            creatingApplications.add(creatingApplication);
        }
        return creatingApplications;
    }

    public void setCreatingApplications(List<CreatingApplication> list) {
        this.document.deleteSection("creatingApplication");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("creatingApplication");
            for (CreatingApplication obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("creatingApplicationName", obj.getCreatingApplicationName());
                dnxSectionRecord.updateKey("creatingApplicationVersion", obj.getCreatingApplicationVersion());
                dnxSectionRecord.updateKey("dateCreatedByApplication", obj.getInternalDateCreatedByApplication());
                dnxSectionRecord.updateKey("creatingApplicationExtension", obj.getCreatingApplicationExtension());
            }
        }
    }

    public List<Inhibitors> getInhibitorss() {
        ArrayList<Inhibitors> inhibitorss = new ArrayList<Inhibitors>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("inhibitors");
        if (recordList == null || recordList.size() == 0) {
            return inhibitorss;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            Inhibitors inhibitors = new Inhibitors(dnxSectionRecord);
            inhibitorss.add(inhibitors);
        }
        return inhibitorss;
    }

    public void setInhibitorss(List<Inhibitors> list) {
        this.document.deleteSection("inhibitors");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("inhibitors");
            for (Inhibitors obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("inhibitorType", obj.getInhibitorType());
                dnxSectionRecord.updateKey("inhibitorTarget", obj.getInhibitorTarget());
                dnxSectionRecord.updateKey("inhibitorKey", obj.getInhibitorKey());
            }
        }
    }

    public List<ObjectCharacteristicsExtension> getObjectCharacteristicsExtensions() {
        ArrayList<ObjectCharacteristicsExtension> objectCharacteristicsExtensions = new ArrayList<ObjectCharacteristicsExtension>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("objectCharacteristicsExtension");
        if (recordList == null || recordList.size() == 0) {
            return objectCharacteristicsExtensions;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            ObjectCharacteristicsExtension objectCharacteristicsExtension = new ObjectCharacteristicsExtension(dnxSectionRecord);
            objectCharacteristicsExtensions.add(objectCharacteristicsExtension);
        }
        return objectCharacteristicsExtensions;
    }

    public void setObjectCharacteristicsExtensions(List<ObjectCharacteristicsExtension> list) {
        this.document.deleteSection("objectCharacteristicsExtension");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("objectCharacteristicsExtension");
            for (ObjectCharacteristicsExtension obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("objectCharacteristicsExtension", obj.getObjectCharacteristicsExtension());
            }
        }
    }

    public List<Environment> getEnvironments() {
        ArrayList<Environment> environments = new ArrayList<Environment>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("environment");
        if (recordList == null || recordList.size() == 0) {
            return environments;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            Environment environment = new Environment(dnxSectionRecord);
            environments.add(environment);
        }
        return environments;
    }

    public void setEnvironments(List<Environment> list) {
        this.document.deleteSection("environment");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("environment");
            for (Environment obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("environmentCharacteristic", obj.getEnvironmentCharacteristic());
                dnxSectionRecord.updateKey("environmentPurpose", obj.getEnvironmentPurpose());
                dnxSectionRecord.updateKey("environmentNote", obj.getEnvironmentNote());
            }
        }
    }

    public List<EnvironmentDependencies> getEnvironmentDependenciess() {
        ArrayList<EnvironmentDependencies> environmentDependenciess = new ArrayList<EnvironmentDependencies>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("environmentDependencies");
        if (recordList == null || recordList.size() == 0) {
            return environmentDependenciess;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            EnvironmentDependencies environmentDependencies = new EnvironmentDependencies(dnxSectionRecord);
            environmentDependenciess.add(environmentDependencies);
        }
        return environmentDependenciess;
    }

    public void setEnvironmentDependenciess(List<EnvironmentDependencies> list) {
        this.document.deleteSection("environmentDependencies");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("environmentDependencies");
            for (EnvironmentDependencies obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("dependencyName", obj.getDependencyName());
                dnxSectionRecord.updateKey("dependencyIdentifierType1", obj.getDependencyIdentifierType1());
                dnxSectionRecord.updateKey("dependencyIdentifierValue1", obj.getDependencyIdentifierValue1());
                dnxSectionRecord.updateKey("dependencyIdentifierType2", obj.getDependencyIdentifierType2());
                dnxSectionRecord.updateKey("dependencyIdentifierValue2", obj.getDependencyIdentifierValue2());
                dnxSectionRecord.updateKey("dependencyIdentifierType3", obj.getDependencyIdentifierType3());
                dnxSectionRecord.updateKey("dependencyIdentifierValue3", obj.getDependencyIdentifierValue3());
            }
        }
    }

    public List<EnvironmentSoftware> getEnvironmentSoftwares() {
        ArrayList<EnvironmentSoftware> environmentSoftwares = new ArrayList<EnvironmentSoftware>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("environmentSoftware");
        if (recordList == null || recordList.size() == 0) {
            return environmentSoftwares;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            EnvironmentSoftware environmentSoftware = new EnvironmentSoftware(dnxSectionRecord);
            environmentSoftwares.add(environmentSoftware);
        }
        return environmentSoftwares;
    }

    public void setEnvironmentSoftwares(List<EnvironmentSoftware> list) {
        this.document.deleteSection("environmentSoftware");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("environmentSoftware");
            for (EnvironmentSoftware obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("softwareName", obj.getSoftwareName());
                dnxSectionRecord.updateKey("softwareVersion", obj.getSoftwareVersion());
                dnxSectionRecord.updateKey("softwareType", obj.getSoftwareType());
                dnxSectionRecord.updateKey("softwareOtherInformation", obj.getSoftwareOtherInformation());
                dnxSectionRecord.updateKey("softwareDependancy", obj.getSoftwareDependancy());
            }
        }
    }

    public List<EnvSoftwareRegistry> getEnvSoftwareRegistrys() {
        ArrayList<EnvSoftwareRegistry> envSoftwareRegistrys = new ArrayList<EnvSoftwareRegistry>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("envSoftwareRegistry");
        if (recordList == null || recordList.size() == 0) {
            return envSoftwareRegistrys;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            EnvSoftwareRegistry envSoftwareRegistry = new EnvSoftwareRegistry(dnxSectionRecord);
            envSoftwareRegistrys.add(envSoftwareRegistry);
        }
        return envSoftwareRegistrys;
    }

    public void setEnvSoftwareRegistrys(List<EnvSoftwareRegistry> list) {
        this.document.deleteSection("envSoftwareRegistry");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("envSoftwareRegistry");
            for (EnvSoftwareRegistry obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("registryId", obj.getRegistryId());
            }
        }
    }

    public List<EnvironmentHardware> getEnvironmentHardwares() {
        ArrayList<EnvironmentHardware> environmentHardwares = new ArrayList<EnvironmentHardware>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("environmentHardware");
        if (recordList == null || recordList.size() == 0) {
            return environmentHardwares;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            EnvironmentHardware environmentHardware = new EnvironmentHardware(dnxSectionRecord);
            environmentHardwares.add(environmentHardware);
        }
        return environmentHardwares;
    }

    public void setEnvironmentHardwares(List<EnvironmentHardware> list) {
        this.document.deleteSection("environmentHardware");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("environmentHardware");
            for (EnvironmentHardware obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("hardwareName", obj.getHardwareName());
                dnxSectionRecord.updateKey("hardwareType", obj.getHardwareType());
                dnxSectionRecord.updateKey("hardwareOtherInformation", obj.getHardwareOtherInformation());
            }
        }
    }

    public List<EnvHardwareRegistry> getEnvHardwareRegistrys() {
        ArrayList<EnvHardwareRegistry> envHardwareRegistrys = new ArrayList<EnvHardwareRegistry>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("envHardwareRegistry");
        if (recordList == null || recordList.size() == 0) {
            return envHardwareRegistrys;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            EnvHardwareRegistry envHardwareRegistry = new EnvHardwareRegistry(dnxSectionRecord);
            envHardwareRegistrys.add(envHardwareRegistry);
        }
        return envHardwareRegistrys;
    }

    public void setEnvHardwareRegistrys(List<EnvHardwareRegistry> list) {
        this.document.deleteSection("envHardwareRegistry");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("envHardwareRegistry");
            for (EnvHardwareRegistry obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("registryId", obj.getRegistryId());
            }
        }
    }

    public List<EnvironmentExtension> getEnvironmentExtensions() {
        ArrayList<EnvironmentExtension> environmentExtensions = new ArrayList<EnvironmentExtension>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("environmentExtension");
        if (recordList == null || recordList.size() == 0) {
            return environmentExtensions;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            EnvironmentExtension environmentExtension = new EnvironmentExtension(dnxSectionRecord);
            environmentExtensions.add(environmentExtension);
        }
        return environmentExtensions;
    }

    public void setEnvironmentExtensions(List<EnvironmentExtension> list) {
        this.document.deleteSection("environmentExtension");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("environmentExtension");
            for (EnvironmentExtension obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("environmentExtension", obj.getEnvironmentExtension());
            }
        }
    }

    public List<SignatureInformation> getSignatureInformations() {
        ArrayList<SignatureInformation> signatureInformations = new ArrayList<SignatureInformation>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("signatureInformation");
        if (recordList == null || recordList.size() == 0) {
            return signatureInformations;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            SignatureInformation signatureInformation = new SignatureInformation(dnxSectionRecord);
            signatureInformations.add(signatureInformation);
        }
        return signatureInformations;
    }

    public void setSignatureInformations(List<SignatureInformation> list) {
        this.document.deleteSection("signatureInformation");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("signatureInformation");
            for (SignatureInformation obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("signatureInformationEncoding", obj.getSignatureInformationEncoding());
                dnxSectionRecord.updateKey("signer", obj.getSigner());
                dnxSectionRecord.updateKey("signatureMethod", obj.getSignatureMethod());
                dnxSectionRecord.updateKey("signatureValue", obj.getSignatureValue());
                dnxSectionRecord.updateKey("signatureValidationRules", obj.getSignatureValidationRules());
                dnxSectionRecord.updateKey("signatureProperties", obj.getSignatureProperties());
                dnxSectionRecord.updateKey("keyInformation", obj.getKeyInformation());
            }
        }
    }

    public List<SignatureInformationExtension> getSignatureInformationExtensions() {
        ArrayList<SignatureInformationExtension> signatureInformationExtensions = new ArrayList<SignatureInformationExtension>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("signatureInformationExtension");
        if (recordList == null || recordList.size() == 0) {
            return signatureInformationExtensions;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            SignatureInformationExtension signatureInformationExtension = new SignatureInformationExtension(dnxSectionRecord);
            signatureInformationExtensions.add(signatureInformationExtension);
        }
        return signatureInformationExtensions;
    }

    public void setSignatureInformationExtensions(List<SignatureInformationExtension> list) {
        this.document.deleteSection("signatureInformationExtension");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("signatureInformationExtension");
            for (SignatureInformationExtension obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("signatureInformationExtension", obj.getSignatureInformationExtension());
            }
        }
    }

    public List<Relationship> getRelationships() {
        ArrayList<Relationship> relationships = new ArrayList<Relationship>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("relationship");
        if (recordList == null || recordList.size() == 0) {
            return relationships;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            Relationship relationship = new Relationship(dnxSectionRecord);
            relationships.add(relationship);
        }
        return relationships;
    }

    public void setRelationships(List<Relationship> list) {
        this.document.deleteSection("relationship");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("relationship");
            for (Relationship obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("relationshipType", obj.getRelationshipType());
                dnxSectionRecord.updateKey("relationshipSubType", obj.getRelationshipSubType());
                dnxSectionRecord.updateKey("relatedObjectIdentifierType1", obj.getRelatedObjectIdentifierType1());
                dnxSectionRecord.updateKey("relatedObjectIdentifierValue1", obj.getRelatedObjectIdentifierValue1());
                dnxSectionRecord.updateKey("relatedObjectSequence1", obj.getRelatedObjectSequence1());
                dnxSectionRecord.updateKey("relatedObjectIdentifierType2", obj.getRelatedObjectIdentifierType2());
                dnxSectionRecord.updateKey("relatedObjectIdentifierValue2", obj.getRelatedObjectIdentifierValue2());
                dnxSectionRecord.updateKey("relatedObjectSequence2", obj.getRelatedObjectSequence2());
                dnxSectionRecord.updateKey("relatedObjectIdentifierType3", obj.getRelatedObjectIdentifierType3());
                dnxSectionRecord.updateKey("relatedObjectIdentifierValue3", obj.getRelatedObjectIdentifierValue3());
                dnxSectionRecord.updateKey("relatedObjectSequence3", obj.getRelatedObjectSequence3());
            }
        }
    }

    public List<LinkingIEIdentifier> getLinkingIEIdentifiers() {
        ArrayList<LinkingIEIdentifier> linkingIEIdentifiers = new ArrayList<LinkingIEIdentifier>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("linkingIEIdentifier");
        if (recordList == null || recordList.size() == 0) {
            return linkingIEIdentifiers;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            LinkingIEIdentifier linkingIEIdentifier = new LinkingIEIdentifier(dnxSectionRecord);
            linkingIEIdentifiers.add(linkingIEIdentifier);
        }
        return linkingIEIdentifiers;
    }

    public void setLinkingIEIdentifiers(List<LinkingIEIdentifier> list) {
        this.document.deleteSection("linkingIEIdentifier");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("linkingIEIdentifier");
            for (LinkingIEIdentifier obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("linkingIEIdentifierType", obj.getLinkingIEIdentifierType());
                dnxSectionRecord.updateKey("linkingIEIdentifierValue", obj.getLinkingIEIdentifierValue());
            }
        }
    }

    public Producer getProducer() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("producer");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new Producer(recordList.get(0));
    }

    public void setProducer(Producer obj) {
        this.document.deleteSection("producer");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("producer");
            dnxSection.updateSectionKey("producerId", obj.getProducerId());
            dnxSection.updateSectionKey("userIdAppId", obj.getUserIdAppId());
            dnxSection.updateSectionKey("defaultLanguage", obj.getDefaultLanguage());
            dnxSection.updateSectionKey("authorativeName", obj.getAuthorativeName());
            dnxSection.updateSectionKey("userName", obj.getUserName());
            dnxSection.updateSectionKey("firstName", obj.getFirstName());
            dnxSection.updateSectionKey("lastName", obj.getLastName());
            dnxSection.updateSectionKey("middleName", obj.getMiddleName());
            dnxSection.updateSectionKey("jobTitle", obj.getJobTitle());
            dnxSection.updateSectionKey("address1", obj.getAddress1());
            dnxSection.updateSectionKey("address2", obj.getAddress2());
            dnxSection.updateSectionKey("address3", obj.getAddress3());
            dnxSection.updateSectionKey("address4", obj.getAddress4());
            dnxSection.updateSectionKey("address5", obj.getAddress5());
            dnxSection.updateSectionKey("zip", obj.getZip());
            dnxSection.updateSectionKey("emailAddress", obj.getEmailAddress());
            dnxSection.updateSectionKey("webSiteUrl", obj.getWebSiteUrl());
            dnxSection.updateSectionKey("telephone1", obj.getTelephone1());
            dnxSection.updateSectionKey("telephone2", obj.getTelephone2());
        }
    }

    public ProducerAgent getProducerAgent() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("producerAgent");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new ProducerAgent(recordList.get(0));
    }

    public void setProducerAgent(ProducerAgent obj) {
        this.document.deleteSection("producerAgent");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("producerAgent");
            dnxSection.updateSectionKey("firstName", obj.getFirstName());
            dnxSection.updateSectionKey("lastName", obj.getLastName());
            dnxSection.updateSectionKey("middleName", obj.getMiddleName());
        }
    }

    public List<Event> getEvents() {
        ArrayList<Event> events = new ArrayList<Event>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("event");
        if (recordList == null || recordList.size() == 0) {
            return events;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            Event event = new Event(dnxSectionRecord);
            events.add(event);
        }
        return events;
    }

    public void setEvents(List<Event> list) {
        this.document.deleteSection("event");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("event");
            for (Event obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("eventIdentifierType", obj.getEventIdentifierType());
                dnxSectionRecord.updateKey("eventIdentifierValue", obj.getEventIdentifierValue());
                dnxSectionRecord.updateKey("eventType", obj.getEventType());
                dnxSectionRecord.updateKey("eventDescription", obj.getEventDescription());
                dnxSectionRecord.updateKey("eventDateTime", obj.getInternalEventDateTime());
                dnxSectionRecord.updateKey("eventOutcome1", obj.getEventOutcome1());
                dnxSectionRecord.updateKey("eventOutcomeDetail1", obj.getEventOutcomeDetail1());
                dnxSectionRecord.updateKey("eventOutcomeDetailExtension1", obj.getEventOutcomeDetailExtension1());
                dnxSectionRecord.updateKey("eventOutcome2", obj.getEventOutcome2());
                dnxSectionRecord.updateKey("eventOutcomeDetail2", obj.getEventOutcomeDetail2());
                dnxSectionRecord.updateKey("eventOutcomeDetailExtension2", obj.getEventOutcomeDetailExtension2());
                dnxSectionRecord.updateKey("eventOutcome3", obj.getEventOutcome3());
                dnxSectionRecord.updateKey("eventOutcomeDetail3", obj.getEventOutcomeDetail3());
                dnxSectionRecord.updateKey("eventOutcomeDetailExtension3", obj.getEventOutcomeDetailExtension3());
                dnxSectionRecord.updateKey("linkingAgentIdentifierXMLID1", obj.getLinkingAgentIdentifierXMLID1());
                dnxSectionRecord.updateKey("linkingAgentIdentifierType1", obj.getLinkingAgentIdentifierType1());
                dnxSectionRecord.updateKey("linkingAgentIdentifierValue1", obj.getLinkingAgentIdentifierValue1());
                dnxSectionRecord.updateKey("linkingAgentRole1", obj.getLinkingAgentRole1());
                dnxSectionRecord.updateKey("linkingAgentIdentifierXMLID2", obj.getLinkingAgentIdentifierXMLID2());
                dnxSectionRecord.updateKey("linkingAgentIdentifierType2", obj.getLinkingAgentIdentifierType2());
                dnxSectionRecord.updateKey("linkingAgentIdentifierValue2", obj.getLinkingAgentIdentifierValue2());
                dnxSectionRecord.updateKey("linkingAgentRole2", obj.getLinkingAgentRole2());
                dnxSectionRecord.updateKey("linkingAgentIdentifierXMLID3", obj.getLinkingAgentIdentifierXMLID3());
                dnxSectionRecord.updateKey("linkingAgentIdentifierType3", obj.getLinkingAgentIdentifierType3());
                dnxSectionRecord.updateKey("linkingAgentIdentifierValue3", obj.getLinkingAgentIdentifierValue3());
                dnxSectionRecord.updateKey("linkingAgentRole3", obj.getLinkingAgentRole3());
            }
        }
    }

    public List<LinkingRightsStatementIdentifier> getLinkingRightsStatementIdentifiers() {
        ArrayList<LinkingRightsStatementIdentifier> linkingRightsStatementIdentifiers = new ArrayList<LinkingRightsStatementIdentifier>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("linkingRightsStatementIdentifier");
        if (recordList == null || recordList.size() == 0) {
            return linkingRightsStatementIdentifiers;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            LinkingRightsStatementIdentifier linkingRightsStatementIdentifier = new LinkingRightsStatementIdentifier(dnxSectionRecord);
            linkingRightsStatementIdentifiers.add(linkingRightsStatementIdentifier);
        }
        return linkingRightsStatementIdentifiers;
    }

    public void setLinkingRightsStatementIdentifiers(List<LinkingRightsStatementIdentifier> list) {
        this.document.deleteSection("linkingRightsStatementIdentifier");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("linkingRightsStatementIdentifier");
            for (LinkingRightsStatementIdentifier obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("linkingRightsStatementIdentifierType", obj.getLinkingRightsStatementIdentifierType());
                dnxSectionRecord.updateKey("linkingRightsStatementIdentifierValue", obj.getLinkingRightsStatementIdentifierValue());
            }
        }
    }

    public AccessRightsPolicy getAccessRightsPolicy() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("accessRightsPolicy");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new AccessRightsPolicy(recordList.get(0));
    }

    public void setAccessRightsPolicy(AccessRightsPolicy obj) {
        this.document.deleteSection("accessRightsPolicy");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("accessRightsPolicy");
            dnxSection.updateSectionKey("policyId", obj.getPolicyId());
            dnxSection.updateSectionKey("policyParameters", obj.getPolicyParameters());
            dnxSection.updateSectionKey("policyDescription", obj.getPolicyDescription());
        }
    }

    public RetentionPolicy getRetentionPolicy() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("retentionPolicy");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new RetentionPolicy(recordList.get(0));
    }

    public void setRetentionPolicy(RetentionPolicy obj) {
        this.document.deleteSection("retentionPolicy");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("retentionPolicy");
            dnxSection.updateSectionKey("policyId", obj.getPolicyId());
            dnxSection.updateSectionKey("policyDescription", obj.getPolicyDescription());
        }
    }

    public GrantedRightsStatement getGrantedRightsStatement() {
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("grantedRightsStatement");
        if (recordList == null || recordList.size() == 0) {
            return null;
        }
        return new GrantedRightsStatement(recordList.get(0));
    }

    public void setGrantedRightsStatement(GrantedRightsStatement obj) {
        this.document.deleteSection("grantedRightsStatement");
        if (obj != null) {
            DnxSection dnxSection = this.document.createSection("grantedRightsStatement");
            dnxSection.updateSectionKey("grantedRightsStatementIdentifier", obj.getGrantedRightsStatementIdentifier());
            dnxSection.updateSectionKey("grantedRightsStatementValue", obj.getGrantedRightsStatementValue());
        }
    }

    public List<MetaData> getMetaDatas() {
        ArrayList<MetaData> metaDatas = new ArrayList<MetaData>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("metaData");
        if (recordList == null || recordList.size() == 0) {
            return metaDatas;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            MetaData metaData = new MetaData(dnxSectionRecord);
            metaDatas.add(metaData);
        }
        return metaDatas;
    }

    public void setMetaDatas(List<MetaData> list) {
        this.document.deleteSection("metaData");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("metaData");
            for (MetaData obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("MID", obj.getMID());
                dnxSectionRecord.updateKey("UUID", obj.getUUID());
                dnxSectionRecord.updateKey("creationDate", obj.getInternalCreationDate());
                dnxSectionRecord.updateKey("createdBy", obj.getCreatedBy());
                dnxSectionRecord.updateKey("modificationDate", obj.getInternalModificationDate());
                dnxSectionRecord.updateKey("modifiedBy", obj.getModifiedBy());
                dnxSectionRecord.updateKey("metadataType", obj.getMetadataType());
                dnxSectionRecord.updateKey("description", obj.getDescription());
                dnxSectionRecord.updateKey("application", obj.getApplication());
                dnxSectionRecord.updateKey("externalSystem", obj.getExternalSystem());
                dnxSectionRecord.updateKey("externalRecordId", obj.getExternalRecordId());
            }
        }
    }

    public List<WorkProduct> getWorkProducts() {
        ArrayList<WorkProduct> workProducts = new ArrayList<WorkProduct>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("workProduct");
        if (recordList == null || recordList.size() == 0) {
            return workProducts;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            WorkProduct workProduct = new WorkProduct(dnxSectionRecord);
            workProducts.add(workProduct);
        }
        return workProducts;
    }

    public void setWorkProducts(List<WorkProduct> list) {
        this.document.deleteSection("workProduct");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("workProduct");
            for (WorkProduct obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("publishingHistory", obj.getPublishingHistory());
            }
        }
    }

    public List<Collection> getCollections() {
        ArrayList<Collection> Collections2 = new ArrayList<Collection>();
        List<DnxSectionRecord> recordList = this.document.getSectionRecordsListById("Collection");
        if (recordList == null || recordList.size() == 0) {
            return Collections2;
        }
        for (DnxSectionRecord dnxSectionRecord : recordList) {
            Collection Collection2 = new Collection(dnxSectionRecord);
            Collections2.add(Collection2);
        }
        return Collections2;
    }

    public void setCollections(List<Collection> list) {
        this.document.deleteSection("Collection");
        if (list != null && list.size() != 0) {
            DnxSection dnxSection = this.document.createSection("Collection");
            for (Collection obj : list) {
                DnxSectionRecord dnxSectionRecord = dnxSection.createRecord();
                dnxSectionRecord.updateKey("collectionId", obj.getCollectionId());
                dnxSectionRecord.updateKey("collectionParentId", obj.getCollectionParentId());
                dnxSectionRecord.updateKey("name", obj.getName());
                dnxSectionRecord.updateKey("externalId", obj.getExternalId());
                dnxSectionRecord.updateKey("externalSystem", obj.getExternalSystem());
                dnxSectionRecord.updateKey("publish", obj.getPublish());
                dnxSectionRecord.updateKey("navigate", obj.getNavigate());
                dnxSectionRecord.updateKey("collectionOrder", obj.getCollectionOrder());
            }
        }
    }

    public class Collection {
        public static final String sectionId = "Collection";
        public static final String COLLECTIONID = "collectionId";
        public static final String COLLECTIONPARENTID = "collectionParentId";
        public static final String NAME = "name";
        public static final String EXTERNALID = "externalId";
        public static final String EXTERNALSYSTEM = "externalSystem";
        public static final String PUBLISH = "publish";
        public static final String NAVIGATE = "navigate";
        public static final String COLLECTIONORDER = "collectionOrder";
        private DnxSectionRecord record;

        public Collection() {
            this.init();
        }

        private Collection(DnxSectionRecord record) {
            this.record = record;
        }

        public Collection(String collectionId, String collectionParentId, String name, String externalId, String externalSystem, String publish, String navigate, String collectionOrder) {
            this.init();
            this.setCollectionId(collectionId);
            this.setCollectionParentId(collectionParentId);
            this.setName(name);
            this.setExternalId(externalId);
            this.setExternalSystem(externalSystem);
            this.setPublish(publish);
            this.setNavigate(navigate);
            this.setCollectionOrder(collectionOrder);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getCollectionId() {
            return this.record.getSectionKeyValue(COLLECTIONID);
        }

        public void setCollectionId(String s) {
            this.record.updateKey(COLLECTIONID, s);
        }

        public String getCollectionParentId() {
            return this.record.getSectionKeyValue(COLLECTIONPARENTID);
        }

        public void setCollectionParentId(String s) {
            this.record.updateKey(COLLECTIONPARENTID, s);
        }

        public String getName() {
            return this.record.getSectionKeyValue(NAME);
        }

        public void setName(String s) {
            this.record.updateKey(NAME, s);
        }

        public String getExternalId() {
            return this.record.getSectionKeyValue(EXTERNALID);
        }

        public void setExternalId(String s) {
            this.record.updateKey(EXTERNALID, s);
        }

        public String getExternalSystem() {
            return this.record.getSectionKeyValue(EXTERNALSYSTEM);
        }

        public void setExternalSystem(String s) {
            this.record.updateKey(EXTERNALSYSTEM, s);
        }

        public String getPublish() {
            return this.record.getSectionKeyValue(PUBLISH);
        }

        public void setPublish(String s) {
            this.record.updateKey(PUBLISH, s);
        }

        public String getNavigate() {
            return this.record.getSectionKeyValue(NAVIGATE);
        }

        public void setNavigate(String s) {
            this.record.updateKey(NAVIGATE, s);
        }

        public String getCollectionOrder() {
            return this.record.getSectionKeyValue(COLLECTIONORDER);
        }

        public void setCollectionOrder(String s) {
            this.record.updateKey(COLLECTIONORDER, s);
        }
    }

    public class WorkProduct {
        public static final String sectionId = "workProduct";
        public static final String PUBLISHINGHISTORY = "publishingHistory";
        private DnxSectionRecord record;

        public WorkProduct() {
            this.init();
        }

        private WorkProduct(DnxSectionRecord record) {
            this.record = record;
        }

        public WorkProduct(String publishingHistory) {
            this.init();
            this.setPublishingHistory(publishingHistory);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getPublishingHistory() {
            return this.record.getSectionKeyValue(PUBLISHINGHISTORY);
        }

        public void setPublishingHistory(String s) {
            this.record.updateKey(PUBLISHINGHISTORY, s);
        }
    }

    public class MetaData {
        public static final String sectionId = "metaData";
        public static final String MID = "MID";
        public static final String UUID = "UUID";
        public static final String CREATIONDATE = "creationDate";
        public static final String CREATEDBY = "createdBy";
        public static final String MODIFICATIONDATE = "modificationDate";
        public static final String MODIFIEDBY = "modifiedBy";
        public static final String METADATATYPE = "metadataType";
        public static final String DESCRIPTION = "description";
        public static final String APPLICATION = "application";
        public static final String EXTERNALSYSTEM = "externalSystem";
        public static final String EXTERNALRECORDID = "externalRecordId";
        private DnxSectionRecord record;

        public MetaData() {
            this.init();
        }

        private MetaData(DnxSectionRecord record) {
            this.record = record;
        }

        public MetaData(String MID, String UUID2, String creationDate, String createdBy, String modificationDate, String modifiedBy, String metadataType, String description, String application, String externalSystem, String externalRecordId) {
            this.init();
            this.setMID(MID);
            this.setUUID(UUID2);
            this.setCreationDate(creationDate);
            this.setCreatedBy(createdBy);
            this.setModificationDate(modificationDate);
            this.setModifiedBy(modifiedBy);
            this.setMetadataType(metadataType);
            this.setDescription(description);
            this.setApplication(application);
            this.setExternalSystem(externalSystem);
            this.setExternalRecordId(externalRecordId);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getMID() {
            return this.record.getSectionKeyValue(MID);
        }

        public void setMID(String s) {
            this.record.updateKey(MID, s);
        }

        public String getUUID() {
            return this.record.getSectionKeyValue(UUID);
        }

        public void setUUID(String s) {
            this.record.updateKey(UUID, s);
        }

        public String getCreationDate() {
            String value = this.record.getSectionKeyValue(CREATIONDATE);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalCreationDate() {
            return this.record.getSectionKeyValue(CREATIONDATE);
        }

        public void setCreationDate(String s) {
            this.record.updateKey(CREATIONDATE, s);
        }

        public String getCreatedBy() {
            return this.record.getSectionKeyValue(CREATEDBY);
        }

        public void setCreatedBy(String s) {
            this.record.updateKey(CREATEDBY, s);
        }

        public String getModificationDate() {
            String value = this.record.getSectionKeyValue(MODIFICATIONDATE);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalModificationDate() {
            return this.record.getSectionKeyValue(MODIFICATIONDATE);
        }

        public void setModificationDate(String s) {
            this.record.updateKey(MODIFICATIONDATE, s);
        }

        public String getModifiedBy() {
            return this.record.getSectionKeyValue(MODIFIEDBY);
        }

        public void setModifiedBy(String s) {
            this.record.updateKey(MODIFIEDBY, s);
        }

        public String getMetadataType() {
            return this.record.getSectionKeyValue(METADATATYPE);
        }

        public void setMetadataType(String s) {
            this.record.updateKey(METADATATYPE, s);
        }

        public String getDescription() {
            return this.record.getSectionKeyValue(DESCRIPTION);
        }

        public void setDescription(String s) {
            this.record.updateKey(DESCRIPTION, s);
        }

        public String getApplication() {
            return this.record.getSectionKeyValue(APPLICATION);
        }

        public void setApplication(String s) {
            this.record.updateKey(APPLICATION, s);
        }

        public String getExternalSystem() {
            return this.record.getSectionKeyValue(EXTERNALSYSTEM);
        }

        public void setExternalSystem(String s) {
            this.record.updateKey(EXTERNALSYSTEM, s);
        }

        public String getExternalRecordId() {
            return this.record.getSectionKeyValue(EXTERNALRECORDID);
        }

        public void setExternalRecordId(String s) {
            this.record.updateKey(EXTERNALRECORDID, s);
        }
    }

    public class GrantedRightsStatement {
        public static final String sectionId = "grantedRightsStatement";
        public static final String GRANTEDRIGHTSSTATEMENTIDENTIFIER = "grantedRightsStatementIdentifier";
        public static final String GRANTEDRIGHTSSTATEMENTVALUE = "grantedRightsStatementValue";
        private DnxSectionRecord record;

        public GrantedRightsStatement() {
            this.init();
        }

        private GrantedRightsStatement(DnxSectionRecord record) {
            this.record = record;
        }

        public GrantedRightsStatement(String grantedRightsStatementIdentifier, String grantedRightsStatementValue) {
            this.init();
            this.setGrantedRightsStatementIdentifier(grantedRightsStatementIdentifier);
            this.setGrantedRightsStatementValue(grantedRightsStatementValue);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getGrantedRightsStatementIdentifier() {
            return this.record.getSectionKeyValue(GRANTEDRIGHTSSTATEMENTIDENTIFIER);
        }

        public void setGrantedRightsStatementIdentifier(String s) {
            this.record.updateKey(GRANTEDRIGHTSSTATEMENTIDENTIFIER, s);
        }

        public String getGrantedRightsStatementValue() {
            return this.record.getSectionKeyValue(GRANTEDRIGHTSSTATEMENTVALUE);
        }

        public void setGrantedRightsStatementValue(String s) {
            this.record.updateKey(GRANTEDRIGHTSSTATEMENTVALUE, s);
        }
    }

    public class RetentionPolicy {
        public static final String sectionId = "retentionPolicy";
        public static final String POLICYID = "policyId";
        public static final String POLICYDESCRIPTION = "policyDescription";
        private DnxSectionRecord record;

        public RetentionPolicy() {
            this.init();
        }

        private RetentionPolicy(DnxSectionRecord record) {
            this.record = record;
        }

        public RetentionPolicy(String policyId, String policyDescription) {
            this.init();
            this.setPolicyId(policyId);
            this.setPolicyDescription(policyDescription);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getPolicyId() {
            return this.record.getSectionKeyValue(POLICYID);
        }

        public void setPolicyId(String s) {
            this.record.updateKey(POLICYID, s);
        }

        public String getPolicyDescription() {
            return this.record.getSectionKeyValue(POLICYDESCRIPTION);
        }

        public void setPolicyDescription(String s) {
            this.record.updateKey(POLICYDESCRIPTION, s);
        }
    }

    public class AccessRightsPolicy {
        public static final String sectionId = "accessRightsPolicy";
        public static final String POLICYID = "policyId";
        public static final String POLICYPARAMETERS = "policyParameters";
        public static final String POLICYDESCRIPTION = "policyDescription";
        private DnxSectionRecord record;

        public AccessRightsPolicy() {
            this.init();
        }

        private AccessRightsPolicy(DnxSectionRecord record) {
            this.record = record;
        }

        public AccessRightsPolicy(String policyId, String policyParameters, String policyDescription) {
            this.init();
            this.setPolicyId(policyId);
            this.setPolicyParameters(policyParameters);
            this.setPolicyDescription(policyDescription);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getPolicyId() {
            return this.record.getSectionKeyValue(POLICYID);
        }

        public void setPolicyId(String s) {
            this.record.updateKey(POLICYID, s);
        }

        public String getPolicyParameters() {
            return this.record.getSectionKeyValue(POLICYPARAMETERS);
        }

        public void setPolicyParameters(String s) {
            this.record.updateKey(POLICYPARAMETERS, s);
        }

        public String getPolicyDescription() {
            return this.record.getSectionKeyValue(POLICYDESCRIPTION);
        }

        public void setPolicyDescription(String s) {
            this.record.updateKey(POLICYDESCRIPTION, s);
        }
    }

    public class LinkingRightsStatementIdentifier {
        public static final String sectionId = "linkingRightsStatementIdentifier";
        public static final String LINKINGRIGHTSSTATEMENTIDENTIFIERTYPE = "linkingRightsStatementIdentifierType";
        public static final String LINKINGRIGHTSSTATEMENTIDENTIFIERVALUE = "linkingRightsStatementIdentifierValue";
        private DnxSectionRecord record;

        public LinkingRightsStatementIdentifier() {
            this.init();
        }

        private LinkingRightsStatementIdentifier(DnxSectionRecord record) {
            this.record = record;
        }

        public LinkingRightsStatementIdentifier(String linkingRightsStatementIdentifierType, String linkingRightsStatementIdentifierValue) {
            this.init();
            this.setLinkingRightsStatementIdentifierType(linkingRightsStatementIdentifierType);
            this.setLinkingRightsStatementIdentifierValue(linkingRightsStatementIdentifierValue);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getLinkingRightsStatementIdentifierType() {
            return this.record.getSectionKeyValue(LINKINGRIGHTSSTATEMENTIDENTIFIERTYPE);
        }

        public void setLinkingRightsStatementIdentifierType(String s) {
            this.record.updateKey(LINKINGRIGHTSSTATEMENTIDENTIFIERTYPE, s);
        }

        public String getLinkingRightsStatementIdentifierValue() {
            return this.record.getSectionKeyValue(LINKINGRIGHTSSTATEMENTIDENTIFIERVALUE);
        }

        public void setLinkingRightsStatementIdentifierValue(String s) {
            this.record.updateKey(LINKINGRIGHTSSTATEMENTIDENTIFIERVALUE, s);
        }
    }

    public class Event {
        public static final String sectionId = "event";
        public static final String EVENTIDENTIFIERTYPE = "eventIdentifierType";
        public static final String EVENTIDENTIFIERVALUE = "eventIdentifierValue";
        public static final String EVENTTYPE = "eventType";
        public static final String EVENTDESCRIPTION = "eventDescription";
        public static final String EVENTDATETIME = "eventDateTime";
        public static final String EVENTOUTCOME1 = "eventOutcome1";
        public static final String EVENTOUTCOMEDETAIL1 = "eventOutcomeDetail1";
        public static final String EVENTOUTCOMEDETAILEXTENSION1 = "eventOutcomeDetailExtension1";
        public static final String EVENTOUTCOME2 = "eventOutcome2";
        public static final String EVENTOUTCOMEDETAIL2 = "eventOutcomeDetail2";
        public static final String EVENTOUTCOMEDETAILEXTENSION2 = "eventOutcomeDetailExtension2";
        public static final String EVENTOUTCOME3 = "eventOutcome3";
        public static final String EVENTOUTCOMEDETAIL3 = "eventOutcomeDetail3";
        public static final String EVENTOUTCOMEDETAILEXTENSION3 = "eventOutcomeDetailExtension3";
        public static final String LINKINGAGENTIDENTIFIERXMLID1 = "linkingAgentIdentifierXMLID1";
        public static final String LINKINGAGENTIDENTIFIERTYPE1 = "linkingAgentIdentifierType1";
        public static final String LINKINGAGENTIDENTIFIERVALUE1 = "linkingAgentIdentifierValue1";
        public static final String LINKINGAGENTROLE1 = "linkingAgentRole1";
        public static final String LINKINGAGENTIDENTIFIERXMLID2 = "linkingAgentIdentifierXMLID2";
        public static final String LINKINGAGENTIDENTIFIERTYPE2 = "linkingAgentIdentifierType2";
        public static final String LINKINGAGENTIDENTIFIERVALUE2 = "linkingAgentIdentifierValue2";
        public static final String LINKINGAGENTROLE2 = "linkingAgentRole2";
        public static final String LINKINGAGENTIDENTIFIERXMLID3 = "linkingAgentIdentifierXMLID3";
        public static final String LINKINGAGENTIDENTIFIERTYPE3 = "linkingAgentIdentifierType3";
        public static final String LINKINGAGENTIDENTIFIERVALUE3 = "linkingAgentIdentifierValue3";
        public static final String LINKINGAGENTROLE3 = "linkingAgentRole3";
        private DnxSectionRecord record;

        public Event() {
            this.init();
        }

        private Event(DnxSectionRecord record) {
            this.record = record;
        }

        public Event(String eventIdentifierType, String eventIdentifierValue, String eventType, String eventDescription, String eventDateTime, String eventOutcome1, String eventOutcomeDetail1, String eventOutcomeDetailExtension1, String eventOutcome2, String eventOutcomeDetail2, String eventOutcomeDetailExtension2, String eventOutcome3, String eventOutcomeDetail3, String eventOutcomeDetailExtension3, String linkingAgentIdentifierXMLID1, String linkingAgentIdentifierType1, String linkingAgentIdentifierValue1, String linkingAgentRole1, String linkingAgentIdentifierXMLID2, String linkingAgentIdentifierType2, String linkingAgentIdentifierValue2, String linkingAgentRole2, String linkingAgentIdentifierXMLID3, String linkingAgentIdentifierType3, String linkingAgentIdentifierValue3, String linkingAgentRole3) {
            this.init();
            this.setEventIdentifierType(eventIdentifierType);
            this.setEventIdentifierValue(eventIdentifierValue);
            this.setEventType(eventType);
            this.setEventDescription(eventDescription);
            this.setEventDateTime(eventDateTime);
            this.setEventOutcome1(eventOutcome1);
            this.setEventOutcomeDetail1(eventOutcomeDetail1);
            this.setEventOutcomeDetailExtension1(eventOutcomeDetailExtension1);
            this.setEventOutcome2(eventOutcome2);
            this.setEventOutcomeDetail2(eventOutcomeDetail2);
            this.setEventOutcomeDetailExtension2(eventOutcomeDetailExtension2);
            this.setEventOutcome3(eventOutcome3);
            this.setEventOutcomeDetail3(eventOutcomeDetail3);
            this.setEventOutcomeDetailExtension3(eventOutcomeDetailExtension3);
            this.setLinkingAgentIdentifierXMLID1(linkingAgentIdentifierXMLID1);
            this.setLinkingAgentIdentifierType1(linkingAgentIdentifierType1);
            this.setLinkingAgentIdentifierValue1(linkingAgentIdentifierValue1);
            this.setLinkingAgentRole1(linkingAgentRole1);
            this.setLinkingAgentIdentifierXMLID2(linkingAgentIdentifierXMLID2);
            this.setLinkingAgentIdentifierType2(linkingAgentIdentifierType2);
            this.setLinkingAgentIdentifierValue2(linkingAgentIdentifierValue2);
            this.setLinkingAgentRole2(linkingAgentRole2);
            this.setLinkingAgentIdentifierXMLID3(linkingAgentIdentifierXMLID3);
            this.setLinkingAgentIdentifierType3(linkingAgentIdentifierType3);
            this.setLinkingAgentIdentifierValue3(linkingAgentIdentifierValue3);
            this.setLinkingAgentRole3(linkingAgentRole3);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getEventIdentifierType() {
            return this.record.getSectionKeyValue(EVENTIDENTIFIERTYPE);
        }

        public void setEventIdentifierType(String s) {
            this.record.updateKey(EVENTIDENTIFIERTYPE, s);
        }

        public String getEventIdentifierValue() {
            return this.record.getSectionKeyValue(EVENTIDENTIFIERVALUE);
        }

        public void setEventIdentifierValue(String s) {
            this.record.updateKey(EVENTIDENTIFIERVALUE, s);
        }

        public String getEventType() {
            return this.record.getSectionKeyValue(EVENTTYPE);
        }

        public void setEventType(String s) {
            this.record.updateKey(EVENTTYPE, s);
        }

        public String getEventDescription() {
            return this.record.getSectionKeyValue(EVENTDESCRIPTION);
        }

        public void setEventDescription(String s) {
            this.record.updateKey(EVENTDESCRIPTION, s);
        }

        public String getEventDateTime() {
            String value = this.record.getSectionKeyValue(EVENTDATETIME);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalEventDateTime() {
            return this.record.getSectionKeyValue(EVENTDATETIME);
        }

        public void setEventDateTime(String s) {
            this.record.updateKey(EVENTDATETIME, s);
        }

        public String getEventOutcome1() {
            return this.record.getSectionKeyValue(EVENTOUTCOME1);
        }

        public void setEventOutcome1(String s) {
            this.record.updateKey(EVENTOUTCOME1, s);
        }

        public String getEventOutcomeDetail1() {
            return this.record.getSectionKeyValue(EVENTOUTCOMEDETAIL1);
        }

        public void setEventOutcomeDetail1(String s) {
            this.record.updateKey(EVENTOUTCOMEDETAIL1, s);
        }

        public String getEventOutcomeDetailExtension1() {
            return this.record.getSectionKeyValue(EVENTOUTCOMEDETAILEXTENSION1);
        }

        public void setEventOutcomeDetailExtension1(String s) {
            this.record.updateKey(EVENTOUTCOMEDETAILEXTENSION1, s);
        }

        public String getEventOutcome2() {
            return this.record.getSectionKeyValue(EVENTOUTCOME2);
        }

        public void setEventOutcome2(String s) {
            this.record.updateKey(EVENTOUTCOME2, s);
        }

        public String getEventOutcomeDetail2() {
            return this.record.getSectionKeyValue(EVENTOUTCOMEDETAIL2);
        }

        public void setEventOutcomeDetail2(String s) {
            this.record.updateKey(EVENTOUTCOMEDETAIL2, s);
        }

        public String getEventOutcomeDetailExtension2() {
            return this.record.getSectionKeyValue(EVENTOUTCOMEDETAILEXTENSION2);
        }

        public void setEventOutcomeDetailExtension2(String s) {
            this.record.updateKey(EVENTOUTCOMEDETAILEXTENSION2, s);
        }

        public String getEventOutcome3() {
            return this.record.getSectionKeyValue(EVENTOUTCOME3);
        }

        public void setEventOutcome3(String s) {
            this.record.updateKey(EVENTOUTCOME3, s);
        }

        public String getEventOutcomeDetail3() {
            return this.record.getSectionKeyValue(EVENTOUTCOMEDETAIL3);
        }

        public void setEventOutcomeDetail3(String s) {
            this.record.updateKey(EVENTOUTCOMEDETAIL3, s);
        }

        public String getEventOutcomeDetailExtension3() {
            return this.record.getSectionKeyValue(EVENTOUTCOMEDETAILEXTENSION3);
        }

        public void setEventOutcomeDetailExtension3(String s) {
            this.record.updateKey(EVENTOUTCOMEDETAILEXTENSION3, s);
        }

        public String getLinkingAgentIdentifierXMLID1() {
            return this.record.getSectionKeyValue(LINKINGAGENTIDENTIFIERXMLID1);
        }

        public void setLinkingAgentIdentifierXMLID1(String s) {
            this.record.updateKey(LINKINGAGENTIDENTIFIERXMLID1, s);
        }

        public String getLinkingAgentIdentifierType1() {
            return this.record.getSectionKeyValue(LINKINGAGENTIDENTIFIERTYPE1);
        }

        public void setLinkingAgentIdentifierType1(String s) {
            this.record.updateKey(LINKINGAGENTIDENTIFIERTYPE1, s);
        }

        public String getLinkingAgentIdentifierValue1() {
            return this.record.getSectionKeyValue(LINKINGAGENTIDENTIFIERVALUE1);
        }

        public void setLinkingAgentIdentifierValue1(String s) {
            this.record.updateKey(LINKINGAGENTIDENTIFIERVALUE1, s);
        }

        public String getLinkingAgentRole1() {
            return this.record.getSectionKeyValue(LINKINGAGENTROLE1);
        }

        public void setLinkingAgentRole1(String s) {
            this.record.updateKey(LINKINGAGENTROLE1, s);
        }

        public String getLinkingAgentIdentifierXMLID2() {
            return this.record.getSectionKeyValue(LINKINGAGENTIDENTIFIERXMLID2);
        }

        public void setLinkingAgentIdentifierXMLID2(String s) {
            this.record.updateKey(LINKINGAGENTIDENTIFIERXMLID2, s);
        }

        public String getLinkingAgentIdentifierType2() {
            return this.record.getSectionKeyValue(LINKINGAGENTIDENTIFIERTYPE2);
        }

        public void setLinkingAgentIdentifierType2(String s) {
            this.record.updateKey(LINKINGAGENTIDENTIFIERTYPE2, s);
        }

        public String getLinkingAgentIdentifierValue2() {
            return this.record.getSectionKeyValue(LINKINGAGENTIDENTIFIERVALUE2);
        }

        public void setLinkingAgentIdentifierValue2(String s) {
            this.record.updateKey(LINKINGAGENTIDENTIFIERVALUE2, s);
        }

        public String getLinkingAgentRole2() {
            return this.record.getSectionKeyValue(LINKINGAGENTROLE2);
        }

        public void setLinkingAgentRole2(String s) {
            this.record.updateKey(LINKINGAGENTROLE2, s);
        }

        public String getLinkingAgentIdentifierXMLID3() {
            return this.record.getSectionKeyValue(LINKINGAGENTIDENTIFIERXMLID3);
        }

        public void setLinkingAgentIdentifierXMLID3(String s) {
            this.record.updateKey(LINKINGAGENTIDENTIFIERXMLID3, s);
        }

        public String getLinkingAgentIdentifierType3() {
            return this.record.getSectionKeyValue(LINKINGAGENTIDENTIFIERTYPE3);
        }

        public void setLinkingAgentIdentifierType3(String s) {
            this.record.updateKey(LINKINGAGENTIDENTIFIERTYPE3, s);
        }

        public String getLinkingAgentIdentifierValue3() {
            return this.record.getSectionKeyValue(LINKINGAGENTIDENTIFIERVALUE3);
        }

        public void setLinkingAgentIdentifierValue3(String s) {
            this.record.updateKey(LINKINGAGENTIDENTIFIERVALUE3, s);
        }

        public String getLinkingAgentRole3() {
            return this.record.getSectionKeyValue(LINKINGAGENTROLE3);
        }

        public void setLinkingAgentRole3(String s) {
            this.record.updateKey(LINKINGAGENTROLE3, s);
        }
    }

    public class ProducerAgent {
        public static final String sectionId = "producerAgent";
        public static final String FIRSTNAME = "firstName";
        public static final String LASTNAME = "lastName";
        public static final String MIDDLENAME = "middleName";
        private DnxSectionRecord record;

        public ProducerAgent() {
            this.init();
        }

        private ProducerAgent(DnxSectionRecord record) {
            this.record = record;
        }

        public ProducerAgent(String firstName, String lastName, String middleName) {
            this.init();
            this.setFirstName(firstName);
            this.setLastName(lastName);
            this.setMiddleName(middleName);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getFirstName() {
            return this.record.getSectionKeyValue(FIRSTNAME);
        }

        public void setFirstName(String s) {
            this.record.updateKey(FIRSTNAME, s);
        }

        public String getLastName() {
            return this.record.getSectionKeyValue(LASTNAME);
        }

        public void setLastName(String s) {
            this.record.updateKey(LASTNAME, s);
        }

        public String getMiddleName() {
            return this.record.getSectionKeyValue(MIDDLENAME);
        }

        public void setMiddleName(String s) {
            this.record.updateKey(MIDDLENAME, s);
        }
    }

    public class Producer {
        public static final String sectionId = "producer";
        public static final String PRODUCERID = "producerId";
        public static final String USERIDAPPID = "userIdAppId";
        public static final String DEFAULTLANGUAGE = "defaultLanguage";
        public static final String AUTHORATIVENAME = "authorativeName";
        public static final String USERNAME = "userName";
        public static final String FIRSTNAME = "firstName";
        public static final String LASTNAME = "lastName";
        public static final String MIDDLENAME = "middleName";
        public static final String JOBTITLE = "jobTitle";
        public static final String ADDRESS1 = "address1";
        public static final String ADDRESS2 = "address2";
        public static final String ADDRESS3 = "address3";
        public static final String ADDRESS4 = "address4";
        public static final String ADDRESS5 = "address5";
        public static final String ZIP = "zip";
        public static final String EMAILADDRESS = "emailAddress";
        public static final String WEBSITEURL = "webSiteUrl";
        public static final String TELEPHONE1 = "telephone1";
        public static final String TELEPHONE2 = "telephone2";
        private DnxSectionRecord record;

        public Producer() {
            this.init();
        }

        private Producer(DnxSectionRecord record) {
            this.record = record;
        }

        public Producer(String producerId, String userIdAppId, String defaultLanguage, String authorativeName, String userName, String firstName, String lastName, String middleName, String jobTitle, String address1, String address2, String address3, String address4, String address5, String zip, String emailAddress, String webSiteUrl, String telephone1, String telephone2) {
            this.init();
            this.setProducerId(producerId);
            this.setUserIdAppId(userIdAppId);
            this.setDefaultLanguage(defaultLanguage);
            this.setAuthorativeName(authorativeName);
            this.setUserName(userName);
            this.setFirstName(firstName);
            this.setLastName(lastName);
            this.setMiddleName(middleName);
            this.setJobTitle(jobTitle);
            this.setAddress1(address1);
            this.setAddress2(address2);
            this.setAddress3(address3);
            this.setAddress4(address4);
            this.setAddress5(address5);
            this.setZip(zip);
            this.setEmailAddress(emailAddress);
            this.setWebSiteUrl(webSiteUrl);
            this.setTelephone1(telephone1);
            this.setTelephone2(telephone2);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getProducerId() {
            return this.record.getSectionKeyValue(PRODUCERID);
        }

        public void setProducerId(String s) {
            this.record.updateKey(PRODUCERID, s);
        }

        public String getUserIdAppId() {
            return this.record.getSectionKeyValue(USERIDAPPID);
        }

        public void setUserIdAppId(String s) {
            this.record.updateKey(USERIDAPPID, s);
        }

        public String getDefaultLanguage() {
            return this.record.getSectionKeyValue(DEFAULTLANGUAGE);
        }

        public void setDefaultLanguage(String s) {
            this.record.updateKey(DEFAULTLANGUAGE, s);
        }

        public String getAuthorativeName() {
            return this.record.getSectionKeyValue(AUTHORATIVENAME);
        }

        public void setAuthorativeName(String s) {
            this.record.updateKey(AUTHORATIVENAME, s);
        }

        public String getUserName() {
            return this.record.getSectionKeyValue(USERNAME);
        }

        public void setUserName(String s) {
            this.record.updateKey(USERNAME, s);
        }

        public String getFirstName() {
            return this.record.getSectionKeyValue(FIRSTNAME);
        }

        public void setFirstName(String s) {
            this.record.updateKey(FIRSTNAME, s);
        }

        public String getLastName() {
            return this.record.getSectionKeyValue(LASTNAME);
        }

        public void setLastName(String s) {
            this.record.updateKey(LASTNAME, s);
        }

        public String getMiddleName() {
            return this.record.getSectionKeyValue(MIDDLENAME);
        }

        public void setMiddleName(String s) {
            this.record.updateKey(MIDDLENAME, s);
        }

        public String getJobTitle() {
            return this.record.getSectionKeyValue(JOBTITLE);
        }

        public void setJobTitle(String s) {
            this.record.updateKey(JOBTITLE, s);
        }

        public String getAddress1() {
            return this.record.getSectionKeyValue(ADDRESS1);
        }

        public void setAddress1(String s) {
            this.record.updateKey(ADDRESS1, s);
        }

        public String getAddress2() {
            return this.record.getSectionKeyValue(ADDRESS2);
        }

        public void setAddress2(String s) {
            this.record.updateKey(ADDRESS2, s);
        }

        public String getAddress3() {
            return this.record.getSectionKeyValue(ADDRESS3);
        }

        public void setAddress3(String s) {
            this.record.updateKey(ADDRESS3, s);
        }

        public String getAddress4() {
            return this.record.getSectionKeyValue(ADDRESS4);
        }

        public void setAddress4(String s) {
            this.record.updateKey(ADDRESS4, s);
        }

        public String getAddress5() {
            return this.record.getSectionKeyValue(ADDRESS5);
        }

        public void setAddress5(String s) {
            this.record.updateKey(ADDRESS5, s);
        }

        public String getZip() {
            return this.record.getSectionKeyValue(ZIP);
        }

        public void setZip(String s) {
            this.record.updateKey(ZIP, s);
        }

        public String getEmailAddress() {
            return this.record.getSectionKeyValue(EMAILADDRESS);
        }

        public void setEmailAddress(String s) {
            this.record.updateKey(EMAILADDRESS, s);
        }

        public String getWebSiteUrl() {
            return this.record.getSectionKeyValue(WEBSITEURL);
        }

        public void setWebSiteUrl(String s) {
            this.record.updateKey(WEBSITEURL, s);
        }

        public String getTelephone1() {
            return this.record.getSectionKeyValue(TELEPHONE1);
        }

        public void setTelephone1(String s) {
            this.record.updateKey(TELEPHONE1, s);
        }

        public String getTelephone2() {
            return this.record.getSectionKeyValue(TELEPHONE2);
        }

        public void setTelephone2(String s) {
            this.record.updateKey(TELEPHONE2, s);
        }
    }

    public class LinkingIEIdentifier {
        public static final String sectionId = "linkingIEIdentifier";
        public static final String LINKINGIEIDENTIFIERTYPE = "linkingIEIdentifierType";
        public static final String LINKINGIEIDENTIFIERVALUE = "linkingIEIdentifierValue";
        private DnxSectionRecord record;

        public LinkingIEIdentifier() {
            this.init();
        }

        private LinkingIEIdentifier(DnxSectionRecord record) {
            this.record = record;
        }

        public LinkingIEIdentifier(String linkingIEIdentifierType, String linkingIEIdentifierValue) {
            this.init();
            this.setLinkingIEIdentifierType(linkingIEIdentifierType);
            this.setLinkingIEIdentifierValue(linkingIEIdentifierValue);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getLinkingIEIdentifierType() {
            return this.record.getSectionKeyValue(LINKINGIEIDENTIFIERTYPE);
        }

        public void setLinkingIEIdentifierType(String s) {
            this.record.updateKey(LINKINGIEIDENTIFIERTYPE, s);
        }

        public String getLinkingIEIdentifierValue() {
            return this.record.getSectionKeyValue(LINKINGIEIDENTIFIERVALUE);
        }

        public void setLinkingIEIdentifierValue(String s) {
            this.record.updateKey(LINKINGIEIDENTIFIERVALUE, s);
        }
    }

    public class Relationship {
        public static final String sectionId = "relationship";
        public static final String RELATIONSHIPTYPE = "relationshipType";
        public static final String RELATIONSHIPSUBTYPE = "relationshipSubType";
        public static final String RELATEDOBJECTIDENTIFIERTYPE1 = "relatedObjectIdentifierType1";
        public static final String RELATEDOBJECTIDENTIFIERVALUE1 = "relatedObjectIdentifierValue1";
        public static final String RELATEDOBJECTSEQUENCE1 = "relatedObjectSequence1";
        public static final String RELATEDOBJECTIDENTIFIERTYPE2 = "relatedObjectIdentifierType2";
        public static final String RELATEDOBJECTIDENTIFIERVALUE2 = "relatedObjectIdentifierValue2";
        public static final String RELATEDOBJECTSEQUENCE2 = "relatedObjectSequence2";
        public static final String RELATEDOBJECTIDENTIFIERTYPE3 = "relatedObjectIdentifierType3";
        public static final String RELATEDOBJECTIDENTIFIERVALUE3 = "relatedObjectIdentifierValue3";
        public static final String RELATEDOBJECTSEQUENCE3 = "relatedObjectSequence3";
        private DnxSectionRecord record;

        public Relationship() {
            this.init();
        }

        private Relationship(DnxSectionRecord record) {
            this.record = record;
        }

        public Relationship(String relationshipType, String relationshipSubType, String relatedObjectIdentifierType1, String relatedObjectIdentifierValue1, String relatedObjectSequence1, String relatedObjectIdentifierType2, String relatedObjectIdentifierValue2, String relatedObjectSequence2, String relatedObjectIdentifierType3, String relatedObjectIdentifierValue3, String relatedObjectSequence3) {
            this.init();
            this.setRelationshipType(relationshipType);
            this.setRelationshipSubType(relationshipSubType);
            this.setRelatedObjectIdentifierType1(relatedObjectIdentifierType1);
            this.setRelatedObjectIdentifierValue1(relatedObjectIdentifierValue1);
            this.setRelatedObjectSequence1(relatedObjectSequence1);
            this.setRelatedObjectIdentifierType2(relatedObjectIdentifierType2);
            this.setRelatedObjectIdentifierValue2(relatedObjectIdentifierValue2);
            this.setRelatedObjectSequence2(relatedObjectSequence2);
            this.setRelatedObjectIdentifierType3(relatedObjectIdentifierType3);
            this.setRelatedObjectIdentifierValue3(relatedObjectIdentifierValue3);
            this.setRelatedObjectSequence3(relatedObjectSequence3);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getRelationshipType() {
            return this.record.getSectionKeyValue(RELATIONSHIPTYPE);
        }

        public void setRelationshipType(String s) {
            this.record.updateKey(RELATIONSHIPTYPE, s);
        }

        public String getRelationshipSubType() {
            return this.record.getSectionKeyValue(RELATIONSHIPSUBTYPE);
        }

        public void setRelationshipSubType(String s) {
            this.record.updateKey(RELATIONSHIPSUBTYPE, s);
        }

        public String getRelatedObjectIdentifierType1() {
            return this.record.getSectionKeyValue(RELATEDOBJECTIDENTIFIERTYPE1);
        }

        public void setRelatedObjectIdentifierType1(String s) {
            this.record.updateKey(RELATEDOBJECTIDENTIFIERTYPE1, s);
        }

        public String getRelatedObjectIdentifierValue1() {
            return this.record.getSectionKeyValue(RELATEDOBJECTIDENTIFIERVALUE1);
        }

        public void setRelatedObjectIdentifierValue1(String s) {
            this.record.updateKey(RELATEDOBJECTIDENTIFIERVALUE1, s);
        }

        public String getRelatedObjectSequence1() {
            return this.record.getSectionKeyValue(RELATEDOBJECTSEQUENCE1);
        }

        public void setRelatedObjectSequence1(String s) {
            this.record.updateKey(RELATEDOBJECTSEQUENCE1, s);
        }

        public String getRelatedObjectIdentifierType2() {
            return this.record.getSectionKeyValue(RELATEDOBJECTIDENTIFIERTYPE2);
        }

        public void setRelatedObjectIdentifierType2(String s) {
            this.record.updateKey(RELATEDOBJECTIDENTIFIERTYPE2, s);
        }

        public String getRelatedObjectIdentifierValue2() {
            return this.record.getSectionKeyValue(RELATEDOBJECTIDENTIFIERVALUE2);
        }

        public void setRelatedObjectIdentifierValue2(String s) {
            this.record.updateKey(RELATEDOBJECTIDENTIFIERVALUE2, s);
        }

        public String getRelatedObjectSequence2() {
            return this.record.getSectionKeyValue(RELATEDOBJECTSEQUENCE2);
        }

        public void setRelatedObjectSequence2(String s) {
            this.record.updateKey(RELATEDOBJECTSEQUENCE2, s);
        }

        public String getRelatedObjectIdentifierType3() {
            return this.record.getSectionKeyValue(RELATEDOBJECTIDENTIFIERTYPE3);
        }

        public void setRelatedObjectIdentifierType3(String s) {
            this.record.updateKey(RELATEDOBJECTIDENTIFIERTYPE3, s);
        }

        public String getRelatedObjectIdentifierValue3() {
            return this.record.getSectionKeyValue(RELATEDOBJECTIDENTIFIERVALUE3);
        }

        public void setRelatedObjectIdentifierValue3(String s) {
            this.record.updateKey(RELATEDOBJECTIDENTIFIERVALUE3, s);
        }

        public String getRelatedObjectSequence3() {
            return this.record.getSectionKeyValue(RELATEDOBJECTSEQUENCE3);
        }

        public void setRelatedObjectSequence3(String s) {
            this.record.updateKey(RELATEDOBJECTSEQUENCE3, s);
        }
    }

    public class SignatureInformationExtension {
        public static final String sectionId = "signatureInformationExtension";
        public static final String SIGNATUREINFORMATIONEXTENSION = "signatureInformationExtension";
        private DnxSectionRecord record;

        public SignatureInformationExtension() {
            this.init();
        }

        private SignatureInformationExtension(DnxSectionRecord record) {
            this.record = record;
        }

        public SignatureInformationExtension(String signatureInformationExtension) {
            this.init();
            this.setSignatureInformationExtension(signatureInformationExtension);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById("signatureInformationExtension");
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection("signatureInformationExtension");
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getSignatureInformationExtension() {
            return this.record.getSectionKeyValue("signatureInformationExtension");
        }

        public void setSignatureInformationExtension(String s) {
            this.record.updateKey("signatureInformationExtension", s);
        }
    }

    public class SignatureInformation {
        public static final String sectionId = "signatureInformation";
        public static final String SIGNATUREINFORMATIONENCODING = "signatureInformationEncoding";
        public static final String SIGNER = "signer";
        public static final String SIGNATUREMETHOD = "signatureMethod";
        public static final String SIGNATUREVALUE = "signatureValue";
        public static final String SIGNATUREVALIDATIONRULES = "signatureValidationRules";
        public static final String SIGNATUREPROPERTIES = "signatureProperties";
        public static final String KEYINFORMATION = "keyInformation";
        private DnxSectionRecord record;

        public SignatureInformation() {
            this.init();
        }

        private SignatureInformation(DnxSectionRecord record) {
            this.record = record;
        }

        public SignatureInformation(String signatureInformationEncoding, String signer, String signatureMethod, String signatureValue, String signatureValidationRules, String signatureProperties, String keyInformation) {
            this.init();
            this.setSignatureInformationEncoding(signatureInformationEncoding);
            this.setSigner(signer);
            this.setSignatureMethod(signatureMethod);
            this.setSignatureValue(signatureValue);
            this.setSignatureValidationRules(signatureValidationRules);
            this.setSignatureProperties(signatureProperties);
            this.setKeyInformation(keyInformation);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getSignatureInformationEncoding() {
            return this.record.getSectionKeyValue(SIGNATUREINFORMATIONENCODING);
        }

        public void setSignatureInformationEncoding(String s) {
            this.record.updateKey(SIGNATUREINFORMATIONENCODING, s);
        }

        public String getSigner() {
            return this.record.getSectionKeyValue(SIGNER);
        }

        public void setSigner(String s) {
            this.record.updateKey(SIGNER, s);
        }

        public String getSignatureMethod() {
            return this.record.getSectionKeyValue(SIGNATUREMETHOD);
        }

        public void setSignatureMethod(String s) {
            this.record.updateKey(SIGNATUREMETHOD, s);
        }

        public String getSignatureValue() {
            return this.record.getSectionKeyValue(SIGNATUREVALUE);
        }

        public void setSignatureValue(String s) {
            this.record.updateKey(SIGNATUREVALUE, s);
        }

        public String getSignatureValidationRules() {
            return this.record.getSectionKeyValue(SIGNATUREVALIDATIONRULES);
        }

        public void setSignatureValidationRules(String s) {
            this.record.updateKey(SIGNATUREVALIDATIONRULES, s);
        }

        public String getSignatureProperties() {
            return this.record.getSectionKeyValue(SIGNATUREPROPERTIES);
        }

        public void setSignatureProperties(String s) {
            this.record.updateKey(SIGNATUREPROPERTIES, s);
        }

        public String getKeyInformation() {
            return this.record.getSectionKeyValue(KEYINFORMATION);
        }

        public void setKeyInformation(String s) {
            this.record.updateKey(KEYINFORMATION, s);
        }
    }

    public class EnvironmentExtension {
        public static final String sectionId = "environmentExtension";
        public static final String ENVIRONMENTEXTENSION = "environmentExtension";
        private DnxSectionRecord record;

        public EnvironmentExtension() {
            this.init();
        }

        private EnvironmentExtension(DnxSectionRecord record) {
            this.record = record;
        }

        public EnvironmentExtension(String environmentExtension) {
            this.init();
            this.setEnvironmentExtension(environmentExtension);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById("environmentExtension");
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection("environmentExtension");
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getEnvironmentExtension() {
            return this.record.getSectionKeyValue("environmentExtension");
        }

        public void setEnvironmentExtension(String s) {
            this.record.updateKey("environmentExtension", s);
        }
    }

    public class EnvHardwareRegistry {
        public static final String sectionId = "envHardwareRegistry";
        public static final String REGISTRYID = "registryId";
        private DnxSectionRecord record;

        public EnvHardwareRegistry() {
            this.init();
        }

        private EnvHardwareRegistry(DnxSectionRecord record) {
            this.record = record;
        }

        public EnvHardwareRegistry(String registryId) {
            this.init();
            this.setRegistryId(registryId);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getRegistryId() {
            return this.record.getSectionKeyValue(REGISTRYID);
        }

        public void setRegistryId(String s) {
            this.record.updateKey(REGISTRYID, s);
        }
    }

    public class EnvironmentHardware {
        public static final String sectionId = "environmentHardware";
        public static final String HARDWARENAME = "hardwareName";
        public static final String HARDWARETYPE = "hardwareType";
        public static final String HARDWAREOTHERINFORMATION = "hardwareOtherInformation";
        private DnxSectionRecord record;

        public EnvironmentHardware() {
            this.init();
        }

        private EnvironmentHardware(DnxSectionRecord record) {
            this.record = record;
        }

        public EnvironmentHardware(String hardwareName, String hardwareType, String hardwareOtherInformation) {
            this.init();
            this.setHardwareName(hardwareName);
            this.setHardwareType(hardwareType);
            this.setHardwareOtherInformation(hardwareOtherInformation);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getHardwareName() {
            return this.record.getSectionKeyValue(HARDWARENAME);
        }

        public void setHardwareName(String s) {
            this.record.updateKey(HARDWARENAME, s);
        }

        public String getHardwareType() {
            return this.record.getSectionKeyValue(HARDWARETYPE);
        }

        public void setHardwareType(String s) {
            this.record.updateKey(HARDWARETYPE, s);
        }

        public String getHardwareOtherInformation() {
            return this.record.getSectionKeyValue(HARDWAREOTHERINFORMATION);
        }

        public void setHardwareOtherInformation(String s) {
            this.record.updateKey(HARDWAREOTHERINFORMATION, s);
        }
    }

    public class EnvSoftwareRegistry {
        public static final String sectionId = "envSoftwareRegistry";
        public static final String REGISTRYID = "registryId";
        private DnxSectionRecord record;

        public EnvSoftwareRegistry() {
            this.init();
        }

        private EnvSoftwareRegistry(DnxSectionRecord record) {
            this.record = record;
        }

        public EnvSoftwareRegistry(String registryId) {
            this.init();
            this.setRegistryId(registryId);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getRegistryId() {
            return this.record.getSectionKeyValue(REGISTRYID);
        }

        public void setRegistryId(String s) {
            this.record.updateKey(REGISTRYID, s);
        }
    }

    public class EnvironmentSoftware {
        public static final String sectionId = "environmentSoftware";
        public static final String SOFTWARENAME = "softwareName";
        public static final String SOFTWAREVERSION = "softwareVersion";
        public static final String SOFTWARETYPE = "softwareType";
        public static final String SOFTWAREOTHERINFORMATION = "softwareOtherInformation";
        public static final String SOFTWAREDEPENDANCY = "softwareDependancy";
        private DnxSectionRecord record;

        public EnvironmentSoftware() {
            this.init();
        }

        private EnvironmentSoftware(DnxSectionRecord record) {
            this.record = record;
        }

        public EnvironmentSoftware(String softwareName, String softwareVersion, String softwareType, String softwareOtherInformation, String softwareDependancy) {
            this.init();
            this.setSoftwareName(softwareName);
            this.setSoftwareVersion(softwareVersion);
            this.setSoftwareType(softwareType);
            this.setSoftwareOtherInformation(softwareOtherInformation);
            this.setSoftwareDependancy(softwareDependancy);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getSoftwareName() {
            return this.record.getSectionKeyValue(SOFTWARENAME);
        }

        public void setSoftwareName(String s) {
            this.record.updateKey(SOFTWARENAME, s);
        }

        public String getSoftwareVersion() {
            return this.record.getSectionKeyValue(SOFTWAREVERSION);
        }

        public void setSoftwareVersion(String s) {
            this.record.updateKey(SOFTWAREVERSION, s);
        }

        public String getSoftwareType() {
            return this.record.getSectionKeyValue(SOFTWARETYPE);
        }

        public void setSoftwareType(String s) {
            this.record.updateKey(SOFTWARETYPE, s);
        }

        public String getSoftwareOtherInformation() {
            return this.record.getSectionKeyValue(SOFTWAREOTHERINFORMATION);
        }

        public void setSoftwareOtherInformation(String s) {
            this.record.updateKey(SOFTWAREOTHERINFORMATION, s);
        }

        public String getSoftwareDependancy() {
            return this.record.getSectionKeyValue(SOFTWAREDEPENDANCY);
        }

        public void setSoftwareDependancy(String s) {
            this.record.updateKey(SOFTWAREDEPENDANCY, s);
        }
    }

    public class EnvironmentDependencies {
        public static final String sectionId = "environmentDependencies";
        public static final String DEPENDENCYNAME = "dependencyName";
        public static final String DEPENDENCYIDENTIFIERTYPE1 = "dependencyIdentifierType1";
        public static final String DEPENDENCYIDENTIFIERVALUE1 = "dependencyIdentifierValue1";
        public static final String DEPENDENCYIDENTIFIERTYPE2 = "dependencyIdentifierType2";
        public static final String DEPENDENCYIDENTIFIERVALUE2 = "dependencyIdentifierValue2";
        public static final String DEPENDENCYIDENTIFIERTYPE3 = "dependencyIdentifierType3";
        public static final String DEPENDENCYIDENTIFIERVALUE3 = "dependencyIdentifierValue3";
        private DnxSectionRecord record;

        public EnvironmentDependencies() {
            this.init();
        }

        private EnvironmentDependencies(DnxSectionRecord record) {
            this.record = record;
        }

        public EnvironmentDependencies(String dependencyName, String dependencyIdentifierType1, String dependencyIdentifierValue1, String dependencyIdentifierType2, String dependencyIdentifierValue2, String dependencyIdentifierType3, String dependencyIdentifierValue3) {
            this.init();
            this.setDependencyName(dependencyName);
            this.setDependencyIdentifierType1(dependencyIdentifierType1);
            this.setDependencyIdentifierValue1(dependencyIdentifierValue1);
            this.setDependencyIdentifierType2(dependencyIdentifierType2);
            this.setDependencyIdentifierValue2(dependencyIdentifierValue2);
            this.setDependencyIdentifierType3(dependencyIdentifierType3);
            this.setDependencyIdentifierValue3(dependencyIdentifierValue3);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getDependencyName() {
            return this.record.getSectionKeyValue(DEPENDENCYNAME);
        }

        public void setDependencyName(String s) {
            this.record.updateKey(DEPENDENCYNAME, s);
        }

        public String getDependencyIdentifierType1() {
            return this.record.getSectionKeyValue(DEPENDENCYIDENTIFIERTYPE1);
        }

        public void setDependencyIdentifierType1(String s) {
            this.record.updateKey(DEPENDENCYIDENTIFIERTYPE1, s);
        }

        public String getDependencyIdentifierValue1() {
            return this.record.getSectionKeyValue(DEPENDENCYIDENTIFIERVALUE1);
        }

        public void setDependencyIdentifierValue1(String s) {
            this.record.updateKey(DEPENDENCYIDENTIFIERVALUE1, s);
        }

        public String getDependencyIdentifierType2() {
            return this.record.getSectionKeyValue(DEPENDENCYIDENTIFIERTYPE2);
        }

        public void setDependencyIdentifierType2(String s) {
            this.record.updateKey(DEPENDENCYIDENTIFIERTYPE2, s);
        }

        public String getDependencyIdentifierValue2() {
            return this.record.getSectionKeyValue(DEPENDENCYIDENTIFIERVALUE2);
        }

        public void setDependencyIdentifierValue2(String s) {
            this.record.updateKey(DEPENDENCYIDENTIFIERVALUE2, s);
        }

        public String getDependencyIdentifierType3() {
            return this.record.getSectionKeyValue(DEPENDENCYIDENTIFIERTYPE3);
        }

        public void setDependencyIdentifierType3(String s) {
            this.record.updateKey(DEPENDENCYIDENTIFIERTYPE3, s);
        }

        public String getDependencyIdentifierValue3() {
            return this.record.getSectionKeyValue(DEPENDENCYIDENTIFIERVALUE3);
        }

        public void setDependencyIdentifierValue3(String s) {
            this.record.updateKey(DEPENDENCYIDENTIFIERVALUE3, s);
        }
    }

    public class Environment {
        public static final String sectionId = "environment";
        public static final String ENVIRONMENTCHARACTERISTIC = "environmentCharacteristic";
        public static final String ENVIRONMENTPURPOSE = "environmentPurpose";
        public static final String ENVIRONMENTNOTE = "environmentNote";
        private DnxSectionRecord record;

        public Environment() {
            this.init();
        }

        private Environment(DnxSectionRecord record) {
            this.record = record;
        }

        public Environment(String environmentCharacteristic, String environmentPurpose, String environmentNote) {
            this.init();
            this.setEnvironmentCharacteristic(environmentCharacteristic);
            this.setEnvironmentPurpose(environmentPurpose);
            this.setEnvironmentNote(environmentNote);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getEnvironmentCharacteristic() {
            return this.record.getSectionKeyValue(ENVIRONMENTCHARACTERISTIC);
        }

        public void setEnvironmentCharacteristic(String s) {
            this.record.updateKey(ENVIRONMENTCHARACTERISTIC, s);
        }

        public String getEnvironmentPurpose() {
            return this.record.getSectionKeyValue(ENVIRONMENTPURPOSE);
        }

        public void setEnvironmentPurpose(String s) {
            this.record.updateKey(ENVIRONMENTPURPOSE, s);
        }

        public String getEnvironmentNote() {
            return this.record.getSectionKeyValue(ENVIRONMENTNOTE);
        }

        public void setEnvironmentNote(String s) {
            this.record.updateKey(ENVIRONMENTNOTE, s);
        }
    }

    public class ObjectCharacteristicsExtension {
        public static final String sectionId = "objectCharacteristicsExtension";
        public static final String OBJECTCHARACTERISTICSEXTENSION = "objectCharacteristicsExtension";
        private DnxSectionRecord record;

        public ObjectCharacteristicsExtension() {
            this.init();
        }

        private ObjectCharacteristicsExtension(DnxSectionRecord record) {
            this.record = record;
        }

        public ObjectCharacteristicsExtension(String objectCharacteristicsExtension) {
            this.init();
            this.setObjectCharacteristicsExtension(objectCharacteristicsExtension);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById("objectCharacteristicsExtension");
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection("objectCharacteristicsExtension");
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getObjectCharacteristicsExtension() {
            return this.record.getSectionKeyValue("objectCharacteristicsExtension");
        }

        public void setObjectCharacteristicsExtension(String s) {
            this.record.updateKey("objectCharacteristicsExtension", s);
        }
    }

    public class Inhibitors {
        public static final String sectionId = "inhibitors";
        public static final String INHIBITORTYPE = "inhibitorType";
        public static final String INHIBITORTARGET = "inhibitorTarget";
        public static final String INHIBITORKEY = "inhibitorKey";
        private DnxSectionRecord record;

        public Inhibitors() {
            this.init();
        }

        private Inhibitors(DnxSectionRecord record) {
            this.record = record;
        }

        public Inhibitors(String inhibitorType, String inhibitorTarget, String inhibitorKey) {
            this.init();
            this.setInhibitorType(inhibitorType);
            this.setInhibitorTarget(inhibitorTarget);
            this.setInhibitorKey(inhibitorKey);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getInhibitorType() {
            return this.record.getSectionKeyValue(INHIBITORTYPE);
        }

        public void setInhibitorType(String s) {
            this.record.updateKey(INHIBITORTYPE, s);
        }

        public String getInhibitorTarget() {
            return this.record.getSectionKeyValue(INHIBITORTARGET);
        }

        public void setInhibitorTarget(String s) {
            this.record.updateKey(INHIBITORTARGET, s);
        }

        public String getInhibitorKey() {
            return this.record.getSectionKeyValue(INHIBITORKEY);
        }

        public void setInhibitorKey(String s) {
            this.record.updateKey(INHIBITORKEY, s);
        }
    }

    public class CreatingApplication {
        public static final String sectionId = "creatingApplication";
        public static final String CREATINGAPPLICATIONNAME = "creatingApplicationName";
        public static final String CREATINGAPPLICATIONVERSION = "creatingApplicationVersion";
        public static final String DATECREATEDBYAPPLICATION = "dateCreatedByApplication";
        public static final String CREATINGAPPLICATIONEXTENSION = "creatingApplicationExtension";
        private DnxSectionRecord record;

        public CreatingApplication() {
            this.init();
        }

        private CreatingApplication(DnxSectionRecord record) {
            this.record = record;
        }

        public CreatingApplication(String creatingApplicationName, String creatingApplicationVersion, String dateCreatedByApplication, String creatingApplicationExtension) {
            this.init();
            this.setCreatingApplicationName(creatingApplicationName);
            this.setCreatingApplicationVersion(creatingApplicationVersion);
            this.setDateCreatedByApplication(dateCreatedByApplication);
            this.setCreatingApplicationExtension(creatingApplicationExtension);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getCreatingApplicationName() {
            return this.record.getSectionKeyValue(CREATINGAPPLICATIONNAME);
        }

        public void setCreatingApplicationName(String s) {
            this.record.updateKey(CREATINGAPPLICATIONNAME, s);
        }

        public String getCreatingApplicationVersion() {
            return this.record.getSectionKeyValue(CREATINGAPPLICATIONVERSION);
        }

        public void setCreatingApplicationVersion(String s) {
            this.record.updateKey(CREATINGAPPLICATIONVERSION, s);
        }

        public String getDateCreatedByApplication() {
            String value = this.record.getSectionKeyValue(DATECREATEDBYAPPLICATION);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalDateCreatedByApplication() {
            return this.record.getSectionKeyValue(DATECREATEDBYAPPLICATION);
        }

        public void setDateCreatedByApplication(String s) {
            this.record.updateKey(DATECREATEDBYAPPLICATION, s);
        }

        public String getCreatingApplicationExtension() {
            return this.record.getSectionKeyValue(CREATINGAPPLICATIONEXTENSION);
        }

        public void setCreatingApplicationExtension(String s) {
            this.record.updateKey(CREATINGAPPLICATIONEXTENSION, s);
        }
    }

    public class VsOutcome {
        public static final String sectionId = "vsOutcome";
        public static final String CHECKDATE = "checkDate";
        public static final String VSAGENT = "vsAgent";
        public static final String TYPE = "type";
        public static final String RESULT = "result";
        public static final String RESULTDETAILS = "resultDetails";
        public static final String VSEVALUATION = "vsEvaluation";
        public static final String VSEVALUATIONDETAILS = "vsEvaluationDetails";
        private DnxSectionRecord record;

        public VsOutcome() {
            this.init();
        }

        private VsOutcome(DnxSectionRecord record) {
            this.record = record;
        }

        public VsOutcome(String checkDate, String vsAgent, String type, String result, String resultDetails, String vsEvaluation, String vsEvaluationDetails) {
            this.init();
            this.setCheckDate(checkDate);
            this.setVsAgent(vsAgent);
            this.setType(type);
            this.setResult(result);
            this.setResultDetails(resultDetails);
            this.setVsEvaluation(vsEvaluation);
            this.setVsEvaluationDetails(vsEvaluationDetails);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getCheckDate() {
            String value = this.record.getSectionKeyValue(CHECKDATE);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalCheckDate() {
            return this.record.getSectionKeyValue(CHECKDATE);
        }

        public void setCheckDate(String s) {
            this.record.updateKey(CHECKDATE, s);
        }

        public String getVsAgent() {
            return this.record.getSectionKeyValue(VSAGENT);
        }

        public void setVsAgent(String s) {
            this.record.updateKey(VSAGENT, s);
        }

        public String getType() {
            return this.record.getSectionKeyValue(TYPE);
        }

        public void setType(String s) {
            this.record.updateKey(TYPE, s);
        }

        public String getResult() {
            return this.record.getSectionKeyValue(RESULT);
        }

        public void setResult(String s) {
            this.record.updateKey(RESULT, s);
        }

        public String getResultDetails() {
            return this.record.getSectionKeyValue(RESULTDETAILS);
        }

        public void setResultDetails(String s) {
            this.record.updateKey(RESULTDETAILS, s);
        }

        public String getVsEvaluation() {
            return this.record.getSectionKeyValue(VSEVALUATION);
        }

        public void setVsEvaluation(String s) {
            this.record.updateKey(VSEVALUATION, s);
        }

        public String getVsEvaluationDetails() {
            return this.record.getSectionKeyValue(VSEVALUATIONDETAILS);
        }

        public void setVsEvaluationDetails(String s) {
            this.record.updateKey(VSEVALUATIONDETAILS, s);
        }
    }

    public class FileValidation {
        public static final String sectionId = "fileValidation";
        public static final String AGENT = "agent";
        public static final String PLUGINNAME = "pluginName";
        public static final String STATUS = "status";
        public static final String FORMAT = "format";
        public static final String VERSION = "version";
        public static final String MIMETYPE = "mimeType";
        public static final String PROFILE = "profile";
        public static final String ISVALID = "isValid";
        public static final String ISWELLFORMED = "isWellFormed";
        public static final String ERRORMESSAGE = "errorMessage";
        private DnxSectionRecord record;

        public FileValidation() {
            this.init();
        }

        private FileValidation(DnxSectionRecord record) {
            this.record = record;
        }

        public FileValidation(String agent, String pluginName, String status, String format, String version, String mimeType, String profile, String isValid, String isWellFormed, String errorMessage) {
            this.init();
            this.setAgent(agent);
            this.setPluginName(pluginName);
            this.setStatus(status);
            this.setFormat(format);
            this.setVersion(version);
            this.setMimeType(mimeType);
            this.setProfile(profile);
            this.setIsValid(isValid);
            this.setIsWellFormed(isWellFormed);
            this.setErrorMessage(errorMessage);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getAgent() {
            return this.record.getSectionKeyValue(AGENT);
        }

        public void setAgent(String s) {
            this.record.updateKey(AGENT, s);
        }

        public String getPluginName() {
            return this.record.getSectionKeyValue(PLUGINNAME);
        }

        public void setPluginName(String s) {
            this.record.updateKey(PLUGINNAME, s);
        }

        public String getStatus() {
            return this.record.getSectionKeyValue(STATUS);
        }

        public void setStatus(String s) {
            this.record.updateKey(STATUS, s);
        }

        public String getFormat() {
            return this.record.getSectionKeyValue(FORMAT);
        }

        public void setFormat(String s) {
            this.record.updateKey(FORMAT, s);
        }

        public String getVersion() {
            return this.record.getSectionKeyValue(VERSION);
        }

        public void setVersion(String s) {
            this.record.updateKey(VERSION, s);
        }

        public String getMimeType() {
            return this.record.getSectionKeyValue(MIMETYPE);
        }

        public void setMimeType(String s) {
            this.record.updateKey(MIMETYPE, s);
        }

        public String getProfile() {
            return this.record.getSectionKeyValue(PROFILE);
        }

        public void setProfile(String s) {
            this.record.updateKey(PROFILE, s);
        }

        public String getIsValid() {
            return this.record.getSectionKeyValue(ISVALID);
        }

        public void setIsValid(String s) {
            this.record.updateKey(ISVALID, s);
        }

        public String getIsWellFormed() {
            return this.record.getSectionKeyValue(ISWELLFORMED);
        }

        public void setIsWellFormed(String s) {
            this.record.updateKey(ISWELLFORMED, s);
        }

        public String getErrorMessage() {
            return this.record.getSectionKeyValue(ERRORMESSAGE);
        }

        public void setErrorMessage(String s) {
            this.record.updateKey(ERRORMESSAGE, s);
        }
    }

    public class FileVirusCheck {
        public static final String sectionId = "fileVirusCheck";
        public static final String AGENT = "agent";
        public static final String STATUS = "status";
        public static final String CONTENT = "content";
        private DnxSectionRecord record;

        public FileVirusCheck() {
            this.init();
        }

        private FileVirusCheck(DnxSectionRecord record) {
            this.record = record;
        }

        public FileVirusCheck(String agent, String status, String content) {
            this.init();
            this.setAgent(agent);
            this.setStatus(status);
            this.setContent(content);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getAgent() {
            return this.record.getSectionKeyValue(AGENT);
        }

        public void setAgent(String s) {
            this.record.updateKey(AGENT, s);
        }

        public String getStatus() {
            return this.record.getSectionKeyValue(STATUS);
        }

        public void setStatus(String s) {
            this.record.updateKey(STATUS, s);
        }

        public String getContent() {
            return this.record.getSectionKeyValue(CONTENT);
        }

        public void setContent(String s) {
            this.record.updateKey(CONTENT, s);
        }
    }

    public class FileFormat {
        public static final String sectionId = "fileFormat";
        public static final String AGENT = "agent";
        public static final String FORMATREGISTRY = "formatRegistry";
        public static final String FORMATREGISTRYID = "formatRegistryId";
        public static final String FORMATREGISTRYROLE = "formatRegistryRole";
        public static final String FORMATNAME = "formatName";
        public static final String FORMATVERSION = "formatVersion";
        public static final String FORMATDESCRIPTION = "formatDescription";
        public static final String FORMATNOTE = "formatNote";
        public static final String EXACTFORMATIDENTIFICATION = "exactFormatIdentification";
        public static final String MIMETYPE = "mimeType";
        public static final String AGENTVERSION = "agentVersion";
        public static final String AGENTSIGNATUREVERSION = "agentSignatureVersion";
        public static final String IDENTIFICATIONMETHOD = "identificationMethod";
        public static final String FORMATLIBRARYVERSION = "formatLibraryVersion";
        private DnxSectionRecord record;

        public FileFormat() {
            this.init();
        }

        private FileFormat(DnxSectionRecord record) {
            this.record = record;
        }

        public FileFormat(String agent, String formatRegistry, String formatRegistryId, String formatRegistryRole, String formatName, String formatVersion, String formatDescription, String formatNote, String exactFormatIdentification, String mimeType, String agentVersion, String agentSignatureVersion, String identificationMethod, String formatLibraryVersion) {
            this.init();
            this.setAgent(agent);
            this.setFormatRegistry(formatRegistry);
            this.setFormatRegistryId(formatRegistryId);
            this.setFormatRegistryRole(formatRegistryRole);
            this.setFormatName(formatName);
            this.setFormatVersion(formatVersion);
            this.setFormatDescription(formatDescription);
            this.setFormatNote(formatNote);
            this.setExactFormatIdentification(exactFormatIdentification);
            this.setMimeType(mimeType);
            this.setAgentVersion(agentVersion);
            this.setAgentSignatureVersion(agentSignatureVersion);
            this.setIdentificationMethod(identificationMethod);
            this.setFormatLibraryVersion(formatLibraryVersion);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getAgent() {
            return this.record.getSectionKeyValue(AGENT);
        }

        public void setAgent(String s) {
            this.record.updateKey(AGENT, s);
        }

        public String getFormatRegistry() {
            return this.record.getSectionKeyValue(FORMATREGISTRY);
        }

        public void setFormatRegistry(String s) {
            this.record.updateKey(FORMATREGISTRY, s);
        }

        public String getFormatRegistryId() {
            return this.record.getSectionKeyValue(FORMATREGISTRYID);
        }

        public void setFormatRegistryId(String s) {
            this.record.updateKey(FORMATREGISTRYID, s);
        }

        public String getFormatRegistryRole() {
            return this.record.getSectionKeyValue(FORMATREGISTRYROLE);
        }

        public void setFormatRegistryRole(String s) {
            this.record.updateKey(FORMATREGISTRYROLE, s);
        }

        public String getFormatName() {
            return this.record.getSectionKeyValue(FORMATNAME);
        }

        public void setFormatName(String s) {
            this.record.updateKey(FORMATNAME, s);
        }

        public String getFormatVersion() {
            return this.record.getSectionKeyValue(FORMATVERSION);
        }

        public void setFormatVersion(String s) {
            this.record.updateKey(FORMATVERSION, s);
        }

        public String getFormatDescription() {
            return this.record.getSectionKeyValue(FORMATDESCRIPTION);
        }

        public void setFormatDescription(String s) {
            this.record.updateKey(FORMATDESCRIPTION, s);
        }

        public String getFormatNote() {
            return this.record.getSectionKeyValue(FORMATNOTE);
        }

        public void setFormatNote(String s) {
            this.record.updateKey(FORMATNOTE, s);
        }

        public String getExactFormatIdentification() {
            return this.record.getSectionKeyValue(EXACTFORMATIDENTIFICATION);
        }

        public void setExactFormatIdentification(String s) {
            this.record.updateKey(EXACTFORMATIDENTIFICATION, s);
        }

        public String getMimeType() {
            return this.record.getSectionKeyValue(MIMETYPE);
        }

        public void setMimeType(String s) {
            this.record.updateKey(MIMETYPE, s);
        }

        public String getAgentVersion() {
            return this.record.getSectionKeyValue(AGENTVERSION);
        }

        public void setAgentVersion(String s) {
            this.record.updateKey(AGENTVERSION, s);
        }

        public String getAgentSignatureVersion() {
            return this.record.getSectionKeyValue(AGENTSIGNATUREVERSION);
        }

        public void setAgentSignatureVersion(String s) {
            this.record.updateKey(AGENTSIGNATUREVERSION, s);
        }

        public String getIdentificationMethod() {
            return this.record.getSectionKeyValue(IDENTIFICATIONMETHOD);
        }

        public void setIdentificationMethod(String s) {
            this.record.updateKey(IDENTIFICATIONMETHOD, s);
        }

        public String getFormatLibraryVersion() {
            return this.record.getSectionKeyValue(FORMATLIBRARYVERSION);
        }

        public void setFormatLibraryVersion(String s) {
            this.record.updateKey(FORMATLIBRARYVERSION, s);
        }
    }

    public class FileFixity {
        public static final String sectionId = "fileFixity";
        public static final String AGENT = "agent";
        public static final String PLUGINNAME = "pluginName";
        public static final String FIXITYTYPE = "fixityType";
        public static final String FIXITYVALUE = "fixityValue";
        private DnxSectionRecord record;

        public FileFixity() {
            this.init();
        }

        private FileFixity(DnxSectionRecord record) {
            this.record = record;
        }

        public FileFixity(String agent, String pluginName, String fixityType, String fixityValue) {
            this.init();
            this.setAgent(agent);
            this.setPluginName(pluginName);
            this.setFixityType(fixityType);
            this.setFixityValue(fixityValue);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getAgent() {
            return this.record.getSectionKeyValue(AGENT);
        }

        public void setAgent(String s) {
            this.record.updateKey(AGENT, s);
        }

        public String getPluginName() {
            return this.record.getSectionKeyValue(PLUGINNAME);
        }

        public void setPluginName(String s) {
            this.record.updateKey(PLUGINNAME, s);
        }

        public String getFixityType() {
            return this.record.getSectionKeyValue(FIXITYTYPE);
        }

        public void setFixityType(String s) {
            this.record.updateKey(FIXITYTYPE, s);
        }

        public String getFixityValue() {
            return this.record.getSectionKeyValue(FIXITYVALUE);
        }

        public void setFixityValue(String s) {
            this.record.updateKey(FIXITYVALUE, s);
        }
    }

    public class SignificantProperties {
        public static final String sectionId = "significantProperties";
        public static final String SIGNIFICANTPROPERTIESTYPE = "significantPropertiesType";
        public static final String SIGNIFICANTPROPERTIESVALUE = "significantPropertiesValue";
        public static final String SIGNIFICANTPROPERTIESEXTENSION = "significantPropertiesExtension";
        private DnxSectionRecord record;

        public SignificantProperties() {
            this.init();
        }

        private SignificantProperties(DnxSectionRecord record) {
            this.record = record;
        }

        public SignificantProperties(String significantPropertiesType, String significantPropertiesValue, String significantPropertiesExtension) {
            this.init();
            this.setSignificantPropertiesType(significantPropertiesType);
            this.setSignificantPropertiesValue(significantPropertiesValue);
            this.setSignificantPropertiesExtension(significantPropertiesExtension);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getSignificantPropertiesType() {
            return this.record.getSectionKeyValue(SIGNIFICANTPROPERTIESTYPE);
        }

        public void setSignificantPropertiesType(String s) {
            this.record.updateKey(SIGNIFICANTPROPERTIESTYPE, s);
        }

        public String getSignificantPropertiesValue() {
            return this.record.getSectionKeyValue(SIGNIFICANTPROPERTIESVALUE);
        }

        public void setSignificantPropertiesValue(String s) {
            this.record.updateKey(SIGNIFICANTPROPERTIESVALUE, s);
        }

        public String getSignificantPropertiesExtension() {
            return this.record.getSectionKeyValue(SIGNIFICANTPROPERTIESEXTENSION);
        }

        public void setSignificantPropertiesExtension(String s) {
            this.record.updateKey(SIGNIFICANTPROPERTIESEXTENSION, s);
        }
    }

    public class PreservationLevel {
        public static final String sectionId = "preservationLevel";
        public static final String PRESERVATIONLEVELVALUE = "preservationLevelValue";
        public static final String PRESERVATIONLEVELROLE = "preservationLevelRole";
        public static final String PRESERVATIONLEVELRATIONALE = "preservationLevelRationale";
        public static final String PRESERVATIONLEVELDATEASSIGNED = "preservationLevelDateAssigned";
        public static final String PRESERVATIONLEVELTYPE = "preservationLevelType";
        private DnxSectionRecord record;

        public PreservationLevel() {
            this.init();
        }

        private PreservationLevel(DnxSectionRecord record) {
            this.record = record;
        }

        public PreservationLevel(String preservationLevelValue, String preservationLevelRole, String preservationLevelRationale, String preservationLevelDateAssigned, String preservationLevelType) {
            this.init();
            this.setPreservationLevelValue(preservationLevelValue);
            this.setPreservationLevelRole(preservationLevelRole);
            this.setPreservationLevelRationale(preservationLevelRationale);
            this.setPreservationLevelDateAssigned(preservationLevelDateAssigned);
            this.setPreservationLevelType(preservationLevelType);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getPreservationLevelValue() {
            return this.record.getSectionKeyValue(PRESERVATIONLEVELVALUE);
        }

        public void setPreservationLevelValue(String s) {
            this.record.updateKey(PRESERVATIONLEVELVALUE, s);
        }

        public String getPreservationLevelRole() {
            return this.record.getSectionKeyValue(PRESERVATIONLEVELROLE);
        }

        public void setPreservationLevelRole(String s) {
            this.record.updateKey(PRESERVATIONLEVELROLE, s);
        }

        public String getPreservationLevelRationale() {
            return this.record.getSectionKeyValue(PRESERVATIONLEVELRATIONALE);
        }

        public void setPreservationLevelRationale(String s) {
            this.record.updateKey(PRESERVATIONLEVELRATIONALE, s);
        }

        public String getPreservationLevelDateAssigned() {
            String value = this.record.getSectionKeyValue(PRESERVATIONLEVELDATEASSIGNED);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalPreservationLevelDateAssigned() {
            return this.record.getSectionKeyValue(PRESERVATIONLEVELDATEASSIGNED);
        }

        public void setPreservationLevelDateAssigned(String s) {
            this.record.updateKey(PRESERVATIONLEVELDATEASSIGNED, s);
        }

        public String getPreservationLevelType() {
            return this.record.getSectionKeyValue(PRESERVATIONLEVELTYPE);
        }

        public void setPreservationLevelType(String s) {
            this.record.updateKey(PRESERVATIONLEVELTYPE, s);
        }
    }

    public class ObjectIdentifier {
        public static final String sectionId = "objectIdentifier";
        public static final String OBJECTIDENTIFIERTYPE = "objectIdentifierType";
        public static final String OBJECTIDENTIFIERVALUE = "objectIdentifierValue";
        private DnxSectionRecord record;

        public ObjectIdentifier() {
            this.init();
        }

        private ObjectIdentifier(DnxSectionRecord record) {
            this.record = record;
        }

        public ObjectIdentifier(String objectIdentifierType, String objectIdentifierValue) {
            this.init();
            this.setObjectIdentifierType(objectIdentifierType);
            this.setObjectIdentifierValue(objectIdentifierValue);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getObjectIdentifierType() {
            return this.record.getSectionKeyValue(OBJECTIDENTIFIERTYPE);
        }

        public void setObjectIdentifierType(String s) {
            this.record.updateKey(OBJECTIDENTIFIERTYPE, s);
        }

        public String getObjectIdentifierValue() {
            return this.record.getSectionKeyValue(OBJECTIDENTIFIERVALUE);
        }

        public void setObjectIdentifierValue(String s) {
            this.record.updateKey(OBJECTIDENTIFIERVALUE, s);
        }
    }

    public class InternalIdentifier {
        public static final String sectionId = "internalIdentifier";
        public static final String INTERNALIDENTIFIERTYPE = "internalIdentifierType";
        public static final String INTERNALIDENTIFIERVALUE = "internalIdentifierValue";
        private DnxSectionRecord record;

        public InternalIdentifier() {
            this.init();
        }

        private InternalIdentifier(DnxSectionRecord record) {
            this.record = record;
        }

        public InternalIdentifier(String internalIdentifierType, String internalIdentifierValue) {
            this.init();
            this.setInternalIdentifierType(internalIdentifierType);
            this.setInternalIdentifierValue(internalIdentifierValue);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getInternalIdentifierType() {
            return this.record.getSectionKeyValue(INTERNALIDENTIFIERTYPE);
        }

        public void setInternalIdentifierType(String s) {
            this.record.updateKey(INTERNALIDENTIFIERTYPE, s);
        }

        public String getInternalIdentifierValue() {
            return this.record.getSectionKeyValue(INTERNALIDENTIFIERVALUE);
        }

        public void setInternalIdentifierValue(String s) {
            this.record.updateKey(INTERNALIDENTIFIERVALUE, s);
        }
    }

    public class WebHarvesting {
        public static final String sectionId = "webHarvesting";
        public static final String PRIMARYSEEDURL = "primarySeedURL";
        public static final String WCTIDENTIFIER = "WCTIdentifier";
        public static final String TARGETNAME = "targetName";
        public static final String GROUP = "group";
        public static final String HARVESTDATE = "harvestDate";
        public static final String HARVESTTIME = "harvestTime";
        private DnxSectionRecord record;

        public WebHarvesting() {
            this.init();
        }

        private WebHarvesting(DnxSectionRecord record) {
            this.record = record;
        }

        public WebHarvesting(String primarySeedURL, String WCTIdentifier, String targetName, String group, String harvestDate, String harvestTime) {
            this.init();
            this.setPrimarySeedURL(primarySeedURL);
            this.setWCTIdentifier(WCTIdentifier);
            this.setTargetName(targetName);
            this.setGroup(group);
            this.setHarvestDate(harvestDate);
            this.setHarvestTime(harvestTime);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getPrimarySeedURL() {
            return this.record.getSectionKeyValue(PRIMARYSEEDURL);
        }

        public void setPrimarySeedURL(String s) {
            this.record.updateKey(PRIMARYSEEDURL, s);
        }

        public String getWCTIdentifier() {
            return this.record.getSectionKeyValue(WCTIDENTIFIER);
        }

        public void setWCTIdentifier(String s) {
            this.record.updateKey(WCTIDENTIFIER, s);
        }

        public String getTargetName() {
            return this.record.getSectionKeyValue(TARGETNAME);
        }

        public void setTargetName(String s) {
            this.record.updateKey(TARGETNAME, s);
        }

        public String getGroup() {
            return this.record.getSectionKeyValue(GROUP);
        }

        public void setGroup(String s) {
            this.record.updateKey(GROUP, s);
        }

        public String getHarvestDate() {
            String value = this.record.getSectionKeyValue(HARVESTDATE);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalHarvestDate() {
            return this.record.getSectionKeyValue(HARVESTDATE);
        }

        public void setHarvestDate(String s) {
            this.record.updateKey(HARVESTDATE, s);
        }

        public String getHarvestTime() {
            String value = this.record.getSectionKeyValue(HARVESTTIME);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalHarvestTime() {
            return this.record.getSectionKeyValue(HARVESTTIME);
        }

        public void setHarvestTime(String s) {
            this.record.updateKey(HARVESTTIME, s);
        }
    }

    public class CMS {
        public static final String sectionId = "CMS";
        public static final String SYSTEM = "system";
        public static final String RECORDID = "recordId";
        public static final String MID = "mId";
        private DnxSectionRecord record;

        public CMS() {
            this.init();
        }

        private CMS(DnxSectionRecord record) {
            this.record = record;
        }

        public CMS(String system, String recordId, String mId) {
            this.init();
            this.setSystem(system);
            this.setRecordId(recordId);
            this.setMId(mId);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getSystem() {
            return this.record.getSectionKeyValue(SYSTEM);
        }

        public void setSystem(String s) {
            this.record.updateKey(SYSTEM, s);
        }

        public String getRecordId() {
            return this.record.getSectionKeyValue(RECORDID);
        }

        public void setRecordId(String s) {
            this.record.updateKey(RECORDID, s);
        }

        public String getMId() {
            return this.record.getSectionKeyValue(MID);
        }

        public void setMId(String s) {
            this.record.updateKey(MID, s);
        }
    }

    public class ObjectCharacteristics {
        public static final String sectionId = "objectCharacteristics";
        public static final String OBJECTTYPE = "objectType";
        public static final String PARENTID = "parentID";
        public static final String GROUPID = "groupID";
        public static final String CREATIONDATE = "creationDate";
        public static final String CREATEDBY = "createdBy";
        public static final String MODIFICATIONDATE = "modificationDate";
        public static final String MODIFIEDBY = "modifiedBy";
        public static final String OWNER = "owner";
        private DnxSectionRecord record;

        public ObjectCharacteristics() {
            this.init();
        }

        private ObjectCharacteristics(DnxSectionRecord record) {
            this.record = record;
        }

        public ObjectCharacteristics(String objectType2, String parentID, String groupID, String creationDate, String createdBy, String modificationDate, String modifiedBy, String owner) {
            this.init();
            this.setObjectType(objectType2);
            this.setParentID(parentID);
            this.setGroupID(groupID);
            this.setCreationDate(creationDate);
            this.setCreatedBy(createdBy);
            this.setModificationDate(modificationDate);
            this.setModifiedBy(modifiedBy);
            this.setOwner(owner);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getObjectType() {
            return this.record.getSectionKeyValue(OBJECTTYPE);
        }

        public void setObjectType(String s) {
            this.record.updateKey(OBJECTTYPE, s);
        }

        public String getParentID() {
            return this.record.getSectionKeyValue(PARENTID);
        }

        public void setParentID(String s) {
            this.record.updateKey(PARENTID, s);
        }

        public String getGroupID() {
            return this.record.getSectionKeyValue(GROUPID);
        }

        public void setGroupID(String s) {
            this.record.updateKey(GROUPID, s);
        }

        public String getCreationDate() {
            String value = this.record.getSectionKeyValue(CREATIONDATE);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalCreationDate() {
            return this.record.getSectionKeyValue(CREATIONDATE);
        }

        public void setCreationDate(String s) {
            this.record.updateKey(CREATIONDATE, s);
        }

        public String getCreatedBy() {
            return this.record.getSectionKeyValue(CREATEDBY);
        }

        public void setCreatedBy(String s) {
            this.record.updateKey(CREATEDBY, s);
        }

        public String getModificationDate() {
            String value = this.record.getSectionKeyValue(MODIFICATIONDATE);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalModificationDate() {
            return this.record.getSectionKeyValue(MODIFICATIONDATE);
        }

        public void setModificationDate(String s) {
            this.record.updateKey(MODIFICATIONDATE, s);
        }

        public String getModifiedBy() {
            return this.record.getSectionKeyValue(MODIFIEDBY);
        }

        public void setModifiedBy(String s) {
            this.record.updateKey(MODIFIEDBY, s);
        }

        public String getOwner() {
            return this.record.getSectionKeyValue(OWNER);
        }

        public void setOwner(String s) {
            this.record.updateKey(OWNER, s);
        }
    }

    public class GeneralFileCharacteristics {
        public static final String sectionId = "generalFileCharacteristics";
        public static final String LABEL = "label";
        public static final String NOTE = "note";
        public static final String FILECREATIONDATE = "fileCreationDate";
        public static final String FILEMODIFICATIONDATE = "fileModificationDate";
        public static final String FILEENTITYTYPE = "FileEntityType";
        public static final String COMPOSITIONLEVEL = "compositionLevel";
        public static final String FILELOCATIONTYPE = "fileLocationType";
        public static final String FILELOCATION = "fileLocation";
        public static final String FILEORIGINALNAME = "fileOriginalName";
        public static final String FILEORIGINALPATH = "fileOriginalPath";
        public static final String FILEORIGINALID = "fileOriginalID";
        public static final String FILEEXTENSION = "fileExtension";
        public static final String FILEMIMETYPE = "fileMIMEType";
        public static final String FILESIZEBYTES = "fileSizeBytes";
        public static final String FORMATLIBRARYID = "formatLibraryId";
        public static final String RISKLIBRARYIDENTIFIERS = "riskLibraryIdentifiers";
        private DnxSectionRecord record;

        public GeneralFileCharacteristics() {
            this.init();
        }

        private GeneralFileCharacteristics(DnxSectionRecord record) {
            this.record = record;
        }

        public GeneralFileCharacteristics(String label, String note, String fileCreationDate, String fileModificationDate, String FileEntityType, String compositionLevel, String fileLocationType, String fileLocation, String fileOriginalName, String fileOriginalPath, String fileOriginalID, String fileExtension, String fileMIMEType, String fileSizeBytes, String formatLibraryId, String riskLibraryIdentifiers) {
            this.init();
            this.setLabel(label);
            this.setNote(note);
            this.setFileCreationDate(fileCreationDate);
            this.setFileModificationDate(fileModificationDate);
            this.setFileEntityType(FileEntityType);
            this.setCompositionLevel(compositionLevel);
            this.setFileLocationType(fileLocationType);
            this.setFileLocation(fileLocation);
            this.setFileOriginalName(fileOriginalName);
            this.setFileOriginalPath(fileOriginalPath);
            this.setFileOriginalID(fileOriginalID);
            this.setFileExtension(fileExtension);
            this.setFileMIMEType(fileMIMEType);
            this.setFileSizeBytes(fileSizeBytes);
            this.setFormatLibraryId(formatLibraryId);
            this.setRiskLibraryIdentifiers(riskLibraryIdentifiers);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getLabel() {
            return this.record.getSectionKeyValue(LABEL);
        }

        public void setLabel(String s) {
            this.record.updateKey(LABEL, s);
        }

        public String getNote() {
            return this.record.getSectionKeyValue(NOTE);
        }

        public void setNote(String s) {
            this.record.updateKey(NOTE, s);
        }

        public String getFileCreationDate() {
            String value = this.record.getSectionKeyValue(FILECREATIONDATE);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalFileCreationDate() {
            return this.record.getSectionKeyValue(FILECREATIONDATE);
        }

        public void setFileCreationDate(String s) {
            this.record.updateKey(FILECREATIONDATE, s);
        }

        public String getFileModificationDate() {
            String value = this.record.getSectionKeyValue(FILEMODIFICATIONDATE);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalFileModificationDate() {
            return this.record.getSectionKeyValue(FILEMODIFICATIONDATE);
        }

        public void setFileModificationDate(String s) {
            this.record.updateKey(FILEMODIFICATIONDATE, s);
        }

        public String getFileEntityType() {
            return this.record.getSectionKeyValue(FILEENTITYTYPE);
        }

        public void setFileEntityType(String s) {
            this.record.updateKey(FILEENTITYTYPE, s);
        }

        public String getCompositionLevel() {
            return this.record.getSectionKeyValue(COMPOSITIONLEVEL);
        }

        public void setCompositionLevel(String s) {
            this.record.updateKey(COMPOSITIONLEVEL, s);
        }

        public String getFileLocationType() {
            return this.record.getSectionKeyValue(FILELOCATIONTYPE);
        }

        public void setFileLocationType(String s) {
            this.record.updateKey(FILELOCATIONTYPE, s);
        }

        public String getFileLocation() {
            return this.record.getSectionKeyValue(FILELOCATION);
        }

        public void setFileLocation(String s) {
            this.record.updateKey(FILELOCATION, s);
        }

        public String getFileOriginalName() {
            return this.record.getSectionKeyValue(FILEORIGINALNAME);
        }

        public void setFileOriginalName(String s) {
            this.record.updateKey(FILEORIGINALNAME, s);
        }

        public String getFileOriginalPath() {
            return this.record.getSectionKeyValue(FILEORIGINALPATH);
        }

        public void setFileOriginalPath(String s) {
            this.record.updateKey(FILEORIGINALPATH, s);
        }

        public String getFileOriginalID() {
            return this.record.getSectionKeyValue(FILEORIGINALID);
        }

        public void setFileOriginalID(String s) {
            this.record.updateKey(FILEORIGINALID, s);
        }

        public String getFileExtension() {
            return this.record.getSectionKeyValue(FILEEXTENSION);
        }

        public void setFileExtension(String s) {
            this.record.updateKey(FILEEXTENSION, s);
        }

        public String getFileMIMEType() {
            return this.record.getSectionKeyValue(FILEMIMETYPE);
        }

        public void setFileMIMEType(String s) {
            this.record.updateKey(FILEMIMETYPE, s);
        }

        public String getFileSizeBytes() {
            return this.record.getSectionKeyValue(FILESIZEBYTES);
        }

        public void setFileSizeBytes(String s) {
            this.record.updateKey(FILESIZEBYTES, s);
        }

        public String getFormatLibraryId() {
            return this.record.getSectionKeyValue(FORMATLIBRARYID);
        }

        public void setFormatLibraryId(String s) {
            this.record.updateKey(FORMATLIBRARYID, s);
        }

        public String getRiskLibraryIdentifiers() {
            return this.record.getSectionKeyValue(RISKLIBRARYIDENTIFIERS);
        }

        public void setRiskLibraryIdentifiers(String s) {
            this.record.updateKey(RISKLIBRARYIDENTIFIERS, s);
        }
    }

    public class GeneralRepCharacteristics {
        public static final String sectionId = "generalRepCharacteristics";
        public static final String LABEL = "label";
        public static final String PRESERVATIONTYPE = "preservationType";
        public static final String USAGETYPE = "usageType";
        public static final String REPRESENTATIONENTITYTYPE = "representationEntityType";
        public static final String CONTENTTYPE = "contentType";
        public static final String CONTEXTTYPE = "contextType";
        public static final String HARDWAREUSED = "hardwareUsed";
        public static final String PHYSICALCARRIERMEDIA = "physicalCarrierMedia";
        public static final String DERIVEDFROMID = "derivedFromId";
        public static final String DELIVERYPRIORITY = "deliveryPriority";
        public static final String ORDERINGSEQUENCE = "orderingSequence";
        public static final String DIGITALORIGINAL = "DigitalOriginal";
        public static final String REVISIONNUMBER = "RevisionNumber";
        public static final String REPRESENTATIONCODE = "RepresentationCode";
        public static final String TASKID = "TaskID";
        public static final String REPRESENTATIONORIGINALNAME = "RepresentationOriginalName";
        public static final String USERDEFINEDA = "UserDefinedA";
        public static final String USERDEFINEDB = "UserDefinedB";
        public static final String USERDEFINEDC = "UserDefinedC";
        private DnxSectionRecord record;

        public GeneralRepCharacteristics() {
            this.init();
        }

        private GeneralRepCharacteristics(DnxSectionRecord record) {
            this.record = record;
        }

        public GeneralRepCharacteristics(String label, String preservationType, String usageType, String representationEntityType, String contentType, String contextType, String hardwareUsed, String physicalCarrierMedia, String derivedFromId, String deliveryPriority, String orderingSequence, String DigitalOriginal, String RevisionNumber, String RepresentationCode, String TaskID, String RepresentationOriginalName, String UserDefinedA, String UserDefinedB, String UserDefinedC) {
            this.init();
            this.setLabel(label);
            this.setPreservationType(preservationType);
            this.setUsageType(usageType);
            this.setRepresentationEntityType(representationEntityType);
            this.setContentType(contentType);
            this.setContextType(contextType);
            this.setHardwareUsed(hardwareUsed);
            this.setPhysicalCarrierMedia(physicalCarrierMedia);
            this.setDerivedFromId(derivedFromId);
            this.setDeliveryPriority(deliveryPriority);
            this.setOrderingSequence(orderingSequence);
            this.setDigitalOriginal(DigitalOriginal);
            this.setRevisionNumber(RevisionNumber);
            this.setRepresentationCode(RepresentationCode);
            this.setTaskID(TaskID);
            this.setRepresentationOriginalName(RepresentationOriginalName);
            this.setUserDefinedA(UserDefinedA);
            this.setUserDefinedB(UserDefinedB);
            this.setUserDefinedC(UserDefinedC);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getLabel() {
            return this.record.getSectionKeyValue(LABEL);
        }

        public void setLabel(String s) {
            this.record.updateKey(LABEL, s);
        }

        public String getPreservationType() {
            return this.record.getSectionKeyValue(PRESERVATIONTYPE);
        }

        public void setPreservationType(String s) {
            this.record.updateKey(PRESERVATIONTYPE, s);
        }

        public String getUsageType() {
            return this.record.getSectionKeyValue(USAGETYPE);
        }

        public void setUsageType(String s) {
            this.record.updateKey(USAGETYPE, s);
        }

        public String getRepresentationEntityType() {
            return this.record.getSectionKeyValue(REPRESENTATIONENTITYTYPE);
        }

        public void setRepresentationEntityType(String s) {
            this.record.updateKey(REPRESENTATIONENTITYTYPE, s);
        }

        public String getContentType() {
            return this.record.getSectionKeyValue(CONTENTTYPE);
        }

        public void setContentType(String s) {
            this.record.updateKey(CONTENTTYPE, s);
        }

        public String getContextType() {
            return this.record.getSectionKeyValue(CONTEXTTYPE);
        }

        public void setContextType(String s) {
            this.record.updateKey(CONTEXTTYPE, s);
        }

        public String getHardwareUsed() {
            return this.record.getSectionKeyValue(HARDWAREUSED);
        }

        public void setHardwareUsed(String s) {
            this.record.updateKey(HARDWAREUSED, s);
        }

        public String getPhysicalCarrierMedia() {
            return this.record.getSectionKeyValue(PHYSICALCARRIERMEDIA);
        }

        public void setPhysicalCarrierMedia(String s) {
            this.record.updateKey(PHYSICALCARRIERMEDIA, s);
        }

        public String getDerivedFromId() {
            return this.record.getSectionKeyValue(DERIVEDFROMID);
        }

        public void setDerivedFromId(String s) {
            this.record.updateKey(DERIVEDFROMID, s);
        }

        public String getDeliveryPriority() {
            return this.record.getSectionKeyValue(DELIVERYPRIORITY);
        }

        public void setDeliveryPriority(String s) {
            this.record.updateKey(DELIVERYPRIORITY, s);
        }

        public String getOrderingSequence() {
            return this.record.getSectionKeyValue(ORDERINGSEQUENCE);
        }

        public void setOrderingSequence(String s) {
            this.record.updateKey(ORDERINGSEQUENCE, s);
        }

        public String getDigitalOriginal() {
            return this.record.getSectionKeyValue(DIGITALORIGINAL);
        }

        public void setDigitalOriginal(String s) {
            this.record.updateKey(DIGITALORIGINAL, s);
        }

        public String getRevisionNumber() {
            return this.record.getSectionKeyValue(REVISIONNUMBER);
        }

        public void setRevisionNumber(String s) {
            this.record.updateKey(REVISIONNUMBER, s);
        }

        public String getRepresentationCode() {
            return this.record.getSectionKeyValue(REPRESENTATIONCODE);
        }

        public void setRepresentationCode(String s) {
            this.record.updateKey(REPRESENTATIONCODE, s);
        }

        public String getTaskID() {
            return this.record.getSectionKeyValue(TASKID);
        }

        public void setTaskID(String s) {
            this.record.updateKey(TASKID, s);
        }

        public String getRepresentationOriginalName() {
            return this.record.getSectionKeyValue(REPRESENTATIONORIGINALNAME);
        }

        public void setRepresentationOriginalName(String s) {
            this.record.updateKey(REPRESENTATIONORIGINALNAME, s);
        }

        public String getUserDefinedA() {
            return this.record.getSectionKeyValue(USERDEFINEDA);
        }

        public void setUserDefinedA(String s) {
            this.record.updateKey(USERDEFINEDA, s);
        }

        public String getUserDefinedB() {
            return this.record.getSectionKeyValue(USERDEFINEDB);
        }

        public void setUserDefinedB(String s) {
            this.record.updateKey(USERDEFINEDB, s);
        }

        public String getUserDefinedC() {
            return this.record.getSectionKeyValue(USERDEFINEDC);
        }

        public void setUserDefinedC(String s) {
            this.record.updateKey(USERDEFINEDC, s);
        }
    }

    public class GeneralIECharacteristics {
        public static final String sectionId = "generalIECharacteristics";
        public static final String SUBMISSIONREASON = "submissionReason";
        public static final String STATUS = "status";
        public static final String STATUSDATE = "statusDate";
        public static final String IEENTITYTYPE = "IEEntityType";
        public static final String VERSION = "Version";
        public static final String USERDEFINEDA = "UserDefinedA";
        public static final String USERDEFINEDB = "UserDefinedB";
        public static final String USERDEFINEDC = "UserDefinedC";
        private DnxSectionRecord record;

        public GeneralIECharacteristics() {
            this.init();
        }

        private GeneralIECharacteristics(DnxSectionRecord record) {
            this.record = record;
        }

        public GeneralIECharacteristics(String submissionReason, String status, String statusDate, String IEEntityType, String Version2, String UserDefinedA, String UserDefinedB, String UserDefinedC) {
            this.init();
            this.setSubmissionReason(submissionReason);
            this.setStatus(status);
            this.setStatusDate(statusDate);
            this.setIEEntityType(IEEntityType);
            this.setVersion(Version2);
            this.setUserDefinedA(UserDefinedA);
            this.setUserDefinedB(UserDefinedB);
            this.setUserDefinedC(UserDefinedC);
        }

        private void init() {
            DnxSection sec = DnxDocumentHelper.this.document.getSectionById(sectionId);
            if (sec == null) {
                sec = DnxDocumentHelper.this.document.createSection(sectionId);
            }
            this.setRecord(sec.createRecord());
        }

        public DnxSectionRecord getRecord() {
            return this.record;
        }

        public void setRecord(DnxSectionRecord record) {
            this.record = record;
        }

        public String getSubmissionReason() {
            return this.record.getSectionKeyValue(SUBMISSIONREASON);
        }

        public void setSubmissionReason(String s) {
            this.record.updateKey(SUBMISSIONREASON, s);
        }

        public String getStatus() {
            return this.record.getSectionKeyValue(STATUS);
        }

        public void setStatus(String s) {
            this.record.updateKey(STATUS, s);
        }

        public String getStatusDate() {
            String value = this.record.getSectionKeyValue(STATUSDATE);
            try {
                Date date = DateHandler.getInternalDate(value);
                value = DateHandler.formatDateAndTime(date);
            }
            catch (ParseException e) {
                logger.warn((Object)"Failed formatting date.", e, new String[0]);
            }
            return value;
        }

        public String getInternalStatusDate() {
            return this.record.getSectionKeyValue(STATUSDATE);
        }

        public void setStatusDate(String s) {
            this.record.updateKey(STATUSDATE, s);
        }

        public String getIEEntityType() {
            return this.record.getSectionKeyValue(IEENTITYTYPE);
        }

        public void setIEEntityType(String s) {
            this.record.updateKey(IEENTITYTYPE, s);
        }

        public String getVersion() {
            return this.record.getSectionKeyValue(VERSION);
        }

        public void setVersion(String s) {
            this.record.updateKey(VERSION, s);
        }

        public String getUserDefinedA() {
            return this.record.getSectionKeyValue(USERDEFINEDA);
        }

        public void setUserDefinedA(String s) {
            this.record.updateKey(USERDEFINEDA, s);
        }

        public String getUserDefinedB() {
            return this.record.getSectionKeyValue(USERDEFINEDB);
        }

        public void setUserDefinedB(String s) {
            this.record.updateKey(USERDEFINEDB, s);
        }

        public String getUserDefinedC() {
            return this.record.getSectionKeyValue(USERDEFINEDC);
        }

        public void setUserDefinedC(String s) {
            this.record.updateKey(USERDEFINEDC, s);
        }
    }
}

