/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.dps.sdk.techmd;

import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.svc.api.scriptRunner.ScriptPluginRunner;
import com.exlibris.digitool.repository.api.xmlbeans.MdExtractorDocument;
import com.exlibris.dps.sdk.techmd.MDExtractorPlugin;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.impl.values.XmlValueOutOfRangeException;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class MDExtractionPluginScript
extends ScriptPluginRunner
implements MDExtractorPlugin {
    private MdExtractorDocument doc = null;
    private MdExtractorDocument.MdExtractor mdExtractor = null;
    private static final String KEY = "key";
    private static final String BIN_DIR = "bin";
    private static final String PROPERTIES_PATH = "PLUGIN-INF/properties.xml";
    private static final String PROPERTY_START = "<property>";
    private static final String PROPERTY_END = "</property>";
    private static final String PROPERTIES_START = "<properties>";
    private static final String PROPERTIES_END = "</properties>";
    private int exitCode;

    @Override
    public void extract(String file) throws Exception {
        this.mdExtractor = MdExtractorDocument.MdExtractor.Factory.newInstance();
        File myFile = new File(file);
        this.exitCode = this.runScript(false, myFile.getAbsolutePath());
        this.parseMDExtractionOutput(this.getInputStream());
    }

    @Override
    public String getAttributeByName(String attributeName) {
        MdExtractorDocument.MdExtractor.Attributes attr = this.mdExtractor.getAttributes();
        return attr == null ? "" : this.findMatch(attr.getDomNode(), attributeName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<String> getSupportedAttributeNames() {
        String attributesFile = StringUtils.substringBeforeLast((String)this.getCommand(), (String)BIN_DIR) + PROPERTIES_PATH;
        File attFile = new File(attributesFile);
        ArrayList<String> supportedAttributeNames = new ArrayList<String>();
        FileReader fr = null;
        BufferedReader br = null;
        try {
            String att = null;
            fr = new FileReader(attFile);
            br = new BufferedReader(fr);
            while ((att = br.readLine()) != null) {
                if (att.contains(PROPERTIES_START) || att.contains(PROPERTIES_END)) continue;
                att = att.replace(PROPERTY_START, "").replace(PROPERTY_END, "").trim();
                supportedAttributeNames.add(att);
            }
        }
        catch (IOException e) {
            try {
                log.error("Failed to read Extractor's attributes file", e, new String[0]);
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(fr);
                IOUtil.closeQuietly(br);
                throw throwable;
            }
            IOUtil.closeQuietly(fr);
            IOUtil.closeQuietly(br);
        }
        IOUtil.closeQuietly(fr);
        IOUtil.closeQuietly(br);
        return supportedAttributeNames;
    }

    @Override
    public String getAgent() {
        return this.mdExtractor.getAgent();
    }

    @Override
    public String getProfile() {
        return this.mdExtractor.getProfile();
    }

    @Override
    public String getFormatName() {
        return this.mdExtractor.getFormatName();
    }

    @Override
    public String getFormatVersion() {
        return this.mdExtractor.getFormatVersion();
    }

    @Override
    public String getMimeType() {
        return this.mdExtractor.getMimeType();
    }

    @Override
    public Integer getImageCount() {
        try {
            return this.mdExtractor.getImageCount();
        }
        catch (XmlValueOutOfRangeException e) {
            return 0;
        }
    }

    @Override
    public List<String> getExtractionErrors() {
        if (this.exitCode != 0) {
            return new ArrayList<String>(){
                {
                    this.add(MDExtractionPluginScript.this.getErrorStream());
                }
            };
        }
        return new ArrayList<String>();
    }

    @Override
    public boolean isValid() {
        return this.mdExtractor.getIsValid();
    }

    @Override
    public boolean isWellFormed() {
        return this.mdExtractor.getIsWellFormed();
    }

    private void parseMDExtractionOutput(String inStream) throws XmlException {
        this.doc = MdExtractorDocument.Factory.parse(inStream);
        this.mdExtractor = this.doc.getMdExtractor();
    }

    private String findMatch(Node node, String attributeName) {
        if (node == null) {
            return null;
        }
        NodeList nodeList = node.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node currentNode = nodeList.item(i);
            if (currentNode.getNodeType() != 1) continue;
            return this.findMatch(currentNode, attributeName);
        }
        if (node.getNodeName().equals(KEY) && node.getAttributes().item(0).getNodeValue().equals(attributeName)) {
            return node.getFirstChild().getNodeValue();
        }
        return this.findMatch(node.getNextSibling(), attributeName);
    }
}

