/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.rio.turtle;

import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayDeque;
import java.util.Collection;
import java.util.Deque;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import org.eclipse.rdf4j.common.io.CharSink;
import org.eclipse.rdf4j.common.io.IndentingWriter;
import org.eclipse.rdf4j.common.net.ParsedIRI;
import org.eclipse.rdf4j.common.text.StringUtil;
import org.eclipse.rdf4j.model.BNode;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.Literal;
import org.eclipse.rdf4j.model.Model;
import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.Resource;
import org.eclipse.rdf4j.model.Statement;
import org.eclipse.rdf4j.model.Triple;
import org.eclipse.rdf4j.model.Value;
import org.eclipse.rdf4j.model.datatypes.XMLDatatypeUtil;
import org.eclipse.rdf4j.model.impl.LinkedHashModelFactory;
import org.eclipse.rdf4j.model.impl.SimpleIRI;
import org.eclipse.rdf4j.model.util.Literals;
import org.eclipse.rdf4j.model.util.ModelException;
import org.eclipse.rdf4j.model.util.Models;
import org.eclipse.rdf4j.model.util.RDFCollections;
import org.eclipse.rdf4j.model.vocabulary.RDF;
import org.eclipse.rdf4j.model.vocabulary.XSD;
import org.eclipse.rdf4j.rio.RDFFormat;
import org.eclipse.rdf4j.rio.RDFHandlerException;
import org.eclipse.rdf4j.rio.RioSetting;
import org.eclipse.rdf4j.rio.helpers.AbstractRDFWriter;
import org.eclipse.rdf4j.rio.helpers.BasicParserSettings;
import org.eclipse.rdf4j.rio.helpers.BasicWriterSettings;
import org.eclipse.rdf4j.rio.helpers.TurtleWriterSettings;
import org.eclipse.rdf4j.rio.turtle.TurtleUtil;

public class TurtleWriter
extends AbstractRDFWriter
implements CharSink {
    private static final int LINE_WRAP = 80;
    private static final long DEFAULT_BUFFER_SIZE = 1000L;
    private static final IRI FIRST = new SimpleIRI(RDF.FIRST.stringValue()){
        private static final long serialVersionUID = -7951518099940758898L;
    };
    private static final IRI REST = new SimpleIRI(RDF.REST.stringValue()){
        private static final long serialVersionUID = -7951518099940758898L;
    };
    private long bufferSize = 1000L;
    protected Model bufferedStatements;
    private final Object bufferLock = new Object();
    protected ParsedIRI baseIRI;
    protected IndentingWriter writer;
    protected boolean statementClosed = true;
    protected Resource lastWrittenSubject;
    protected IRI lastWrittenPredicate;
    private final Deque<Resource> stack = new ArrayDeque<Resource>();
    private final Deque<IRI> path = new ArrayDeque<IRI>();
    private Boolean xsdStringToPlainLiteral;
    private Boolean prettyPrint;
    private boolean inlineBNodes;
    private Boolean abbreviateNumbers;
    private ModelFactory modelFactory = new LinkedHashModelFactory();

    public TurtleWriter(OutputStream out) {
        this(out, null);
    }

    public TurtleWriter(OutputStream out, ParsedIRI baseIRI) {
        this.baseIRI = baseIRI;
        this.writer = new IndentingWriter((Writer)new BufferedWriter(new OutputStreamWriter(out, StandardCharsets.UTF_8)));
    }

    public TurtleWriter(Writer writer) {
        this(writer, null);
    }

    public TurtleWriter(Writer writer, ParsedIRI baseIRI) {
        this.baseIRI = baseIRI;
        this.writer = new IndentingWriter(writer);
    }

    public Writer getWriter() {
        return this.writer;
    }

    public RDFFormat getRDFFormat() {
        return RDFFormat.TURTLE;
    }

    public Collection<RioSetting<?>> getSupportedSettings() {
        HashSet settings = new HashSet(super.getSupportedSettings());
        settings.add(BasicWriterSettings.BASE_DIRECTIVE);
        settings.add(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
        settings.add(BasicWriterSettings.PRETTY_PRINT);
        settings.add(BasicWriterSettings.INLINE_BLANK_NODES);
        settings.add(TurtleWriterSettings.ABBREVIATE_NUMBERS);
        return settings;
    }

    public void startRDF() throws RDFHandlerException {
        super.startRDF();
        try {
            this.xsdStringToPlainLiteral = (Boolean)this.getWriterConfig().get(BasicWriterSettings.XSD_STRING_TO_PLAIN_LITERAL);
            this.prettyPrint = (Boolean)this.getWriterConfig().get(BasicWriterSettings.PRETTY_PRINT);
            this.inlineBNodes = (Boolean)this.getWriterConfig().get(BasicWriterSettings.INLINE_BLANK_NODES);
            this.abbreviateNumbers = (Boolean)this.getWriterConfig().get(TurtleWriterSettings.ABBREVIATE_NUMBERS);
            if (this.isBuffering()) {
                this.bufferedStatements = this.getModelFactory().createEmptyModel();
                long l = this.bufferSize = this.inlineBNodes ? Long.MAX_VALUE : 1000L;
            }
            if (this.prettyPrint.booleanValue()) {
                this.writer.setIndentationString("  ");
            } else {
                this.writer.setIndentationString("");
            }
            if (this.baseIRI != null && ((Boolean)this.getWriterConfig().get(BasicWriterSettings.BASE_DIRECTIVE)).booleanValue()) {
                this.writeBase(this.baseIRI.toString());
            }
            for (Map.Entry entry : this.namespaceTable.entrySet()) {
                String name = (String)entry.getKey();
                String prefix = (String)entry.getValue();
                this.writeNamespace(prefix, name);
            }
            if (!this.namespaceTable.isEmpty()) {
                this.writer.writeEOL();
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endRDF() throws RDFHandlerException {
        this.checkWritingStarted();
        Object object = this.bufferLock;
        synchronized (object) {
            this.processBuffer();
        }
        try {
            this.closePreviousStatement();
            this.writer.flush();
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void handleNamespace(String prefix, String name) throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            if (!this.namespaceTable.containsKey(name)) {
                boolean isLegalPrefix;
                boolean bl = isLegalPrefix = ((String)prefix).length() == 0 || TurtleUtil.isPN_PREFIX((String)prefix);
                if (!isLegalPrefix || this.namespaceTable.containsValue(prefix)) {
                    if (((String)prefix).length() == 0 || !isLegalPrefix) {
                        prefix = "ns";
                    }
                    int number = 1;
                    while (this.namespaceTable.containsValue((String)prefix + number)) {
                        ++number;
                    }
                    prefix = (String)prefix + number;
                }
                this.namespaceTable.put(name, prefix);
                this.closePreviousStatement();
                this.writeNamespace((String)prefix, name);
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    public void setModelFactory(ModelFactory modelFactory) {
        this.modelFactory = Objects.requireNonNull(modelFactory);
    }

    protected ModelFactory getModelFactory() {
        return this.modelFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void consumeStatement(Statement st) throws RDFHandlerException {
        if (this.isBuffering()) {
            Object object = this.bufferLock;
            synchronized (object) {
                this.bufferedStatements.add((Object)st);
                if ((long)this.bufferedStatements.size() >= this.bufferSize) {
                    this.processBuffer();
                }
            }
        } else {
            this.handleStatementInternal(st, false, false, false);
        }
    }

    protected void handleStatementInternal(Statement st, boolean endRDFCalled, boolean canShortenSubjectBNode, boolean canShortenObjectBNode) {
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        Value obj = st.getObject();
        try {
            if (this.inlineBNodes) {
                if ((pred.equals((Object)RDF.FIRST) || pred.equals((Object)RDF.REST)) && this.isWellFormedCollection(subj)) {
                    this.handleList(st, canShortenObjectBNode);
                } else if (!subj.equals(this.lastWrittenSubject) && this.stack.contains(subj)) {
                    this.handleInlineNode(st, canShortenSubjectBNode, canShortenObjectBNode);
                } else {
                    this.writeStatement(subj, pred, obj, st.getContext(), canShortenSubjectBNode, canShortenObjectBNode);
                }
            } else {
                this.writeStatement(subj, pred, obj, st.getContext(), canShortenSubjectBNode, canShortenObjectBNode);
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    private boolean isWellFormedCollection(Resource subj) {
        try {
            Model collection = (Model)RDFCollections.getCollection((Model)this.bufferedStatements, (Resource)subj, (Collection)this.getModelFactory().createEmptyModel(), (Resource[])new Resource[0]);
            for (Resource s : Models.subjectBNodes((Model)collection)) {
                boolean firstFound = false;
                boolean restFound = false;
                for (Statement st : this.bufferedStatements.getStatements(s, null, null, new Resource[0])) {
                    IRI pred = st.getPredicate();
                    if (pred.equals((Object)RDF.FIRST)) {
                        if (!firstFound) {
                            firstFound = true;
                            continue;
                        }
                        return false;
                    }
                    if (pred.equals((Object)RDF.REST)) {
                        if (!restFound) {
                            restFound = true;
                            continue;
                        }
                        return false;
                    }
                    return false;
                }
            }
            return true;
        }
        catch (ModelException e) {
            return false;
        }
    }

    protected void writeStatement(Resource subj, IRI pred, Value obj, Resource context, boolean canShortenSubjectBNode, boolean canShortenObjectBNode) throws IOException {
        this.closeHangingResource();
        if (subj.equals(this.lastWrittenSubject)) {
            if (pred.equals((Object)this.lastWrittenPredicate)) {
                this.writer.write(",");
                this.wrapLine(this.prettyPrint);
            } else {
                this.writer.write(";");
                this.writer.writeEOL();
                this.writer.decreaseIndentation();
                this.writePredicate(pred);
                this.writer.increaseIndentation();
                this.wrapLine(true);
                this.path.removeLast();
                this.path.addLast(pred);
                this.lastWrittenPredicate = pred;
            }
        } else {
            this.closePreviousStatement();
            this.stack.addLast(subj);
            if (this.prettyPrint.booleanValue()) {
                this.writer.writeEOL();
            }
            this.writeResource(subj, canShortenSubjectBNode);
            this.wrapLine(true);
            this.writer.increaseIndentation();
            this.lastWrittenSubject = subj;
            this.writePredicate(pred);
            this.wrapLine(true);
            this.path.addLast(pred);
            this.lastWrittenPredicate = pred;
            this.statementClosed = false;
            this.writer.increaseIndentation();
        }
        this.writeValue(obj, canShortenObjectBNode);
    }

    public void handleComment(String comment) throws RDFHandlerException {
        this.checkWritingStarted();
        try {
            this.closePreviousStatement();
            if (comment.indexOf(13) != -1 || comment.indexOf(10) != -1) {
                StringTokenizer st = new StringTokenizer(comment, "\r\n");
                while (st.hasMoreTokens()) {
                    this.writeCommentLine(st.nextToken());
                }
            } else {
                this.writeCommentLine(comment);
            }
        }
        catch (IOException e) {
            throw new RDFHandlerException((Throwable)e);
        }
    }

    protected void writeCommentLine(String line) throws IOException {
        this.writer.write("# ");
        this.writer.write(line);
        this.writer.writeEOL();
    }

    protected void writeBase(String baseURI) throws IOException {
        this.writer.write("@base <");
        StringUtil.simpleEscapeIRI((String)baseURI, (Appendable)this.writer, (boolean)false);
        this.writer.write("> .");
        this.writer.writeEOL();
    }

    protected void writeNamespace(String prefix, String name) throws IOException {
        this.writer.write("@prefix ");
        this.writer.write(prefix);
        this.writer.write(": <");
        StringUtil.simpleEscapeIRI((String)name, (Appendable)this.writer, (boolean)false);
        this.writer.write("> .");
        this.writer.writeEOL();
    }

    protected void writePredicate(IRI predicate) throws IOException {
        if (predicate.equals((Object)RDF.TYPE)) {
            this.writer.write("a");
        } else {
            this.writeURI(predicate);
        }
    }

    @Deprecated
    protected void writeValue(Value val) throws IOException {
        this.writeValue(val, false);
    }

    protected void writeValue(Value val, boolean canShorten) throws IOException {
        if (val instanceof BNode && canShorten && !val.equals(this.stack.peekLast()) && !val.equals(this.lastWrittenSubject)) {
            this.stack.addLast((Resource)((BNode)val));
        } else if (val instanceof Resource) {
            this.writeResource((Resource)val, canShorten);
        } else {
            this.writeLiteral((Literal)val);
        }
    }

    @Deprecated
    protected void writeResource(Resource res) throws IOException {
        this.writeResource(res, false);
    }

    protected void writeResource(Resource res, boolean canShorten) throws IOException {
        if (res instanceof IRI) {
            this.writeURI((IRI)res);
        } else if (res instanceof BNode) {
            this.writeBNode((BNode)res, canShorten);
        } else {
            this.writeTriple((Triple)res, canShorten);
        }
    }

    protected void writeURI(IRI uri) throws IOException {
        String uriString = uri.toString();
        String prefix = null;
        int splitIdx = TurtleUtil.findURISplitIndex(uriString);
        if (splitIdx > 0) {
            String namespace = uriString.substring(0, splitIdx);
            prefix = (String)this.namespaceTable.get(namespace);
        }
        if (prefix != null) {
            this.writer.write(prefix);
            this.writer.write(":");
            this.writer.write(uriString.substring(splitIdx));
        } else if (this.baseIRI != null) {
            this.writer.write("<");
            StringUtil.simpleEscapeIRI((String)this.baseIRI.relativize(uriString), (Appendable)this.writer, (boolean)false);
            this.writer.write(">");
        } else {
            this.writer.write("<");
            StringUtil.simpleEscapeIRI((String)uriString, (Appendable)this.writer, (boolean)false);
            this.writer.write(">");
        }
    }

    @Deprecated
    protected void writeBNode(BNode bNode) throws IOException {
        this.writeBNode(bNode, false);
    }

    protected void writeBNode(BNode bNode, boolean canShorten) throws IOException {
        if (canShorten) {
            this.writer.write("[]");
            return;
        }
        this.writer.write("_:");
        String id = bNode.getID();
        if (id.isEmpty()) {
            if (((Boolean)this.getWriterConfig().get(BasicParserSettings.PRESERVE_BNODE_IDS)).booleanValue()) {
                throw new IOException("Cannot consistently write blank nodes with empty internal identifiers");
            }
            this.writer.write("genid-hash-");
            this.writer.write(Integer.toHexString(System.identityHashCode(bNode)));
        } else {
            if (!TurtleUtil.isNameStartChar(id.charAt(0))) {
                this.writer.write("genid-start-");
                this.writer.write(Integer.toHexString(id.charAt(0)));
            } else {
                this.writer.write((int)id.charAt(0));
            }
            for (int i = 1; i < id.length() - 1; ++i) {
                if (TurtleUtil.isPN_CHARS(id.charAt(i))) {
                    this.writer.write((int)id.charAt(i));
                    continue;
                }
                this.writer.write(Integer.toHexString(id.charAt(i)));
            }
            if (id.length() > 1) {
                if (!TurtleUtil.isNameEndChar(id.charAt(id.length() - 1))) {
                    this.writer.write(Integer.toHexString(id.charAt(id.length() - 1)));
                } else {
                    this.writer.write((int)id.charAt(id.length() - 1));
                }
            }
        }
    }

    protected void writeTriple(Triple triple, boolean canShorten) throws IOException {
        throw new IOException(this.getRDFFormat().getName() + " does not support RDF-star triples");
    }

    protected void writeTripleRDFStar(Triple triple, boolean canShorten) throws IOException {
        this.writer.write("<<");
        this.writeResource(triple.getSubject());
        this.writer.write(" ");
        this.writeURI(triple.getPredicate());
        this.writer.write(" ");
        Value object = triple.getObject();
        if (object instanceof Literal) {
            this.writeLiteral((Literal)object);
        } else {
            this.writeResource((Resource)object, canShorten);
        }
        this.writer.write(">>");
    }

    protected void writeLiteral(Literal lit) throws IOException {
        String label = lit.getLabel();
        IRI datatype = lit.getDatatype();
        if (this.prettyPrint.booleanValue() && this.abbreviateNumbers.booleanValue() && (XSD.INTEGER.equals((Object)datatype) || XSD.DECIMAL.equals((Object)datatype) || XSD.DOUBLE.equals((Object)datatype) || XSD.BOOLEAN.equals((Object)datatype))) {
            try {
                String normalized = XMLDatatypeUtil.normalize((String)label, (IRI)datatype);
                if (!(normalized.equals("INF") || normalized.equals("-INF") || normalized.equals("NaN"))) {
                    this.writer.write(normalized);
                    return;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (label.indexOf(10) != -1 || label.indexOf(13) != -1 || label.indexOf(9) != -1) {
            this.writer.write("\"\"\"");
            this.writer.write(TurtleUtil.encodeLongString(label));
            this.writer.write("\"\"\"");
        } else {
            this.writer.write("\"");
            this.writer.write(TurtleUtil.encodeString(label));
            this.writer.write("\"");
        }
        if (Literals.isLanguageLiteral((Literal)lit)) {
            this.writer.write("@");
            this.writer.write((String)lit.getLanguage().get());
        } else if (!this.xsdStringToPlainLiteral.booleanValue() || !XSD.STRING.equals((Object)datatype)) {
            this.writer.write("^^");
            this.writeURI(datatype);
        }
    }

    protected void closePreviousStatement() throws IOException {
        this.closeNestedResources(null);
        if (!this.statementClosed) {
            this.writer.write(" .");
            this.writer.writeEOL();
            this.writer.decreaseIndentation();
            this.writer.decreaseIndentation();
            this.stack.pollLast();
            this.path.pollLast();
            assert (this.stack.isEmpty());
            assert (this.path.isEmpty());
            this.statementClosed = true;
            this.lastWrittenSubject = null;
            this.lastWrittenPredicate = null;
        }
    }

    private boolean isHanging() {
        return !this.stack.isEmpty() && this.lastWrittenSubject != null && !this.lastWrittenSubject.equals(this.stack.peekLast());
    }

    private void closeHangingResource() throws IOException {
        if (this.isHanging()) {
            Value val = (Value)this.stack.pollLast();
            if (val instanceof Resource) {
                this.writeResource((Resource)val, this.inlineBNodes);
            } else {
                this.writeLiteral((Literal)val);
            }
            assert (this.lastWrittenSubject.equals(this.stack.peekLast()));
        }
    }

    private void closeNestedResources(Resource subj) throws IOException {
        this.closeHangingResource();
        while (this.stack.size() > 1 && !this.stack.peekLast().equals(subj)) {
            if (this.prettyPrint.booleanValue()) {
                this.writer.writeEOL();
            }
            this.writer.decreaseIndentation();
            this.writer.decreaseIndentation();
            this.writer.write("]");
            this.stack.pollLast();
            this.path.pollLast();
            this.lastWrittenSubject = this.stack.peekLast();
            this.lastWrittenPredicate = this.path.peekLast();
        }
    }

    private void handleInlineNode(Statement st, boolean inlineSubject, boolean inlineObject) throws IOException {
        Resource subj = st.getSubject();
        IRI pred = st.getPredicate();
        if (this.isHanging() && subj.equals(this.stack.peekLast())) {
            this.lastWrittenSubject = subj;
            this.writer.write("[");
            if (this.prettyPrint.booleanValue() && !RDF.TYPE.equals((Object)pred)) {
                this.writer.writeEOL();
            } else {
                this.wrapLine(this.prettyPrint);
            }
            this.writer.increaseIndentation();
            this.writePredicate(pred);
            this.writer.increaseIndentation();
            this.wrapLine(true);
            this.path.addLast(pred);
            this.lastWrittenPredicate = pred;
            this.writeValue(st.getObject(), inlineObject);
        } else if (!subj.equals(this.lastWrittenSubject) && this.stack.contains(subj)) {
            this.closeNestedResources(subj);
            this.writeStatement(subj, pred, st.getObject(), st.getContext(), inlineSubject, inlineObject);
        } else assert (false);
    }

    private void handleList(Statement st, boolean canInlineObjectBNode) throws IOException {
        boolean nil;
        Resource subj = st.getSubject();
        boolean first = RDF.FIRST.equals((Object)st.getPredicate());
        boolean rest = RDF.REST.equals((Object)st.getPredicate()) && !RDF.NIL.equals((Object)st.getObject());
        boolean bl = nil = RDF.REST.equals((Object)st.getPredicate()) && RDF.NIL.equals((Object)st.getObject());
        if (first && REST != this.lastWrittenPredicate && this.isHanging()) {
            this.writer.write("(");
            this.writer.increaseIndentation();
            this.wrapLine(false);
            this.lastWrittenSubject = subj;
            this.path.addLast(FIRST);
            this.lastWrittenPredicate = FIRST;
            this.writeValue(st.getObject(), canInlineObjectBNode);
        } else if (first && REST == this.lastWrittenPredicate) {
            this.lastWrittenSubject = subj;
            this.path.addLast(FIRST);
            this.lastWrittenPredicate = FIRST;
            this.writeValue(st.getObject(), canInlineObjectBNode);
        } else {
            this.closeNestedResources(subj);
            if (rest && FIRST == this.lastWrittenPredicate) {
                this.wrapLine(true);
                this.path.removeLast();
                this.path.addLast(REST);
                this.lastWrittenPredicate = REST;
                this.writeValue(st.getObject(), this.inlineBNodes);
            } else if (nil && FIRST == this.lastWrittenPredicate) {
                this.writer.decreaseIndentation();
                this.writer.write(")");
                this.path.removeLast();
                this.path.addLast(REST);
                while (REST == this.path.peekLast()) {
                    this.stack.pollLast();
                    this.path.pollLast();
                    this.lastWrittenSubject = this.stack.peekLast();
                    this.lastWrittenPredicate = this.path.peekLast();
                }
            } else {
                this.writeStatement(subj, st.getPredicate(), st.getObject(), st.getContext(), this.inlineBNodes, this.inlineBNodes);
            }
        }
    }

    private void wrapLine(boolean space) throws IOException {
        if (this.prettyPrint.booleanValue() && this.writer.getCharactersSinceEOL() > 80) {
            this.writer.writeEOL();
        } else if (space) {
            this.writer.write(" ");
        }
    }

    private void processBuffer() throws RDFHandlerException {
        if (!this.isBuffering()) {
            return;
        }
        if (this.getRDFFormat().supportsContexts()) {
            for (Resource context : this.bufferedStatements.contexts()) {
                Model contextData = this.bufferedStatements.filter(null, null, null, new Resource[]{context});
                HashSet<Resource> processedSubjects = new HashSet<Resource>();
                Optional<Resource> nextSubject = this.nextSubject(contextData, processedSubjects);
                while (nextSubject.isPresent()) {
                    this.processSubject(contextData, nextSubject.get(), processedSubjects);
                    nextSubject = this.nextSubject(contextData, processedSubjects);
                }
            }
        } else {
            HashSet<Resource> processedSubjects = new HashSet<Resource>();
            Optional<Resource> nextSubject = this.nextSubject(this.bufferedStatements, processedSubjects);
            while (nextSubject.isPresent()) {
                this.processSubject(this.bufferedStatements, nextSubject.get(), processedSubjects);
                nextSubject = this.nextSubject(this.bufferedStatements, processedSubjects);
            }
        }
        this.bufferedStatements.clear();
    }

    private Optional<Resource> nextSubject(Model contextData, Set<Resource> processedSubjects) {
        for (Resource subject2 : contextData.subjects()) {
            Set otherSubjects;
            if (processedSubjects.contains(subject2) || subject2.isBNode() && this.inlineBNodes && (otherSubjects = contextData.filter(null, null, (Value)subject2, new Resource[0]).subjects()).stream().anyMatch(s -> !processedSubjects.contains(s))) continue;
            return Optional.of(subject2);
        }
        return contextData.subjects().stream().filter(subject -> !processedSubjects.contains(subject)).findAny();
    }

    private void processSubject(Model contextData, Resource subject, Set<Resource> processedSubjects) {
        if (processedSubjects.contains(subject)) {
            return;
        }
        HashSet<IRI> processedPredicates = new HashSet<IRI>();
        this.processPredicate(contextData, subject, RDF.TYPE, processedSubjects, processedPredicates);
        this.processPredicate(contextData, subject, RDF.FIRST, processedSubjects, processedPredicates);
        for (IRI predicate : contextData.filter(subject, null, null, new Resource[0]).predicates()) {
            if (processedPredicates.contains(predicate)) continue;
            this.processPredicate(contextData, subject, predicate, processedSubjects, processedPredicates);
        }
        processedSubjects.add(subject);
    }

    private void processPredicate(Model contextData, Resource subject, IRI predicate, Set<Resource> processedSubjects, Set<IRI> processedPredicates) {
        for (Statement st : contextData.getStatements(subject, predicate, null, new Resource[0])) {
            boolean canInlineObject = this.canInlineValue(contextData, st.getObject());
            this.handleStatementInternal(st, false, this.canInlineValue(contextData, (Value)st.getSubject()), canInlineObject);
            if (!canInlineObject || !(st.getObject() instanceof BNode)) continue;
            this.processSubject(contextData, (Resource)((BNode)st.getObject()), processedSubjects);
        }
        processedPredicates.add(predicate);
    }

    private boolean canInlineValue(Model contextData, Value v) {
        if (!this.inlineBNodes) {
            return false;
        }
        if (v instanceof BNode) {
            return contextData.filter(null, null, v, new Resource[0]).size() <= 1;
        }
        return true;
    }

    private boolean isBuffering() {
        return this.inlineBNodes || this.prettyPrint != false;
    }
}

