/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.email;

import com.exlibris.core.infra.common.email.EncryptionUtil;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import java.util.Date;
import java.util.Properties;
import java.util.Vector;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Address;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;

public class EMailUtil {
    private static EMailUtil emailUtil = new EMailUtil();
    private String smtpServer = "localhost";
    private static final String MIME_TEXT_HTML = "text/html";
    private static final String UTF = "UTF-8";
    private static final String ATTACHMENT_FILE_NAME = "attachment.html";
    private EncryptionUtil encryptionUtil = null;
    private GeneralParameterManager gpm;
    private boolean use_smtp = false;
    private static final ExLogger log = ExLogger.getExLogger(EMailUtil.class);

    public void setEncryptionUtil(EncryptionUtil eu) {
        this.encryptionUtil = eu;
    }

    private EMailUtil() {
    }

    public static EMailUtil getInstance() {
        return emailUtil;
    }

    public boolean sendEmail(String addressFrom, String addressTo, String subject, String body) throws Exception {
        return this.sendEmail(addressFrom, addressTo, null, subject, body, null, null, false);
    }

    public boolean sendEmail(String addressFrom, String[] addressToArray, String[] addressCCArray, String subject, String body) throws Exception {
        return this.sendEmail(addressFrom, addressToArray, addressCCArray, subject, body, null, null);
    }

    public boolean sendEmail(String addressFrom, String[] addressToArray, String[] addressCCArray, String subject, String body, DataSource[] embeddedObjects) throws Exception {
        return this.sendEmail(addressFrom, addressToArray, addressCCArray, subject, body, null, embeddedObjects);
    }

    public boolean sendEmail(String addressFrom, String[] addressToArray, String[] addressCCArray, String subject, String body, String attachedHTML, DataSource[] embeddedObjects) throws Exception {
        String addressTo = addressToArray != null && addressToArray.length > 0 ? addressToArray[0] : null;
        String addressCC = addressCCArray != null && addressCCArray.length > 0 ? addressCCArray[0] : null;
        return this.sendEmail(addressFrom, addressTo, addressCC, subject, body, attachedHTML, embeddedObjects, false);
    }

    public boolean sendEmail(String addressFrom, String addressTo, String subject, String body, String attachedHTML) throws Exception {
        return this.sendEmail(addressFrom, addressTo, null, subject, body, attachedHTML, null, false);
    }

    public boolean sendEmail(String addressFrom, String addressTo, String subject, String body, DataSource[] embeddedObjects) throws Exception {
        return this.sendEmail(addressFrom, addressTo, null, subject, body, null, embeddedObjects, false);
    }

    public boolean sendEmail(String addressFrom, String addressTo, String addressCC, String subject, String body, String attachedHTML, DataSource[] embeddedObjects, boolean isBCC) throws Exception {
        try {
            this.sendEmailThrowsException(addressFrom, addressTo, addressCC, subject, body, attachedHTML, embeddedObjects, isBCC);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public void sendEmailThrowsException(String addressFrom, String addressTo, String addressCC, String subject, String body, String attachedHTML, DataSource[] embeddedObjects, boolean isBCC) throws Exception {
        GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        this.use_smtp = gpm.checkBooleanParameter("smtp_email", "use_email_smtp");
        Properties props = System.getProperties();
        this.clearSmtpProperties();
        String email_smtp_host = this.getGeneralParmameterManger().getParameter("smtp_email", "email_smtp_host");
        String email_smtp_port = this.getGeneralParmameterManger().getParameter("smtp_email", "email_smtp_port");
        String email_smtp_from = this.getGeneralParmameterManger().getParameter("smtp_email", "email_smtp_from");
        String email_smtp_pass = this.getGeneralParmameterManger().getParameter("smtp_email", "email_smtp_pass");
        if (this.use_smtp) {
            props.put("mail.smtp.starttls.enable", "true");
            props.put("mail.smtp.host", email_smtp_host);
            props.put("mail.smtp.port", email_smtp_port);
            props.put("mail.smtp.password", email_smtp_pass);
            props.put("mail.smtp.auth", "true");
            addressFrom = email_smtp_from;
        }
        Session session = Session.getDefaultInstance((Properties)props, null);
        MimeMessage msg = new MimeMessage(session);
        msg.setHeader("Content-Type", "text/plain; charset=UTF-8");
        msg.setReplyTo(null);
        msg.setFrom((Address)this.getInternetAddress(addressFrom));
        if (isBCC) {
            msg.setRecipients(Message.RecipientType.BCC, (Address[])InternetAddress.parse((String)addressTo, (boolean)false));
        } else {
            msg.setRecipients(Message.RecipientType.TO, (Address[])InternetAddress.parse((String)addressTo, (boolean)false));
            if (addressCC != null) {
                msg.setRecipients(Message.RecipientType.CC, (Address[])InternetAddress.parse((String)addressCC, (boolean)false));
            }
        }
        msg.setSubject(subject, UTF);
        MimeMultipart mp = new MimeMultipart();
        MimeBodyPart bodyPart1 = new MimeBodyPart();
        bodyPart1.setContent((Object)body, "text/html; charset=UTF-8");
        mp.addBodyPart((BodyPart)bodyPart1);
        if (attachedHTML != null) {
            MimeBodyPart bodyPart2 = new MimeBodyPart();
            bodyPart2.setContent((Object)attachedHTML, MIME_TEXT_HTML);
            bodyPart2.setFileName(ATTACHMENT_FILE_NAME);
            mp.addBodyPart((BodyPart)bodyPart2);
        }
        if (embeddedObjects != null) {
            Vector<MimeBodyPart> vBodyParts = new Vector<MimeBodyPart>();
            MimeBodyPart bodyPart3 = null;
            for (int i = 0; i < embeddedObjects.length; ++i) {
                bodyPart3 = new MimeBodyPart();
                String strName = embeddedObjects[i].getName();
                bodyPart3.setFileName(strName);
                bodyPart3.setContentID(strName);
                bodyPart3.setHeader("Content-ID", "<" + strName + ">");
                bodyPart3.setDisposition("attachment");
                bodyPart3.setDataHandler(new DataHandler(embeddedObjects[i]));
                vBodyParts.add(bodyPart3);
            }
            MimeMultipart mp1 = new MimeMultipart();
            mp1.addBodyPart((BodyPart)bodyPart1);
            for (int i = 0; i < vBodyParts.size(); ++i) {
                mp1.addBodyPart((BodyPart)vBodyParts.elementAt(i));
            }
            msg.setContent((Multipart)mp1);
        } else {
            msg.setContent((Multipart)mp);
        }
        if (this.sign() && this.encryptionUtil != null) {
            MimeMessage signedMsg;
            msg = signedMsg = this.encryptionUtil.signMultiPartMessage(msg, session);
        }
        msg.setSentDate(new Date());
        if (this.use_smtp) {
            try {
                Transport transport = session.getTransport("smtp");
                transport.connect(email_smtp_host, this.getEmailFromAddress(email_smtp_from), email_smtp_pass);
                transport.sendMessage((Message)msg, msg.getAllRecipients());
                transport.close();
            }
            catch (Exception e) {
                e.printStackTrace();
                log.warn((Object)"failure while sending email through SMTP, trying to sent by the default system (Unix)", new String[0]);
                this.clearSmtpProperties();
                Transport.send((Message)msg);
            }
        } else {
            Transport.send((Message)msg);
        }
    }

    private void clearSmtpProperties() {
        System.clearProperty("mail.smtp.starttls.enable");
        System.clearProperty("mail.smtp.host");
        System.clearProperty("mail.smtp.port");
        System.clearProperty("mail.smtp.password");
        System.clearProperty("mail.smtp.from");
        System.clearProperty("mail.smtp.auth");
    }

    private InternetAddress getInternetAddress(String address) {
        InternetAddress internetAddress = null;
        try {
            internetAddress = address.contains("<") ? new InternetAddress(address.substring(address.indexOf("<") + 1, address.indexOf(">")).trim(), address.substring(0, address.indexOf("<")).trim(), UTF) : new InternetAddress(address);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return internetAddress;
    }

    private String getEmailFromAddress(String address) {
        try {
            if (address.contains("<") && address.contains(">")) {
                address = address.substring(address.indexOf("<") + 1, address.indexOf(">")).trim();
            }
            return address;
        }
        catch (Exception e) {
            return address;
        }
    }

    public static void main(String[] argv) {
        try {
            EMailUtil.getInstance().sendEmail("from me <from@me>", "yonatan.matalon@exlibris.co.il", "my subject", "hello");
            EMailUtil.getInstance().sendEmail("from me <from@me>", "tsachm@exlibris.co.il", "my subject", "see attached", "<i>hello</i>");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getSmtpServer() {
        return this.smtpServer;
    }

    public void setSmtpServer(String smtpServer) {
        this.smtpServer = smtpServer;
    }

    private boolean sign() {
        try {
            String genPar = this.getGeneralParmameterManger().getParameter("general", "digital_signature");
            return Boolean.parseBoolean(genPar);
        }
        catch (Exception e) {
            return false;
        }
    }

    private GeneralParameterManager getGeneralParmameterManger() {
        if (this.gpm == null) {
            this.gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
        }
        return this.gpm;
    }
}

