/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class PropertyPath {
    private List pathInfo = new LinkedList();

    public PropertyPath() {
    }

    public PropertyPath(PropertyPath path) {
        this.pathInfo.addAll(path.pathInfo);
    }

    public PropertyPath(String[] pathArray) {
        for (int i = 0; i < pathArray.length; ++i) {
            this.pathInfo.add(pathArray[i]);
        }
    }

    public void addPropertyName(String str) {
        this.pathInfo.add(str);
    }

    public void addPropertyKey(Object obj) {
        this.pathInfo.add(new PropertyKey(obj));
    }

    public void addPropertyIndex(int idx) {
        this.pathInfo.add(new Integer(idx));
    }

    public Property locateProperty(RepInfo info) {
        return this.locateProperty(info, false);
    }

    public Property locateProperty(RepInfo info, boolean trace) {
        Property prop;
        if (this.pathInfo.isEmpty()) {
            if (trace) {
                System.out.println("Empty property path");
            }
            return null;
        }
        Object obj = this.pathInfo.get(0);
        if (!(obj instanceof String)) {
            if (trace) {
                System.out.println("Not a property name");
            }
            return null;
        }
        String top = (String)obj;
        if (trace) {
            System.out.println("Getting proprerty " + top);
        }
        if ((prop = info.getProperty(top)) == null) {
            if (trace) {
                System.out.println("Property is null");
            }
            return null;
        }
        int pathLen = this.pathInfo.size();
        return this.locateSubProperty(prop, this.pathInfo.subList(1, pathLen), trace);
    }

    private Property locateSubProperty(Property property, List path, boolean trace) {
        if (path.isEmpty()) {
            return property;
        }
        List cdr = path.subList(1, path.size());
        PropertyArity arity = property.getArity();
        PropertyType type = property.getType();
        Object val = property.getValue();
        if (trace) {
            System.out.println("Property arity = " + arity + ", type = " + type);
        }
        if (type != PropertyType.PROPERTY) {
            if (trace) {
                System.out.println("Not a property, type is " + type.toString());
            }
            return null;
        }
        Object obj = path.get(0);
        if (obj instanceof String) {
            String name = (String)obj;
            if (trace) {
                System.out.println("Looking for subproperty " + name + " arity= " + arity.toString());
            }
            if (arity.equals(PropertyArity.SCALAR)) {
                Property p = (Property)property.getValue();
                if (p.getName().equals(name)) {
                    return this.locateSubProperty(p, cdr, trace);
                }
                return null;
            }
            if (arity.equals(PropertyArity.ARRAY)) {
                Property[] parray = (Property[])val;
                for (int i = 0; i < parray.length; ++i) {
                    Property p = parray[i];
                    if (!p.getName().equals(name)) continue;
                    return this.locateSubProperty(p, cdr, trace);
                }
                return null;
            }
            if (arity.equals(PropertyArity.LIST)) {
                ListIterator iter = ((List)val).listIterator();
                return this.getIteratedSubProperty(iter, name, cdr, trace);
            }
            if (arity.equals(PropertyArity.SET)) {
                Iterator iter = ((Set)val).iterator();
                return this.getIteratedSubProperty(iter, name, cdr, trace);
            }
            if (arity.equals(PropertyArity.MAP)) {
                Iterator iter = ((Map)val).values().iterator();
                return this.getIteratedSubProperty(iter, name, cdr, trace);
            }
            return null;
        }
        if (obj instanceof Integer) {
            int idx = (Integer)obj;
            if (arity.equals(PropertyArity.LIST)) {
                List propList = (List)val;
                return this.locateSubProperty((Property)propList.get(idx), cdr, trace);
            }
            if (arity.equals(PropertyArity.ARRAY)) {
                Property[] propArr = (Property[])val;
                return this.locateSubProperty(propArr[idx], cdr, trace);
            }
            return null;
        }
        if (obj instanceof PropertyKey) {
            if (arity != PropertyArity.MAP) {
                return null;
            }
            return null;
        }
        return null;
    }

    private Property getIteratedSubProperty(Iterator iter, String name, List path, boolean trace) {
        while (iter.hasNext()) {
            Property p = (Property)iter.next();
            if (!p.getName().equals(name)) continue;
            return this.locateSubProperty(p, path, trace);
        }
        return null;
    }

    private class PropertyKey {
        public Object key;

        public PropertyKey(Object obj) {
            this.key = obj;
        }
    }
}

