/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.gzip;

import java.util.HashMap;
import java.util.Map;

public class CompressionType {
    private static Map<Integer, CompressionType> values = new HashMap<Integer, CompressionType>();
    public static final CompressionType MAXIMUM_COMPRESSION = new CompressionType(2, "Maximum compression", true);
    public static final CompressionType FASTEST_ALGORITHM = new CompressionType(4, "Fastest algorithm", true);
    public final int value;
    public final String label;
    public final boolean valid;

    protected CompressionType(int value, String label, boolean valid) {
        this.value = value;
        this.label = label;
        this.valid = valid;
    }

    public static CompressionType fromValue(int n) {
        CompressionType v = values.get(n);
        if (v == null) {
            v = new CompressionType(n, null, false);
        }
        return v;
    }

    static {
        values.put(CompressionType.MAXIMUM_COMPRESSION.value, MAXIMUM_COMPRESSION);
        values.put(CompressionType.FASTEST_ALGORITHM.value, FASTEST_ALGORITHM);
    }
}

