/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.NameNode;
import org.icepdf.core.util.Library;

public class NameTree
extends Dictionary {
    private NameNode root;

    public NameTree(Library l, HashMap h) {
        super(l, h);
    }

    public void init() {
        if (this.inited) {
            return;
        }
        this.root = new NameNode(this.library, this.entries);
        this.inited = true;
    }

    public List getNamesAndValues() {
        if (this.root != null) {
            ArrayList namesAndValues = new ArrayList();
            if (this.root.getNamesAndValues() != null) {
                namesAndValues.addAll(this.root.getNamesAndValues());
                return namesAndValues;
            }
            if (this.root.getKidsNodes() != null) {
                for (NameNode node : this.root.getKidsNodes()) {
                    namesAndValues.addAll(this.getNamesAndValues(node));
                }
                return namesAndValues;
            }
        }
        return null;
    }

    private List getNamesAndValues(NameNode nameNode) {
        if (nameNode.getNamesAndValues() != null) {
            return nameNode.getNamesAndValues();
        }
        ArrayList namesAndValues = new ArrayList();
        for (NameNode node : nameNode.getKidsNodes()) {
            namesAndValues.addAll(this.getNamesAndValues(node));
        }
        return namesAndValues;
    }

    public Object searchName(String key) {
        return this.root.searchName(key);
    }

    public NameNode getRoot() {
        return this.root;
    }
}

