/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform;

import java.util.HashMap;
import org.icepdf.core.pobjects.Dictionary;
import org.icepdf.core.pobjects.Name;
import org.icepdf.core.pobjects.acroform.DocMDPTransferParam;
import org.icepdf.core.pobjects.acroform.FieldMDPTransferParam;
import org.icepdf.core.pobjects.acroform.TransformParams;
import org.icepdf.core.pobjects.acroform.UR3TransferParam;
import org.icepdf.core.util.Library;

public class SignatureReferenceDictionary
extends Dictionary {
    public static final Name SIG_REF_TYPE_VALUE = new Name("SigRef");
    public static final Name TRANSFORM_METHOD_KEY = new Name("TransformMethod");
    private TransformParams transformParams;
    public static final Name TRANSFORM_PARAMS_KEY = new Name("TransformParams");
    public static final Name DATA_KEY = new Name("Data");
    public static final Name DIGEST_METHOD_KEY = new Name("DigestMethod");

    public SignatureReferenceDictionary(Library library, HashMap entries) {
        super(library, entries);
    }

    public TransformMethods getTransformMethod() {
        Name tmp = this.library.getName(this.entries, TRANSFORM_METHOD_KEY);
        if (tmp != null) {
            if (tmp.equals(TransformMethods.DocMDP.toString())) {
                return TransformMethods.DocMDP;
            }
            if (tmp.equals(TransformMethods.FieldMDP.toString())) {
                return TransformMethods.FieldMDP;
            }
            if (tmp.equals(TransformMethods.UR3.toString())) {
                return TransformMethods.UR3;
            }
        }
        return null;
    }

    public TransformParams getTransformParams() {
        Name tmp = this.library.getName(this.entries, TRANSFORM_METHOD_KEY);
        if (tmp.equals(TransformMethods.DocMDP.toString())) {
            this.transformParams = new DocMDPTransferParam(this.library, this.library.getDictionary(this.entries, TRANSFORM_PARAMS_KEY));
        } else if (tmp.equals(TransformMethods.FieldMDP.toString())) {
            this.transformParams = new FieldMDPTransferParam(this.library, this.library.getDictionary(this.entries, TRANSFORM_PARAMS_KEY));
        } else if (tmp.equals(TransformMethods.UR3.toString())) {
            this.transformParams = new UR3TransferParam(this.library, this.library.getDictionary(this.entries, TRANSFORM_PARAMS_KEY));
        }
        return this.transformParams;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum TransformMethods {
        FieldMDP,
        DocMDP,
        UR3;

    }
}

