/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove;

import edu.harvard.hul.ois.jhove.Checksum;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.Module;
import edu.harvard.hul.ois.jhove.OutputHandler;
import edu.harvard.hul.ois.jhove.Property;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;

public class RepInfo
implements Cloneable {
    private List<Checksum> _checksum;
    private boolean _consistent;
    private int _valid;
    public static final int TRUE = 1;
    public static final int FALSE = 0;
    public static final int UNDETERMINED = -1;
    private Date _created;
    private RepInfo _external;
    private String _format;
    private Date _lastModified;
    private List<Message> _message;
    private String _mimeType;
    private Module _module;
    private List<String> _profile;
    private List<String> _sigMatch;
    private Map<String, Property> _property;
    private long _size;
    private String _uri;
    private boolean _urlFlag;
    private int _wellFormed;
    private String _version;
    private String _note;

    public RepInfo(String uri) {
        this.init(uri);
    }

    public RepInfo(String uri, RepInfo external) {
        this.init(uri);
        this._external = external;
    }

    private void init(String uri) {
        this._uri = uri;
        this._size = -1L;
        this._wellFormed = 1;
        this._consistent = true;
        this._urlFlag = false;
        this._valid = 1;
        this._checksum = new ArrayList<Checksum>();
        this._message = new ArrayList<Message>();
        this._profile = new ArrayList<String>();
        this._property = new TreeMap<String, Property>();
        this._sigMatch = new ArrayList<String>();
    }

    public Object clone() {
        RepInfo newri;
        try {
            newri = (RepInfo)super.clone();
        }
        catch (CloneNotSupportedException e) {
            return null;
        }
        newri._checksum = new ArrayList<Checksum>(this._checksum);
        newri._message = new ArrayList<Message>(this._message);
        newri._profile = new ArrayList<String>(this._profile);
        newri._sigMatch = new ArrayList<String>(this._sigMatch);
        newri._property = new TreeMap<String, Property>(this._property);
        return newri;
    }

    public void copy(RepInfo info) {
        this._checksum = info._checksum;
        this._consistent = info._consistent;
        this._created = info._created;
        this._external = info._external;
        this._format = info._format;
        this._lastModified = info._lastModified;
        this._message = info._message;
        this._mimeType = info._mimeType;
        this._profile = info._profile;
        this._property = info._property;
        this._size = info._size;
        this._uri = info._uri;
        this._urlFlag = info._urlFlag;
        this._wellFormed = info._wellFormed;
        this._valid = info._valid;
        this._version = info._version;
        this._note = info._note;
        this._module = info._module;
        this._sigMatch = info._sigMatch;
    }

    public List<Checksum> getChecksum() {
        return this._checksum;
    }

    public Date getCreated() {
        return this._created;
    }

    public String getFormat() {
        return this._format;
    }

    public Date getLastModified() {
        return this._lastModified;
    }

    public List<Message> getMessage() {
        return this._message;
    }

    public String getMimeType() {
        return this._mimeType;
    }

    public Module getModule() {
        return this._module;
    }

    public List<String> getProfile() {
        return this._profile;
    }

    public Map<String, Property> getProperty() {
        return this._property;
    }

    public Property getProperty(String name) {
        Property property = null;
        if (this._property.size() > 0) {
            property = this._property.get(name);
        }
        return property;
    }

    public long getSize() {
        return this._size;
    }

    public String getUri() {
        return this._uri;
    }

    public boolean getURLFlag() {
        return this._urlFlag;
    }

    public boolean isConsistent() {
        return this._consistent;
    }

    public int getWellFormed() {
        return this._wellFormed;
    }

    public int getValid() {
        return this._valid;
    }

    public String getVersion() {
        return this._version;
    }

    public String getNote() {
        return this._note;
    }

    public List<String> getSigMatch() {
        return this._sigMatch;
    }

    public Property getByName(String name) {
        Property prop2 = null;
        Collection<Property> coll = this._property.values();
        for (Property prop2 : coll) {
            if ((prop2 = prop2.getByName(name)) == null) continue;
            break;
        }
        return prop2;
    }

    public void setChecksum(Checksum checksum) {
        this._checksum.add(checksum);
    }

    public void setConsistent(boolean consistent) {
        this._consistent = consistent;
    }

    public void setCreated(Date created) {
        this._created = created;
    }

    public void setFormat(String format) {
        this._format = format;
    }

    public void setLastModified(Date lastModified) {
        this._lastModified = lastModified;
    }

    public void setMessage(Message message) {
        this._message.add(message);
    }

    public void setMimeType(String mimeType) {
        this._mimeType = mimeType;
    }

    public void setModule(Module module) {
        this._module = module;
    }

    public void setProfile(String profile) {
        this._profile.add(profile);
    }

    public void setProperty(Property property) {
        this._property.put(property.getName(), property);
    }

    public void setSize(long size) {
        this._size = size;
    }

    public void setURLFlag(boolean flag) {
        this._urlFlag = flag;
    }

    public void setWellFormed(boolean wellFormed) {
        int n = this._wellFormed = wellFormed ? 1 : 0;
        if (!wellFormed) {
            this._consistent = false;
            this._valid = 0;
        }
    }

    public void setWellFormed(int wellFormed) {
        this._wellFormed = wellFormed;
        if (wellFormed == 0) {
            this._consistent = false;
            this._valid = 0;
        }
        if (wellFormed == -1) {
            this._valid = -1;
        }
    }

    public void setValid(boolean valid) {
        this._valid = valid ? 1 : 0;
    }

    public void setValid(int valid) {
        this._valid = valid;
    }

    public void setVersion(String version) {
        this._version = version;
    }

    public void setNote(String note) {
        this._note = note;
    }

    public void setSigMatch(String modname) {
        this._sigMatch.add(modname);
    }

    public void setSigMatch(List<String> modnames) {
        this._sigMatch = modnames;
    }

    public void show(OutputHandler handler) {
        handler.analyze(this);
        handler.show(this);
    }
}

