/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.sax;

import com.exlibris.core.infra.common.sax.ExtendedAttributes;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.XMLFilterImpl;

public class UnEscapeSequenceXMLFilter
extends XMLFilterImpl
implements LexicalHandler {
    private static final String CDATA_END = "]]>";
    private static final String CDATA_START = "<![CDATA[";
    private String currentEntity = null;
    private ExtendedAttributes attr = null;
    List<Map.Entry<String, String>> extAttrList = new ArrayList<Map.Entry<String, String>>();

    public UnEscapeSequenceXMLFilter(XMLReader reader) throws SAXNotRecognizedException, SAXNotSupportedException {
        super(reader);
        this.setProperty("http://xml.org/sax/properties/lexical-handler", this);
    }

    @Override
    public void characters(char[] ch, int start, int length) throws SAXException {
        if (this.currentEntity == null) {
            super.characters(ch, start, length);
            return;
        }
        String entity = "&" + this.currentEntity + ";";
        super.characters(entity.toCharArray(), 0, entity.length());
        this.currentEntity = null;
    }

    @Override
    public void startEntity(String name) throws SAXException {
        this.currentEntity = name;
    }

    @Override
    public void endEntity(String name) throws SAXException {
    }

    @Override
    public void startCDATA() throws SAXException {
        super.characters(CDATA_START.toCharArray(), 0, CDATA_START.length());
    }

    @Override
    public void endCDATA() throws SAXException {
        super.characters(CDATA_END.toCharArray(), 0, CDATA_END.length());
    }

    @Override
    public void startElement(String paramString1, String paramString2, String paramString3, Attributes paramAttributes) throws SAXException {
        this.attr = new ExtendedAttributes(paramAttributes);
        this.attr.addExtendedAttributes(this.extAttrList);
        super.startElement(paramString1, paramString2, paramString3, this.attr);
        this.extAttrList.clear();
    }

    @Override
    public void startPrefixMapping(String paramString1, String paramString2) throws SAXException {
        AbstractMap.SimpleEntry<String, String> extAttr = new AbstractMap.SimpleEntry<String, String>(paramString1, paramString2);
        this.extAttrList.add(extAttr);
    }

    @Override
    public void startDTD(String name, String publicId, String systemId) throws SAXException {
    }

    @Override
    public void endDTD() throws SAXException {
    }

    @Override
    public void comment(char[] ch, int start, int length) throws SAXException {
    }
}

