/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.creator;

import gov.loc.repository.bagit.domain.Manifest;
import gov.loc.repository.bagit.hash.Hasher;
import gov.loc.repository.bagit.util.PathUtils;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.security.MessageDigest;
import java.util.Map;
import java.util.ResourceBundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractCreateManifestsVistor
extends SimpleFileVisitor<Path> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractCreateManifestsVistor.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");
    protected final transient Map<Manifest, MessageDigest> manifestToMessageDigestMap;
    protected final transient boolean includeHiddenFiles;

    public AbstractCreateManifestsVistor(Map<Manifest, MessageDigest> manifestToMessageDigestMap, boolean includeHiddenFiles) {
        this.manifestToMessageDigestMap = manifestToMessageDigestMap;
        this.includeHiddenFiles = includeHiddenFiles;
    }

    public FileVisitResult abstractPreVisitDirectory(Path dir, String directoryToIgnore) throws IOException {
        if (!this.includeHiddenFiles && PathUtils.isHidden(dir) && !dir.endsWith(Paths.get(".bagit", new String[0]))) {
            logger.debug(messages.getString("skipping_hidden_file"), (Object)dir);
            return FileVisitResult.SKIP_SUBTREE;
        }
        if (dir.endsWith(directoryToIgnore)) {
            logger.debug(messages.getString("skipping_ignored_directory"), (Object)dir);
            return FileVisitResult.SKIP_SUBTREE;
        }
        return FileVisitResult.CONTINUE;
    }

    @Override
    public FileVisitResult visitFile(Path path, BasicFileAttributes attrs) throws IOException {
        if (!this.includeHiddenFiles && PathUtils.isHidden(path) && !path.endsWith(".keep")) {
            logger.debug(messages.getString("skipping_hidden_file"), (Object)path);
        } else {
            Hasher.hash(path, this.manifestToMessageDigestMap);
        }
        return FileVisitResult.CONTINUE;
    }
}

