/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.office;

import com.sun.star.lib.uno.helper.UnoUrl;
import java.util.Map;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

class OfficeUrl {
    private static final String DEFAULT_HOST = "127.0.0.1";
    private final UnoUrl unoUrl;

    static UnoUrl pipe(@NonNull String pipeName) {
        try {
            return UnoUrl.parseUnoUrl((String)("pipe,name=" + pipeName + ";urp;StarOffice.ServiceManager"));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    static UnoUrl socket(int port) {
        return OfficeUrl.socket(null, port);
    }

    static UnoUrl socket(String host, int port) {
        String h = host == null ? DEFAULT_HOST : host;
        try {
            return UnoUrl.parseUnoUrl((String)("socket,host=" + h + ",port=" + port + ",tcpNoDelay=1;urp;StarOffice.ServiceManager"));
        }
        catch (Exception ex) {
            throw new IllegalArgumentException(ex);
        }
    }

    public OfficeUrl(@NonNull String pipeName) {
        this.unoUrl = OfficeUrl.pipe(pipeName);
    }

    public OfficeUrl(int port) {
        this(DEFAULT_HOST, port);
    }

    public OfficeUrl(@Nullable String host, int port) {
        this.unoUrl = OfficeUrl.socket(host, port);
    }

    public String getConnection() {
        return this.unoUrl.getConnection();
    }

    public String getProtocol() {
        return this.unoUrl.getProtocol();
    }

    public String getRootOid() {
        return this.unoUrl.getRootOid();
    }

    public Map<String, String> getProtocolParameters() {
        return this.unoUrl.getProtocolParameters().entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
    }

    public Map<String, String> getConnectionParameters() {
        return this.unoUrl.getConnectionParameters().entrySet().stream().collect(Collectors.toMap(e -> e.getKey().toString(), e -> e.getValue().toString()));
    }

    public String getProtocolParametersAsString() {
        return this.unoUrl.getProtocolParametersAsString();
    }

    public String getConnectionParametersAsString() {
        return this.unoUrl.getConnectionParametersAsString();
    }

    public String getProtocolAndParametersAsString() {
        return this.unoUrl.getProtocolAndParametersAsString();
    }

    public String getConnectionAndParametersAsString() {
        return this.unoUrl.getConnectionAndParametersAsString();
    }

    public String toString() {
        return this.unoUrl.toString();
    }
}

