/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.DividedDate;
import com.exlibris.core.infra.model.HFrPublishingProfile;
import com.exlibris.core.infra.model.HFrPublishingSet;
import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.annotation.Searchable;
import java.util.Calendar;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Transient;
import org.hibernate.annotations.Cascade;

@NamedQueries(value={@NamedQuery(name="findConfigurations", query="from HFrPublishingConfiguration")})
@Entity
public class HFrPublishingConfiguration
extends HOwneredEntity {
    public static final String FIND_CONFIGURATIONS = "findConfigurations";
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private Calendar statusDate;
    private DividedDate statusDateDummy;
    private Boolean active;
    private Boolean deleted;
    private Boolean purged;
    private List<HFrPublishingSet> publishingSets;
    private List<HFrPublishingProfile> publishingProfiles;
    private String indexXml;
    private boolean republish;

    public HFrPublishingConfiguration() {
        this.deleted = false;
        this.purged = false;
        this.republish = false;
        this.publishingProfiles = new LinkedList<HFrPublishingProfile>();
        this.publishingSets = new LinkedList<HFrPublishingSet>();
    }

    public HFrPublishingConfiguration(HFrPublishingConfiguration configuration) {
        this.setName(configuration.getName());
        this.setDescription(configuration.getDescription());
        this.setStatusDate(Calendar.getInstance());
        this.setActive(configuration.getActive());
        this.publishingProfiles = new LinkedList<HFrPublishingProfile>();
        this.publishingSets = new LinkedList<HFrPublishingSet>();
        this.deleted = false;
        this.purged = false;
        this.republish = false;
        this.setCreator(configuration.getCreator());
        this.setCreateDate(Calendar.getInstance());
        this.setModifiedBy(configuration.getModifiedBy());
        this.setModificationDate(Calendar.getInstance());
    }

    @Searchable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(length=4000)
    @Searchable
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="status_date")
    public Calendar getStatusDate() {
        return this.statusDate;
    }

    public void setStatusDate(Calendar statusDate) {
        this.statusDate = statusDate;
        this.statusDateDummy = new DividedDate(this.statusDate);
        this.statusDate = this.statusDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getStatusDateDummy() {
        return this.statusDateDummy;
    }

    public void setStatusDateDummy(DividedDate statusDateDummy) {
        this.statusDateDummy = statusDateDummy;
    }

    @Searchable
    public Boolean getActive() {
        return this.active;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    @OneToMany(mappedBy="publishingConfiguration", targetEntity=HFrPublishingSet.class, fetch=FetchType.EAGER)
    public List<HFrPublishingSet> getPublishingSets() {
        return this.publishingSets;
    }

    public void setPublishingSets(List<HFrPublishingSet> publishingSets) {
        this.publishingSets = publishingSets;
    }

    @OneToMany(cascade={CascadeType.ALL}, mappedBy="publishingConfiguration", targetEntity=HFrPublishingProfile.class)
    @Cascade(value={org.hibernate.annotations.CascadeType.ALL, org.hibernate.annotations.CascadeType.DELETE_ORPHAN})
    public List<HFrPublishingProfile> getPublishingProfiles() {
        return this.publishingProfiles;
    }

    public void setPublishingProfiles(List<HFrPublishingProfile> publishingProfiles) {
        this.publishingProfiles = publishingProfiles;
    }

    @Transient
    public HFrPublishingSet getPublishingSet(Long id) {
        for (HFrPublishingSet set : this.publishingSets) {
            if (!set.getId().equals(id)) continue;
            return set;
        }
        return null;
    }

    public void addPublishingSet(HFrPublishingSet set) {
        if (this.publishingSets == null) {
            this.publishingSets = new LinkedList<HFrPublishingSet>();
        }
        int i = 0;
        for (HFrPublishingSet curSet : this.publishingSets) {
            if (curSet.getSetId().equals(set.getSetId())) {
                this.publishingSets.set(i, set);
                return;
            }
            ++i;
        }
        this.publishingSets.add(set);
    }

    @Transient
    public HFrPublishingProfile getPublishingProfile(Long id) {
        for (HFrPublishingProfile profile : this.publishingProfiles) {
            if (!profile.getId().equals(id)) continue;
            return profile;
        }
        return null;
    }

    public void addPublishingProfile(HFrPublishingProfile profile) {
        if (this.publishingProfiles == null) {
            this.publishingProfiles = new LinkedList<HFrPublishingProfile>();
        }
        int i = 0;
        for (HFrPublishingProfile curProfile : this.publishingProfiles) {
            if (curProfile.getId().equals(profile.getId())) {
                this.publishingProfiles.set(i, profile);
                return;
            }
            ++i;
        }
        this.publishingProfiles.add(profile);
    }

    @Column(name="index_xml", length=4000)
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public Boolean getDeleted() {
        return this.deleted;
    }

    public void setDeleted(Boolean deleted) {
        this.deleted = deleted;
    }

    @Column(name="REPUBLISH", nullable=false, columnDefinition="NUMBER(1,0) DEFAULT 0")
    public boolean isRepublish() {
        return this.republish;
    }

    public void setRepublish(boolean republish) {
        this.republish = republish;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " " + this.getName();
    }

    public Boolean getPurged() {
        return this.purged;
    }

    public void setPurged(Boolean purged) {
        this.purged = purged;
    }
}

