/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.BoxHolder;
import edu.harvard.hul.ois.jhove.module.jpeg2000.ComposLayerHdrBox;
import edu.harvard.hul.ois.jhove.module.jpeg2000.JP2Box;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.RandomAccessFile;

public class CodestreamRegBox
extends JP2Box {
    public CodestreamRegBox(RandomAccessFile raf, BoxHolder parent) {
        super(raf, parent);
    }

    @Override
    public boolean readBox() throws IOException {
        if (!(this._parentBox instanceof ComposLayerHdrBox)) {
            this.wrongBoxContext();
            return false;
        }
        Property[] propArray = new Property[3];
        propArray[0] = new Property("HorizontalGridSize", PropertyType.INTEGER, (Object)new Integer(this._module.readUnsignedShort(this._dstrm)));
        propArray[1] = new Property("VerticalGridSize", PropertyType.INTEGER, (Object)new Integer(this._module.readUnsignedShort(this._dstrm)));
        int bytesLeft = (int)this._boxHeader.getDataLength() - 4;
        int nStreams = bytesLeft / 6;
        Property[] streamsProp = new Property[nStreams];
        for (int i = 0; i < nStreams; ++i) {
            Property[] csProp = new Property[]{new Property("CodestreamNumber", PropertyType.INTEGER, (Object)new Integer(this._module.readUnsignedShort(this._dstrm))), new Property("HorizontalResolution", PropertyType.INTEGER, (Object)new Integer(ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module))), new Property("VerticalResolution", PropertyType.INTEGER, (Object)new Integer(ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module))), new Property("HorizontalOffset", PropertyType.INTEGER, (Object)new Integer(ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module))), new Property("VerticalOffset", PropertyType.INTEGER, (Object)new Integer(ModuleBase.readUnsignedByte((DataInputStream)this._dstrm, (ModuleBase)this._module)))};
            streamsProp[i] = new Property("Codestreams", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)csProp);
        }
        ((ComposLayerHdrBox)this._parentBox).addCodestreamReg(new Property("CodestreamRegistration", PropertyType.PROPERTY, PropertyArity.ARRAY, (Object)streamsProp));
        return true;
    }

    @Override
    protected String getSelfPropName() {
        return "Codestream Registration Box";
    }
}

