/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.model.base;

import java.util.Optional;
import org.eclipse.rdf4j.model.IRI;
import org.eclipse.rdf4j.model.base.CoreDatatypeHelper;
import org.eclipse.rdf4j.model.base.DefaultDatatype;
import org.eclipse.rdf4j.model.base.InternedIRI;

public interface CoreDatatype {
    public static final CoreDatatype NONE = DefaultDatatype.NONE;

    default public boolean isXSDDatatype() {
        return false;
    }

    default public boolean isRDFDatatype() {
        return false;
    }

    default public boolean isGEODatatype() {
        return false;
    }

    default public Optional<XSD> asXSDDatatype() {
        return Optional.empty();
    }

    default public Optional<RDF> asRDFDatatype() {
        return Optional.empty();
    }

    default public Optional<GEO> asGEODatatype() {
        return Optional.empty();
    }

    public IRI getIri();

    public static CoreDatatype from(IRI datatype) {
        if (datatype == null) {
            return NONE;
        }
        return CoreDatatypeHelper.getReverseLookup().getOrDefault(datatype, NONE);
    }

    public static enum GEO implements CoreDatatype
    {
        WKT_LITERAL(GEO.iri("wktLiteral"));

        public static final String NAMESPACE = "http://www.opengis.net/ont/geosparql#";
        private final IRI iri;
        private final Optional<GEO> optional;

        private static IRI iri(String localName) {
            return new InternedIRI(NAMESPACE, localName);
        }

        private GEO(IRI iri) {
            this.iri = iri;
            this.optional = Optional.of(this);
        }

        @Override
        public boolean isGEODatatype() {
            return true;
        }

        @Override
        public IRI getIri() {
            return this.iri;
        }

        @Override
        public Optional<GEO> asGEODatatype() {
            return this.optional;
        }

        public String toString() {
            return this.iri.toString();
        }
    }

    public static enum RDF implements CoreDatatype
    {
        HTML(RDF.iri("HTML")),
        XMLLITERAL(RDF.iri("XMLLiteral")),
        LANGSTRING(RDF.iri("langString"));

        public static final String NAMESPACE = "http://www.w3.org/1999/02/22-rdf-syntax-ns#";
        private final IRI iri;
        private final Optional<RDF> optional;

        private static IRI iri(String localName) {
            return new InternedIRI(NAMESPACE, localName);
        }

        private RDF(IRI iri) {
            this.iri = iri;
            this.optional = Optional.of(this);
        }

        @Override
        public boolean isRDFDatatype() {
            return true;
        }

        @Override
        public IRI getIri() {
            return this.iri;
        }

        @Override
        public Optional<RDF> asRDFDatatype() {
            return this.optional;
        }

        public String toString() {
            return this.iri.toString();
        }
    }

    public static enum XSD implements CoreDatatype
    {
        ENTITIES(XSD.iri("ENTITIES"), false, false, false, true, false, false, false),
        ENTITY(XSD.iri("ENTITY"), false, false, false, true, false, false, false),
        ID(XSD.iri("ID"), false, false, false, true, false, false, false),
        IDREF(XSD.iri("IDREF"), false, false, false, true, false, false, false),
        IDREFS(XSD.iri("IDREFS"), false, false, false, true, false, false, false),
        NCNAME(XSD.iri("NCName"), false, false, false, true, false, false, false),
        NMTOKEN(XSD.iri("NMTOKEN"), false, false, false, true, false, false, false),
        NMTOKENS(XSD.iri("NMTOKENS"), false, false, false, true, false, false, false),
        NOTATION(XSD.iri("NOTATION"), true, false, false, false, false, false, false),
        NAME(XSD.iri("Name"), false, false, false, true, false, false, false),
        QNAME(XSD.iri("QName"), true, false, false, false, false, false, false),
        ANYURI(XSD.iri("anyURI"), true, false, false, false, false, false, false),
        BASE64BINARY(XSD.iri("base64Binary"), true, false, false, false, false, false, false),
        BOOLEAN(XSD.iri("boolean"), true, false, false, false, false, false, false),
        BYTE(XSD.iri("byte"), false, false, true, true, true, false, false),
        DATE(XSD.iri("date"), true, false, false, false, false, false, true),
        DATETIME(XSD.iri("dateTime"), true, false, false, false, false, false, true),
        DATETIMESTAMP(XSD.iri("dateTimeStamp"), false, false, false, true, false, false, true),
        DAYTIMEDURATION(XSD.iri("dayTimeDuration"), false, true, false, true, false, false, false),
        DECIMAL(XSD.iri("decimal"), true, false, false, false, true, false, false),
        DOUBLE(XSD.iri("double"), true, false, false, false, false, true, false),
        DURATION(XSD.iri("duration"), true, true, false, false, false, false, false),
        FLOAT(XSD.iri("float"), true, false, false, false, false, true, false),
        GDAY(XSD.iri("gDay"), true, false, false, false, false, false, true),
        GMONTH(XSD.iri("gMonth"), true, false, false, false, false, false, true),
        GMONTHDAY(XSD.iri("gMonthDay"), true, false, false, false, false, false, true),
        GYEAR(XSD.iri("gYear"), true, false, false, false, false, false, true),
        GYEARMONTH(XSD.iri("gYearMonth"), true, false, false, false, false, false, true),
        HEXBINARY(XSD.iri("hexBinary"), true, false, false, false, false, false, false),
        INT(XSD.iri("int"), false, false, true, true, true, false, false),
        INTEGER(XSD.iri("integer"), false, false, true, true, true, false, false),
        LANGUAGE(XSD.iri("language"), false, false, false, true, false, false, false),
        LONG(XSD.iri("long"), false, false, true, true, true, false, false),
        NEGATIVE_INTEGER(XSD.iri("negativeInteger"), false, false, true, true, true, false, false),
        NON_NEGATIVE_INTEGER(XSD.iri("nonNegativeInteger"), false, false, true, true, true, false, false),
        NON_POSITIVE_INTEGER(XSD.iri("nonPositiveInteger"), false, false, true, true, true, false, false),
        NORMALIZEDSTRING(XSD.iri("normalizedString"), false, false, false, true, false, false, false),
        POSITIVE_INTEGER(XSD.iri("positiveInteger"), false, false, true, true, true, false, false),
        SHORT(XSD.iri("short"), false, false, true, true, true, false, false),
        STRING(XSD.iri("string"), true, false, false, false, false, false, false),
        TIME(XSD.iri("time"), true, false, false, false, false, false, true),
        TOKEN(XSD.iri("token"), false, false, false, true, false, false, false),
        UNSIGNED_BYTE(XSD.iri("unsignedByte"), false, false, true, true, true, false, false),
        UNSIGNED_INT(XSD.iri("unsignedInt"), false, false, true, true, true, false, false),
        UNSIGNED_LONG(XSD.iri("unsignedLong"), false, false, true, true, true, false, false),
        UNSIGNED_SHORT(XSD.iri("unsignedShort"), false, false, true, true, true, false, false),
        YEARMONTHDURATION(XSD.iri("yearMonthDuration"), false, true, false, true, false, false, false);

        public static final String NAMESPACE = "http://www.w3.org/2001/XMLSchema#";
        private final IRI iri;
        private final boolean primitive;
        private final boolean duration;
        private final boolean integer;
        private final boolean derived;
        private final boolean decimal;
        private final boolean floatingPoint;
        private final boolean calendar;
        private final boolean builtIn;
        private final boolean numeric;
        private final boolean ordered;
        private final Optional<XSD> optional;

        private static IRI iri(String localName) {
            return new InternedIRI(NAMESPACE, localName);
        }

        private XSD(IRI iri, boolean primitive, boolean duration, boolean integer, boolean derived, boolean decimal, boolean floatingPoint, boolean calendar) {
            this.iri = iri;
            this.primitive = primitive;
            this.duration = duration;
            this.integer = integer;
            this.derived = derived;
            this.decimal = decimal;
            this.floatingPoint = floatingPoint;
            this.calendar = calendar;
            this.builtIn = primitive || derived;
            this.numeric = decimal || floatingPoint;
            this.ordered = this.numeric || calendar;
            this.optional = Optional.of(this);
        }

        public boolean isPrimitiveDatatype() {
            return this.primitive;
        }

        public boolean isDerivedDatatype() {
            return this.derived;
        }

        public boolean isBuiltInDatatype() {
            return this.builtIn;
        }

        public boolean isNumericDatatype() {
            return this.numeric;
        }

        public boolean isDecimalDatatype() {
            return this.decimal;
        }

        public boolean isIntegerDatatype() {
            return this.integer;
        }

        public boolean isFloatingPointDatatype() {
            return this.floatingPoint;
        }

        public boolean isCalendarDatatype() {
            return this.calendar;
        }

        public boolean isDurationDatatype() {
            return this.duration;
        }

        public boolean isOrderedDatatype() {
            return this.ordered;
        }

        @Override
        public boolean isXSDDatatype() {
            return true;
        }

        @Override
        public IRI getIri() {
            return this.iri;
        }

        @Override
        public Optional<XSD> asXSDDatatype() {
            return this.optional;
        }

        public String toString() {
            return this.iri.toString();
        }
    }
}

