/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.interfaces.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.gov.nationalarchives.droid.core.interfaces.config.DroidGlobalProperty;

public class DroidGlobalConfig {
    public static final String DROID_PROPERTIES = "droid.properties";
    private static final String DEFAULT_DROID_PROPERTIES = "default_droid.properties";
    private static final String DROID_SIGNATURE_FILE = "DROID_SignatureFile_V109.xml";
    private static final String CONTAINER_SIGNATURE_FILE = "container-signature-20221102.xml";
    private static final String TEXT_SIGNATURE_FILE = "text-signature-20101101.xml";
    private static final String DATABASE_DURABILITY = "database.durability";
    private static final String AVAILABLE_HASH_ALGORITHMS = "availableHashAlgorithms";
    private static final String TEMPLATE_SCHEMA_VERSION = "schema 6.04";
    private static final List<String> NON_CONFIGURABLE_PROPERTIES = Arrays.asList("availableHashAlgorithms");
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private Path droidWorkDir;
    private Path signatureFilesDir;
    private Path profileTemplateDir;
    private Path containerSignatureDir;
    private Path textSignatureFileDir;
    private Path reportDefinitionDir;
    private Path filterDir;
    private PropertiesConfiguration props;
    private PropertiesConfiguration defaultProps;
    private Path profilesDir;
    private Path tempDir;

    public DroidGlobalConfig() throws IOException {
        String droidHomePath = System.getProperty("droidUserDir");
        this.droidWorkDir = Paths.get(droidHomePath, new String[0]);
        Files.createDirectories(this.droidWorkDir, new FileAttribute[0]);
        this.signatureFilesDir = this.droidWorkDir.resolve("signature_files");
        Files.createDirectories(this.signatureFilesDir, new FileAttribute[0]);
        this.createResourceFile(this.signatureFilesDir, DROID_SIGNATURE_FILE, DROID_SIGNATURE_FILE);
        this.containerSignatureDir = this.droidWorkDir.resolve("container_sigs");
        Files.createDirectories(this.containerSignatureDir, new FileAttribute[0]);
        this.createResourceFile(this.containerSignatureDir, CONTAINER_SIGNATURE_FILE, CONTAINER_SIGNATURE_FILE);
        this.reportDefinitionDir = this.droidWorkDir.resolve("report_definitions");
        Files.createDirectories(this.reportDefinitionDir, new FileAttribute[0]);
        this.filterDir = this.droidWorkDir.resolve("filter_definitions");
        Files.createDirectories(this.filterDir, new FileAttribute[0]);
        this.profileTemplateDir = this.droidWorkDir.resolve("profile_templates");
        Files.createDirectories(this.profileTemplateDir, new FileAttribute[0]);
        this.profileTemplateDir = this.profileTemplateDir.resolve(TEMPLATE_SCHEMA_VERSION);
        Files.createDirectories(this.profileTemplateDir, new FileAttribute[0]);
        String droidTempPath = System.getProperty("droidTempDir");
        this.profilesDir = Paths.get(droidTempPath, "profiles");
        Files.createDirectories(this.profilesDir, new FileAttribute[0]);
        this.tempDir = Paths.get(droidTempPath, "tmp");
        Files.createDirectories(this.tempDir, new FileAttribute[0]);
    }

    public void init() throws ConfigurationException {
        boolean durability;
        Path droidProperties = this.droidWorkDir.resolve(DROID_PROPERTIES);
        this.props = new PropertiesConfiguration(droidProperties.toFile());
        URL defaultPropsUrl = this.getClass().getClassLoader().getResource(DEFAULT_DROID_PROPERTIES);
        this.defaultProps = new PropertiesConfiguration(defaultPropsUrl);
        boolean saveProperties = false;
        Iterator it = this.defaultProps.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            if (this.props.containsKey(key)) continue;
            this.props.addProperty(key, this.defaultProps.getProperty(key));
            saveProperties = true;
        }
        if (saveProperties) {
            this.props.save();
        }
        if (this.props.containsKey(DATABASE_DURABILITY) && !(durability = this.props.getBoolean(DATABASE_DURABILITY))) {
            System.setProperty("derby.system.durability", "test");
        }
    }

    public Path getDroidWorkDir() {
        return this.droidWorkDir;
    }

    public Properties getProfileProperties() {
        Properties profileProperties = new Properties();
        Configuration profilePropsConfig = this.props.subset("profile");
        Iterator it = profilePropsConfig.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            profileProperties.setProperty(key, profilePropsConfig.getProperty(key).toString());
        }
        return profileProperties;
    }

    public PropertiesConfiguration getProperties() {
        return this.props;
    }

    public PropertiesConfiguration getDefaultProperties() {
        return this.defaultProps;
    }

    public void update(Map<String, Object> properties) throws ConfigurationException {
        for (Map.Entry<String, Object> entry : properties.entrySet()) {
            if (NON_CONFIGURABLE_PROPERTIES.contains(entry.getKey())) continue;
            this.props.setProperty(entry.getKey(), entry.getValue());
        }
        this.props.save();
    }

    public Map<String, Object> getPropertiesMap() {
        HashMap<String, Object> allSettings = new HashMap<String, Object>();
        Iterator it = this.props.getKeys();
        while (it.hasNext()) {
            String key = (String)it.next();
            DroidGlobalProperty property = DroidGlobalProperty.forName(key);
            if (property == null) continue;
            allSettings.put(key, property.getType().getTypeSafeValue((Configuration)this.props, key));
        }
        ArrayList<String> availableHashAlgorithms = new ArrayList<String>();
        availableHashAlgorithms.add("md5");
        availableHashAlgorithms.add("sha1");
        availableHashAlgorithms.add("sha256");
        allSettings.put(AVAILABLE_HASH_ALGORITHMS, availableHashAlgorithms);
        return allSettings;
    }

    public Path getSignatureFileDir() {
        return this.signatureFilesDir;
    }

    public Path getProfileTemplateDir() {
        return this.profileTemplateDir;
    }

    public Path getContainerSignatureDir() {
        return this.containerSignatureDir;
    }

    public Path getTextSignatureFileDir() {
        return this.textSignatureFileDir;
    }

    public Path getReportDefinitionDir() {
        return this.reportDefinitionDir;
    }

    public Path getProfilesDir() {
        return this.profilesDir;
    }

    public Path getFilterDir() {
        return this.filterDir;
    }

    public Path getTempDir() {
        return this.tempDir;
    }

    private void createResourceFile(Path resourceDir, String fileName, String resourceName) throws IOException {
        Path resourcefile = resourceDir.resolve(fileName);
        if (!Files.exists(resourcefile, new LinkOption[0])) {
            try (InputStream in = this.getClass().getClassLoader().getResourceAsStream(resourceName);){
                if (in == null) {
                    this.log.warn("Resource not found: " + resourceName);
                } else {
                    Files.copy(in, resourcefile, new CopyOption[0]);
                }
            }
        }
    }

    public boolean getBooleanProperty(DroidGlobalProperty propertyKey) {
        return this.props.getBoolean(propertyKey.getName());
    }
}

