/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.seda21;

import ch.docuteam.darc.ead.C;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.mdconfig.CSVMetadataValue;
import ch.docuteam.darc.mdconfig.LevelOfDescription;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.RDFMetadataValue;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.filesec.File;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.mets.structmap.NodeFile;
import ch.docuteam.darc.mets.structmap.StructureMap;
import ch.docuteam.darc.premis.Event;
import ch.docuteam.darc.premis.Object;
import ch.docuteam.mapping.ExporterSEDA;
import ch.docuteam.mapping.util.ExporterUtil;
import ch.docuteam.mapping.util.MetsExportFacade;
import ch.docuteam.tools.out.Logger;
import fr.gouv.culture.archivesdefrance.seda.v2_1.AccessRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.AppraisalRuleType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.ArchiveTransferType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.ArchiveUnitType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.BinaryDataObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.CodeKeywordType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.CodeListVersionsType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.CodeType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.CustodialHistoryItemType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.CustodialHistoryType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.DataObjectPackageType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.DataObjectRefType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.DescriptiveMetadataContentType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.DescriptiveMetadataType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.EventType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.FileInfoType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.FinalActionAppraisalCodeType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.FormatIdentificationType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.IdentifierType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.KeyType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.KeywordsType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.LevelType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.LogBookType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.ManagementMetadataType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.ManagementType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.MessageDigestBinaryObjectType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.ObjectFactory;
import fr.gouv.culture.archivesdefrance.seda.v2_1.OrganizationType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.OrganizationWithIdType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.RuleIdType;
import fr.gouv.culture.archivesdefrance.seda.v2_1.TextType;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.math.BigInteger;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.PropertyException;
import javax.xml.datatype.XMLGregorianCalendar;

public class Exporter
implements ExporterSEDA {
    static final String CONTEXT_PATH_SEDA_V21 = "fr.gouv.culture.archivesdefrance.seda.v2_1";
    static final String SCHEMA_LOCATION = "fr:gouv:culture:archivesdefrance:seda:v2.1 seda-2.1-main.xsd";

    @Override
    public boolean exportMetsToSEDA(Path metsDocumentPath, Path sedaSIPPath, String operatorName) {
        Document metsDocument = null;
        try {
            metsDocument = Document.openReadOnly((String)metsDocumentPath.toString(), (String)operatorName);
            Path sedaMetadataPath = ExporterUtil.getValidSEDAMetadataPath(sedaSIPPath);
            Marshaller marshaller = this.getMarshaller();
            ObjectFactory sedaObjectFactory = new ObjectFactory();
            ArchiveTransferType archiveTransferType = this.createArchiveTransfer(sedaObjectFactory, metsDocument);
            DataObjectPackageType dataObjectPackageType = sedaObjectFactory.createDataObjectPackageType();
            archiveTransferType.setDataObjectPackage(dataObjectPackageType);
            DescriptiveMetadataType descriptiveMetadataType = sedaObjectFactory.createDescriptiveMetadataType();
            dataObjectPackageType.setDescriptiveMetadata(descriptiveMetadataType);
            ManagementMetadataType managementMetadataType = sedaObjectFactory.createManagementMetadataType();
            managementMetadataType.setLogBook(this.createLogbookWithSoftwareIdAndVersion(metsDocument, sedaObjectFactory));
            dataObjectPackageType.setManagementMetadata(managementMetadataType);
            StructureMap structureMap = metsDocument.getStructureMap();
            NodeAbstract rootNode = structureMap.getRoot();
            ArchiveUnitType archiveUnitType = sedaObjectFactory.createArchiveUnitType();
            List<java.lang.Object> dataObjectList = dataObjectPackageType.getDataObjectGroupOrBinaryDataObjectOrPhysicalDataObject();
            HashMap<NodeAbstract, String> nodesToUniqueFileNamesMap = new HashMap<NodeAbstract, String>();
            this.createArchiveUnitRecursive(rootNode, archiveUnitType, sedaObjectFactory, dataObjectList, nodesToUniqueFileNamesMap);
            descriptiveMetadataType.getArchiveUnit().add(archiveUnitType);
            JAXBElement<ArchiveTransferType> archiveTransfer = sedaObjectFactory.createArchiveTransfer(archiveTransferType);
            try (FileOutputStream outputStream = new FileOutputStream(sedaMetadataPath.toFile());){
                marshaller.marshal(archiveTransfer, (OutputStream)outputStream);
                this.copyFiles(metsDocument, archiveTransfer, sedaSIPPath);
            }
            return true;
        }
        catch (Exception e) {
            Logger.error((java.lang.Object)"error at exportMetsToSEDA because of: ", (Throwable)e);
            return false;
        }
    }

    private Marshaller getMarshaller() throws JAXBException, PropertyException {
        JAXBContext sedaJAXBContext = JAXBContext.newInstance((String)CONTEXT_PATH_SEDA_V21);
        Marshaller marshaller = sedaJAXBContext.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (java.lang.Object)true);
        marshaller.setProperty("jaxb.schemaLocation", (java.lang.Object)SCHEMA_LOCATION);
        return marshaller;
    }

    private void copyFiles(Document metsDocument, JAXBElement<ArchiveTransferType> archiveTransfer, Path sedaSIPPath) {
        for (java.lang.Object minimalDataObjectType : ((ArchiveTransferType)archiveTransfer.getValue()).getDataObjectPackage().getDataObjectGroupOrBinaryDataObjectOrPhysicalDataObject()) {
            if (!(minimalDataObjectType instanceof BinaryDataObjectType)) continue;
            BinaryDataObjectType binaryDataObject = (BinaryDataObjectType)minimalDataObjectType;
            String id = binaryDataObject.getId();
            String relPath = binaryDataObject.getUri();
            ExporterUtil.copyFile(metsDocument, ExporterUtil.getMETSId(id), sedaSIPPath, relPath);
        }
    }

    private ArchiveTransferType createArchiveTransfer(ObjectFactory sedaObjectFactory, Document metsDocument) {
        ArchiveTransferType archiveTransferType = new ArchiveTransferType();
        archiveTransferType.setDate(ExporterUtil.getNewXMLGregorianCalendar());
        archiveTransferType.setId(MetsExportFacade.getHeaderAdmId(metsDocument));
        IdentifierType identifierType = sedaObjectFactory.createIdentifierType();
        identifierType.setValue("");
        archiveTransferType.setMessageIdentifier(identifierType);
        this.createCodeListVersions(sedaObjectFactory, archiveTransferType);
        String archivalAgency = MetsExportFacade.getArchivalAgencyFromSubmissionAgreement(metsDocument);
        OrganizationWithIdType organizationWithId = this.createOrganizationWithId(sedaObjectFactory, archivalAgency);
        archiveTransferType.setArchivalAgency(organizationWithId);
        String transferringAgency = MetsExportFacade.getTransferringAgencyFromSubmissionAgreement(metsDocument);
        archiveTransferType.setTransferringAgency(this.createOrganizationWithId(sedaObjectFactory, transferringAgency));
        return archiveTransferType;
    }

    private void createCodeListVersions(ObjectFactory sedaObjectFactory, ArchiveTransferType archiveTransferType) {
        CodeListVersionsType codeListVersionsType = sedaObjectFactory.createCodeListVersionsType();
        CodeType accessRuleCodeValue = sedaObjectFactory.createCodeType();
        accessRuleCodeValue.setValue(CodeListVersionsEnum.AccessRuleCode.name());
        codeListVersionsType.setAccessRuleCodeListVersion(accessRuleCodeValue);
        CodeType appraisalRuleCodeValue = sedaObjectFactory.createCodeType();
        appraisalRuleCodeValue.setValue(CodeListVersionsEnum.AppraisalRuleCode.name());
        codeListVersionsType.setAppraisalRuleCodeListVersion(appraisalRuleCodeValue);
        CodeType classificationRuleCodeValue = sedaObjectFactory.createCodeType();
        classificationRuleCodeValue.setValue(CodeListVersionsEnum.ClassificationRuleCode.name());
        codeListVersionsType.setClassificationRuleCodeListVersion(classificationRuleCodeValue);
        CodeType disseminationRuleCodeValue = sedaObjectFactory.createCodeType();
        disseminationRuleCodeValue.setValue(CodeListVersionsEnum.DisseminationRuleCode.name());
        codeListVersionsType.setDisseminationRuleCodeListVersion(disseminationRuleCodeValue);
        CodeType reuseRuleCodeValue = sedaObjectFactory.createCodeType();
        reuseRuleCodeValue.setValue(CodeListVersionsEnum.ReuseRuleCode.name());
        codeListVersionsType.setReuseRuleCodeListVersion(reuseRuleCodeValue);
        CodeType storageRuleCodeValue = sedaObjectFactory.createCodeType();
        storageRuleCodeValue.setValue(CodeListVersionsEnum.StorageRuleCode.name());
        codeListVersionsType.setStorageRuleCodeListVersion(storageRuleCodeValue);
        CodeType fileFormatCodeValue = sedaObjectFactory.createCodeType();
        fileFormatCodeValue.setValue(CodeListVersionsEnum.FileFormatCode.name());
        codeListVersionsType.setFileFormatCodeListVersion(fileFormatCodeValue);
        CodeType messageDigestAlgorithmCodeValue = sedaObjectFactory.createCodeType();
        messageDigestAlgorithmCodeValue.setValue(CodeListVersionsEnum.MessageDigestAlgorithmCode.name());
        codeListVersionsType.setMessageDigestAlgorithmCodeListVersion(messageDigestAlgorithmCodeValue);
        CodeType mimeTypeCodeValue = sedaObjectFactory.createCodeType();
        mimeTypeCodeValue.setValue(CodeListVersionsEnum.MimeTypeCode.name());
        codeListVersionsType.setMimeTypeCodeListVersion(mimeTypeCodeValue);
        archiveTransferType.setCodeListVersions(codeListVersionsType);
    }

    private OrganizationWithIdType createOrganizationWithId(ObjectFactory sedaObjectFactory, String identifierTypeValue) {
        OrganizationWithIdType organizationWithId = sedaObjectFactory.createOrganizationWithIdType();
        IdentifierType identifierType = sedaObjectFactory.createIdentifierType();
        identifierType.setValue(identifierTypeValue);
        organizationWithId.setIdentifier(identifierType);
        return organizationWithId;
    }

    private ManagementType createManagement(ObjectFactory sedaObjectFactory, ArchiveUnitType archiveUnitType, NodeAbstract metsStructMapNode) {
        ManagementType management = sedaObjectFactory.createManagementType();
        this.createAppraisalRule(sedaObjectFactory, management, metsStructMapNode);
        this.createAccessRule(sedaObjectFactory, management, metsStructMapNode);
        archiveUnitType.setManagement(management);
        LogBookType logBook = sedaObjectFactory.createLogBookType();
        management.setLogBook(logBook);
        this.createEvents(metsStructMapNode, sedaObjectFactory, logBook);
        return management;
    }

    private LogBookType createLogbookWithSoftwareIdAndVersion(Document metsDocument, ObjectFactory sedaObjectFactory) {
        LogBookType logBook = sedaObjectFactory.createLogBookType();
        EventType eventType = sedaObjectFactory.createEventType();
        eventType.setEventDateTime(ExporterUtil.getNewXMLGregorianCalendar().toString());
        TextType eventDetail = sedaObjectFactory.createTextType();
        Object headerPremisObject = MetsExportFacade.getHeaderPremisObject(metsDocument);
        eventDetail.setValue(ExporterUtil.getSoftwareNameAndVersion(headerPremisObject));
        eventType.setEventDetail(eventDetail);
        logBook.getEvent().add(eventType);
        return logBook;
    }

    private void createAppraisalRule(ObjectFactory sedaObjectFactory, ManagementType management, NodeAbstract metsStructMapNode) {
        List appraisalAndDestruction;
        List retentionPeriodBaseYear;
        boolean dataFound = false;
        C eAD_C = MetsExportFacade.getEADComponent(metsStructMapNode);
        AppraisalRuleType appraisalRuleType = sedaObjectFactory.createAppraisalRuleType();
        String retentionPolicy = MetsExportFacade.getRententionPolicy(metsStructMapNode);
        if (retentionPolicy != null && !retentionPolicy.isEmpty()) {
            RuleIdType ruleId = sedaObjectFactory.createRuleIdType();
            ruleId.setValue(retentionPolicy);
            appraisalRuleType.getRuleAndStartDate().add(ruleId);
            dataFound = true;
        }
        if ((retentionPeriodBaseYear = eAD_C.getRetentionPeriodBaseYear()) != null && retentionPeriodBaseYear.size() > 0) {
            XMLGregorianCalendar startDate = ExporterUtil.getXMLGregorianCalendarDATE((String)retentionPeriodBaseYear.get(0), "yyyy-MM-dd");
            appraisalRuleType.getRuleAndStartDate().add(startDate);
            dataFound = true;
        }
        if ((appraisalAndDestruction = eAD_C.getAppraisalAndDestruction()) != null && appraisalAndDestruction.size() > 0) {
            FinalActionAppraisalCodeType value = this.getAppraisalCode(appraisalAndDestruction);
            appraisalRuleType.setFinalAction(value);
            dataFound = true;
        }
        if (dataFound) {
            management.setAppraisalRule(appraisalRuleType);
        }
    }

    private FinalActionAppraisalCodeType getAppraisalCode(List<String> metsAppraisalAndDestruction) {
        FinalActionAppraisalCodeType value;
        try {
            value = FinalActionAppraisalCodeType.fromValue(metsAppraisalAndDestruction.get(0));
        }
        catch (IllegalArgumentException e) {
            Logger.error((java.lang.Object)"cannot parse FinalActionAppraisalCodeType from appraisalAndDestruction, use default. ", (Throwable)e);
            value = FinalActionAppraisalCodeType.KEEP;
        }
        return value;
    }

    private void createAccessRule(ObjectFactory sedaObjectFactory, ManagementType management, NodeAbstract metsStructMapNode) {
        List accessRestrictionPeriodBaseYear;
        boolean dataFound = false;
        C eAD_C = MetsExportFacade.getEADComponent(metsStructMapNode);
        AccessRuleType accessRuleType = sedaObjectFactory.createAccessRuleType();
        String accessRestrictionStatus = MetsExportFacade.getAccessRestrictionStatus(metsStructMapNode);
        if (accessRestrictionStatus != null && !accessRestrictionStatus.isEmpty()) {
            RuleIdType ruleId = sedaObjectFactory.createRuleIdType();
            ruleId.setValue(accessRestrictionStatus);
            accessRuleType.getRuleAndStartDate().add(ruleId);
            dataFound = true;
        }
        if ((accessRestrictionPeriodBaseYear = eAD_C.getAccessRestrictionPeriodBaseYear()) != null && accessRestrictionPeriodBaseYear.size() > 0) {
            XMLGregorianCalendar startDate = ExporterUtil.getXMLGregorianCalendarDATE((String)accessRestrictionPeriodBaseYear.get(0), "yyyy-MM-dd");
            accessRuleType.getRuleAndStartDate().add(startDate);
            dataFound = true;
        }
        if (dataFound) {
            management.setAccessRule(accessRuleType);
        }
    }

    private ArchiveUnitType createArchiveUnitRecursive(NodeAbstract metsStructMapNode, ArchiveUnitType archiveUnit, ObjectFactory sedaObjectFactory, List<java.lang.Object> dataObjectList, Map<NodeAbstract, String> nodesToUniqueFileNamesMap) {
        String adminId = ExporterUtil.getIdForSEDA(metsStructMapNode.getAdmId());
        archiveUnit.setId(adminId);
        this.createManagement(sedaObjectFactory, archiveUnit, metsStructMapNode);
        this.createArchiveUnitContent(metsStructMapNode, archiveUnit, sedaObjectFactory, nodesToUniqueFileNamesMap);
        this.createBinaryDataObjectAndDataObjectReference(metsStructMapNode, archiveUnit, sedaObjectFactory, dataObjectList, nodesToUniqueFileNamesMap);
        int childCount = metsStructMapNode.getChildCount();
        for (int i = 0; i < childCount; ++i) {
            NodeAbstract metsChildNode = (NodeAbstract)metsStructMapNode.getChildAt(i);
            ArchiveUnitType childAchiveUnit = sedaObjectFactory.createArchiveUnitType();
            archiveUnit.getArchiveUnitOrArchiveUnitReferenceAbstractOrDataObjectReference().add(childAchiveUnit);
            this.createArchiveUnitRecursive(metsChildNode, childAchiveUnit, sedaObjectFactory, dataObjectList, nodesToUniqueFileNamesMap);
        }
        return archiveUnit;
    }

    private void createArchiveUnitContent(NodeAbstract metsStructMapNode, ArchiveUnitType archiveUnit, ObjectFactory sedaObjectFactory, Map<NodeAbstract, String> nodesToUniqueFileNamesMap) {
        List to;
        String language;
        List archivalHistory;
        List sourceType;
        List scopeContent;
        DescriptiveMetadataContentType descriptiveMetadataContentType = sedaObjectFactory.createDescriptiveMetadataContentType();
        LevelType levelType = this.getLevelType(metsStructMapNode);
        descriptiveMetadataContentType.setDescriptionLevel(levelType);
        TextType title = sedaObjectFactory.createTextType();
        String fileOrFolderName = metsStructMapNode.getUnitTitle();
        if (metsStructMapNode.isFile()) {
            ExporterUtil.addUniqueFileName(metsStructMapNode, nodesToUniqueFileNamesMap);
        }
        title.setValue(fileOrFolderName);
        descriptiveMetadataContentType.getTitle().add(title);
        List refCode = MetsExportFacade.getEADComponent(metsStructMapNode).getRefCode();
        if (refCode != null && refCode.size() > 0) {
            descriptiveMetadataContentType.getArchivalAgencyArchiveUnitIdentifier().add((String)refCode.get(0));
        }
        if ((scopeContent = MetsExportFacade.getEADComponent(metsStructMapNode).getScopeContent()) != null && scopeContent.size() > 0) {
            TextType description = sedaObjectFactory.createTextType();
            description.setValue((String)scopeContent.get(0));
            descriptiveMetadataContentType.getDescription().add(description);
        }
        if ((sourceType = MetsExportFacade.getEADComponent(metsStructMapNode).getSourceType()) != null && sourceType.size() > 0) {
            TextType type = sedaObjectFactory.createTextType();
            type.setValue((String)sourceType.get(0));
            descriptiveMetadataContentType.setType(type);
        }
        if ((archivalHistory = MetsExportFacade.getEADComponent(metsStructMapNode).getArchivalHistory()) != null && archivalHistory.size() > 0) {
            this.createCustodialHistory(metsStructMapNode, sedaObjectFactory, descriptiveMetadataContentType, archivalHistory);
        }
        if ((language = MetsExportFacade.getLanguage(metsStructMapNode)) != null) {
            descriptiveMetadataContentType.getLanguage().add(language);
        }
        this.createOriginatingAgency(metsStructMapNode, sedaObjectFactory, descriptiveMetadataContentType);
        List from = MetsExportFacade.getEADComponent(metsStructMapNode).getFrom();
        if (from != null && from.size() > 0) {
            descriptiveMetadataContentType.setStartDate((String)from.get(0));
        }
        if ((to = MetsExportFacade.getEADComponent(metsStructMapNode).getTo()) != null && to.size() > 0) {
            descriptiveMetadataContentType.setEndDate((String)to.get(0));
        }
        this.createKeywords(metsStructMapNode, sedaObjectFactory, descriptiveMetadataContentType);
        archiveUnit.setContent(descriptiveMetadataContentType);
    }

    private void createKeywords(NodeAbstract metsStructMapNode, ObjectFactory sedaObjectFactory, DescriptiveMetadataContentType descriptiveMetadataContentType) {
        this.createKeywordGeneric(sedaObjectFactory, descriptiveMetadataContentType, CodeKeywordType.CORPNAME, metsStructMapNode, "institution");
        this.createKeywordGeneric(sedaObjectFactory, descriptiveMetadataContentType, CodeKeywordType.FAMNAME, metsStructMapNode, "familyName");
        this.createKeywordGeneric(sedaObjectFactory, descriptiveMetadataContentType, CodeKeywordType.FUNCTION, metsStructMapNode, "function");
        this.createKeywordGeneric(sedaObjectFactory, descriptiveMetadataContentType, CodeKeywordType.GENREFORM, metsStructMapNode, "objectType");
        this.createKeywordGeneric(sedaObjectFactory, descriptiveMetadataContentType, CodeKeywordType.GEOGNAME, metsStructMapNode, "geogName");
        this.createKeywordGeneric(sedaObjectFactory, descriptiveMetadataContentType, CodeKeywordType.NAME, metsStructMapNode, "keyword");
        this.createKeywordGeneric(sedaObjectFactory, descriptiveMetadataContentType, CodeKeywordType.OCCUPATION, metsStructMapNode, "occupation");
        this.createKeywordGeneric(sedaObjectFactory, descriptiveMetadataContentType, CodeKeywordType.PERSNAME, metsStructMapNode, "creator");
        this.createKeywordGeneric(sedaObjectFactory, descriptiveMetadataContentType, CodeKeywordType.SUBJECT, metsStructMapNode, "subjectGeneral");
    }

    private void createKeywordGeneric(ObjectFactory sedaObjectFactory, DescriptiveMetadataContentType descriptiveMetadataContentType, CodeKeywordType keywordTypeValue, NodeAbstract metsStructMapNode, String accessorName) {
        List values;
        try {
            values = metsStructMapNode.getAllDynamicMetadataValuesForName_NoCheck(accessorName);
        }
        catch (MetadataElementIsNotDefinedException | IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
            Logger.warn((java.lang.Object)("Error reading metadata values for accessor '" + accessorName + "'"));
            return;
        }
        if (values == null || values.size() == 0) {
            return;
        }
        MetadataElement metadataElement = MetsExportFacade.getMetadataElement(metsStructMapNode, accessorName);
        boolean isMetadataElementOfTypeRDF = metadataElement != null && metadataElement.getValueType().equals((java.lang.Object)MetadataElement.VALUE_TYPE.skosFile);
        boolean isMetadataElementOfTypeCSV = metadataElement != null && metadataElement.getValueType().equals((java.lang.Object)MetadataElement.VALUE_TYPE.csvFile);
        for (String value : values) {
            if (value.isEmpty()) continue;
            String reference = null;
            if (isMetadataElementOfTypeRDF) {
                reference = value;
                value = RDFMetadataValue.getRDFLabelENorDefault((List)metadataElement.getRdfAllowedValues(), (String)reference);
            } else if (isMetadataElementOfTypeCSV) {
                reference = value;
                value = CSVMetadataValue.getCSVLabelEN((List)metadataElement.getCsvAllowedValues(), (String)reference);
            }
            this.createKeyword(sedaObjectFactory, descriptiveMetadataContentType, keywordTypeValue, value, reference);
        }
    }

    private void createKeyword(ObjectFactory sedaObjectFactory, DescriptiveMetadataContentType descriptiveMetadataContentType, CodeKeywordType keywordTypeValue, String content, String reference) {
        KeywordsType keywordsType = sedaObjectFactory.createKeywordsType();
        KeyType keyType = sedaObjectFactory.createKeyType();
        keyType.setValue(keywordTypeValue);
        keywordsType.setKeywordType(keyType);
        TextType keywordContent = sedaObjectFactory.createTextType();
        keywordContent.setValue(content);
        keywordsType.setKeywordContent(keywordContent);
        if (reference != null) {
            IdentifierType identifierType = sedaObjectFactory.createIdentifierType();
            identifierType.setValue(reference);
            keywordsType.setKeywordReference(identifierType);
        }
        descriptiveMetadataContentType.getKeyword().add(keywordsType);
    }

    private void createOriginatingAgency(NodeAbstract metsStructMapNode, ObjectFactory sedaObjectFactory, DescriptiveMetadataContentType descriptiveMetadataContentType) {
        List originationAgency = MetsExportFacade.getEADComponent(metsStructMapNode).getOriginationAgency();
        if (originationAgency != null && originationAgency.size() > 0) {
            OrganizationType organizationType = sedaObjectFactory.createOrganizationType();
            IdentifierType identifierType = sedaObjectFactory.createIdentifierType();
            identifierType.setValue((String)originationAgency.get(0));
            organizationType.setIdentifier(identifierType);
            descriptiveMetadataContentType.setOriginatingAgency(organizationType);
        }
    }

    private void createEvents(NodeAbstract metsStructMapNode, ObjectFactory sedaObjectFactory, LogBookType logBook) {
        for (Event premisEvent : MetsExportFacade.getDigiprovWithPremis(metsStructMapNode).getEvents()) {
            EventType eventType = this.createEvent(sedaObjectFactory, premisEvent);
            logBook.getEvent().add(eventType);
        }
    }

    private EventType createEvent(ObjectFactory sedaObjectFactory, Event premisEvent) {
        EventType eventType = sedaObjectFactory.createEventType();
        eventType.setEventDateTime(premisEvent.getDateTime());
        eventType.setEventType(premisEvent.getType());
        TextType eventDetail = sedaObjectFactory.createTextType();
        eventDetail.setValue(premisEvent.getDetail());
        eventType.setEventDetail(eventDetail);
        eventType.setEventIdentifier(ExporterUtil.getIdForSEDA(premisEvent.getId()));
        return eventType;
    }

    private void createCustodialHistory(NodeAbstract metsStructMapNode, ObjectFactory sedaObjectFactory, DescriptiveMetadataContentType descriptiveMetadataContentType, List<String> archivalHistoryList) {
        CustodialHistoryType custodialHistory = sedaObjectFactory.createCustodialHistoryType();
        Iterator<String> iterator = archivalHistoryList.iterator();
        while (iterator.hasNext()) {
            this.createCustodialHistoryItem(iterator.next(), custodialHistory);
        }
        descriptiveMetadataContentType.setCustodialHistory(custodialHistory);
    }

    private void createCustodialHistoryItem(String custodialHistoryItemValue, CustodialHistoryType custodialHistory) {
        CustodialHistoryItemType custodialHistoryItem = new CustodialHistoryItemType();
        custodialHistoryItem.setValue(custodialHistoryItemValue);
        custodialHistory.getCustodialHistoryItem().add(custodialHistoryItem);
    }

    private LevelType getLevelType(NodeAbstract metsStructMapNode) {
        LevelType levelType;
        LevelOfDescription level = metsStructMapNode.getLevel();
        try {
            levelType = LevelType.fromValue(level.getName());
        }
        catch (IllegalArgumentException e) {
            levelType = LevelType.FILE;
            Logger.warn((java.lang.Object)("catch IllegalArgumentException at LevelType.fromValue() for value '" + level.getName() + "', so just use the default for the levelType: " + levelType));
        }
        return levelType;
    }

    private void createBinaryDataObjectAndDataObjectReference(NodeAbstract metsStructMapNode, ArchiveUnitType archiveUnit, ObjectFactory sedaObjectFactory, List<java.lang.Object> dataObjectList, Map<NodeAbstract, String> nodesToUniqueFileNamesMap) {
        if (metsStructMapNode instanceof NodeFile) {
            BinaryDataObjectType binaryDataObjectType = this.createBinaryDataObject(sedaObjectFactory, (NodeFile)metsStructMapNode, nodesToUniqueFileNamesMap);
            dataObjectList.add(binaryDataObjectType);
            DataObjectRefType dataObjectRefType = sedaObjectFactory.createDataObjectRefType();
            dataObjectRefType.setDataObjectReferenceId(binaryDataObjectType);
            archiveUnit.getArchiveUnitOrArchiveUnitReferenceAbstractOrDataObjectReference().add(dataObjectRefType);
        }
    }

    private BinaryDataObjectType createBinaryDataObject(ObjectFactory sedaObjectFactory, NodeFile fileNode, Map<NodeAbstract, String> nodesToUniqueFileNamesMap) {
        String fileId = ExporterUtil.getIdForSEDA(fileNode.getFileId());
        BinaryDataObjectType binaryDataObjectType = sedaObjectFactory.createBinaryDataObjectType();
        binaryDataObjectType.setId(fileId);
        File metsFile = fileNode.getMyFileSectionFile();
        List usage = MetsExportFacade.getEADComponent((NodeAbstract)fileNode).getUsage();
        if (usage != null && usage.size() > 0) {
            binaryDataObjectType.setDataObjectVersion((String)usage.get(0));
        }
        FileInfoType fileInfoType = sedaObjectFactory.createFileInfoType();
        String uniqueFileName = this.getUniqueFileName(fileNode, nodesToUniqueFileNamesMap);
        fileInfoType.setFilename(uniqueFileName);
        long ioFileLastModified = metsFile.getFile().lastModified();
        XMLGregorianCalendar value = ExporterUtil.getXMLGregorianCalendar(ioFileLastModified);
        fileInfoType.setLastModified(value);
        binaryDataObjectType.setFileInfo(fileInfoType);
        binaryDataObjectType.setUri(ExporterUtil.getSEDA_Uri(uniqueFileName));
        Object premisObject = MetsExportFacade.getPremisObject((NodeAbstract)fileNode);
        MessageDigestBinaryObjectType createMessageDigestBinaryObjectType = sedaObjectFactory.createMessageDigestBinaryObjectType();
        createMessageDigestBinaryObjectType.setAlgorithm(premisObject.getMessageDigestAlgorithm());
        createMessageDigestBinaryObjectType.setValue(premisObject.getMessageDigest());
        binaryDataObjectType.setMessageDigest(createMessageDigestBinaryObjectType);
        BigInteger size = BigInteger.valueOf(Long.valueOf(premisObject.getSize()));
        if (size.compareTo(BigInteger.ZERO) > 0) {
            binaryDataObjectType.setSize(size);
        }
        FormatIdentificationType formatIdentificationType = sedaObjectFactory.createFormatIdentificationType();
        formatIdentificationType.setFormatLitteral(premisObject.getFormatName());
        formatIdentificationType.setFormatId(ExporterUtil.getFormatId(premisObject));
        formatIdentificationType.setMimeType(ExporterUtil.getMimeType(metsFile));
        binaryDataObjectType.setFormatIdentification(formatIdentificationType);
        return binaryDataObjectType;
    }

    String getUniqueFileName(NodeFile nodeFile, Map<NodeAbstract, String> nodesToUniqueFileNamesMap) {
        return nodesToUniqueFileNamesMap.get(nodeFile);
    }

    private static enum CodeListVersionsEnum {
        MessageDigestAlgorithmCode,
        MimeTypeCode,
        FileFormatCode,
        StorageRuleCode,
        AppraisalRuleCode,
        AccessRuleCode,
        DisseminationRuleCode,
        ReuseRuleCode,
        ClassificationRuleCode;

    }
}

