/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.scriptRunner;

import com.exlibris.core.infra.svc.api.scriptRunner.ExecAbstract;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecStrategy;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExecPipe
extends ExecAbstract
implements ExecStrategy {
    private OutputStream stdin = null;
    private InputStream stderr = null;
    private InputStream stdout = null;
    private BufferedReader brCleanUp;
    ProcessBuilder builder;
    private final Process process;
    private static final String PROCESS_ENDED = "Rosetta done ([-]*\\d+)";
    Pattern pattern;

    public ExecPipe(String execScriptPath) throws IOException {
        this.builder = new ProcessBuilder(execScriptPath);
        this.process = this.builder.start();
        this.stdin = null;
        this.stderr = null;
        this.stdout = null;
        this.stdin = this.process.getOutputStream();
        this.stderr = this.process.getErrorStream();
        this.stdout = this.process.getInputStream();
        this.brCleanUp = new BufferedReader(new InputStreamReader(this.stdout));
        this.pattern = Pattern.compile(PROCESS_ENDED);
    }

    @Override
    public int execExternalProcess(String cmd, List<String> args) {
        super.execExternalProcess(cmd, args);
        StringBuilder line = new StringBuilder(cmd);
        StringBuilder output = new StringBuilder("");
        for (String arg : args) {
            line.append(" ").append(arg);
        }
        line.append("\n");
        try {
            Matcher matcher;
            this.stdin.write(line.toString().getBytes());
            this.stdin.flush();
            while (true) {
                String outputLine;
                if ((outputLine = this.brCleanUp.readLine()) == null) continue;
                matcher = this.pattern.matcher(outputLine);
                if (matcher.matches()) break;
                output.append(outputLine).append("\n");
            }
            this.exitValue = new Integer(matcher.group(1));
            this.inputStream = output.toString();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.cleanup();
            return -1;
        }
        return this.exitValue;
    }

    private void cleanup() {
        try {
            this.stdin.close();
            this.brCleanUp.close();
            this.stderr.close();
            this.stdout.close();
            this.process.destroy();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void finalize() throws Throwable {
        super.finalize();
        this.cleanup();
    }
}

