/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.security;

import com.exlibris.core.infra.Common;
import com.exlibris.core.infra.common.security.UserPrincipalRetriever;
import com.exlibris.core.infra.svc.api.sharedsession.SessionHelper;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.web.authentication.logout.LogoutHandler;

public class SecurityContextLogoutHandler
implements LogoutHandler {
    public static void logout(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        SessionHelper.setAttribute(request, "sessionSearchKey", null);
        SessionHelper.setAttribute(request, "LOGIN_SECURITY_CONTEXT", null);
        Common.AuthenticationMode authenticationMode = UserPrincipalRetriever.getUserPrincipal() != null ? UserPrincipalRetriever.getUserPrincipal().getAuthenticationMode() : null;
        Map<String, String> authenticationProfileParameters = UserPrincipalRetriever.getUserPrincipal() != null ? UserPrincipalRetriever.getUserPrincipal().getAuthenticationParameters() : null;
        String curModule = null;
        String authModeName = null;
        if (session != null) {
            curModule = (String)session.getAttribute("curModule");
            authModeName = (String)request.getSession().getAttribute("authenticationModeName");
            SessionHelper.invalidateAllSessions(session);
        }
        SecurityContext context = SecurityContextHolder.getContext();
        context.setAuthentication(null);
        SecurityContextHolder.clearContext();
        if (authenticationMode != null) {
            request.getSession().setAttribute("authentication_mode", (Object)authenticationMode.name());
            request.getSession().setAttribute("authenticationParameters", authenticationProfileParameters);
        }
        if (curModule != null) {
            request.getSession().setAttribute("curModule", (Object)curModule);
        }
        if (authModeName != null) {
            request.getSession().setAttribute("authenticationModeName", (Object)authModeName);
        }
    }

    public void logout(HttpServletRequest request, HttpServletResponse response, Authentication authentication) {
        SecurityContextLogoutHandler.logout(request);
    }
}

