/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence;

import com.exlibris.core.infra.common.normalizers.NormalizerUtil;
import com.exlibris.core.infra.common.util.IndexXmlUtil;
import com.exlibris.core.infra.model.DividedDate;
import com.exlibris.core.infra.model.HOwneredEntity;
import com.exlibris.core.infra.model.annotation.Searchable;
import com.exlibris.digitool.repository.api.xmlbeans.XHeader;
import com.exlibris.digitool.repository.api.xmlbeans.XQueriesDocument;
import com.exlibris.digitool.repository.api.xmlbeans.XQuery;
import com.exlibris.repository.persistence.HDeSetMember;
import java.util.Calendar;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Lob;
import javax.persistence.OneToMany;
import javax.persistence.Temporal;
import javax.persistence.TemporalType;
import javax.persistence.Transient;
import org.apache.commons.lang.StringUtils;
import org.apache.xmlbeans.XmlException;
import org.dom4j.DocumentFactory;
import org.dom4j.Element;
import org.hibernate.annotations.Cascade;
import org.hibernate.annotations.CascadeType;

@Entity
@AttributeOverride(name="id", column=@Column(name="Set_ID_Number"))
public class HDeSet
extends HOwneredEntity {
    private static final long serialVersionUID = 1L;
    private String name;
    private String description;
    private Status status = Status.ACTIVE;
    private String scope;
    private String note;
    private Calendar statusDate;
    private DividedDate statusDateDummy;
    private SetType setType;
    private SetOrigin setOrigin;
    private PremisObjectType objectType;
    private String value;
    private boolean isPrivate;
    private String derivedFromId;
    private String derivationMethod;
    private String systemGenerated;
    private Calendar dateRangeFrom;
    private Calendar dateRangeTo;
    private List<HDeSetMember> setMemberList;
    private String indexXml;
    private int setCount;

    public HDeSet() {
        this.setStatusDate(Calendar.getInstance());
        this.setObjectType(PremisObjectType.INTELLECTUAL_ENTITY);
    }

    public HDeSet(PremisObjectType premisObjectType) {
        this.setStatusDate(Calendar.getInstance());
        this.setObjectType(premisObjectType);
    }

    @Column(length=255, name="Set_Name", nullable=false)
    @Searchable
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    @Column(length=255, name="Set_Description")
    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    @Column(name="Set_Status")
    @Searchable
    public Status getStatus() {
        return this.status;
    }

    public void setStatus(Status status) {
        this.status = status;
    }

    @Column(name="Status_Date")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getStatusDate() {
        if (this.statusDate.getTimeInMillis() == 0L) {
            return null;
        }
        return this.statusDate;
    }

    public void setStatusDate(Calendar statusDate) {
        this.statusDate = statusDate;
        this.statusDateDummy = new DividedDate(this.statusDate);
        this.statusDate = this.statusDateDummy.getCalendar();
    }

    @Transient
    public DividedDate getStatusDateDummy() {
        return this.statusDateDummy;
    }

    public void setStatusDateDummy(DividedDate statusDateDummy) {
        this.statusDateDummy = statusDateDummy;
    }

    @Column(name="Set_Type")
    @Searchable
    public SetType getSetType() {
        return this.setType;
    }

    public void setSetType(SetType setType) {
        this.setType = setType;
    }

    @Column(name="Set_Origin")
    @Searchable
    public SetOrigin getSetOrigin() {
        return this.setOrigin;
    }

    public void setSetOrigin(SetOrigin setOrigin) {
        this.setOrigin = setOrigin;
    }

    @Column(name="Object_Type")
    @Searchable
    public PremisObjectType getObjectType() {
        return this.objectType;
    }

    public void setObjectType(PremisObjectType objectType2) {
        this.objectType = objectType2;
    }

    @Column(name="Value")
    @Lob
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    @Column(name="Private")
    @Searchable
    public boolean getIsPrivate() {
        return this.isPrivate;
    }

    public void setIsPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    public void setPrivate(boolean isPrivate) {
        this.isPrivate = isPrivate;
    }

    @Transient
    public String getIsPrivateStr() {
        if (this.isPrivate) {
            return "Yes";
        }
        return "No";
    }

    public void setIsPrivateStr(String isPrivateStr) {
    }

    @Column(length=100, name="Derived_From_Id")
    public String getDerivedFromId() {
        return this.derivedFromId;
    }

    public void setDerivedFromId(String derivedFromId) {
        this.derivedFromId = derivedFromId;
    }

    @Column(length=100, name="Derived_Method")
    public String getDerivationMethod() {
        return this.derivationMethod;
    }

    public void setDerivationMethod(String derivationMethod) {
        this.derivationMethod = derivationMethod;
    }

    @Column(length=100, name="System_Generated")
    public String getSystemGenerated() {
        return this.systemGenerated;
    }

    public void setSystemGenerated(String systemGenerated) {
        this.systemGenerated = systemGenerated;
    }

    @Column(name="Date_Range_From")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getDateRangeFrom() {
        return this.dateRangeFrom;
    }

    public void setDateRangeFrom(Calendar dateRangeFrom) {
        this.dateRangeFrom = dateRangeFrom;
    }

    @Column(name="Date_Range_To")
    @Temporal(value=TemporalType.TIMESTAMP)
    public Calendar getDateRangeTo() {
        return this.dateRangeTo;
    }

    public void setDateRangeTo(Calendar dateRangeTo) {
        this.dateRangeTo = dateRangeTo;
    }

    @OneToMany(mappedBy="set", fetch=FetchType.LAZY)
    @Cascade(value={CascadeType.ALL, CascadeType.DELETE_ORPHAN})
    public List<HDeSetMember> getSetMemberList() {
        return this.setMemberList;
    }

    public void setSetMemberList(List<HDeSetMember> setMemberList) {
        this.setMemberList = setMemberList;
    }

    @Column(length=100, name="Scope")
    public String getScope() {
        return this.scope;
    }

    public void setScope(String scope) {
        this.scope = scope;
    }

    @Column(length=4000, name="Note")
    public String getNote() {
        return this.note;
    }

    public void setNote(String note) {
        this.note = note;
    }

    @Transient
    public String getStatusStr() {
        return this.status.toString();
    }

    public void setStatusStr(String statusStr) {
        this.status = Status.valueOf(statusStr);
    }

    @Transient
    public String getSetTypeStr() {
        return this.setType.toString();
    }

    public void setSetTypeStr(String setTypeStr) {
        this.setType = SetType.valueOf(setTypeStr);
    }

    @Transient
    public String getSetOriginStr() {
        if (this.setOrigin != null) {
            return this.setOrigin.toString();
        }
        return null;
    }

    public void setSetOriginStr(String setOriginStr) {
        this.setOrigin = SetOrigin.valueOf(setOriginStr);
    }

    @Transient
    public String getObjectTypeStr() {
        return this.objectType.toString();
    }

    public void setObjectTypeStr(String objectTypeStr) {
        this.objectType = PremisObjectType.valueOf(objectTypeStr);
    }

    @Transient
    public String getStatusDateStr() {
        return this.statusDate.getTime().toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.dateRangeFrom == null ? 0 : this.dateRangeFrom.hashCode());
        result = 31 * result + (this.dateRangeTo == null ? 0 : this.dateRangeTo.hashCode());
        result = 31 * result + (this.derivationMethod == null ? 0 : this.derivationMethod.hashCode());
        result = 31 * result + (this.derivedFromId == null ? 0 : this.derivedFromId.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.indexXml == null ? 0 : this.indexXml.hashCode());
        result = 31 * result + (this.isPrivate ? 1231 : 1237);
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.note == null ? 0 : this.note.hashCode());
        result = 31 * result + (this.objectType == null ? 0 : this.objectType.hashCode());
        result = 31 * result + (this.scope == null ? 0 : this.scope.hashCode());
        result = 31 * result + (this.setMemberList == null ? 0 : this.setMemberList.hashCode());
        result = 31 * result + (this.setType == null ? 0 : this.setType.hashCode());
        result = 31 * result + (this.status == null ? 0 : this.status.hashCode());
        result = 31 * result + (this.statusDate == null ? 0 : this.statusDate.hashCode());
        result = 31 * result + (this.systemGenerated == null ? 0 : this.systemGenerated.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDeSet other = (HDeSet)obj;
        if (this.dateRangeFrom == null ? other.dateRangeFrom != null : !this.dateRangeFrom.equals(other.dateRangeFrom)) {
            return false;
        }
        if (this.dateRangeTo == null ? other.dateRangeTo != null : !this.dateRangeTo.equals(other.dateRangeTo)) {
            return false;
        }
        if (this.derivationMethod == null ? other.derivationMethod != null : !this.derivationMethod.equals(other.derivationMethod)) {
            return false;
        }
        if (this.derivedFromId == null ? other.derivedFromId != null : !this.derivedFromId.equals(other.derivedFromId)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.indexXml == null ? other.indexXml != null : !this.indexXml.equals(other.indexXml)) {
            return false;
        }
        if (this.isPrivate != other.isPrivate) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.note == null ? other.note != null : !this.note.equals(other.note)) {
            return false;
        }
        if (this.objectType == null ? other.objectType != null : !this.objectType.equals((Object)other.objectType)) {
            return false;
        }
        if (this.scope == null ? other.scope != null : !this.scope.equals(other.scope)) {
            return false;
        }
        if (this.setMemberList == null ? other.setMemberList != null : !this.setMemberList.equals(other.setMemberList)) {
            return false;
        }
        if (this.setType == null ? other.setType != null : !this.setType.equals((Object)other.setType)) {
            return false;
        }
        if (this.status == null ? other.status != null : !this.status.equals((Object)other.status)) {
            return false;
        }
        if (this.statusDate == null ? other.statusDate != null : !this.statusDate.equals(other.statusDate)) {
            return false;
        }
        if (this.systemGenerated == null ? other.systemGenerated != null : !this.systemGenerated.equals(other.systemGenerated)) {
            return false;
        }
        return !(this.value == null ? other.value != null : !this.value.equals(other.value));
    }

    @Column(nullable=false, name="index_xml")
    @Lob
    public String getIndexXml() {
        return this.indexXml;
    }

    public void setIndexXml(String indexXml) {
        this.indexXml = indexXml;
    }

    public void rebuildIndexXml() {
        Element rootElement = IndexXmlUtil.generateIndexXmlForObject(this);
        switch (this.setOrigin) {
            case PRESERVATION: {
                try {
                    XQueriesDocument xqd = XQueriesDocument.Factory.parse(this.getValue());
                    XQuery xq = XQuery.Factory.parse(xqd.getXQueries().getXQueryArray(0).xmlText());
                    XHeader header = xq.getXHeader();
                    if (header == null) break;
                    String format = header.getFormat();
                    this.addElement(rootElement, "format", format);
                    String classification = header.getClassification();
                    this.addElement(rootElement, "classification", classification);
                    String riskCode = header.getRisk();
                    this.addElement(rootElement, "riskCode", riskCode);
                }
                catch (XmlException e) {
                    e.printStackTrace();
                }
                break;
            }
        }
        this.setIndexXml(rootElement.asXML());
    }

    private void addElement(Element rootElement, String name, String text) {
        if (StringUtils.isNotBlank((String)text)) {
            Element element = DocumentFactory.getInstance().createElement(name);
            element.setText(NormalizerUtil.normalizeWithProfileName("generic", text));
            rootElement.add(element);
        }
    }

    @Transient
    public int getSetCount() {
        return this.setCount;
    }

    public void setSetCount(int setCount) {
        this.setCount = setCount;
    }

    public static enum PremisObjectType {
        INTELLECTUAL_ENTITY,
        REPRESENTATION,
        FILE;

    }

    public static enum SetSource {
        RISK,
        USER;

    }

    public static enum SetType {
        QUERY,
        ITEMIZED;

    }

    public static enum SetOrigin {
        PA,
        BO,
        PRESERVATION,
        FORMAT_RESEARCH,
        PUBLISHING,
        savedQuery,
        EVENT_REPORT,
        BASIC_PRESERVATION;

    }

    public static enum Status {
        ACTIVE,
        INACTIVE,
        DELETED;

    }
}

