/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.matcher.bytes;

import java.io.IOException;
import net.byteseek.io.reader.WindowReader;
import net.byteseek.io.reader.windows.Window;
import net.byteseek.matcher.bytes.InvertibleMatcher;
import net.byteseek.utils.ByteUtils;

public final class AllBitmaskMatcher
extends InvertibleMatcher {
    final byte mBitMaskValue;

    public AllBitmaskMatcher(byte bitMaskValue) {
        super(false);
        this.mBitMaskValue = bitMaskValue;
    }

    public AllBitmaskMatcher(byte bitMaskValue, boolean inverted) {
        super(inverted);
        this.mBitMaskValue = bitMaskValue;
    }

    @Override
    public boolean matches(WindowReader reader, long matchPosition) throws IOException {
        byte localbitmask = this.mBitMaskValue;
        Window window = reader.getWindow(matchPosition);
        return window == null ? false : (window.getByte(reader.getWindowOffset(matchPosition)) & localbitmask) == localbitmask ^ this.inverted;
    }

    @Override
    public boolean matches(byte[] bytes, int matchPosition) {
        byte localbitmask = this.mBitMaskValue;
        return matchPosition >= 0 && matchPosition < bytes.length && (bytes[matchPosition] & localbitmask) == localbitmask ^ this.inverted;
    }

    @Override
    public boolean matches(byte theByte) {
        byte localbitmask = this.mBitMaskValue;
        return (theByte & localbitmask) == localbitmask ^ this.inverted;
    }

    @Override
    public String toRegularExpression(boolean prettyPrint) {
        String wrapper = this.inverted ? "^&%02x" : "&%02x";
        return String.format(wrapper, 0xFF & this.mBitMaskValue);
    }

    @Override
    public byte[] getMatchingBytes() {
        return this.inverted ? ByteUtils.getBytesNotMatchingAllBitMask(this.mBitMaskValue) : ByteUtils.getBytesMatchingAllBitMask(this.mBitMaskValue);
    }

    @Override
    public int getNumberOfMatchingBytes() {
        return this.inverted ? 256 - ByteUtils.countBytesMatchingAllBits(this.mBitMaskValue) : ByteUtils.countBytesMatchingAllBits(this.mBitMaskValue);
    }

    @Override
    public boolean matchesNoBoundsCheck(byte[] bytes, int matchPosition) {
        byte localbitmask = this.mBitMaskValue;
        return (bytes[matchPosition] & localbitmask) == localbitmask ^ this.inverted;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[bitmask:" + String.format("%02x", this.mBitMaskValue & 0xFF) + " inverted:" + this.inverted + ']';
    }
}

