/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rdf4j.sail.base;

import org.eclipse.rdf4j.model.ModelFactory;
import org.eclipse.rdf4j.model.ValueFactory;
import org.eclipse.rdf4j.query.algebra.evaluation.impl.EvaluationStatistics;
import org.eclipse.rdf4j.sail.SailException;
import org.eclipse.rdf4j.sail.base.SailSource;
import org.eclipse.rdf4j.sail.base.SailSourceBranch;
import org.eclipse.rdf4j.sail.base.SailStore;

public class SnapshotSailStore
implements SailStore {
    private final SailStore backingStore;
    private final SailSourceBranch explicitAutoFlush;
    private final SailSourceBranch inferredAutoFlush;

    public SnapshotSailStore(SailStore backingStore, ModelFactory modelFactory) {
        this.backingStore = backingStore;
        this.explicitAutoFlush = new SailSourceBranch(backingStore.getExplicitSailSource(), modelFactory, true);
        this.inferredAutoFlush = new SailSourceBranch(backingStore.getInferredSailSource(), modelFactory, true);
    }

    @Override
    public void close() throws SailException {
        try {
            try {
                this.explicitAutoFlush.flush();
                this.inferredAutoFlush.flush();
            }
            finally {
                this.explicitAutoFlush.close();
                this.inferredAutoFlush.close();
            }
        }
        finally {
            this.backingStore.close();
        }
    }

    @Override
    public ValueFactory getValueFactory() {
        return this.backingStore.getValueFactory();
    }

    @Override
    public EvaluationStatistics getEvaluationStatistics() {
        return this.backingStore.getEvaluationStatistics();
    }

    @Override
    public SailSource getExplicitSailSource() {
        return this.explicitAutoFlush;
    }

    @Override
    public SailSource getInferredSailSource() {
        return this.inferredAutoFlush;
    }
}

