/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.event;

import java.util.HashSet;
import java.util.function.Supplier;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceBindingSet;
import net.sf.saxon.om.NoNamespaceName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.pattern.CombinedNodeTest;
import net.sf.saxon.pattern.ContentTypeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public class TypeCheckingFilter
extends ProxyReceiver {
    private ItemType itemType;
    private int cardinality;
    private RoleDiagnostic role;
    private Location locator;
    private int count = 0;
    private int level = 0;
    private HashSet<Long> checkedElements = new HashSet(10);

    public TypeCheckingFilter(Receiver next) {
        super(next);
    }

    public void setRequiredType(ItemType type, int cardinality, RoleDiagnostic role, Location locator) {
        this.itemType = type;
        this.cardinality = cardinality;
        this.role = role;
        this.locator = locator;
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            CombinedNodeTest type = new CombinedNodeTest(new NameTest(2, nameCode, this.getNamePool()), 23, new ContentTypeTest(2, typeCode, this.getConfiguration(), false));
            this.checkItemType(type, this.nodeSupplier((short)2, nameCode, value), locationId);
        }
        this.nextReceiver.attribute(nameCode, typeCode, value, locationId, properties);
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            this.checkItemType(NodeKindTest.TEXT, this.nodeSupplier((short)3, null, chars), locationId);
        }
        this.nextReceiver.characters(chars, locationId, properties);
    }

    @Override
    public void comment(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            this.checkItemType(NodeKindTest.COMMENT, this.nodeSupplier((short)8, null, chars), locationId);
        }
        this.nextReceiver.comment(chars, locationId, properties);
    }

    @Override
    public void namespace(NamespaceBindingSet namespaceBindings, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(ExplicitLocation.UNKNOWN_LOCATION);
            }
            this.checkItemType(NodeKindTest.NAMESPACE, null, ExplicitLocation.UNKNOWN_LOCATION);
        }
        this.nextReceiver.namespace(namespaceBindings, properties);
    }

    @Override
    public void processingInstruction(String target, CharSequence data, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            this.checkItemType(NodeKindTest.PROCESSING_INSTRUCTION, this.nodeSupplier((short)7, new NoNamespaceName(target), data), locationId);
        }
        this.nextReceiver.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(ExplicitLocation.UNKNOWN_LOCATION);
            }
            this.checkItemType(NodeKindTest.DOCUMENT, this.nodeSupplier((short)9, null, ""), ExplicitLocation.UNKNOWN_LOCATION);
        }
        ++this.level;
        this.nextReceiver.startDocument(properties);
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 1) {
                CombinedNodeTest type = new CombinedNodeTest(new NameTest(1, nodeName, this.getNamePool()), 23, new ContentTypeTest(1, typeCode, this.getConfiguration(), false));
                this.checkItemType(type, this.nodeSupplier((short)1, nodeName, ""), location);
            } else {
                long key;
                if (this.count == 2) {
                    this.checkAllowsMany(location);
                }
                if (!this.checkedElements.contains(key = (long)nodeName.obtainFingerprint(this.getNamePool()) << 32 | (long)typeCode.getFingerprint())) {
                    CombinedNodeTest type = new CombinedNodeTest(new NameTest(1, nodeName, this.getNamePool()), 23, new ContentTypeTest(1, typeCode, this.getConfiguration(), false));
                    this.checkItemType(type, this.nodeSupplier((short)1, nodeName, ""), location);
                    this.checkedElements.add(key);
                }
            }
        }
        ++this.level;
        this.nextReceiver.startElement(nodeName, typeCode, location, properties);
    }

    @Override
    public void endDocument() throws XPathException {
        --this.level;
        this.nextReceiver.endDocument();
    }

    @Override
    public void endElement() throws XPathException {
        --this.level;
        this.nextReceiver.endElement();
    }

    @Override
    public void close() throws XPathException {
        if (this.count == 0 && !Cardinality.allowsZero(this.cardinality)) {
            XPathException err = new XPathException("An empty sequence is not allowed as the " + this.role.getMessage());
            String errorCode = this.role.getErrorCode();
            err.setErrorCode(errorCode);
            if (!"XPDY0050".equals(errorCode)) {
                err.setIsTypeError(true);
            }
            throw err;
        }
    }

    private Supplier<NodeInfo> nodeSupplier(short nodeKind, NodeName name, CharSequence value) {
        return () -> {
            Orphan o = new Orphan(this.getConfiguration());
            o.setNodeKind(nodeKind);
            if (name != null) {
                o.setNodeName(name);
            }
            o.setStringValue(value);
            return o;
        };
    }

    @Override
    public void append(Item item, Location locationId, int copyNamespaces) throws XPathException {
        if (this.level == 0) {
            if (++this.count == 2) {
                this.checkAllowsMany(locationId);
            }
            this.checkItem(item, locationId);
        }
        if (this.nextReceiver instanceof SequenceReceiver) {
            this.nextReceiver.append(item, locationId, copyNamespaces);
        } else {
            super.append(item, locationId, copyNamespaces);
        }
    }

    @Override
    public boolean usesTypeAnnotations() {
        return true;
    }

    private void checkItemType(ItemType type, Supplier<? extends Item<?>> itemSupplier, Location locationId) throws XPathException {
        if (!this.getConfiguration().getTypeHierarchy().isSubType(type, this.itemType)) {
            this.throwTypeError(type, itemSupplier == null ? null : itemSupplier.get(), locationId);
        }
    }

    private void checkItem(Item item, Location locationId) throws XPathException {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        if (!this.itemType.matches(item, th)) {
            this.throwTypeError(null, item, locationId);
        }
    }

    private void throwTypeError(ItemType suppliedType, Item item, Location locationId) throws XPathException {
        TypeHierarchy th = this.getConfiguration().getTypeHierarchy();
        String message = item == null ? this.role.composeErrorMessage(this.itemType, suppliedType) : this.role.composeErrorMessage(this.itemType, item, th);
        String errorCode = this.role.getErrorCode();
        XPathException err = new XPathException(message);
        err.setErrorCode(errorCode);
        if (!"XPDY0050".equals(errorCode)) {
            err.setIsTypeError(true);
        }
        if (locationId == null) {
            err.setLocation(this.locator);
        } else {
            err.setLocation(locationId.saveLocation());
        }
        throw err;
    }

    private void checkAllowsMany(Location locationId) throws XPathException {
        if (!Cardinality.allowsMany(this.cardinality)) {
            XPathException err = new XPathException("A sequence of more than one item is not allowed as the " + this.role.getMessage());
            String errorCode = this.role.getErrorCode();
            err.setErrorCode(errorCode);
            if (!"XPDY0050".equals(errorCode)) {
                err.setIsTypeError(true);
            }
            if (locationId == null || locationId == ExplicitLocation.UNKNOWN_LOCATION) {
                err.setLocator(this.locator);
            } else {
                err.setLocator(locationId);
            }
            throw err;
        }
    }
}

