/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.darc.mdconfig;

import ch.docuteam.darc.exceptions.MetadataElementValidatorException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.MetadataElementValidator;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.tools.string.StringUtil;
import ch.docuteam.tools.translations.I18N;

public class MetadataElementValidatorShort
implements MetadataElementValidator {
    @Override
    public void check(String value, NodeAbstract context, MetadataElement metadataElement) throws MetadataElementValidatorException {
        if (!StringUtil.isNumeric((String)value)) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorShortNotNumeric", (Object[])new Object[]{value}));
        }
        if (value.length() > 5) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorShortMax5Digits", (Object[])new Object[]{value}));
        }
        try {
            int number = new Integer(value);
            if (number > Short.MAX_VALUE) {
                throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorShortMaxValue", (Object[])new Object[]{(short)Short.MAX_VALUE, value}));
            }
        }
        catch (NumberFormatException ex) {
            throw new MetadataElementValidatorException(I18N.translate_NoCheck((String)"MessageValidatorShortCantConvert", (Object[])new Object[]{value}));
        }
    }
}

