/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.common.dao.ejb3;

import com.exlibris.core.infra.common.dao.GenericDao;
import com.exlibris.core.infra.common.dao.ejb3.BoundedVariable;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.normalizers.NormalizerUtil;
import com.exlibris.core.infra.common.util.IndexXmlUtil;
import com.exlibris.core.infra.model.annotation.JoinedOrderBy;
import com.exlibris.core.infra.model.codetables.HCodeTables;
import com.exlibris.core.infra.model.codetables.HMappingTables;
import com.exlibris.core.infra.model.customfields.CustomFieldConfiguration;
import com.exlibris.core.infra.svc.api.CodeTablesManager;
import com.exlibris.core.infra.svc.api.config.GlobalProperties;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.digitool.repository.sets.xmlbeans.Field;
import com.exlibris.digitool.repository.sets.xmlbeans.FieldSet;
import com.exlibris.digitool.repository.sets.xmlbeans.LogicalOpType;
import com.exlibris.digitool.repository.sets.xmlbeans.OpType;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import javax.persistence.AttributeOverride;
import javax.persistence.Column;
import javax.persistence.EntityManager;
import javax.persistence.FlushModeType;
import javax.persistence.LockModeType;
import javax.persistence.Query;
import javax.persistence.TemporalType;
import org.apache.commons.lang.StringEscapeUtils;
import org.apache.commons.lang.StringUtils;
import org.hibernate.annotations.Table;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;

public abstract class GenericEjb3Dao<T, ID extends Serializable>
implements GenericDao<T, ID> {
    public static final long INVALID_APPLICATION_ID = -9999L;
    public static final long START_WITH = 1000L;
    private static final ExLogger log = ExLogger.getExLogger(GenericEjb3Dao.class);
    public static final String CODE_TABLE_DELIMITER = "\\.";
    public static final String CODE_TABLE_DELIMITER_STRING = ".";
    public static final String ORDER_BY_DELIMITER = ",";
    public static final String CODE_TABLE_PREFIX = "CodeTable";
    private Class<T> entityBeanType = (Class)((ParameterizedType)this.getClass().getGenericSuperclass()).getActualTypeArguments()[0];
    public EntityManager em;

    public void setEntityManager(EntityManager em) {
        this.em = em;
    }

    protected EntityManager getEntityManager() {
        if (this.em == null) {
            throw new IllegalStateException("EntityManager has not been set on DAO before usage");
        }
        return this.em;
    }

    public Class<T> getEntityBeanType() {
        return this.entityBeanType;
    }

    @Override
    public void saveOneFlush(List<T> entityList) {
        this.getEntityManager().setFlushMode(FlushModeType.COMMIT);
        for (T entity : entityList) {
            this.save(entity);
        }
        this.getEntityManager().setFlushMode(FlushModeType.AUTO);
    }

    @Override
    public void save(List<T> entityList) {
        for (T entity : entityList) {
            this.save(entity);
        }
    }

    @Override
    public T save(T entity) {
        this.rebuildIndexXml(entity);
        entity = this.getEntityManager().merge(entity);
        return entity;
    }

    @Override
    public void remove(T entity) {
        this.getEntityManager().remove(entity);
    }

    @Override
    public void flush() {
        this.getEntityManager().flush();
    }

    public void clear() {
        this.getEntityManager().clear();
    }

    @Override
    public long generateNextAppId() {
        return ((BigDecimal)this.getEntityManager().createNativeQuery("SELECT " + this.getEntityBeanType().getSimpleName() + "_SEQ.nextval FROM dual").getResultList().get(0)).longValue();
    }

    public int getSeqIncBy() {
        return ((BigDecimal)this.getEntityManager().createNativeQuery("SELECT increment_by from user_sequences where sequence_name ='" + this.getEntityBeanType().getSimpleName().toUpperCase() + "_SEQ'").getResultList().get(0)).intValue();
    }

    @Override
    public long getInvalidAppId() {
        return -9999L;
    }

    protected void rebuildIndexXml(T entity) {
        try {
            Method rebuildIndexXml = entity.getClass().getMethod("rebuildIndexXml", new Class[0]);
            rebuildIndexXml.invoke(entity, new Object[0]);
            return;
        }
        catch (Exception exception) {
            Method setIndexXml;
            try {
                setIndexXml = entity.getClass().getMethod("setIndexXml", String.class);
            }
            catch (Exception e) {
                return;
            }
            String indexXml = IndexXmlUtil.generateIndexXml(entity);
            try {
                setIndexXml.invoke(entity, indexXml);
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return;
        }
    }

    @Override
    public T findById(ID id) {
        return this.findById(id, false);
    }

    @Override
    public T findById(ID id, boolean forUpdate) {
        Object entity = this.getEntityManager().find(this.getEntityBeanType(), id);
        if (forUpdate) {
            try {
                this.getEntityManager().lock(entity, LockModeType.WRITE);
            }
            catch (Exception e) {
                return null;
            }
        }
        return (T)entity;
    }

    @Override
    public List<T> findAll() {
        return this.getEntityManager().createQuery("from " + this.getEntityBeanType().getName()).getResultList();
    }

    @Override
    public List findAllByClass(Class wantedType) {
        return this.getEntityManager().createQuery("from " + wantedType.getName()).getResultList();
    }

    @Override
    public void deleteAllByClass(Class wantedType) {
        this.getEntityManager().createQuery("delete from " + wantedType.getName()).executeUpdate();
    }

    @Override
    public void deleteAllByTableName(String tableName) {
        this.getEntityManager().createNativeQuery("delete from " + tableName).executeUpdate();
    }

    @Override
    public int getCountNativeSearchResult(String countField, List<String> tables, FieldSet indexXmlFS, String whereStr) {
        return this.getRecordsCountResult(countField, tables, indexXmlFS, whereStr, true);
    }

    @Override
    public List<T> getAllNativeSearchResult(String resultClass, List<String> tables, FieldSet indexXmlFS, String whereStr, String orderBy, String direction) {
        return this.getNativeSearchResult(resultClass, tables, indexXmlFS, whereStr, 0, -1, orderBy, direction);
    }

    @Override
    public List<T> getNativeSearchResult(Class<?> resultClass, List<String> tables, FieldSet indexXmlFS, String whereStr, int firstResult, int maxResult, String orderBy, String direction) {
        return this.getNativeSearchResult(resultClass.getName(), tables, indexXmlFS, whereStr, firstResult, maxResult, orderBy, direction);
    }

    @Override
    @Deprecated
    public List<T> getNativeSearchResult(String resultClass, List<String> tables, FieldSet indexXmlFS, String whereStr, int firstResult, int maxResult, String orderBy, String direction) {
        return this.getSearchResult(resultClass, tables, indexXmlFS, whereStr, firstResult, maxResult, orderBy, direction, true);
    }

    @Override
    public int getCountHqlSearchResult(String mainTable, FieldSet indexXmlFS) {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(mainTable);
        return this.getRecordsCountResult(mainTable, tables, indexXmlFS, null, false);
    }

    @Override
    public List<T> getAllHqlSearchResult(String mainTable, FieldSet indexXmlFS, String orderBy, String direction) {
        return this.getHqlSearchResult(mainTable, indexXmlFS, 0, -1, orderBy, direction);
    }

    @Override
    public List<T> getHqlSearchResult(String mainTable, FieldSet indexXmlFS, int firstResult, int maxResult, String orderBy, String direction) {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(mainTable);
        return this.getSearchResult(mainTable, tables, indexXmlFS, null, firstResult, maxResult, orderBy, direction, false);
    }

    @Override
    public int getCountHqlSearchResult(String mainTable, FieldSet indexXmlFS, String whereStr) {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(mainTable);
        return this.getRecordsCountResult(mainTable, tables, indexXmlFS, whereStr, false);
    }

    @Override
    public List<T> getAllHqlSearchResult(String mainTable, FieldSet indexXmlFS, String whereStr, String orderBy, String direction) {
        return this.getHqlSearchResult(mainTable, indexXmlFS, whereStr, 0, -1, orderBy, direction);
    }

    @Override
    public List<T> getHqlSearchResult(Class<?> resultClass, FieldSet indexXmlFS, String whereStr, int firstResult, int maxResult, String orderBy, String direction) {
        return this.getHqlSearchResult(resultClass.getName(), indexXmlFS, whereStr, firstResult, maxResult, orderBy, direction);
    }

    @Override
    @Deprecated
    public List<T> getHqlSearchResult(String mainTable, FieldSet indexXmlFS, String whereStr, int firstResult, int maxResult, String orderBy, String direction) {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(mainTable);
        return this.getSearchResult(mainTable, tables, indexXmlFS, whereStr, firstResult, maxResult, orderBy, direction, false);
    }

    @Override
    public int getCountHqlSearchResult(String mainTable, List<String> tables, FieldSet indexXmlFS, String whereStr) {
        return this.getRecordsCountResult(mainTable, tables, indexXmlFS, whereStr, false);
    }

    @Override
    public List<T> getAllHqlSearchResult(String mainTable, List<String> tables, FieldSet indexXmlFS, String whereStr, String orderBy, String direction) {
        return this.getHqlSearchResult(mainTable, tables, indexXmlFS, whereStr, 0, -1, orderBy, direction);
    }

    @Override
    public List<T> getHqlSearchResult(String mainTable, List<String> tables, FieldSet indexXmlFS, String whereStr, int firstResult, int maxResult, String orderBy, String direction) {
        return this.getSearchResult(mainTable, tables, indexXmlFS, whereStr, firstResult, maxResult, orderBy, direction, false);
    }

    protected void includeCustomFields(FieldSet containsFieldSet, String searchText, Map<String, CustomFieldConfiguration> customFieldsConfiguration) {
        if (null == customFieldsConfiguration || customFieldsConfiguration.isEmpty()) {
            return;
        }
        FieldSet logicalOp = containsFieldSet.addNewLogicalOperator();
        logicalOp.setLogicalOp(LogicalOpType.OR);
        for (String fieldName : customFieldsConfiguration.keySet()) {
            CustomFieldConfiguration fieldConfig = customFieldsConfiguration.get(fieldName);
            if (!fieldConfig.isEnabled()) continue;
            Field searchField = logicalOp.addNewField();
            searchField.setKey(fieldConfig.getColumnName());
            searchField.setOp(OpType.WITHIN);
            searchField.setStringValue(searchText);
        }
    }

    protected StringBuffer getSearchQuery(String resultClass, List<String> tables, FieldSet indexXmlFS, String whereStr, String orderBy, String direction, boolean isNativeQuery) {
        String[] codeTableattributes = this.getCodeTableAttributes(orderBy);
        StringBuffer query = new StringBuffer();
        String mainTable = tables.get(0);
        String classSimpleName = mainTable.substring(mainTable.lastIndexOf(CODE_TABLE_DELIMITER_STRING) + 1);
        query.append("select " + this.getAliasName(mainTable));
        if (isNativeQuery) {
            query.append(".*");
        }
        boolean ignoreOracleText = this.ignoreOracleText(classSimpleName);
        StringBuffer whereStatement = null;
        StringBuffer fromStatement = this.getFromStatement(tables);
        whereStatement = ignoreOracleText ? this.getWhereStatementNoOT(mainTable, indexXmlFS, whereStr, isNativeQuery) : this.getWhereStatement(mainTable, indexXmlFS, whereStr, isNativeQuery);
        orderBy = this.handleJoinedOrderBy(resultClass, mainTable, orderBy, fromStatement, whereStatement, isNativeQuery);
        StringBuffer orderByStatment = this.getOrderByStatment(resultClass, mainTable, orderBy, codeTableattributes, direction);
        if (codeTableattributes != null) {
            this.addCodeTableFromStatement(fromStatement, isNativeQuery);
            this.addCodeTableWhereStatement(mainTable, codeTableattributes, whereStatement, isNativeQuery);
        }
        query.append(fromStatement);
        query.append(whereStatement);
        query.append(orderByStatment);
        log.info("query = " + query);
        return query;
    }

    private FieldSet fieldSet2QueryNoOT(FieldSet fieldSet) {
        FieldSet fieldSetTmp = FieldSet.Factory.newInstance();
        if (fieldSet == null) {
            return fieldSetTmp;
        }
        Field[] fields = fieldSet.getFieldArray();
        if (fields != null) {
            for (Field field : fields) {
                String key = field.getKey();
                String value = field.getStringValue();
                if (key == null || value == null || key.length() == 0 || value.length() == 0) continue;
                Field pair1 = fieldSetTmp.addNewField();
                pair1.setStringValue(StringEscapeUtils.escapeSql((String)value));
                pair1.setOp(field.getOp());
                pair1.setKey(StringEscapeUtils.escapeSql((String)key));
                pair1.setTable(field.getTable());
            }
        }
        return fieldSetTmp;
    }

    protected StringBuffer getWhereStatementNoOT(String tableName, FieldSet indexXmlFS, String whereStr, boolean isNativeQuery) {
        StringBuffer whereStatement = new StringBuffer();
        if ((indexXmlFS = this.fieldSet2QueryNoOT(indexXmlFS)).sizeOfFieldArray() > 0) {
            Field[] fields = indexXmlFS.getFieldArray();
            String table = this.getAliasName(tableName);
            whereStatement.append(" where ");
            for (Field field : fields) {
                if (!this.isValidField(field)) continue;
                String searchText = this.normalizeToOracle(field.getStringValue());
                whereStatement.append("(upper(" + (field.getTable() != null ? field.getTable() : table) + CODE_TABLE_DELIMITER_STRING + field.getKey() + "))");
                if (((Object)((Object)field.getOp())).equals((Object)OpType.EXACT)) {
                    whereStatement.append("=upper('" + searchText + "')");
                } else {
                    whereStatement.append(" like upper('%");
                    whereStatement.append(searchText.trim());
                    whereStatement.append("%')");
                }
                whereStatement.append(" and ");
            }
        }
        whereStatement = GenericEjb3Dao.removeLastAnd(whereStatement.toString());
        if (!StringUtils.isEmpty((String)whereStr)) {
            if (whereStatement.toString().toLowerCase().contains("where")) {
                whereStatement.append(" and ");
            } else {
                whereStr = GenericEjb3Dao.removeFirstAnd(whereStr);
                whereStatement.append(" where ");
            }
            whereStatement.append(whereStr);
        }
        return whereStatement;
    }

    private boolean isValidField(Field field) {
        return field.getKey() != null && field.getStringValue() != null && field.getKey().length() != 0 && field.getStringValue().length() != 0;
    }

    private static String removeFirstAnd(String whereStr) {
        if (whereStr.toLowerCase().trim().startsWith("and ")) {
            return whereStr.replaceFirst("\\s*and\\s*", "");
        }
        return whereStr;
    }

    private static StringBuffer removeLastAnd(String str) {
        if (str.toLowerCase().trim().endsWith(" and")) {
            str = str.substring(0, str.lastIndexOf(" and")) + "";
        }
        return new StringBuffer(str);
    }

    private String normalizeToOracle(String txt) {
        if (txt == null) {
            return "";
        }
        txt = txt.replaceAll("\\*", "%");
        txt = txt.replaceAll("'", "''");
        return txt;
    }

    private String handleJoinedOrderBy(String resultClassName, String mainTable, String orderBy, StringBuffer fromStatement, StringBuffer whereStatement, boolean isNativeQuery) {
        if (!StringUtils.isBlank((String)orderBy) && isNativeQuery) {
            boolean isJoinedOrderBy = false;
            JoinedOrderBy joinedOrderByAnn = null;
            try {
                Class<?> tableClass;
                PropertyDescriptor pDesc;
                String orderByField = orderBy;
                if (orderBy.contains(CODE_TABLE_DELIMITER_STRING)) {
                    orderByField = orderBy.split(CODE_TABLE_DELIMITER)[1];
                }
                if ((joinedOrderByAnn = (pDesc = new PropertyDescriptor(orderByField, tableClass = Class.forName(resultClassName))).getReadMethod().getAnnotation(JoinedOrderBy.class)) != null) {
                    isJoinedOrderBy = true;
                }
            }
            catch (ClassNotFoundException orderByField) {
            }
            catch (IntrospectionException orderByField) {
            }
            catch (NullPointerException orderByField) {
                // empty catch block
            }
            if (isJoinedOrderBy) {
                String nativeOrderBy = joinedOrderByAnn.nativeOrderBy();
                if (!StringUtils.isBlank((String)nativeOrderBy) && isNativeQuery) {
                    orderBy = "(" + nativeOrderBy + ")";
                } else {
                    String targetTable = joinedOrderByAnn.targetTable();
                    String targetTableAl = this.getAliasName(targetTable);
                    String fullField = targetTableAl + CODE_TABLE_DELIMITER_STRING + joinedOrderByAnn.targetOrderedField();
                    fromStatement.append(" , ").append(targetTable).append(" ").append(targetTableAl);
                    if (!StringUtils.isBlank((String)whereStatement.toString()) && whereStatement.toString().toLowerCase().contains("where")) {
                        whereStatement.append(" and ");
                    } else {
                        whereStatement.append(" where ");
                    }
                    whereStatement.append(this.getAliasName(mainTable)).append(CODE_TABLE_DELIMITER_STRING).append(joinedOrderByAnn.sourceJoinField()).append(" = ").append(targetTableAl).append(CODE_TABLE_DELIMITER_STRING).append(joinedOrderByAnn.targetJoinField()).append("(+)");
                    orderBy = fullField;
                }
            }
        }
        return orderBy;
    }

    public StringBuffer getCountQuery(String countField, List<String> tables, FieldSet indexXmlFS, String whereStr, boolean isNativeQuery) {
        StringBuffer query = new StringBuffer();
        String mainTable = tables.get(0);
        String classSimpleName = mainTable.substring(mainTable.lastIndexOf(CODE_TABLE_DELIMITER_STRING) + 1);
        query.append("select count(");
        if (isNativeQuery) {
            query.append("distinct(" + this.getAliasName(mainTable) + CODE_TABLE_DELIMITER_STRING + countField + ")");
        } else {
            query.append(this.getAliasName(mainTable));
        }
        query.append(")");
        StringBuffer fromStatement = this.getFromStatement(tables);
        boolean ignoreOracleText = this.ignoreOracleText(classSimpleName);
        StringBuffer whereStatement = null;
        whereStatement = ignoreOracleText ? this.getWhereStatementNoOT(mainTable, indexXmlFS, whereStr, isNativeQuery) : this.getWhereStatement(mainTable, indexXmlFS, whereStr, isNativeQuery);
        query.append(fromStatement);
        query.append(whereStatement);
        return query;
    }

    private String getAliasName(String tableName) {
        String[] splitFromTable = tableName.split(CODE_TABLE_DELIMITER);
        return splitFromTable[splitFromTable.length - 1];
    }

    private List<T> getSearchResult(String resultClass, List<String> tables, FieldSet indexXmlFS, String whereStr, int firstResult, int maxResult, String orderBy, String direction, boolean isNativeQuery) {
        if (StringUtils.isEmpty((String)resultClass)) {
            resultClass = this.getEntityBeanType().getName();
            String classSimpleName = this.getEntityBeanType().getSimpleName();
        } else {
            String classSimpleName = this.getAliasName(resultClass);
        }
        StringBuffer sb = this.getSearchQuery(resultClass, tables, indexXmlFS, whereStr, orderBy, direction, isNativeQuery);
        Query query = null;
        if (isNativeQuery) {
            try {
                query = this.getEntityManager().createNativeQuery(sb.toString(), Class.forName(resultClass));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        } else {
            query = this.getEntityManager().createQuery(sb.toString());
        }
        if (firstResult < 0) {
            return null;
        }
        query.setFirstResult(firstResult);
        if (maxResult > 0) {
            query.setMaxResults(maxResult);
        }
        return query.getResultList();
    }

    private StringBuffer getFromStatement(List<String> tables) {
        StringBuffer fromStatement = new StringBuffer();
        boolean firstTable = true;
        for (String table : tables) {
            if (firstTable) {
                fromStatement.append(" from " + table + " " + this.getAliasName(table));
                firstTable = false;
                continue;
            }
            fromStatement.append(" , " + table + " " + this.getAliasName(table));
        }
        return fromStatement;
    }

    private StringBuffer getWhereStatement(String tableName, FieldSet indexXmlFS, String whereStr, boolean isNativeQuery) {
        StringBuffer whereStatement = new StringBuffer();
        String q = null;
        q = GenericEjb3Dao.fieldSet2Query(indexXmlFS);
        if (q.length() != 0) {
            String indexXml = this.getAliasName(tableName) + (isNativeQuery ? ".index_xml" : ".indexXml");
            whereStatement.append(" where contains (" + indexXml + " ,' ");
            whereStatement.append(q);
            whereStatement.append("' )>0");
        }
        if (!StringUtils.isBlank((String)whereStr)) {
            if (whereStatement.toString().toLowerCase().contains("where")) {
                whereStatement.append(" and ");
            } else {
                whereStatement.append(" where ");
            }
            whereStatement.append(whereStr);
        }
        return whereStatement;
    }

    private boolean ignoreOracleText(String classSimpleName) {
        CodeTablesManager ctm = (CodeTablesManager)ServiceLocator.getInstance().lookUp(CodeTablesManager.class);
        List<HMappingTables> list = ctm.findMappingTableByName("otUsePolicy");
        for (HMappingTables hMappingTables : list) {
            if (!hMappingTables.getTargetCode().equalsIgnoreCase(classSimpleName) || !hMappingTables.getSourceCode1().equals("true")) continue;
            return true;
        }
        return false;
    }

    private StringBuffer getOrderByStatment(String resultClass, String tableName, String orderBy, String[] codeTableattributes, String direction) {
        StringBuffer orderByStatment = new StringBuffer();
        if (!StringUtils.isEmpty((String)orderBy)) {
            if (orderBy.startsWith("(") && orderBy.endsWith(")")) {
                orderByStatment.append(" order by ");
                orderByStatment.append(orderBy).append(" ").append(direction);
            } else {
                String tableNameAlias = this.getAliasName(tableName);
                Class<?> tableClass = null;
                try {
                    tableClass = Class.forName(resultClass);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    // empty catch block
                }
                String[] splitedOrderBy = orderBy.split(ORDER_BY_DELIMITER);
                for (int i = 0; i < splitedOrderBy.length; ++i) {
                    String curOrderBy = splitedOrderBy[i].trim();
                    if (codeTableattributes != null) {
                        curOrderBy = "ct.description";
                    } else if (!curOrderBy.contains(CODE_TABLE_DELIMITER_STRING)) {
                        curOrderBy = tableNameAlias + CODE_TABLE_DELIMITER_STRING + curOrderBy;
                    }
                    StringBuffer orderByField = this.getOrderByFieldByFieldType(tableClass, curOrderBy, direction);
                    if (orderByField.length() <= 0) continue;
                    if (i == 0) {
                        orderByStatment.append(" order by ");
                    } else {
                        orderByStatment.append(ORDER_BY_DELIMITER);
                    }
                    orderByStatment.append(orderByField);
                }
            }
        }
        return orderByStatment;
    }

    private String[] getCodeTableAttributes(String orderBy) {
        if (StringUtils.isEmpty((String)orderBy)) {
            return null;
        }
        String[] orderByArray = orderBy.split(ORDER_BY_DELIMITER);
        if (orderByArray != null) {
            int orderByArraySize = orderByArray.length;
            for (int i = 0; i < orderByArraySize; ++i) {
                String[] orderByOodeTable = orderByArray[i].split(CODE_TABLE_DELIMITER);
                if (StringUtils.isEmpty((String)orderByOodeTable[0]) || !orderByOodeTable[0].equals(CODE_TABLE_PREFIX)) continue;
                return new String[]{orderByOodeTable[1], orderByOodeTable[2]};
            }
        }
        return null;
    }

    private void addCodeTableFromStatement(StringBuffer fromStatement, boolean isNativeQuery) {
        if (!StringUtils.isEmpty((String)fromStatement.toString())) {
            fromStatement.append(ORDER_BY_DELIMITER);
        }
        String ctTableNameAndAlias = this.getCodeTableFromStatement(isNativeQuery);
        fromStatement.append(ctTableNameAndAlias);
    }

    private String getCodeTableFromStatement(boolean isNativeQuery) {
        if (isNativeQuery) {
            String shrSchema = this.getSchema("dbconnection.shr.username");
            return shrSchema + CODE_TABLE_DELIMITER_STRING + HCodeTables.class.getAnnotation(Table.class).appliesTo() + " ct";
        }
        return HCodeTables.class.getName() + " ct";
    }

    private void addCodeTableWhereStatement(String tableName, String[] codeTableAttributes, StringBuffer whereStatement, boolean isNativeQuery) {
        if (codeTableAttributes == null) {
            return;
        }
        tableName = this.getAliasName(tableName);
        if (!StringUtils.isEmpty((String)whereStatement.toString())) {
            whereStatement.append(" and ");
        }
        String codeTableName = isNativeQuery ? "ct.code_table_name" : "ct.codeTableName";
        whereStatement.append(codeTableName + "(+) = '").append(codeTableAttributes[0]).append(CODE_TABLE_DELIMITER_STRING).append(codeTableAttributes[1]).append("' and ct.code(+) = " + tableName + CODE_TABLE_DELIMITER_STRING).append(codeTableAttributes[1]);
    }

    @Override
    @Deprecated
    public int getNumberOfRecordsWithWhere(String tableName, String whereStr) {
        String tName = tableName.substring(tableName.lastIndexOf(CODE_TABLE_DELIMITER_STRING) + 1);
        Query query1 = this.em.createNativeQuery("select count(*) from " + tName + " " + (whereStr != null ? whereStr : ""));
        BigDecimal result = new BigDecimal(0);
        try {
            result = (BigDecimal)query1.getSingleResult();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return result.intValue();
    }

    private int getRecordsCountResult(String countField, List<String> tables, FieldSet indexXmlFS, String whereStr, boolean isNativeQuery) {
        StringBuffer sb = this.getCountQuery(countField, tables, indexXmlFS, whereStr, isNativeQuery);
        Query query = null;
        query = isNativeQuery ? this.getEntityManager().createNativeQuery(sb.toString()) : this.getEntityManager().createQuery(sb.toString());
        try {
            return Integer.parseInt(query.getSingleResult().toString());
        }
        catch (Exception e) {
            log.error("get count query: " + query, e, new String[0]);
            return 0;
        }
    }

    public int getNumberOfRecords(FieldSet containsFiledSet, String tableName) {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(tableName);
        StringBuffer sb = this.getCountQuery(tableName, tables, containsFiledSet, null, false);
        Query query1 = this.getEntityManager().createQuery(sb.toString());
        return Integer.parseInt(query1.getSingleResult().toString());
    }

    @Override
    @Deprecated
    public int getNumberOfRecordsWithWhere(FieldSet containsFiledSet, String tableName, String whereStr) {
        return this.getCountHqlSearchResult(tableName, containsFiledSet, whereStr);
    }

    @Override
    @Deprecated
    public List<T> search(String qlString, int firstResult, int maxResult, boolean nativeQuery, String tableName, List<BoundedVariable> boundedVariables) throws SQLException, ClassNotFoundException {
        Query query = null;
        if (nativeQuery) {
            String[] split = qlString.split("from");
            String selectPart = split[0];
            selectPart = selectPart.trim() + ".* ";
            qlString = selectPart + "from " + split[1];
            try {
                query = this.em.createNativeQuery(qlString.toString(), Class.forName(tableName));
            }
            catch (ClassNotFoundException e) {
                log.error("Cannot instanciate " + tableName + " class", new String[0]);
                throw e;
            }
        } else {
            query = this.em.createQuery(qlString.toString());
        }
        query.setFirstResult(firstResult);
        query.setMaxResults(maxResult);
        this.setQueryParameters(boundedVariables, query);
        List resultList = query.getResultList();
        return resultList;
    }

    @Override
    public int countEntities() {
        String GETALL = "from ";
        String hqlQuery = GETALL + this.entityBeanType.getName();
        return this.countEntitiesInQuery(hqlQuery, null, null, false);
    }

    @Override
    public int countEntitiesInQuery(String hqlQuery, List<BoundedVariable> boundedVariables, String tableName, boolean nativeQuery) {
        String[] split = hqlQuery.split("from");
        hqlQuery = tableName == null ? "select count(distinct id)" : "select count(distinct " + tableName + ".id)";
        for (int j = 1; j < split.length; ++j) {
            hqlQuery = hqlQuery + " from " + split[j];
        }
        split = hqlQuery.split("order by");
        hqlQuery = split[0];
        Query query = nativeQuery ? this.em.createNativeQuery(hqlQuery) : this.em.createQuery(hqlQuery);
        this.setQueryParameters(boundedVariables, query);
        int counter = Integer.parseInt(query.getSingleResult().toString());
        return counter;
    }

    protected void setQueryParameters(List<BoundedVariable> boundedVariables, Query query) {
        int i = 1;
        if (boundedVariables != null) {
            for (BoundedVariable boundedVariable : boundedVariables) {
                if (boundedVariable.getVariableClass().equals(Date.class)) {
                    query.setParameter(i++, (Date)boundedVariable.getVariableValue(), TemporalType.DATE);
                    continue;
                }
                if (boundedVariable.getVariableClass().equals(Calendar.class)) {
                    query.setParameter(i++, (Calendar)boundedVariable.getVariableValue(), TemporalType.DATE);
                    continue;
                }
                query.setParameter(i++, boundedVariable.getVariableValue());
            }
        }
    }

    protected void setQueryParameters(Map<String, Object> prametersMap, Query query) {
        for (Map.Entry<String, Object> parameter : prametersMap.entrySet()) {
            query.setParameter(parameter.getKey(), parameter.getValue());
        }
    }

    public void whereFieldSet2Query(StringBuffer query, FieldSet fieldSet) {
        if (fieldSet == null) {
            return;
        }
        Field[] fields = fieldSet.getFieldArray();
        if (fields.length == 0) {
            return;
        }
        for (int i = 0; fields != null && i < fields.length; ++i) {
            this.addWhereToQuery(query, fields[i]);
        }
    }

    public void addWhereToQuery(StringBuffer query, Field field) {
        int whereIndx = query.indexOf("where");
        int containsIndx = query.indexOf("contains");
        if (whereIndx == -1) {
            query.append(" where ");
        }
        if (whereIndx != -1 || containsIndx != -1) {
            query.append(" and ");
        }
        String value = field.getStringValue();
        switch (field.getOp().intValue()) {
            case 4: {
                query.append(field.getKey() + " like '%" + value + "%' ");
                break;
            }
            case 2: {
                query.append(field.getKey() + "=" + value);
            }
        }
    }

    public static String field2Query(Field field) {
        StringBuffer sb = new StringBuffer();
        String key = field.getKey();
        String value = field.getStringValue();
        OpType.Enum op = field.getOp();
        if (key == null || key.length() == 0) {
            key = "index";
        }
        if (value == null || value.length() == 0) {
            value = "%";
        }
        if (op == null) {
            op = OpType.EXACT;
        }
        value = NormalizerUtil.normalizeWithProfileName("search", value);
        if (((Object)((Object)op)).equals((Object)OpType.WITHIN)) {
            sb.append(value).append("% within ").append(key);
            return sb.toString();
        }
        sb.append(value).append(" within ").append(key);
        return sb.toString();
    }

    public abstract String[] getIndexArr();

    @Override
    public List<String> optimizeIndexes(String persistenceUnit) throws Exception {
        List indexNames = null;
        try {
            String schema = this.getSchema("dbconnection." + persistenceUnit + ".username");
            String sql = "select IDX_NAME from ctxsys.CTX_INDEXES where IDX_TABLE_OWNER = '" + StringEscapeUtils.escapeSql((String)schema.toUpperCase()) + "'";
            Query query = this.em.createNativeQuery(sql);
            indexNames = query.getResultList();
        }
        catch (Exception e1) {
            log.error("Failed getting index names", e1, new String[0]);
        }
        if (indexNames == null || indexNames.size() == 0) {
            indexNames = Arrays.asList(this.getIndexArr());
        }
        return indexNames;
    }

    @Override
    @Transactional(propagation=Propagation.REQUIRES_NEW)
    public void optimizeIndex(String indexName, String persistenceUnit) {
        try {
            String schemaPrefix = this.getSchemaPrefix(persistenceUnit);
            String call = "CALL " + schemaPrefix + ".OPT_INDEX(:indexname)";
            BoundedVariable boundedVariable = new BoundedVariable(indexName, String.class);
            Query query1 = this.em.createNativeQuery(call);
            query1.setParameter("indexname", boundedVariable.getVariableValue());
            log.info("Executing: " + call + " on index: " + indexName);
            query1.executeUpdate();
        }
        catch (Exception e) {
            log.error("Problems with optimizing index " + indexName + ".\nMessage was:" + e.getMessage(), e, new String[0]);
        }
    }

    @Override
    public String getSchemaPrefix(String persistenceUnit) {
        return this.getSchema("dbconnection." + persistenceUnit + ".username");
    }

    public static String fieldSet2Query(FieldSet fieldSet) {
        FieldSet[] fs;
        StringBuffer query = new StringBuffer();
        if (fieldSet == null) {
            return query.toString();
        }
        if (fieldSet.getLogicalOp() == null) {
            fieldSet.setLogicalOp(LogicalOpType.AND);
        }
        String op = fieldSet.getLogicalOp().toString();
        Field[] fields = fieldSet.getFieldArray();
        if (fields != null) {
            for (Field field : fields) {
                String fieldQuery = GenericEjb3Dao.field2Query(field);
                if (fieldQuery.length() == 0) continue;
                if (query.length() == 0) {
                    query.append("(").append(fieldQuery).append(")");
                    continue;
                }
                query.append(" ").append(op).append(" ").append("(").append(fieldQuery).append(")");
            }
        }
        if ((fs = fieldSet.getLogicalOperatorArray()) != null) {
            for (FieldSet fieldSet2 : fs) {
                String fieldSetQuery = GenericEjb3Dao.fieldSet2Query(fieldSet2);
                if (fieldSetQuery.length() == 0) continue;
                if (query.length() == 0) {
                    query.append("(").append(fieldSetQuery).append(")");
                    continue;
                }
                query.append(" ").append(op).append(" (").append(fieldSetQuery).append(")");
            }
        }
        return query.toString();
    }

    @Deprecated
    public List<T> search(FieldSet indexXmlFS, String orderBy, int firstResult, int maxResult, String tableName, String direction) {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(tableName);
        Query query1 = this.getEntityManager().createQuery(this.getSearchQuery(tableName, tables, indexXmlFS, null, orderBy, direction, false).toString());
        if (firstResult != 0) {
            query1.setFirstResult(firstResult);
        }
        if (maxResult != -1) {
            query1.setMaxResults(maxResult);
        }
        return query1.getResultList();
    }

    @Override
    @Deprecated
    public List<T> searchWithWhere(String tableName, String whereStr) {
        if (whereStr != null) {
            whereStr = whereStr.replaceAll("where", " ");
        }
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(tableName);
        Query query1 = this.getEntityManager().createQuery(this.getSearchQuery(tableName, tables, null, whereStr, null, null, false).toString());
        return query1.getResultList();
    }

    @Deprecated
    public List<T> searchWithWhereOriginal(FieldSet indexXmlFS, String orderBy, int firstResult, int maxResult, String tableName, String whereStr, String direction) {
        if (orderBy.equals("sortBy")) {
            orderBy = "";
            direction = "";
        }
        if (whereStr != null) {
            whereStr = whereStr.replaceAll("where", " ");
        }
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(tableName);
        StringBuffer q = this.getSearchQuery(tableName, tables, indexXmlFS, whereStr, orderBy, direction, false);
        log.info(q);
        Query query1 = this.getEntityManager().createQuery(q.toString());
        query1.setFirstResult(firstResult);
        query1.setMaxResults(maxResult);
        return query1.getResultList();
    }

    @Override
    @Deprecated
    public List<T> searchWithWhere(FieldSet indexXmlFS, String orderBy, int firstResult, int maxResult, String tableName, String whereStr, String direction) {
        String[] splitedOrderBy;
        if (whereStr != null) {
            whereStr = whereStr.replaceAll("where", " ");
        }
        if (orderBy == null || orderBy.startsWith("sortBy")) {
            orderBy = "";
            direction = "";
        }
        if (direction == null) {
            splitedOrderBy = orderBy.split(" ");
            orderBy = splitedOrderBy[0];
            if (splitedOrderBy.length > 1) {
                direction = splitedOrderBy[1];
            }
        }
        if (orderBy != null && orderBy.startsWith(CODE_TABLE_PREFIX)) {
            splitedOrderBy = orderBy.split(CODE_TABLE_DELIMITER);
            ArrayList<String> tables = new ArrayList<String>();
            tables.add(splitedOrderBy[1]);
            return this.getNativeSearchResult(tableName, tables, indexXmlFS, whereStr, firstResult, maxResult, orderBy, direction);
        }
        return this.getHqlSearchResult(tableName, indexXmlFS, whereStr, firstResult, maxResult, orderBy, direction);
    }

    private String getSchema(String schema) {
        return GlobalProperties.getInstance().getProperty(schema);
    }

    protected StringBuffer getOrderByFieldByFieldType(Class tableClass, String orderBy, String direction) {
        Class<Object> curOrderByClass;
        String nextToken;
        StringTokenizer stringTokenizer;
        StringBuffer orderByStatment;
        block16: {
            orderByStatment = new StringBuffer();
            stringTokenizer = new StringTokenizer(orderBy);
            nextToken = stringTokenizer.nextToken();
            curOrderByClass = null;
            if (tableClass != null) {
                try {
                    orderBy = nextToken.split(CODE_TABLE_DELIMITER)[1];
                    PropertyDescriptor pDesc = new PropertyDescriptor(orderBy, tableClass);
                    curOrderByClass = pDesc.getPropertyType();
                }
                catch (IntrospectionException e) {
                    Column c;
                    for (Method method : tableClass.getDeclaredMethods()) {
                        for (Annotation a : method.getAnnotations()) {
                            if (!(a instanceof Column) || !orderBy.equalsIgnoreCase((c = (Column)a).name())) continue;
                            curOrderByClass = method.getReturnType();
                            break;
                        }
                        if (curOrderByClass != null) break;
                    }
                    if (curOrderByClass == null) {
                        for (java.lang.reflect.Field field : tableClass.getDeclaredFields()) {
                            for (Annotation a : field.getAnnotations()) {
                                if (!(a instanceof Column) || !orderBy.equalsIgnoreCase((c = (Column)a).name())) continue;
                                curOrderByClass = field.getType();
                                break;
                            }
                            if (curOrderByClass != null) break;
                        }
                    }
                    if (curOrderByClass == null) {
                        for (Annotation annotation : tableClass.getAnnotations()) {
                            Column c2;
                            if (annotation instanceof AttributeOverride && orderBy.equalsIgnoreCase((c2 = ((AttributeOverride)annotation).column()).name())) {
                                curOrderByClass = annotation.annotationType();
                                break;
                            }
                            if (curOrderByClass != null) break;
                        }
                    }
                    if (curOrderByClass != null) break block16;
                    log.error("Failed to order by " + nextToken, new String[0]);
                    return orderByStatment;
                }
            }
        }
        if (stringTokenizer.hasMoreTokens()) {
            direction = stringTokenizer.nextToken();
        } else if (StringUtils.isEmpty((String)direction)) {
            direction = " ";
        }
        if (curOrderByClass == null || curOrderByClass.getName().contains("String")) {
            orderByStatment.append(" replace(translate(upper(trim(").append(nextToken).append(")), '0123456789', ' '), ' ')");
            orderByStatment.append(" ").append(direction).append(" , ");
            orderByStatment.append(" to_number(replace(translate(upper(trim(").append(nextToken).append(")), translate(upper(trim(").append(nextToken).append(")), '0123456789', ' ') || ' ', ' '), ' '))");
        } else {
            orderByStatment.append(nextToken);
        }
        orderByStatment.append(" " + direction);
        return orderByStatment;
    }

    @Override
    public String getTableName(Class<?> entityClass, boolean isNative) {
        String tableName = null;
        if (isNative) {
            try {
                tableName = entityClass.getAnnotation(Table.class).appliesTo();
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
            if (tableName == null) {
                try {
                    tableName = entityClass.getAnnotation(javax.persistence.Table.class).name();
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (tableName == null) {
                tableName = entityClass.getSimpleName();
            }
        } else {
            tableName = entityClass.getName();
        }
        return tableName;
    }

    protected String addBoundariesToNativeQuery(String sql, List<BoundedVariable> boundedVariables, int firstResult, int maxResults) {
        if (firstResult >= 0 && maxResults > 0) {
            int lastResult = firstResult + maxResults - 1;
            sql = "SELECT * FROM   (SELECT q.*, rownum-1 rn FROM (" + sql + ") q ) " + "WHERE  rn BETWEEN ? AND ? " + "ORDER  BY rn";
            boundedVariables.add(new BoundedVariable(firstResult, Integer.class));
            boundedVariables.add(new BoundedVariable(lastResult, Integer.class));
        }
        return sql;
    }

    protected String addBoundariesToHqlQuery(String sql, Map<String, Object> parametersMap, int firstResult, int maxResults) {
        if (firstResult >= 0 && maxResults > 0) {
            int lastResult = firstResult + maxResults;
            sql = "SELECT q2 FROM   (SELECT q, rownum rn FROM (" + sql + ") q ) q2 " + "WHERE  rn BETWEEN :firstResult AND :lastResult " + "ORDER  BY rn";
            parametersMap.put("firstResult", firstResult);
            parametersMap.put("lastResult", lastResult);
        }
        return sql;
    }

    protected void checkBatch(String tableName, int[] expected, int[] counts) {
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] == expected[i] || counts[i] == -2) continue;
            System.out.println("ERROR in insert to " + tableName + " table");
        }
    }

    protected void checkBatch(String tableName, int expected, int[] counts) {
        for (int i = 0; i < counts.length; ++i) {
            if (counts[i] == expected || counts[i] == -2) continue;
            System.out.println("ERROR in insert to " + tableName + " table, returned :" + counts[i]);
        }
    }

    protected void checkBatch(String tableName, int[] counts) {
        this.checkBatch(tableName, 1, counts);
    }

    @Override
    public Long getLastSequence(Class clazz) {
        Query query = this.getEntityManager().createQuery("select max(id) from " + clazz.getSimpleName());
        try {
            return (Long)query.getSingleResult();
        }
        catch (Exception e) {
            return -1L;
        }
    }

    @Override
    public void setFlushMode(FlushModeType flushMode) {
        this.getEntityManager().setFlushMode(flushMode);
    }
}

