/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.queue;

import com.exlibris.core.infra.svc.api.GeneralParameterManager;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;

public class QueueConstants {
    public static final String ID = "ID";
    public static final String SIP_ID = "sipID";
    public static final String BULK_ID = "BULK_ID";
    public static final String IE_ID = "IE_ID";
    public static final String FILE_PID = "filePID";
    public static final String PROC_ID = "PROC_ID";
    public static final String SIP_LOADING_WORK_QUEUE = "SIP_LOADING_WORK_QUEUE";
    public static final String SIP_PROCESSING_WORK_QUEUE = "SIP_PROCESSING_QUEUE";
    public static final String FILE_PROCESSING_QUEUE = "FILE_PROCESSING_QUEUE";
    public static final String DEPOSIT_WORK_QUEUE = "DEPOSIT_WORK_QUEUE";
    public static final String DEPOSIT_MESSAGES_QUEUE = "DEPOSIT_MESSAGES_QUEUE";
    public static final String PERMANENT_WORK_QUEUE = "PERMANENT_WORK_QUEUE";
    public static final String PERMANENT_QUEUE = "PERMANENT_QUEUE";
    public static final String GENERIC_REP_Q = "GENERIC_REP_Q";
    public static final String INDEX_QUEUE = "INDEX_QUEUE";
    public static final String SIP_INDEX_QUEUE = "SIP_INDEX_QUEUE";
    public static final String EVENTS_QUEUE = "EVENTS_QUEUE";
    public static final String CMS_ALERT_QUEUE = "CMS_ALERT_QUEUE";
    public static final String SHRD_MD_UPD_Q = "SHRD_MD_UPD_Q";
    public static final String SHARED_CACHE_TOPIC = "SHARED_CACHE_TOPIC";
    public static final String SENDER = "sender";
    public static final String SPECIFIC_OPERATION = "SPECIFIC_OPERATION";
    public static final String UNIQUE_ID = "uniqueId";
    public static final String NODE_NAME = "nodeName";
    public static final String PROCESS_ID = "processId";
    public static final String EXECUTION_ID = "execId";
    public static final String TRANSITION_NAME = "transitionName";
    public static final String TASK_CHAIN_ID = "taskChainId";
    public static final String CREATOR = "creator";
    public static final String OWNER = "owner";
    public static final String MONITOR_FILE_BULKS = "monitor_file_bulks";
    public static final String IS_TEST = "isTest";
    public static final String GENERIC_PRSRV_Q = "GENERIC_PRSRV_Q";
    public static final String IS_REPOSITORY = "IS_REPOSITORY";
    public static final String USE_DNX = "USE_DNX";
    public static final String MANUALLY_ASSIGNED = "MANUALLY_ASSIGNED";
    public static final String PATHS_KEYS = "PATHS_KEYS";
    public static final String PATH = "PATH";
    public static final String PATHS_KEYS_SEPERATOR = ";";
    public static final String LOW = "LOW";
    public static final String NORMAL = "NORMAL";
    public static final String HIGH = "HIGH";
    public static final String RUN_BY = "RUN_BY";

    public static int getPriorityLevel(String priorityLevel) {
        try {
            long unixTime = System.currentTimeMillis() / 60000L;
            GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            int priority_time_stamp = Integer.valueOf(gpm.getParameter("general", "priority_time_stamp_min"));
            int priority = NORMAL.equals(priorityLevel) ? (int)(unixTime + (long)priority_time_stamp) : (LOW.equals(priorityLevel) ? (int)(unixTime + (long)(priority_time_stamp * 6)) : 5);
            return priority;
        }
        catch (Exception e) {
            return 5;
        }
    }

    public static int getFileBulkPriorityLevel(int bulkNumber, String priorityLevel) {
        try {
            long unixTime = System.currentTimeMillis() / 60000L;
            int priority = (int)unixTime;
            GeneralParameterManager gpm = (GeneralParameterManager)ServiceLocator.getInstance().lookUp(GeneralParameterManager.class);
            int priority_time_stamp = Integer.valueOf(gpm.getParameter("general", "priority_time_stamp_min"));
            switch (priorityLevel) {
                case "LOW": {
                    priority = (int)(unixTime + (long)(priority_time_stamp * 6 + bulkNumber * 10));
                    break;
                }
                case "NORMAL": {
                    priority = (int)(unixTime + (long)(priority_time_stamp + bulkNumber * 10));
                    break;
                }
                case "HIGH": {
                    priority = 5;
                }
            }
            return priority;
        }
        catch (Exception e) {
            return (int)(System.currentTimeMillis() / 60000L);
        }
    }

    public static enum MessagePriority {
        REAL_TIME(0, 0, 0),
        HIGH(1, 2, 3),
        NORMAL(4, 5, 6),
        LOW(7, 8, 9);

        private final int topRange;
        private final int defaultValue;
        private final int lowerRange;

        private MessagePriority(int topRange, int defaultValue, int lowerRange) {
            this.topRange = topRange;
            this.defaultValue = defaultValue;
            this.lowerRange = lowerRange;
        }

        public int getTopRange() {
            return this.topRange;
        }

        public int getDefaultValue() {
            return this.defaultValue;
        }

        public int getLowerRange() {
            return this.lowerRange;
        }
    }

    public static enum GenericPreservationOperations {
        PROCESS_PLAN,
        START_PLAN;

    }

    public static enum GenericRepositoryOperations {
        UPDATE_IE_AFTER_PROC_EXEC,
        MONITOR_PROCESS,
        PROCESS_BULK,
        PROCESS_RIP,
        START_RIP_PROCESSING,
        EXECUTE_TASKCHAIN,
        DELETE_FILE,
        GENERATE_REPORT_ITEMS,
        PURGE_IE;

    }

    public static enum operationIndex {
        INSERT,
        UPDATE,
        DELETE;

    }

    public static enum messageType {
        QUEUE,
        TOPIC;

    }
}

