/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.core.document;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.jodconverter.core.document.DocumentFamily;
import org.jodconverter.core.document.DocumentFormat;
import org.jodconverter.core.document.DocumentFormatRegistry;
import org.jodconverter.core.util.AssertUtils;

public class SimpleDocumentFormatRegistry
implements DocumentFormatRegistry {
    private final Map<String, DocumentFormat> fmtsByExtension = new HashMap<String, DocumentFormat>();
    private final Map<String, DocumentFormat> fmtsByMediaType = new HashMap<String, DocumentFormat>();

    public void addFormat(@NonNull DocumentFormat documentFormat) {
        documentFormat.getExtensions().stream().map(s -> s.toLowerCase(Locale.ROOT)).forEach(ext -> this.fmtsByExtension.put((String)ext, documentFormat));
        this.fmtsByMediaType.put(documentFormat.getMediaType().toLowerCase(Locale.ROOT), documentFormat);
    }

    @Override
    public @Nullable DocumentFormat getFormatByExtension(@NonNull String extension) {
        AssertUtils.notNull(extension, "extension must not be null");
        return this.fmtsByExtension.get(extension.toLowerCase(Locale.ROOT));
    }

    @Override
    public @Nullable DocumentFormat getFormatByMediaType(@NonNull String mediaType) {
        AssertUtils.notNull(mediaType, "mediaType must not be null");
        return this.fmtsByMediaType.get(mediaType.toLowerCase(Locale.ROOT));
    }

    @Override
    public @NonNull Set<@NonNull DocumentFormat> getOutputFormats(@NonNull DocumentFamily documentFamily) {
        AssertUtils.notNull((Object)documentFamily, "documentFamily must not be null");
        return this.fmtsByMediaType.values().stream().filter(format -> format.getStoreProperties(documentFamily) != null).collect(Collectors.toSet());
    }
}

