/*
 * Decompiled with CFR 0.152.
 */
package org.jodconverter.local.filter.text;

import com.sun.star.beans.XPropertySet;
import com.sun.star.drawing.XShape;
import com.sun.star.lang.XComponent;
import com.sun.star.text.XText;
import com.sun.star.text.XTextContent;
import com.sun.star.text.XTextCursor;
import com.sun.star.text.XTextDocument;
import com.sun.star.text.XTextFrame;
import com.sun.star.text.XTextRange;
import java.awt.Dimension;
import java.util.Map;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.jodconverter.core.office.OfficeContext;
import org.jodconverter.core.util.AssertUtils;
import org.jodconverter.local.filter.FilterChain;
import org.jodconverter.local.filter.text.AbstractTextContentInserterFilter;
import org.jodconverter.local.office.utils.Lo;
import org.jodconverter.local.office.utils.Write;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TextInserterFilter
extends AbstractTextContentInserterFilter {
    private static final Logger LOGGER = LoggerFactory.getLogger(TextInserterFilter.class);
    private final String insertedText;

    public TextInserterFilter(@NonNull String text, int width, int height, int horizontalPosition, int verticalPosition) {
        super(new Dimension(width, height), horizontalPosition, verticalPosition);
        AssertUtils.notBlank((String)text, (String)"text must not be null nor blank");
        this.insertedText = text;
    }

    public TextInserterFilter(@NonNull String text, int width, int height, @NonNull Map<@NonNull String, @NonNull Object> shapeProperties) {
        super(new Dimension(width, height), shapeProperties);
        AssertUtils.notBlank((String)text, (String)"text must not be null nor blank");
        this.insertedText = text;
    }

    @Override
    public void doFilter(@NonNull OfficeContext context, @NonNull XComponent document, @NonNull FilterChain chain) throws Exception {
        if (Write.isText(document)) {
            LOGGER.debug("Applying the TextInserterFilter");
            this.insertText(document);
        }
        chain.doFilter(context, document);
    }

    private void insertText(XComponent document) throws Exception {
        XTextFrame textFrame = Lo.createInstanceMSF(document, XTextFrame.class, "com.sun.star.text.TextFrame");
        XShape shape = Lo.qi(XShape.class, textFrame);
        shape.setSize(TextInserterFilter.toOfficeSize(this.getRectSize()));
        XPropertySet propSet = Lo.qi(XPropertySet.class, textFrame);
        for (Map.Entry<String, Object> entry : this.getShapeProperties().entrySet()) {
            propSet.setPropertyValue(entry.getKey(), entry.getValue());
        }
        XTextDocument docText = Lo.qi(XTextDocument.class, document);
        XText text = docText.getText();
        XTextCursor textCursor = text.createTextCursor();
        this.applyAnchorPageNoFix(docText, textCursor);
        LOGGER.debug("Inserting frame into the document");
        text.insertTextContent((XTextRange)textCursor, (XTextContent)textFrame, false);
        text = textFrame.getText();
        textCursor = text.createTextCursor();
        LOGGER.debug("Writing text to the inserted frame");
        text.insertString((XTextRange)textCursor, this.insertedText, false);
    }
}

