/*
 * Decompiled with CFR 0.152.
 */
package uk.gov.nationalarchives.droid.core.signature;

import uk.gov.nationalarchives.droid.core.signature.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.xml.SimpleElement;

public class FileFormatHit
extends SimpleElement {
    public static final int HIT_TYPE_POSITIVE_SPECIFIC = 10;
    public static final int HIT_TYPE_POSITIVE_GENERIC = 11;
    public static final int HIT_TYPE_TENTATIVE = 12;
    public static final int HIT_TYPE_POSITIVE_GENERIC_OR_SPECIFIC = 15;
    public static final String HIT_TYPE_POSITIVE_SPECIFIC_TEXT = "Positive (Specific Format)";
    public static final String HIT_TYPE_POSITIVE_GENERIC_TEXT = "Positive (Generic Format)";
    public static final String HIT_TYPE_TENTATIVE_TEXT = "Tentative";
    public static final String HIT_TYPE_POSITIVE_GENERIC_OR_SPECIFIC_TEXT = "Positive";
    public static final String FILEEXTENSIONWARNING = "Possible file extension mismatch";
    public static final String POSITIVEIDENTIFICATIONSTATUS = "Positively identified";
    public static final String TENTATIVEIDENTIFICATIONSTATUS = "Tentatively identified";
    public static final String UNIDENTIFIEDSTATUS = "Unable to identify";
    private String myHitWarning = "";
    private int myHitType;
    private FileFormat myHitFileFormat;

    public FileFormatHit(FileFormat theFileFormat, int theType, boolean theSpecificity, String theWarning) {
        this.myHitFileFormat = theFileFormat;
        this.myHitType = theType == 15 ? (theSpecificity ? 10 : 11) : theType;
        this.setIdentificationWarning(theWarning);
    }

    public FileFormatHit() {
    }

    public void setIdentificationWarning(String theWarning) {
        this.myHitWarning = theWarning;
    }

    public FileFormat getFileFormat() {
        return this.myHitFileFormat;
    }

    public String getFileFormatName() {
        return this.myHitFileFormat.getName();
    }

    public String getFileFormatVersion() {
        return this.myHitFileFormat.getVersion();
    }

    public String getMimeType() {
        return this.myHitFileFormat.getMimeType();
    }

    public String getFileFormatPUID() {
        return this.myHitFileFormat.getPUID();
    }

    public int getHitType() {
        return this.myHitType;
    }

    public String getHitTypeVerbose() {
        String theHitType = "";
        if (this.myHitType == 11) {
            theHitType = HIT_TYPE_POSITIVE_GENERIC_TEXT;
        } else if (this.myHitType == 10) {
            theHitType = HIT_TYPE_POSITIVE_SPECIFIC_TEXT;
        } else if (this.myHitType == 12) {
            theHitType = HIT_TYPE_TENTATIVE_TEXT;
        } else if (this.myHitType == 15) {
            theHitType = HIT_TYPE_POSITIVE_GENERIC_OR_SPECIFIC_TEXT;
        }
        return theHitType;
    }

    public String getHitWarning() {
        return this.myHitWarning;
    }

    public boolean isSpecific() {
        return this.myHitType == 10;
    }

    @Override
    public void setAttributeValue(String theName, String theValue) {
        if ("HitStatus".equals(theName)) {
            this.setStatus(theValue);
        } else if ("FormatName".equals(theName)) {
            this.setName(theValue);
        } else if ("FormatVersion".equals(theName)) {
            this.setVersion(theValue);
        } else if ("FormatPUID".equals(theName)) {
            this.setPUID(theValue);
        } else if ("HitWarning".equals(theName)) {
            this.setIdentificationWarning(theValue);
        } else {
            this.unknownAttributeWarning(theName, this.getElementName());
        }
    }

    public void setStatus(String value) {
        if (value.equals(HIT_TYPE_POSITIVE_GENERIC_TEXT)) {
            this.myHitType = 11;
        } else if (value.equals(HIT_TYPE_POSITIVE_SPECIFIC_TEXT)) {
            this.myHitType = 10;
        } else if (value.equals(HIT_TYPE_TENTATIVE_TEXT)) {
            this.myHitType = 12;
        } else if (value.equals(HIT_TYPE_POSITIVE_GENERIC_OR_SPECIFIC_TEXT)) {
            this.myHitType = 15;
        } else {
            this.generalWarning("Unknown hit status listed: " + value);
        }
    }

    public void setName(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("Name", value);
    }

    public void setVersion(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("Version", value);
    }

    public void setPUID(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("PUID", value);
    }

    public void setMimeType(String value) {
        if (this.myHitFileFormat == null) {
            this.myHitFileFormat = new FileFormat();
        }
        this.myHitFileFormat.setAttributeValue("MIMEType", value);
    }
}

