/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.console;

import com.exlibris.core.infra.base.security.ContextConnection;
import com.exlibris.core.infra.base.security.CustomerInstitutionRetriever;
import com.exlibris.core.infra.console.ConsolePage;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;

public class JStack
extends ConsolePage {
    private ThreadGroup rootThreadGroup = null;
    private Thread[] threads = null;
    private static final String DEBUG_STR = "STR_";

    private ThreadGroup getRootThreadGroup() {
        ThreadGroup ptg;
        if (this.rootThreadGroup != null) {
            return this.rootThreadGroup;
        }
        ThreadGroup tg = Thread.currentThread().getThreadGroup();
        while ((ptg = tg.getParent()) != null) {
            tg = ptg;
        }
        return tg;
    }

    private Thread[] getAllThreads() {
        Thread[] threads;
        if (this.threads != null) {
            return this.threads;
        }
        ThreadGroup root = this.getRootThreadGroup();
        ThreadMXBean thbean = ManagementFactory.getThreadMXBean();
        int nAlloc = thbean.getThreadCount();
        int n = 0;
        while ((n = root.enumerate(threads = new Thread[nAlloc *= 2], true)) == nAlloc) {
        }
        return Arrays.copyOf(threads, n);
    }

    private Thread getThread(long id) {
        Thread[] threads;
        for (Thread thread : threads = this.getAllThreads()) {
            if (thread.getId() != id) continue;
            return thread;
        }
        return null;
    }

    public String getJStack(String filter, String sid) {
        ThreadMXBean mxBean = ManagementFactory.getThreadMXBean();
        ThreadInfo[] threadInfos = mxBean.dumpAllThreads(true, true);
        StringBuilder sb = new StringBuilder();
        this.addHeader(sb);
        sb.append("<p><b>Total Number of Started Threads:</b> ").append(mxBean.getTotalStartedThreadCount()).append("<br>\n");
        sb.append("<b>Total Threads:</b> ").append(mxBean.getThreadCount()).append("<br><br>\n");
        Arrays.sort(threadInfos, new Comparator<ThreadInfo>(){

            @Override
            public int compare(ThreadInfo o1, ThreadInfo o2) {
                return o1.getThreadName().compareTo(o2.getThreadName());
            }
        });
        for (ThreadInfo threadInfo : threadInfos) {
            StackTraceElement[] stackTraceElements;
            long threadId = threadInfo.getThreadId();
            Thread thread = this.getThread(threadId);
            Map<String, Object> debugObjects = CustomerInstitutionRetriever.getDebugInfo(threadId);
            if (thread == null || filter != null && !threadInfo.getThreadName().contains(filter)) continue;
            String cSid = ContextConnection.getSid(thread);
            if (sid != null && (cSid == null || !cSid.contains(sid)) && (!"*".equals(sid) || cSid == null)) continue;
            sb.append("<div style=\"height: 2em; float: left; margin-right: 1em \">");
            sb.append("<b>Thread: ").append(threadInfo.getThreadName()).append("</b>:");
            sb.append("</div>");
            sb.append("<div style=\"width: 90%\">");
            sb.append("  priority: ").append(thread.getPriority()).append(",  cputime: ").append((double)mxBean.getThreadCpuTime(thread.getId()) / 1.0E9).append("s,  usertime: ").append((double)mxBean.getThreadUserTime(thread.getId()) / 1.0E9).append("s, daemon: ").append(thread.isDaemon()).append(", threadId: ").append(threadInfo.getThreadId()).append(", threadState: ").append((Object)threadInfo.getThreadState()).append(", lockName: ").append(threadInfo.getLockName());
            if (debugObjects != null) {
                for (String objName : debugObjects.keySet()) {
                    if (!objName.startsWith(DEBUG_STR)) continue;
                    sb.append(", ").append(objName.substring(DEBUG_STR.length())).append(": ").append(debugObjects.get(objName));
                }
                Long startTime = (Long)debugObjects.get("DBG_START_PROCESSING_TIME");
                if (startTime != null) {
                    sb.append(", ");
                    long procTime = System.currentTimeMillis() - startTime;
                    String procTimeDisplay = procTime < 1000L ? String.valueOf(procTime) + " milliseconds" : String.valueOf(procTime / 1000L) + "s";
                    sb.append(JStack.highlight("PROCESSING TIME: " + procTimeDisplay, procTime > 1000L));
                }
            }
            sb.append(", ORACLE SID: ").append(cSid);
            sb.append("</div><br>\n<blockquote style=\"clear: both\">");
            for (StackTraceElement stackTraceElement : stackTraceElements = threadInfo.getStackTrace()) {
                boolean exlibrisCode = stackTraceElement.getClassName().contains("exlibris");
                if (exlibrisCode) {
                    sb.append("<b>");
                }
                sb.append(stackTraceElement.getClassName()).append('.').append(stackTraceElement.getMethodName()).append('(');
                if (stackTraceElement.isNativeMethod()) {
                    sb.append("Native Method");
                } else {
                    sb.append(stackTraceElement.getFileName()).append(':').append(stackTraceElement.getLineNumber());
                }
                sb.append(")<br>\n");
                if (!exlibrisCode) continue;
                sb.append("</b>");
            }
            sb.append("</blockquote><br><hr/>\n");
        }
        sb.append("</p>");
        this.addFooter(sb);
        return sb.toString();
    }

    private static String highlight(String val, boolean highlight) {
        if (!highlight) {
            return val;
        }
        return "<font color=\"red\"><b>" + val + "</b></font>";
    }

    public static void main(String[] args) {
        System.out.println(new JStack().getJStack(null, null));
    }
}

