/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model;

import com.exlibris.core.infra.model.HPersistent;
import java.util.Calendar;
import java.util.Comparator;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.hibernate.annotations.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="findOldest", query="from HFrPublishingQueue queue where queue.eventDate = (select min(q2.eventDate) from HFrPublishingQueue q2)"), @NamedQuery(name="findByConfigurationId", query="from HFrPublishingQueue queue where queue.configurationId = :configurationId order by queue.eventDate asc")})
public class HFrPublishingQueue
extends HPersistent {
    private Event event;
    private Calendar eventDate;
    private String configurationId;
    private String xparams;
    public static Comparator<HFrPublishingQueue> eventDateComparator = new Comparator<HFrPublishingQueue>(){

        @Override
        public int compare(HFrPublishingQueue q0, HFrPublishingQueue q1) {
            return q0.getEventDate().compareTo(q1.getEventDate());
        }
    };

    @Column
    @Enumerated(value=EnumType.STRING)
    public Event getEvent() {
        return this.event;
    }

    public void setEvent(Event event) {
        this.event = event;
    }

    @Column(name="event_date")
    @Index(name="HFRPUBLISHINGQUEUE_EVENT_DATE")
    public Calendar getEventDate() {
        return this.eventDate;
    }

    public void setEventDate(Calendar eventDate) {
        this.eventDate = eventDate;
    }

    @Column(name="configuration_id")
    public String getConfigurationId() {
        return this.configurationId;
    }

    public void setConfigurationId(String configurationId) {
        this.configurationId = configurationId;
    }

    @Column(length=2000)
    public String getXparams() {
        return this.xparams;
    }

    public void setXparams(String xparams) {
        this.xparams = xparams;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(configurationId=" + this.getConfigurationId() + ", event=" + (Object)((Object)this.getEvent()) + ")";
    }

    public static enum Event {
        DELETE_CONFIGURATION,
        UPDATE_SET,
        ADD_SET,
        ADD_MEMBERS_TO_SET,
        REMOVE_MEMBERS_FROM_SET,
        REMOVE_SET,
        ADD_PROFILE,
        REMOVE_PROFILE,
        SYNC_CONFIGURATION;

    }
}

