/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.quartz;

import com.exlibris.core.infra.Common;
import com.exlibris.core.infra.model.HStandardEntity;
import com.exlibris.core.infra.model.quartz.QuartzJobConfig;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.EnumType;
import javax.persistence.Enumerated;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.Table;
import javax.persistence.Transient;
import javax.persistence.UniqueConstraint;
import org.apache.commons.lang.StringUtils;

@Entity
@NamedQueries(value={@NamedQuery(name="FIND_JOB_DEF_BY_NAME", query="select a from OperationalJobDef a where a.jobName = :jobName")})
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"JOB_NAME"})})
public class OperationalJobDef
extends HStandardEntity {
    private static final long serialVersionUID = 1L;
    private String jobName;
    private String jobClass;
    private Common.QuartzRole jobRole;
    private QuartzJobConfig.SchedulerType schedulerType;
    private String paramsXml;
    private boolean sendNotification;

    @Column(name="JOB_NAME")
    public String getJobName() {
        return this.jobName;
    }

    public void setJobName(String jobName) {
        this.jobName = jobName;
    }

    @Column(name="JOB_CLASS")
    public String getJobClass() {
        return this.jobClass;
    }

    public void setJobClass(String jobClass) {
        this.jobClass = jobClass;
    }

    @Column(name="JOB_ROLE")
    @Enumerated(value=EnumType.STRING)
    public Common.QuartzRole getJobRole() {
        return this.jobRole;
    }

    public void setJobRole(Common.QuartzRole jobRole) {
        this.jobRole = jobRole;
    }

    @Column(name="SCHEDULER_TYPE")
    @Enumerated(value=EnumType.STRING)
    public QuartzJobConfig.SchedulerType getSchedulerType() {
        return this.schedulerType;
    }

    public void setSchedulerType(QuartzJobConfig.SchedulerType schedulerType) {
        this.schedulerType = schedulerType;
    }

    @Column(name="PARAMS_XML")
    @Lob
    public String getParamsXml() {
        return this.paramsXml;
    }

    public void setParamsXml(String paramsXml) {
        this.paramsXml = paramsXml;
    }

    @Transient
    public boolean isMultiJobsEnabled() {
        return StringUtils.isNotEmpty((String)this.paramsXml);
    }

    @Column(name="SEND_NOTIFICATION")
    public boolean isSendNotification() {
        return this.sendNotification;
    }

    public void setSendNotification(boolean sendNotification) {
        this.sendNotification = sendNotification;
    }
}

