/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.model.resource;

import gov.loc.zing.srw.ExplainResponseDocument;
import gov.loc.zing.srw.ExplainResponseType;
import gov.loc.zing.srw.RecordType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.z3950.explain.dtd.x20.ExplainDocument;
import org.z3950.explain.dtd.x20.IndexDocument;
import org.z3950.explain.dtd.x20.IndexInfoDocument;
import org.z3950.explain.dtd.x20.MapDocument;
import org.z3950.explain.dtd.x20.NameDocument;

public class ParseSRWExplainResponse {
    static Log log = LogFactory.getLog(ParseSRWExplainResponse.class);
    List<String> repoIndexes = new ArrayList<String>();

    public ParseSRWExplainResponse(String input) {
        this.parse(input);
    }

    private void parse(String input) {
        try {
            ExplainResponseDocument responseDoc = ExplainResponseDocument.Factory.parse(input);
            ExplainResponseType responseType = responseDoc.getExplainResponse();
            RecordType recordType = responseType.getRecord();
            String recordData = recordType.getRecordData().xmlText();
            ExplainDocument explainDoc = ExplainDocument.Factory.parse(recordData);
            ExplainDocument.Explain rootDoc = explainDoc.getExplain();
            IndexInfoDocument.IndexInfo record = rootDoc.getIndexInfo();
            IndexDocument.Index[] allIndexes = record.getIndexArray();
            if (allIndexes != null) {
                for (int i = 0; i < allIndexes.length; ++i) {
                    IndexDocument.Index indx = allIndexes[i];
                    MapDocument.Map[] maps = indx.getMapArray();
                    if (maps == null) continue;
                    for (int m = 0; m < maps.length; ++m) {
                        MapDocument.Map map = maps[m];
                        NameDocument.Name name = map.getName();
                        String set = name.getSet();
                        if (!set.equalsIgnoreCase("dc")) continue;
                        this.repoIndexes.add(name.getStringValue());
                    }
                }
            }
        }
        catch (Exception e) {
            log.error((Object)("Exception when parse explain " + e.getMessage()));
        }
    }

    public List<String> getRepoIndexes() {
        return this.repoIndexes;
    }

    public void setRepoIndexes(List<String> repoIndexes) {
        this.repoIndexes = repoIndexes;
    }
}

