/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.authentication;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.model.filetable.HFileTable;
import com.exlibris.core.infra.svc.api.FileTableManager;
import com.exlibris.core.infra.svc.api.authentication.ExlSAMLBootstrap;
import com.exlibris.core.infra.svc.api.authentication.SamlMetadataUtils;
import com.exlibris.core.infra.svc.api.locator.ServiceLocator;
import com.exlibris.core.infra.svc.api.utils.AuthenticationUtil;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URI;
import java.net.URL;
import java.net.URLEncoder;
import java.security.KeyStore;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang.StringUtils;
import org.apache.tools.ant.filters.StringInputStream;
import org.apache.xml.security.Init;
import org.joda.time.DateTime;
import org.opensaml.common.SAMLVersion;
import org.opensaml.common.impl.SecureRandomIdentifierGenerator;
import org.opensaml.saml2.core.AuthnRequest;
import org.opensaml.saml2.core.Issuer;
import org.opensaml.saml2.core.LogoutRequest;
import org.opensaml.saml2.core.LogoutResponse;
import org.opensaml.saml2.core.NameID;
import org.opensaml.saml2.core.NameIDPolicy;
import org.opensaml.saml2.core.SessionIndex;
import org.opensaml.saml2.core.impl.AuthnRequestBuilder;
import org.opensaml.saml2.core.impl.IssuerBuilder;
import org.opensaml.saml2.core.impl.LogoutRequestBuilder;
import org.opensaml.saml2.core.impl.NameIDBuilder;
import org.opensaml.saml2.core.impl.NameIDPolicyBuilder;
import org.opensaml.saml2.core.impl.SessionIndexBuilder;
import org.opensaml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml2.metadata.SingleLogoutService;
import org.opensaml.xml.Configuration;
import org.opensaml.xml.XMLObject;
import org.opensaml.xml.io.Marshaller;
import org.opensaml.xml.io.MarshallerFactory;
import org.opensaml.xml.io.MarshallingException;
import org.opensaml.xml.io.Unmarshaller;
import org.opensaml.xml.io.UnmarshallerFactory;
import org.opensaml.xml.parse.BasicParserPool;
import org.opensaml.xml.security.credential.Credential;
import org.opensaml.xml.security.x509.BasicX509Credential;
import org.opensaml.xml.security.x509.X509Credential;
import org.opensaml.xml.signature.KeyInfo;
import org.opensaml.xml.signature.Signature;
import org.opensaml.xml.signature.Signer;
import org.opensaml.xml.signature.X509Data;
import org.opensaml.xml.signature.impl.KeyInfoBuilder;
import org.opensaml.xml.signature.impl.SignatureBuilder;
import org.opensaml.xml.signature.impl.SignatureImpl;
import org.opensaml.xml.signature.impl.X509CertificateBuilder;
import org.opensaml.xml.signature.impl.X509DataBuilder;
import org.opensaml.xml.util.XMLHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SamlUtil {
    private static final ExLogger logger = ExLogger.getExLogger(SamlUtil.class);
    private static final String FIRST_SUBDOMAIN_PATTERN = "^https?://(.*?)\\.";

    public static Map<String, String> getParmaetersFromMetadata(String pathToMetada) throws Exception {
        org.opensaml.xml.signature.X509Certificate x509Certificate;
        X509Data x509Data;
        List x509Datas;
        KeyDescriptor keyDescriptor;
        ExlSAMLBootstrap.bootstrap();
        HashMap<String, String> parmetersMap = new HashMap<String, String>();
        EntityDescriptor entityDescriptor = null;
        boolean specificFound = false;
        if (StringUtils.isBlank((String)pathToMetada)) {
            logger.error("No metadata path found.", new String[0]);
            throw new Exception("No metadata path found.");
        }
        entityDescriptor = pathToMetada.startsWith("http") ? SamlMetadataUtils.loadMetadata(new URL(pathToMetada), null) : SamlMetadataUtils.loadMetadata(pathToMetada, null);
        if (entityDescriptor == null) {
            logger.error("Failure to load Metadata file. Exiting.", new String[0]);
            throw new Exception("Failure to load Metadata file. Exiting.");
        }
        parmetersMap.put("IdPIssuer", entityDescriptor.getEntityID());
        if (entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol") == null) {
            return parmetersMap;
        }
        List signOnServices = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleSignOnServices();
        if (signOnServices == null || signOnServices.isEmpty()) {
            logger.info("No Single Sign-On Service found");
        } else {
            for (Object sso : signOnServices) {
                if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(sso.getBinding())) continue;
                specificFound = true;
                parmetersMap.put("IdPLoginURL", sso.getLocation());
                logger.info("SingleSignOnService: \t" + sso.getLocation());
                break;
            }
            if (!specificFound) {
                for (Object sso : signOnServices) {
                    logger.info("SingleSignOnService (" + sso.getBinding().substring(sso.getBinding().lastIndexOf(":") + 1) + "): \t" + sso.getLocation());
                }
            }
        }
        specificFound = false;
        List logoutServices = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getSingleLogoutServices();
        if (logoutServices == null || logoutServices.isEmpty()) {
            logger.info("No Single Logout Service found");
        } else {
            for (SingleLogoutService slo : logoutServices) {
                if (!"urn:oasis:names:tc:SAML:2.0:bindings:HTTP-Redirect".equals(slo.getBinding())) continue;
                specificFound = true;
                parmetersMap.put("IdPLogoutURL", slo.getLocation());
                logger.info("SingleLogoutService: \t" + slo.getLocation());
                break;
            }
            if (!specificFound) {
                for (SingleLogoutService slo : logoutServices) {
                    logger.info("SingleLogoutService (" + slo.getBinding().substring(slo.getBinding().lastIndexOf(":") + 1) + "): \t" + slo.getLocation());
                }
            }
        }
        List keyDescriptors = entityDescriptor.getIDPSSODescriptor("urn:oasis:names:tc:SAML:2.0:protocol").getKeyDescriptors();
        if (keyDescriptors != null && !keyDescriptors.isEmpty() && (keyDescriptor = (KeyDescriptor)keyDescriptors.get(0)) != null && keyDescriptor.getKeyInfo() != null && (x509Datas = keyDescriptor.getKeyInfo().getX509Datas()) != null && !x509Datas.isEmpty() && (x509Data = (X509Data)x509Datas.get(0)) != null && x509Data.getX509Certificates() != null && (x509Certificate = (org.opensaml.xml.signature.X509Certificate)x509Data.getX509Certificates().get(0)) != null) {
            String certString = x509Certificate.getValue();
            StringBuilder strBuilder = new StringBuilder("-----BEGIN CERTIFICATE-----\n");
            strBuilder.append(certString);
            strBuilder.append("\n-----END CERTIFICATE-----");
            certString = strBuilder.toString();
            if (StringUtils.isNotBlank((String)certString)) {
                parmetersMap.put("certificationText", certString);
            }
        }
        return parmetersMap;
    }

    public static byte[] generateMetadataFile(String certificateVersion) throws RuntimeException {
        try {
            String certificate;
            String rosettaCertificate;
            String metadata;
            String metadataTemplate = SamlUtil.getFileTableManager().getFileByKeyAsString("com.exlibris.dps.authentication.samlMetadataTemplate", "CRS00");
            if (metadataTemplate == null) {
                throw new Exception("Failed to find template metadata");
            }
            BufferedReader in = new BufferedReader(new StringReader(metadataTemplate));
            StringBuilder builder = new StringBuilder();
            while ((metadata = in.readLine()) != null) {
                builder.append(metadata);
            }
            in.close();
            metadata = builder.toString();
            String backofficeServerUrl = AuthenticationUtil.getBackofficeUrl();
            String depositServerUrl = AuthenticationUtil.getDepositUrl();
            String deliveryServerUrl = AuthenticationUtil.getDeliveryUrl();
            if (StringUtils.isNotBlank((String)backofficeServerUrl)) {
                metadata = metadata.replaceAll("###BACKOFFICE_SERVER_DOMAIN###", backofficeServerUrl);
            }
            if (StringUtils.isNotBlank((String)depositServerUrl)) {
                metadata = metadata.replaceAll("###DEPOSIT_SERVER_DOMAIN###", depositServerUrl);
            }
            if (StringUtils.isNotBlank((String)deliveryServerUrl)) {
                metadata = metadata.replaceAll("###DELIVERY_SERVER_DOMAIN###", deliveryServerUrl);
            }
            if ((rosettaCertificate = SamlUtil.getRosettaCertificate(certificateVersion)) == null) {
                throw new Exception("Failed to find certificate");
            }
            in = new BufferedReader(new StringReader(rosettaCertificate));
            builder = new StringBuilder();
            while ((certificate = in.readLine()) != null) {
                builder.append(certificate);
            }
            in.close();
            certificate = builder.toString();
            if (StringUtils.isNotBlank((String)certificate)) {
                metadata = metadata.replace("###CRT###", certificate);
            }
            return metadata.getBytes();
        }
        catch (Throwable t) {
            throw new RuntimeException("Error generating metadata file", t);
        }
    }

    public static String getRosettaCertificate(String certificateVersion) {
        return SamlUtil.getFileTableManager().getFileByKeyAsString("com.exlibris.dps.authentication." + certificateVersion + ".crt", "CRS00");
    }

    public static String buildAuthenticationRequest(HttpServletRequest request, Map<String, String> samlParameters) {
        String encodedAuthnRequest = "";
        try {
            String idpUrl = samlParameters.get("IdPLoginURL");
            if (StringUtils.isNotEmpty((String)idpUrl)) {
                String samlSessionId = SamlUtil.generateSessionId();
                request.getSession().setAttribute("SAML_Session_ID", (Object)samlSessionId);
                String assertionConsumerUrl = URI.create(AuthenticationUtil.getServerUrl(request) + "/pdsHandleLogin").normalize().toString();
                String issuerUrl = SamlUtil.getIssuerUrl();
                IssuerBuilder issuerBuilder = new IssuerBuilder();
                Issuer issuer = issuerBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "saml");
                issuer.setValue(issuerUrl);
                NameIDPolicyBuilder nameIdPolicyBuilder = new NameIDPolicyBuilder();
                NameIDPolicy nameIdPolicy = nameIdPolicyBuilder.buildObject();
                if (!Boolean.TRUE.toString().equalsIgnoreCase(samlParameters.get("ADFS"))) {
                    nameIdPolicy.setSPNameQualifier(issuerUrl);
                    nameIdPolicy.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
                }
                nameIdPolicy.setAllowCreate(Boolean.valueOf(true));
                ExlSAMLBootstrap.bootstrap();
                DateTime issueInstant = new DateTime();
                AuthnRequestBuilder authnRequestBuilder = new AuthnRequestBuilder();
                AuthnRequest authnRequest = authnRequestBuilder.buildObject("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnRequest", "samlp");
                authnRequest.setForceAuthn(Boolean.valueOf(false));
                authnRequest.setIsPassive(Boolean.valueOf(false));
                authnRequest.setIssueInstant(issueInstant);
                authnRequest.setDestination(idpUrl);
                authnRequest.setAssertionConsumerServiceURL(assertionConsumerUrl);
                authnRequest.setIssuer(issuer);
                authnRequest.setID(samlSessionId);
                authnRequest.setNameIDPolicy(nameIdPolicy);
                authnRequest.setVersion(SAMLVersion.VERSION_20);
                encodedAuthnRequest = SamlUtil.encode((XMLObject)authnRequest);
            } else {
                logger.error("Missing SAML configuration: Empty IdPLoginURL", new String[0]);
            }
        }
        catch (Exception e) {
            logger.error("Failed to create Authentication Request", e, new String[0]);
        }
        return encodedAuthnRequest;
    }

    public static String getIssuerUrl() {
        String backofficeServerUrl = AuthenticationUtil.getBackofficeUrl();
        String issuerUrl = backofficeServerUrl + "/mng/login";
        return URI.create(issuerUrl).normalize().toString();
    }

    private static String encode(XMLObject samlObj) throws Exception {
        String encodedSAMLObj = "";
        Marshaller marshaller = Configuration.getMarshallerFactory().getMarshaller(samlObj);
        Element authDOM = null;
        try {
            authDOM = marshaller.marshall(samlObj);
        }
        catch (MarshallingException e) {
            logger.error("Failed to encode", (Exception)((Object)e), new String[0]);
        }
        StringWriter rspWrt = new StringWriter();
        XMLHelper.writeNode((Node)authDOM, (Writer)rspWrt);
        String requestMessage = rspWrt.toString();
        Deflater deflater = new Deflater(8, true);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream((OutputStream)byteArrayOutputStream, deflater);
        deflaterOutputStream.write(requestMessage.getBytes());
        deflaterOutputStream.close();
        encodedSAMLObj = org.opensaml.xml.util.Base64.encodeBytes((byte[])byteArrayOutputStream.toByteArray(), (int)8);
        return encodedSAMLObj;
    }

    private static FileTableManager getFileTableManager() {
        return (FileTableManager)ServiceLocator.getInstance().lookUp(FileTableManager.class);
    }

    public static KeyStore importCertificate(String samlFreeTextCrt) {
        String templateJks;
        KeyStore keystore = null;
        if (!samlFreeTextCrt.startsWith("-----BEGIN CERTIFICATE-----")) {
            samlFreeTextCrt = "-----BEGIN CERTIFICATE-----\n" + samlFreeTextCrt;
        }
        if (!samlFreeTextCrt.endsWith("-----END CERTIFICATE-----")) {
            samlFreeTextCrt = samlFreeTextCrt + "\n" + "-----END CERTIFICATE-----";
        }
        if (StringUtils.isBlank((String)(templateJks = SamlUtil.getFileTableManager().getFileByKeyAsString("com.exlibris.dps.authentication.idp_saml.jks", "CRS00")))) {
            logger.error("Failed to retreive template jks file", new String[0]);
            return null;
        }
        try (StringInputStream is = new StringInputStream(samlFreeTextCrt);
             ByteArrayInputStream in = new ByteArrayInputStream(org.opensaml.xml.util.Base64.decode((String)templateJks));){
            keystore = KeyStore.getInstance("JKS");
            keystore.load(in, "p5909206323797881374".toCharArray());
            CertificateFactory cf = CertificateFactory.getInstance("X.509");
            Certificate cert = cf.generateCertificate((InputStream)is);
            keystore.setCertificateEntry("idp saml_jks", cert);
        }
        catch (Exception e) {
            logger.error("Failed to generate keystore file", e, new String[0]);
            keystore = null;
        }
        return keystore;
    }

    public static KeyStore getIdpKeyStore(String samlProfile) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS", "SUN");
        char[] password = "p5909206323797881374".toCharArray();
        InputStream fis = null;
        try {
            HFileTable fileTable = SamlUtil.getFileTableManager().getFileByKey("samlKs." + samlProfile, "CRS00");
            if (fileTable == null) {
                throw new Exception("Rosetta Certificate (keyStore) is missing in Rosetta DB.");
            }
            fis = new ByteArrayInputStream(org.opensaml.xml.util.Base64.decode((String)fileTable.getFile()));
            ks.load(fis, password);
        }
        catch (Exception e) {
            logger.error("Rosetta Certificate (keyStore) is corrupted and cannot be loaded", new String[0]);
            throw e;
        }
        finally {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static KeyStore getRosettaKeyStore(String certificateVersion) throws Exception {
        KeyStore ks = KeyStore.getInstance("JKS", "SUN");
        HFileTable fileTable = SamlUtil.getFileTableManager().getFileByKey("com.exlibris.dps.authentication." + certificateVersion + ".jks", "CRS00");
        ByteArrayInputStream in = null;
        try {
            in = new ByteArrayInputStream(org.opensaml.xml.util.Base64.decode((String)fileTable.getFile()));
            ks.load(in, "p5909206323797881374".toCharArray());
        }
        finally {
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException iOException) {}
            }
        }
        return ks;
    }

    public static boolean matchUrls(String url, String urlFromIDP) {
        if (StringUtils.equals((String)url, (String)urlFromIDP)) {
            return true;
        }
        boolean match = false;
        if (url != null && urlFromIDP != null) {
            try {
                Pattern p = Pattern.compile(FIRST_SUBDOMAIN_PATTERN);
                Matcher m1 = p.matcher(url);
                Matcher m2 = p.matcher(urlFromIDP);
                if (m1.find() && m2.find()) {
                    String subdomain = m1.group(1);
                    String subdomainIDP = m2.group(1);
                    if (StringUtils.equals((String)(subdomain = subdomain + "-a"), (String)subdomainIDP)) {
                        match = true;
                    }
                }
            }
            catch (Exception e) {
                logger.warn((Object)e, new String[0]);
            }
        }
        return match;
    }

    public static List<Certificate> getCertificateList(KeyStore keyStore, Certificate certFromResponse) {
        ArrayList<Certificate> certs = new ArrayList<Certificate>();
        certs.add(certFromResponse);
        return certs;
    }

    public static String generateSessionId() {
        String samlId;
        try {
            SecureRandomIdentifierGenerator idGenerator = new SecureRandomIdentifierGenerator();
            samlId = idGenerator.generateIdentifier();
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Problem initializing ID generator, using local algorithm to create SAML ID.", e, new String[0]);
            samlId = "_".concat(UUID.randomUUID().toString().replace("-", ""));
        }
        return samlId;
    }

    public static LogoutResponse parseLogoutResponse(HttpServletRequest request) throws Exception {
        ByteArrayInputStream in = new ByteArrayInputStream(SamlUtil.decode(request.getParameter("SAMLResponse")).getBytes());
        Element metadataRoot = SamlUtil.getMetadataRoot(in);
        LogoutResponse logoutResponse = (LogoutResponse)SamlUtil.getUnmarshaller(metadataRoot).unmarshall(metadataRoot);
        return logoutResponse;
    }

    private static String decode(String encodedStr) throws Exception {
        try {
            Base64 base64Decoder = new Base64();
            byte[] xmlBytes = encodedStr.getBytes("UTF-8");
            byte[] base64DecodedByteArray = base64Decoder.decode(xmlBytes);
            try {
                Inflater inflater = new Inflater(true);
                inflater.setInput(base64DecodedByteArray);
                byte[] xmlMessageBytes = new byte[5000];
                int resultLength = inflater.inflate(xmlMessageBytes);
                if (inflater.getRemaining() > 0) {
                    throw new RuntimeException("didn't allocate enough space to hold decompressed data");
                }
                inflater.end();
                String decodedString = new String(xmlMessageBytes, 0, resultLength, "UTF-8");
                return decodedString;
            }
            catch (DataFormatException e) {
                ByteArrayInputStream bais = new ByteArrayInputStream(base64DecodedByteArray);
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                InflaterInputStream iis = new InflaterInputStream(bais);
                byte[] buf = new byte[1024];
                int count = iis.read(buf);
                while (count != -1) {
                    baos.write(buf, 0, count);
                    count = iis.read(buf);
                }
                iis.close();
                String decodedStr = new String(baos.toByteArray());
                return decodedStr;
            }
        }
        catch (IOException e) {
            throw new Exception("Error when decoding the SAML Request.", e);
        }
    }

    private static Element getMetadataRoot(InputStream in) throws Exception {
        ExlSAMLBootstrap.bootstrap();
        BasicParserPool ppMgr = new BasicParserPool();
        ppMgr.setNamespaceAware(true);
        Document doc = ppMgr.parse(in);
        Element metadataRoot = doc.getDocumentElement();
        return metadataRoot;
    }

    private static Unmarshaller getUnmarshaller(Element metadataRoot) throws Exception {
        UnmarshallerFactory unmarshallerFactory = Configuration.getUnmarshallerFactory();
        Unmarshaller unmarshaller = unmarshallerFactory.getUnmarshaller(metadataRoot);
        return unmarshaller;
    }

    public static String buildLogoutRequest(HttpServletRequest request, Map<String, String> samlParameters) {
        String encodedLogoutRequest = "";
        try {
            String idpLogoutUrl = samlParameters.get("IdPLogoutURL");
            String samlSessionId = SamlUtil.generateSessionId();
            if (StringUtils.isNotBlank((String)idpLogoutUrl)) {
                ExlSAMLBootstrap.bootstrap();
                String issuerUrl = SamlUtil.getIssuerUrl();
                LogoutRequest logoutRequest = new LogoutRequestBuilder().buildObject();
                logoutRequest.setID(samlSessionId);
                logoutRequest.setIssueInstant(new DateTime());
                Issuer issuer = new IssuerBuilder().buildObject();
                issuer.setValue(issuerUrl);
                logoutRequest.setIssuer(issuer);
                logoutRequest.setDestination(idpLogoutUrl);
                NameID nameId = new NameIDBuilder().buildObject();
                if (!Boolean.TRUE.toString().equalsIgnoreCase(samlParameters.get("ADFS"))) {
                    nameId.setSPNameQualifier(issuerUrl);
                    nameId.setFormat("urn:oasis:names:tc:SAML:2.0:nameid-format:transient");
                }
                Map authenticationParameters = (Map)request.getSession().getAttribute("authenticationParameters");
                nameId.setNameQualifier((String)authenticationParameters.get("SAMLIdpNameIdNameQualifier"));
                nameId.setValue((String)authenticationParameters.get("SAMLIdpNameId"));
                logoutRequest.setNameID(nameId);
                SessionIndex sessionIndex = new SessionIndexBuilder().buildObject();
                sessionIndex.setSessionIndex((String)authenticationParameters.get("SAMLIdpSessionIndex"));
                logoutRequest.getSessionIndexes().add(sessionIndex);
                KeyStore rosettaKeyStore = SamlUtil.getRosettaKeyStore((String)authenticationParameters.get("rosettaCertificateVersion"));
                RSAPrivateKey privateKey = (RSAPrivateKey)rosettaKeyStore.getKey("rosetta saml_jks", "p5909206323797881374".toCharArray());
                KeyStore.PrivateKeyEntry privateKeyEntry = null;
                privateKeyEntry = (KeyStore.PrivateKeyEntry)rosettaKeyStore.getEntry("rosetta saml_jks", new KeyStore.PasswordProtection("p5909206323797881374".toCharArray()));
                Certificate certificate = privateKeyEntry.getCertificate();
                BasicX509Credential credential = new BasicX509Credential();
                credential.setEntityCertificate((X509Certificate)certificate);
                credential.setPrivateKey((PrivateKey)privateKey);
                SamlUtil.setSignature(logoutRequest, "http://www.w3.org/2000/09/xmldsig#rsa-sha1", (X509Credential)credential);
                encodedLogoutRequest = URLEncoder.encode(SamlUtil.encode((XMLObject)logoutRequest), "UTF-8");
            }
        }
        catch (Exception e) {
            logger.error("Failed to create Logout Request", e, new String[0]);
        }
        return encodedLogoutRequest;
    }

    public static LogoutRequest setSignature(LogoutRequest logoutRequest, String signatureAlgorithm, X509Credential cred) throws Exception {
        try {
            ExlSAMLBootstrap.bootstrap();
            SignatureImpl signature = new SignatureBuilder().buildObject();
            signature.setSigningCredential((Credential)cred);
            signature.setSignatureAlgorithm(signatureAlgorithm);
            signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
            try {
                KeyInfo keyInfo = new KeyInfoBuilder().buildObject();
                X509Data data = new X509DataBuilder().buildObject();
                org.opensaml.xml.signature.X509Certificate cert = new X509CertificateBuilder().buildObject();
                String value = org.opensaml.xml.util.Base64.encodeBytes((byte[])cred.getEntityCertificate().getEncoded());
                cert.setValue(value);
                data.getX509Certificates().add(cert);
                keyInfo.getX509Datas().add(data);
                signature.setKeyInfo(keyInfo);
            }
            catch (Exception e) {
                throw new Exception("Error getting certificate", e);
            }
            logoutRequest.setSignature((Signature)signature);
            ArrayList<SignatureImpl> signatureList = new ArrayList<SignatureImpl>();
            signatureList.add(signature);
            MarshallerFactory marshallerFactory = Configuration.getMarshallerFactory();
            Marshaller marshaller = marshallerFactory.getMarshaller((XMLObject)logoutRequest);
            marshaller.marshall((XMLObject)logoutRequest);
            Init.init();
            Signer.signObjects(signatureList);
            return logoutRequest;
        }
        catch (Exception e) {
            throw new Exception("Error while signing the Logout Request message", e);
        }
    }
}

