/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.infra.svc.api.scriptRunner;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecExternalProcess;
import java.util.List;
import org.apache.commons.lang.StringUtils;

public class ScriptPluginRunner {
    protected static final ExLogger log = ExLogger.getExLogger(ScriptPluginRunner.class);
    private ExecExternalProcess proc;
    private String command;
    protected List<String> args;

    public int runScript(boolean getExitValue, String ... additionalArgs) {
        this.proc = new ExecExternalProcess();
        for (String arg : additionalArgs) {
            this.args.add(arg);
        }
        int retValue = this.proc.execExternalProcess(this.command, this.args);
        if (retValue == 0) {
            log.info("Execution of " + this.command + " ended succesfuly: " + this.proc.getInputStream());
        } else if (!getExitValue) {
            log.error("Execution of " + this.command + " failed: " + (StringUtils.isNotBlank((String)this.proc.getErrorStream()) ? this.proc.getErrorStream() : this.proc.getInputStream()), new String[0]);
        }
        return retValue;
    }

    public String getErrorStream() {
        if (this.proc == null) {
            return null;
        }
        return StringUtils.isNotBlank((String)this.proc.getErrorStream()) ? this.proc.getErrorStream() : this.proc.getInputStream();
    }

    public void setCommand(String command) {
        this.command = command;
    }

    public String getCommand() {
        return this.command;
    }

    public void setInitialArgs(List<String> initialArgs) {
        this.args = initialArgs;
    }

    public String getInputStream() {
        if (this.proc == null) {
            return null;
        }
        return this.proc.getInputStream();
    }
}

