/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.repository.tools;

import com.exlibris.core.infra.api.xmlbeans.Field;
import com.exlibris.core.infra.common.cache.SessionUtils;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.ResourceBundleUtil;
import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import com.exlibris.core.infra.svc.api.tools.WhereClauser;
import com.exlibris.digitool.repository.api.xmlbeans.ObjectType;
import com.exlibris.digitool.repository.api.xmlbeans.XCondition;
import com.exlibris.digitool.repository.api.xmlbeans.XPopulateElements;
import com.exlibris.digitool.repository.api.xmlbeans.XQueriesDocument;
import com.exlibris.digitool.repository.api.xmlbeans.XQuery;
import com.exlibris.digitool.repository.api.xmlbeans.XSelect;
import com.exlibris.digitool.repository.api.xmlbeans.XSorting;
import com.exlibris.digitool.repository.api.xmlbeans.XType;
import com.exlibris.digitool.repository.api.xmlbeans.XWhere;
import java.util.List;
import java.util.Locale;
import java.util.ResourceBundle;

public class CreateXQueryUtil {
    private static final ExLogger logger = ExLogger.getExLogger(CreateXQueryUtil.class);
    protected static ResourceBundle resourceBundle = CodeTablesResourceBundle.getDefaultBundle(new Locale(SessionUtils.getSessionLanguage()));
    public static final String IE_MODIFICATION_DATE = "IE.objectCharacteristics.modificationDate";
    protected static final int ANSWER_PER_PAGE = 10;
    public static final String FIELDS_PREFIX = "ui.search_object.fields.";

    public static String converterXType(XType.Enum type) {
        switch (type.intValue()) {
            case 8: {
                return "==";
            }
            case 1: {
                return "=";
            }
            case 15: {
                return "<>";
            }
            case 18: {
                return "IS_EMPTY";
            }
            case 19: {
                return "IS_NOT_EMPTY";
            }
            case 6: 
            case 11: {
                return "<";
            }
            case 7: 
            case 9: {
                return ">";
            }
            case 12: {
                return "<=";
            }
            case 10: {
                return ">=";
            }
            case 14: {
                return "like";
            }
            case 16: {
                return "in";
            }
            case 17: {
                return "not in";
            }
            case 2: {
                return "START_WITH";
            }
            case 13: {
                return "NOT_WITHIN";
            }
            case 3: 
            case 4: 
            case 5: {
                return "WITHIN";
            }
        }
        return "ERROR";
    }

    public static String getLabel(Field field, String prefix, Locale locale) {
        String label = field.getUiDefaultText();
        String key = prefix + field.getIndexCode();
        try {
            ResourceBundle resourceBundle = CodeTablesResourceBundle.getDefaultBundle(locale);
            String bundeledLabel = ResourceBundleUtil.getString(resourceBundle, key);
            if (!bundeledLabel.equals(key)) {
                label = bundeledLabel;
            }
        }
        catch (RuntimeException e) {
            logger.error("Failed to get I18N Message of: " + key, e, new String[0]);
        }
        return label;
    }

    public static XQueriesDocument createSortedQuary(int startLocation, XPopulateElements.Enum elements, List<WhereClauser> whereClausers, List<XSorting> sort, ObjectType.Enum objectType2) {
        XQueriesDocument xqd = XQueriesDocument.Factory.newInstance();
        XQuery xq = xqd.addNewXQueries().addNewXQuery();
        xq.setType("xql");
        xq.setSetName("SET-1");
        CreateXQueryUtil.createSelect(startLocation, elements, xq, objectType2);
        XWhere xWhere = CreateXQueryUtil.createXWhere(whereClausers, xq, null);
        if (xWhere == null) {
            return null;
        }
        if (sort != null) {
            CreateXQueryUtil.createSortBy(sort, xq);
        }
        return xqd;
    }

    public static XSelect createSelect(int startLocation, XPopulateElements.Enum elements, XQuery xq, ObjectType.Enum objectType2) {
        XSelect select = xq.addNewXSelect();
        select.setElement(XPopulateElements.CONTROL);
        select.setObjectType(objectType2);
        select.setFromAnswer(startLocation);
        select.setToAnswer(startLocation + 10 - 1);
        return select;
    }

    private static int createXWhere(List<WhereClauser> whereClausers, int index, int indentation, XWhere xWhere) {
        WhereClauser whereClauser;
        while (index < whereClausers.size() && (whereClauser = whereClausers.get(index)).getIndentation() > indentation) {
            ++index;
            if (whereClauser.getLogicalOperator() != null) {
                XWhere newXWhere = xWhere.addNewXWhere();
                newXWhere.setOperator(whereClauser.getLogicalOperator().name());
                index = CreateXQueryUtil.createXWhere(whereClausers, index, indentation + 1, newXWhere);
                continue;
            }
            XCondition cond = xWhere.addNewXCondition();
            cond.setElement(whereClauser.getFieldName());
            cond.setType(XType.Enum.forString(whereClauser.getCompareType().name().toLowerCase()));
            whereClauser.updateCompareValue();
            String compareValue = whereClauser.getCompareValue();
            if (whereClauser.getFieldName().endsWith(".sourceMD.type")) {
                compareValue = whereClauser.getUiCompareValue();
            }
            if (compareValue.trim().length() == 0) continue;
            cond.setValue(compareValue);
            cond.setUiValue(whereClauser.getUiCompareValue());
        }
        return index;
    }

    public static XWhere createXWhere(List<WhereClauser> whereClausers, XQuery xq, ObjectType.Enum objectType2) {
        XWhere where = xq.addNewXWhere();
        where.setOperator(whereClausers.get(0).getLogicalOperator().name());
        if (objectType2 != null) {
            where.setObjectType(objectType2);
        }
        CreateXQueryUtil.createXWhere(whereClausers, 1, 1, where);
        return where;
    }

    public static void createSortBy(List<XSorting> sort, XQuery xq) {
        for (int i = 0; i < sort.size(); ++i) {
            XSorting xSorting = xq.addNewXSorting();
            xSorting.set(sort.get(i));
        }
    }

    public static void changeObjectType(XQueriesDocument queriesDocument, ObjectType.Enum objectType2) {
        XQuery query = queriesDocument.getXQueries().getXQueryArray(0);
        query.getXSelect().setObjectType(objectType2);
    }

    public static void addCondition(XWhere where, String element, XType.Enum type, String value) {
        XCondition condition = where.addNewXCondition();
        condition.setElement(element);
        condition.setType(type);
        condition.setValue(value);
    }

    public static enum ListType {
        IE,
        REP,
        FILE,
        MANDATORY,
        SIP;

    }
}

