/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.core.sdk.utils;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.IOUtil;
import com.exlibris.core.infra.svc.api.scriptRunner.ExecExternalProcess;
import com.exlibris.core.sdk.utils.FileTransferUtil;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.RandomAccessFile;
import java.io.Reader;
import java.io.StringWriter;
import java.io.Writer;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.Vector;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.SystemUtils;

public final class FileUtil {
    private static final ExLogger log = ExLogger.getExLogger(FileUtil.class);
    private static final String TEMP_PREFIX = ".tmp";
    private static FileUtil SINGLE_INSTANCE = new FileUtil();

    private FileUtil() {
    }

    public static void copyFileWithoutDelete(File source, File destination) throws IOException {
        if (!source.exists()) {
            throw new IOException("File " + source + " does not exist");
        }
        File parentFile = destination.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (destination.exists() && source.length() == destination.length()) {
            return;
        }
        try {
            FileUtils.copyFile((File)source, (File)destination);
        }
        catch (Exception e) {
            throw new IOException("Failed to copy file from " + source + " to " + destination);
        }
        if (source.length() != destination.length()) {
            throw new IOException("Failed to copy full contents from " + source + " to " + destination);
        }
    }

    public static File toFile(URL url) {
        if (!url.getProtocol().equals("file")) {
            return null;
        }
        String filename = url.getFile().replace('/', File.separatorChar);
        return new File(filename);
    }

    public static URL[] toURLs(File[] files) throws IOException {
        URL[] urls = new URL[files.length];
        for (int i = 0; i < urls.length; ++i) {
            urls[i] = files[i].toURL();
        }
        return urls;
    }

    public static String removeExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return filename;
        }
        return filename.substring(0, index);
    }

    public static String getExtension(String filename) {
        int index = filename.lastIndexOf(46);
        if (-1 == index) {
            return "";
        }
        return filename.substring(index + 1);
    }

    public static String removePath(String filepath) {
        return FileUtil.removePath(filepath, File.separatorChar);
    }

    public static String removePath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return filepath;
        }
        return filepath.substring(index + 1);
    }

    public static String getFileName(String filepath) {
        File f = new File(filepath);
        return f.getName();
    }

    public static String getPath(String filepath) {
        return FileUtil.getPath(filepath, File.separatorChar);
    }

    public static String getPath(String filepath, char fileSeparatorChar) {
        int index = filepath.lastIndexOf(fileSeparatorChar);
        if (-1 == index) {
            return "";
        }
        return filepath.substring(0, index);
    }

    public static void copyFilesToDirectory(String sourceDirectory, String destinationDirectory, boolean recursive) throws IOException {
        FileUtil.copyFilesToDirectory(new File(sourceDirectory), new File(destinationDirectory), recursive);
    }

    public static void copyFilesToDirectory(File sourceDirectory, File destinationDirectory, boolean recursive, boolean force) throws IOException {
        FileUtil.copyFilesToDirectory(sourceDirectory, destinationDirectory, recursive, force, null);
    }

    public static void copyFilesToDirectory(File sourceDirectory, File destinationDirectory, boolean recursive, String extension) throws IOException {
        FileUtil.copyFilesToDirectory(sourceDirectory, destinationDirectory, recursive, false, extension);
    }

    public static void copyFilesToDirectory(File sourceDirectory, File destinationDirectory, boolean recursive, boolean force, String extension) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new FileNotFoundException("Can not find directory: " + sourceDirectory);
        }
        File[] files = extension != null ? sourceDirectory.listFiles(new ExtensionFilter(extension)) : sourceDirectory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File childFile = files[i];
            if (childFile.isDirectory()) {
                if (!recursive) continue;
                File destChildFile = new File(destinationDirectory, childFile.getName());
                destChildFile.mkdirs();
                FileUtil.copyFilesToDirectory(childFile, destChildFile, recursive, force, extension);
                continue;
            }
            try {
                FileUtil.copyFileToDirectory(childFile, destinationDirectory);
                continue;
            }
            catch (IOException ioe) {
                if (force) continue;
                throw ioe;
            }
        }
    }

    public static void copyFilesToDirectory(File sourceDirectory, File destinationDirectory, boolean recursive) throws IOException {
        FileUtil.copyFilesToDirectory(sourceDirectory, destinationDirectory, recursive, false, null);
    }

    public static void copyFileToDirectory(String source, String destinationDirectory) throws IOException {
        FileUtil.copyFileToDirectory(new File(source), new File(destinationDirectory));
    }

    public static void copyFileToDirectory(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtil.copyFile(source, new File(destinationDirectory, source.getName()));
    }

    public static void copyFile(String source, String destination) throws IOException {
        if (source.toLowerCase().trim().startsWith("http")) {
            InputStream input = FileTransferUtil.getUrlContent(source);
            FileOutputStream output = new FileOutputStream(destination);
            IOUtil.copy(input, (OutputStream)output);
            IOUtil.shutdownStream(input);
            IOUtil.shutdownStream(output);
        } else {
            FileUtil.copyFile(new File(source), new File(destination));
        }
    }

    public static String getPathFromUrl(String formattedPath) {
        return FilenameUtils.normalize((String)formattedPath.replaceFirst("^(http[s]?://www\\.|http[s]?://|www\\.)", ""));
    }

    public static void copyDirToDirRecursively(File source, File destinationDirectory) throws IOException {
        FileUtil.copyDirToDirRecursively(source, destinationDirectory, null);
    }

    public static void copyDirToDirRecursively(File sourceDirectory, File destinationDirectory, String extension) throws IOException {
        File tempDstFolder = new File(destinationDirectory.getAbsolutePath() + TEMP_PREFIX);
        FileUtil.doCopyDirToDirRecursively(sourceDirectory, tempDstFolder, extension);
        if (destinationDirectory.exists()) {
            FileUtil.deleteDirectory(destinationDirectory);
        }
        tempDstFolder.renameTo(destinationDirectory);
    }

    private static void doCopyDirToDirRecursively(File sourceDirectory, File destinationDirectory, String extension) throws IOException {
        File[] files = sourceDirectory.listFiles();
        File file = null;
        for (int i = 0; i < files.length; ++i) {
            file = files[i];
            if (file.isDirectory()) {
                File newDestDir = new File(destinationDirectory, file.getName());
                FileUtil.doCopyDirToDirRecursively(file, newDestDir, extension);
                continue;
            }
            File destFile = new File(destinationDirectory, file.getName());
            FileUtil.copyFile(file, destFile);
        }
    }

    public static void copyDirToDirRecursively(String source, String destinationDirectory) throws IOException {
        FileUtil.copyDirToDirRecursively(new File(source), new File(destinationDirectory));
    }

    public static void copyFile(File source, File destination) throws IOException {
        if (!source.exists()) {
            throw new IOException("File " + source + " does not exist");
        }
        File parentFile = destination.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (destination.exists() && !destination.delete()) {
            throw new IOException("Unable to open file " + destination + " for writing.");
        }
        try {
            FileUtils.copyFile((File)source, (File)destination);
        }
        catch (Exception e) {
            throw new IOException("Failed to copy " + source + " to " + destination, e);
        }
        if (source.length() != destination.length()) {
            throw new IOException("Failed to copy full contents from " + source + " to " + destination);
        }
    }

    public static void copyURLToFile(URL source, File destination) throws IOException {
        if (destination.getParentFile() != null && !destination.getParentFile().exists()) {
            destination.mkdirs();
        }
        if (destination.exists() && !destination.canWrite()) {
            throw new IOException("Unable to open file " + destination + " for writing.");
        }
        InputStream input = source.openStream();
        FileOutputStream output = new FileOutputStream(destination);
        IOUtil.copy(input, (OutputStream)output);
        IOUtil.shutdownStream(input);
        IOUtil.shutdownStream(output);
    }

    public static void moveFile(File source, File destination) throws IOException {
        boolean result;
        if (!source.exists()) {
            throw new IOException("File " + source + " does not exist");
        }
        if (source.getPath().equals(destination.getPath())) {
            throw new IOException("Source and destination paths are the same");
        }
        File parentFile = destination.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (destination.exists()) {
            if (!destination.canWrite()) {
                throw new IOException("Unable to open file " + destination + " for writing.");
            }
            if (!destination.delete()) {
                throw new IOException("Unable to delete file " + destination);
            }
        }
        if (!(result = source.renameTo(destination))) {
            FileUtil.copyFile(source, destination);
            source.delete();
        }
    }

    public static void moveOrCopyFile(File source, File destination) throws IOException {
        boolean result;
        if (!source.exists()) {
            throw new IOException("File " + source + " does not exist");
        }
        if (source.getPath().equals(destination.getPath())) {
            throw new IOException("Source and destination paths are the same");
        }
        File parentFile = destination.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        if (destination.exists()) {
            if (!destination.canWrite()) {
                throw new IOException("Unable to open file " + destination + " for writing.");
            }
            if (!destination.delete()) {
                throw new IOException("Unable to delete file " + destination);
            }
        }
        if (!(result = source.renameTo(destination))) {
            FileUtil.copyFile(source, destination);
        }
    }

    public static void moveFilesToDirectory(File sourceDirectory, File destinationDirectory, boolean recursive) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new FileNotFoundException("Can not find directory: " + sourceDirectory);
        }
        File[] files = sourceDirectory.listFiles(new FilesFilter());
        for (int i = 0; i < files.length; ++i) {
            File childFile = files[i];
            if (childFile.isDirectory()) {
                if (!recursive) continue;
                File destChildFile = new File(destinationDirectory, childFile.getName());
                FileUtil.moveFilesToDirectory(childFile, destChildFile, true);
                continue;
            }
            FileUtil.moveFileToDirectory(childFile, destinationDirectory);
        }
    }

    public static void moveAllToDirectory(File sourceDirectory, File destinationDirectory) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new FileNotFoundException("Can not find directory: " + sourceDirectory);
        }
        destinationDirectory.mkdirs();
        File[] files = sourceDirectory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File childFile = files[i];
            FileUtil.moveFile(childFile, new File(destinationDirectory, childFile.getName()));
        }
    }

    public static void moveDirectory(File sourceDirectory, File destinationDirectory, boolean recursive) throws IOException {
        if (!sourceDirectory.exists()) {
            throw new FileNotFoundException("Can not find directory: " + sourceDirectory);
        }
        String destDir = destinationDirectory.getAbsolutePath() + File.separator + sourceDirectory.getName();
        File fDestDir = new File(destDir);
        fDestDir.mkdirs();
        File[] files = sourceDirectory.listFiles(new FilesFilter());
        for (int i = 0; i < files.length; ++i) {
            File childFile = files[i];
            if (childFile.isDirectory()) {
                if (!recursive) continue;
                File destChildFile = new File(fDestDir, childFile.getName());
                FileUtil.moveFilesToDirectory(childFile, destChildFile, true);
                continue;
            }
            FileUtil.moveFileToDirectory(childFile, fDestDir);
        }
        sourceDirectory.delete();
    }

    public static void moveFileToDirectory(File source, File destinationDirectory) throws IOException {
        if (destinationDirectory.exists() && !destinationDirectory.isDirectory()) {
            throw new IllegalArgumentException("Destination is not a directory");
        }
        FileUtil.moveFile(source, new File(destinationDirectory, source.getName()));
    }

    public static String normalize(String path) {
        int index;
        String normalized = path;
        while ((index = normalized.indexOf("//")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 1);
        }
        while ((index = normalized.indexOf("/./")) >= 0) {
            normalized = normalized.substring(0, index) + normalized.substring(index + 2);
        }
        while ((index = normalized.indexOf("/../")) >= 0) {
            if (index == 0) {
                return null;
            }
            int index2 = normalized.lastIndexOf(47, index - 1);
            normalized = normalized.substring(0, index2) + normalized.substring(index + 3);
        }
        return normalized;
    }

    public static String catPath(String lookupPath, String path) {
        int index = lookupPath.lastIndexOf("/");
        String lookup = lookupPath.substring(0, index);
        String pth = path;
        while (pth.startsWith("../")) {
            if (lookup.length() <= 0) {
                return null;
            }
            index = lookup.lastIndexOf("/");
            lookup = lookup.substring(0, index);
            index = pth.indexOf("../") + 3;
            pth = pth.substring(index);
        }
        return lookup + "/" + pth;
    }

    public static String appendPath(String directoryName, String fileName) {
        if (directoryName == null || fileName == null) {
            return null;
        }
        String slash = File.separator;
        if (!directoryName.endsWith(slash)) {
            directoryName = directoryName + slash;
        }
        if (fileName.startsWith(slash)) {
            fileName = fileName.substring(slash.length());
        }
        return directoryName + fileName;
    }

    public static File resolveFile(File baseFile, String filename) {
        String filenm = null;
        if ('/' != File.separatorChar) {
            filenm = filename.replace('/', File.separatorChar);
        }
        if ('\\' != File.separatorChar) {
            filenm = filename.replace('\\', File.separatorChar);
        }
        if (filenm.startsWith(File.separator)) {
            File file = new File(filenm);
            try {
                file = file.getCanonicalFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return file;
        }
        char[] chars = filename.toCharArray();
        StringBuffer sb = new StringBuffer();
        int start = 0;
        if ('\\' == File.separatorChar) {
            sb.append(filenm.charAt(0));
            ++start;
        }
        for (int i = start; i < chars.length; ++i) {
            boolean doubleSeparator;
            boolean bl = doubleSeparator = File.separatorChar == chars[i] && File.separatorChar == chars[i - 1];
            if (doubleSeparator) continue;
            sb.append(chars[i]);
        }
        filenm = sb.toString();
        File file = new File(baseFile, filenm).getAbsoluteFile();
        try {
            file = file.getCanonicalFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return file;
    }

    public static void forceDelete(String file) throws IOException {
        FileUtil.forceDelete(new File(file));
    }

    public static void forceDelete(File file) throws IOException {
        if (!file.exists()) {
            return;
        }
        if (file.isDirectory()) {
            FileUtil.deleteDirectory(file);
        } else if (!file.delete()) {
            throw new IOException("File " + file + " could not be deleted.");
        }
    }

    public static void forceCleanDirectory(File directory, boolean recursive) throws IOException {
        if (!directory.exists()) {
            return;
        }
        if (!directory.isDirectory()) {
            throw new IOException(directory + " is not a directory");
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (!recursive) continue;
                FileUtil.forceCleanDirectory(file, true);
                file.delete();
                continue;
            }
            file.delete();
        }
    }

    public static void deleteDirectory(String directory) throws IOException {
        FileUtil.deleteDirectory(new File(directory));
    }

    public static File createFile(String path) {
        File lFile = new File(path);
        lFile.mkdirs();
        return lFile;
    }

    public static String createFile(String path, List subFolders, String fileName) {
        StringBuffer lBuffer = new StringBuffer(path);
        if (subFolders != null) {
            for (int i = 0; i < subFolders.size(); ++i) {
                lBuffer.append(File.separator);
                lBuffer.append(subFolders.get(i));
            }
        }
        FileUtil.createFile(lBuffer.toString());
        if (fileName != null) {
            lBuffer.append(File.separator);
            lBuffer.append(fileName);
        }
        return lBuffer.toString();
    }

    public static void deleteDirectory(File directory) throws IOException {
        if (!directory.exists()) {
            return;
        }
        FileUtil.cleanDirectory(directory);
        if (!directory.delete()) {
            throw new IOException("Directory " + directory + " could not be deleted.");
        }
    }

    public static void cleanDirectory(String directory) throws IOException {
        FileUtil.cleanDirectory(new File(directory));
    }

    public static void cleanDirectory(File directory) throws IOException {
        FileUtil.cleanDirectory(directory, true);
    }

    public static void cleanDirectory(String directory, boolean recursive) throws IOException {
        FileUtil.cleanDirectory(new File(directory), recursive);
    }

    public static void cleanDirectory(File directory, boolean recursive) throws IOException {
        if (!directory.exists()) {
            throw new FileNotFoundException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IOException(directory + " is not a directory");
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (!recursive) continue;
                FileUtil.deleteDirectory(file);
                continue;
            }
            FileUtil.forceDelete(file);
        }
    }

    public static void cleanDirectory(String directory, boolean recursive, int olderThanDays) throws IOException {
        FileUtil.cleanDirectory(new File(directory), recursive, olderThanDays);
    }

    public static void cleanDirectory(File directory, boolean recursive, int olderThanDays) throws IOException {
        if (!directory.exists()) {
            throw new FileNotFoundException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IOException(directory + " is not a directory");
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                if (!recursive) continue;
                FileUtil.cleanDirectory(file, recursive, olderThanDays);
                if (!FileUtil.isFolderEmpty(file.getPath())) continue;
                FileUtil.deleteDirectory(file);
                continue;
            }
            if (!FileUtil.isOlderThenGivenDays(file, olderThanDays)) continue;
            FileUtil.forceDelete(file);
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("MM/dd/yyyy HH:mm:ss");
            log.info("Cleanup Job : Delete " + file.getAbsolutePath() + "Last Modified :" + simpleDateFormat.format(file.lastModified()));
        }
    }

    public static void cleanDirectory(File directory, String extension) throws IOException {
        if (!directory.exists()) {
            throw new FileNotFoundException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IOException(directory + " is not a directory");
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            String lExtension;
            File file = files[i];
            if (file.isDirectory()) {
                FileUtil.deleteDirectory(file);
                continue;
            }
            if (extension == null || (lExtension = FileUtil.getExtension(file.getName())).equalsIgnoreCase(extension)) continue;
            FileUtil.forceDelete(file);
        }
    }

    public static void cleanDirectory(String directory, String extension) throws IOException {
        FileUtil.cleanDirectory(new File(directory), extension);
    }

    private static String replaceSubString(String original, String oldString, String newString) {
        StringBuffer sb = new StringBuffer();
        int end = original.indexOf(oldString);
        int start = 0;
        int stringSize = oldString.length();
        while (end != -1) {
            sb.append(original.substring(start, end));
            sb.append(newString);
            start = end + stringSize;
            end = original.indexOf(oldString, start);
        }
        end = original.length();
        sb.append(original.substring(start, end));
        return sb.toString();
    }

    public static long sizeOfDirectory(String directory) {
        return FileUtil.sizeOfDirectory(new File(directory));
    }

    public static long sizeOfDirectory(File directory) {
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        long size = 0L;
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (file.isDirectory()) {
                size += FileUtil.sizeOfDirectory(file);
                continue;
            }
            size += file.length();
        }
        return size;
    }

    public static boolean isFolderEmpty(String folder) {
        File file = new File(folder);
        String[] files = file.list();
        return files == null || files.length == 0;
    }

    public static void listFilesRecursive(String dirPath, List filesList) {
        FileUtil.listFilesRecursive(dirPath, filesList, null);
    }

    public static void listFilesRecursive(String dirPath, List filesList, String extension) {
        FileUtil.listFilesRecursive(new File(dirPath), filesList, extension);
    }

    public static void listFilesRecursive(File dirPath, List filesList, String extension) {
        File[] files = null;
        if (dirPath.isDirectory()) {
            files = dirPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtil.listFilesRecursive(files[i], filesList, extension);
            }
        } else if (extension == null || FileUtil.getExtension(dirPath.getName()).equals(extension)) {
            filesList.add(dirPath.getAbsolutePath());
        }
    }

    public static void listObjectFilesRecursive(File dirPath, List filesList, String extension) {
        File[] files = null;
        if (dirPath.isDirectory()) {
            files = dirPath.listFiles();
            for (int i = 0; i < files.length; ++i) {
                FileUtil.listObjectFilesRecursive(files[i], filesList, extension);
            }
        } else if (extension == null || FileUtil.getExtension(dirPath.getName()).equals(extension)) {
            filesList.add(dirPath);
        }
    }

    public static void listFilesRecursive(File dirPath, List filesList) {
        FileUtil.listFilesRecursive(dirPath, filesList, null);
    }

    public static void listDirsRecursive(String dirPath, List filesList) {
        File file = new File(dirPath);
        if (file.isDirectory()) {
            String[] list = file.list();
            for (int i = 0; i < list.length; ++i) {
                FileUtil.listDirsRecursive(dirPath + File.separatorChar + list[i], filesList);
            }
        }
        if (file.isDirectory()) {
            filesList.add(dirPath);
        }
    }

    public static File[] getSubDirectories(File directory) {
        File[] lFiles = directory.listFiles(new DirectoryFilter());
        return lFiles;
    }

    public static File[] getFilesOnlyFromDirectory(File directory) {
        File[] lFiles = directory.listFiles(new FilesFilter());
        return lFiles;
    }

    public static String[] getFileNamesWithExtension(File directory, String extension) {
        String[] lDirFiles = directory.list(new ExtensionFilter(extension));
        return lDirFiles;
    }

    public static File[] getFilesWithExtension(File directory, String extension) {
        File[] lFiles = directory.listFiles(new ExtensionFilter(extension));
        return lFiles;
    }

    public static String[] getFiles(File directory, String regExp) {
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        String[] lDirFiles = directory.list(new WildCardFilter(regExp));
        return lDirFiles;
    }

    public static String getFileRoot(String path) {
        File file = new File(path);
        String parent = file.getParent();
        if (parent == null) {
            return path;
        }
        return FileUtil.getFileRoot(parent);
    }

    public static byte[] getBytesFromFile(File file) throws IOException {
        int offset;
        FileInputStream is = new FileInputStream(file);
        long length = file.length();
        if (length > Integer.MAX_VALUE) {
            throw new IOException("File is too large " + file.getName());
        }
        byte[] bytes = new byte[(int)length];
        int numRead = 0;
        for (offset = 0; offset < bytes.length && (numRead = ((InputStream)is).read(bytes, offset, bytes.length - offset)) >= 0; offset += numRead) {
        }
        if (offset < bytes.length) {
            throw new IOException("Could not completely read file " + file.getName());
        }
        ((InputStream)is).close();
        return bytes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File aFile) {
        StringBuffer contents = new StringBuffer();
        BufferedReader input = null;
        try {
            input = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(aFile), "utf-8"));
            String line = null;
            while ((line = input.readLine()) != null) {
                contents.append(line);
                contents.append(System.getProperty("line.separator"));
            }
        }
        catch (FileNotFoundException fileNotFoundException) {
            IOUtils.closeQuietly(input);
        }
        catch (IOException iOException) {
            IOUtils.closeQuietly(input);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)input);
        return contents.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getContents(File aFile, String charsetName) throws IOException {
        StringWriter writer = null;
        FileInputStream input = null;
        String contents = null;
        try {
            writer = new StringWriter();
            input = new FileInputStream(aFile);
            IOUtils.copy((InputStream)input, (Writer)writer, (String)charsetName);
            contents = writer.toString();
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(input);
            IOUtils.closeQuietly((Writer)writer);
            throw throwable;
        }
        IOUtils.closeQuietly((InputStream)input);
        IOUtils.closeQuietly((Writer)writer);
        return contents;
    }

    public static File getHashDirectory(File rootFolder, String directoryPrefix, int filePerDir, int hashCode) {
        int targetDirIndex = hashCode % filePerDir;
        File new_set_f = null;
        new_set_f = new File(rootFolder, directoryPrefix + targetDirIndex);
        if (!new_set_f.exists()) {
            new_set_f.mkdirs();
        }
        return new_set_f;
    }

    public static File getNextDirectory(File rootFolder, String directoryPrefix, int filePerDir) {
        DirectoryPrefixFilter sff = new DirectoryPrefixFilter(directoryPrefix);
        File[] fs = rootFolder.listFiles(sff);
        int lastDir = -1;
        int lastDirIndex = 0;
        for (int i = 0; i < fs.length; ++i) {
            String s_num = fs[i].getName().substring(directoryPrefix.length());
            int num = Integer.parseInt(s_num);
            if (num <= lastDir) continue;
            lastDir = num;
            lastDirIndex = i;
        }
        File set_f = null;
        File new_set_f = null;
        if (lastDir == -1) {
            set_f = new File(rootFolder, directoryPrefix + "1");
            set_f.mkdirs();
        } else {
            set_f = fs[lastDirIndex];
        }
        if (set_f.list().length > filePerDir - 1) {
            new_set_f = new File(rootFolder, directoryPrefix + (lastDir + 1));
            new_set_f.mkdirs();
        } else {
            new_set_f = set_f;
        }
        return new_set_f;
    }

    public static long getFileSize(String fileName) {
        long length = -1L;
        if (fileName != null) {
            length = new File(fileName).length();
        }
        return length;
    }

    public static String normalizeFileName(String fileName) {
        fileName = fileName.replace(' ', '_').toLowerCase();
        return fileName;
    }

    public static String fileNameNormalizer(String name) {
        if (SystemUtils.IS_OS_WINDOWS) {
            return name.replaceAll("[\\/:*?\"<>|]", "");
        }
        return name.replaceAll("[/]", "");
    }

    public static String normalizeUrlToFileName(String fileName) {
        fileName = fileName.replaceAll("/", "{sl}");
        fileName = fileName.replaceAll("\\\\", "{bs}");
        fileName = fileName.replaceAll(":", "{sc}");
        fileName = fileName.replaceAll("\\*", "{x}");
        fileName = fileName.replaceAll("\\?", "{qm}");
        fileName = fileName.replaceAll("\"", "{qt}");
        fileName = fileName.replaceAll("<", "{lt}");
        fileName = fileName.replaceAll(">", "{gt}");
        fileName = fileName.replaceAll("\\|", "{p}");
        fileName = fileName.replaceAll("%", "{pct}");
        fileName = fileName.replaceAll("&", "{amp}");
        fileName = fileName.replace(' ', '_').toLowerCase();
        return fileName;
    }

    public static String normalizeFileNameToUrl(String fileName) {
        fileName = fileName.replaceAll("\\{sl\\}", "/");
        fileName = fileName.replaceAll("\\{bs\\}", "\\");
        fileName = fileName.replaceAll("\\{sc\\}", ":");
        fileName = fileName.replaceAll("\\{x\\}", "*");
        fileName = fileName.replaceAll("\\{qm\\}", "?");
        fileName = fileName.replaceAll("\\{qt\\}", "\"");
        fileName = fileName.replaceAll("\\{lt\\}", "<");
        fileName = fileName.replaceAll("\\{gt\\}", ">");
        fileName = fileName.replaceAll("\\{p\\}", "|");
        fileName = fileName.replaceAll("\\{pct\\}", "%");
        fileName = fileName.replaceAll("\\{amp\\}", "&");
        fileName = fileName.replace('_', ' ').toLowerCase();
        return fileName;
    }

    public static void writeFile(File file, String text) throws IOException {
        FileUtil.writeFile(file, text, false);
    }

    public static void writeFile(File file, String text, boolean append) throws IOException {
        if (!file.exists()) {
            file.getParentFile().mkdirs();
            file.createNewFile();
        }
        OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(file, append), "UTF-8");
        BufferedWriter out = new BufferedWriter(writer);
        out.write(text);
        out.close();
    }

    public static void writeBytesToFile(File file, byte[] stream) throws IOException {
        FileOutputStream outStream = new FileOutputStream(file);
        ((OutputStream)outStream).write(stream);
        ((OutputStream)outStream).close();
    }

    public static String getFileTail(String fileName, int numberOfLines) {
        try {
            long currentPosition;
            String lineSeparator = System.getProperty("line.separator");
            RandomAccessFile file = new RandomAccessFile(new File(fileName), "r");
            long fileLength = file.length();
            file.seek(fileLength);
            int testLineSeparator = 0;
            byte[] buffer = new byte[lineSeparator.length()];
            String currChar = null;
            ++numberOfLines;
            for (currentPosition = 0L; currentPosition < fileLength && testLineSeparator < numberOfLines; ++currentPosition) {
                file.seek(fileLength - currentPosition);
                try {
                    file.read(buffer);
                    currChar = new String(buffer);
                    if (!lineSeparator.equals(currChar)) continue;
                    ++testLineSeparator;
                    continue;
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
            file.seek(fileLength - currentPosition + 1L);
            byte[] content = new byte[(int)currentPosition - 1];
            file.readFully(content);
            file.close();
            return new String(content);
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public static List<File> getEmptyDirectories(File root) {
        DirInfo dirInfo = FileUtil.findEmptyDirectories(root);
        return dirInfo.getEmptyDirectories();
    }

    private static DirInfo findEmptyDirectories(File root) {
        ArrayList<File> directories = new ArrayList<File>();
        FileUtil fileUtil = SINGLE_INSTANCE;
        fileUtil.getClass();
        DirInfo dirInfo = fileUtil.new DirInfo();
        dirInfo.setEmpty(true);
        if (root.isDirectory()) {
            File[] filesInRoot = root.listFiles();
            DirInfo innerDirInfo = null;
            for (int i = 0; i < filesInRoot.length; ++i) {
                File currFile = filesInRoot[i];
                if (currFile.isDirectory()) {
                    innerDirInfo = FileUtil.findEmptyDirectories(currFile);
                    directories.addAll(innerDirInfo.getEmptyDirectories());
                    if (!innerDirInfo.isEmpty()) {
                        dirInfo.setEmpty(false);
                        continue;
                    }
                    directories.add(currFile);
                    continue;
                }
                dirInfo.setEmpty(false);
            }
        }
        dirInfo.setEmptyDirectories(directories);
        return dirInfo;
    }

    public static void main(String[] args) {
        System.out.println(FileUtil.appendPath("a\\b\\c", "d"));
        System.out.println(FileUtil.appendPath("a\\b\\c\\", "d"));
        System.out.println(FileUtil.appendPath("a\\b\\c\\", "\\d"));
        System.out.println(FileUtil.appendPath("a\\b\\c\\", "\\d\\e"));
        System.out.println(FileUtil.appendPath("a\\b\\c\\", null));
        DirInfo dirInfo = FileUtil.findEmptyDirectories(new File("C:\\ng\\digitool\\home\\profile\\storage"));
        List<File> directories = dirInfo.getEmptyDirectories();
        System.out.println(directories.size());
        for (File element : directories) {
            System.out.println(element.getAbsolutePath());
        }
    }

    public static boolean isFileExist(String normalizeFileName) {
        return new File(normalizeFileName).exists();
    }

    public static void streamToFile(InputStream in, String filePath) throws IOException {
        int len;
        FileOutputStream out = new FileOutputStream(filePath);
        byte[] buf = new byte[1024];
        while ((len = in.read(buf)) > 0) {
            ((OutputStream)out).write(buf, 0, len);
        }
        in.close();
        ((OutputStream)out).close();
    }

    public static String getFileContent(String fileName) {
        StringBuffer sb = new StringBuffer();
        try {
            InputStream in = Thread.currentThread().getContextClassLoader().getResourceAsStream(fileName);
            BufferedReader br = new BufferedReader(new InputStreamReader(in));
            String line = null;
            while ((line = br.readLine()) != null) {
                sb.append(line);
            }
        }
        catch (Exception e) {
            return null;
        }
        return sb.toString();
    }

    public static boolean appendStringToFile(String filePath, String appended) {
        FileWriter fw = null;
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
            }
            fw = new FileWriter(filePath, true);
            fw.write(appended);
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String readStringFromFile(String filePath, String seperator, String byString) {
        FileInputStream in = null;
        InputStreamReader isr = null;
        String requestedString = null;
        try {
            File file = new File(filePath);
            in = new FileInputStream(file);
            isr = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                if (!byString.equals(line.split(seperator)[0])) continue;
                requestedString = line.split(seperator)[1];
                break;
            }
            IOUtil.closeQuietly(in);
        }
        catch (Exception e) {
            String string = null;
            return string;
        }
        finally {
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(isr);
        }
        IOUtil.closeQuietly(isr);
        return requestedString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getFileContentAsMap(String filePath, String seperator) {
        File file;
        HashMap<String, String> results;
        InputStreamReader isr;
        FileInputStream in;
        block6: {
            in = null;
            isr = null;
            results = new HashMap<String, String>();
            file = new File(filePath);
            if (file.exists()) break block6;
            Map<String, String> map = null;
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(isr);
            return map;
        }
        try {
            in = new FileInputStream(file);
            isr = new InputStreamReader(in);
            BufferedReader br = new BufferedReader(isr);
            String line = null;
            while ((line = br.readLine()) != null) {
                results.put(line.split(seperator)[0], line.split(seperator)[1]);
            }
        }
        catch (Exception e) {
            Map<String, String> map;
            try {
                log.error("Failed to get file content from file " + filePath, e, new String[0]);
                map = null;
            }
            catch (Throwable throwable) {
                IOUtil.closeQuietly(in);
                IOUtil.closeQuietly(isr);
                throw throwable;
            }
            IOUtil.closeQuietly(in);
            IOUtil.closeQuietly(isr);
            return map;
        }
        IOUtil.closeQuietly(in);
        IOUtil.closeQuietly(isr);
        return results;
    }

    public static boolean isOlderThenGivenDays(File file, int days) {
        Date lastModified = new Date(file.lastModified());
        Calendar calendar = Calendar.getInstance();
        calendar.add(5, -1 * days);
        return lastModified.before(calendar.getTime());
    }

    public static boolean isEmptyAvailableDirectory(String path) {
        try {
            File file = new File(FilenameUtils.normalize((String)path).trim());
            if (file.exists() && file.isDirectory()) {
                File[] files = file.listFiles();
                if (files == null || files.length == 0) {
                    return true;
                }
                for (File f : files) {
                    if (f.isHidden()) continue;
                    return false;
                }
                return true;
            }
        }
        catch (Exception e) {
            log.error("isEmptyAvailableDirectory Failed for " + path, e, new String[0]);
        }
        return false;
    }

    public static boolean isDirectoryEmptyOrContainsOnlyEmptyDirectories(String directory) {
        return FileUtil.isDirectoryEmptyOrContainsOnlyEmptyDirectories(new File(directory));
    }

    public static boolean isDirectoryEmptyOrContainsOnlyEmptyDirectories(File directory) {
        if (!directory.exists()) {
            throw new IllegalArgumentException(directory + " does not exist");
        }
        if (!directory.isDirectory()) {
            throw new IllegalArgumentException(directory + " is not a directory");
        }
        File[] files = directory.listFiles();
        boolean isEmpty = true;
        for (int i = 0; isEmpty && i < files.length; ++i) {
            File file = files[i];
            if (!file.isDirectory()) {
                return false;
            }
            isEmpty = FileUtil.isDirectoryEmptyOrContainsOnlyEmptyDirectories(file);
        }
        return isEmpty;
    }

    public static void createSoftLink(String srcPath, String destPath) throws IOException {
        File source = new File(srcPath);
        if (!source.exists()) {
            throw new IOException("File " + source + " does not exist");
        }
        File destination = new File(destPath);
        if (destination.exists()) {
            if (srcPath.equals(destination.getCanonicalPath())) {
                return;
            }
            throw new IOException("Failed to create soft link: " + destPath + "already exists.");
        }
        File parentFile = destination.getParentFile();
        if (parentFile != null && !parentFile.exists()) {
            parentFile.mkdirs();
        }
        String command = "ln";
        ExecExternalProcess proc = new ExecExternalProcess();
        ArrayList<String> args = new ArrayList<String>();
        args.add("-s");
        args.add(srcPath);
        args.add(destPath);
        int retValue = proc.execExternalProcess(command, args);
        if (retValue != 0) {
            throw new IOException("ln -s " + srcPath + " " + destPath + " failed " + proc.getErrorStream() + proc.getInputStream());
        }
    }

    private class DirInfo {
        private List<File> emptyDirectories;
        private boolean isEmpty;

        private DirInfo() {
        }

        public List<File> getEmptyDirectories() {
            return this.emptyDirectories;
        }

        public void setEmptyDirectories(List<File> emptyDirectories) {
            this.emptyDirectories = emptyDirectories;
        }

        public boolean isEmpty() {
            return this.isEmpty;
        }

        public void setEmpty(boolean isEmpty) {
            this.isEmpty = isEmpty;
        }
    }

    private static class WildCardFilter
    implements FilenameFilter {
        String wildPattern = null;
        Vector pattern = new Vector();
        final String FIND = "find";
        final String EXPECT = "expect";
        final String ANYTHING = "anything";
        final String NOTHING = "nothing";

        public WildCardFilter(String wildString) {
            this.wildPattern = wildString;
            wildString = wildString.toLowerCase();
            int i = wildString.indexOf("**");
            while (i >= 0) {
                wildString = wildString.substring(0, i + 1) + wildString.substring(i + 2);
                i = wildString.indexOf("**");
            }
            StringTokenizer tokens = new StringTokenizer(wildString, "*", true);
            String token = null;
            while (tokens.hasMoreTokens()) {
                token = tokens.nextToken();
                if (token.equals("*")) {
                    this.pattern.addElement("find");
                    if (tokens.hasMoreTokens()) {
                        token = tokens.nextToken();
                        this.pattern.addElement(token);
                        continue;
                    }
                    this.pattern.addElement("anything");
                    continue;
                }
                this.pattern.addElement("expect");
                this.pattern.addElement(token);
            }
            if (!token.equals("*")) {
                this.pattern.addElement("expect");
                this.pattern.addElement("nothing");
            }
        }

        @Override
        public boolean accept(File dir, String name) {
            File tempFile;
            String path = dir.getPath();
            if (!path.endsWith("/") && !path.endsWith("\\")) {
                path = path + File.separator;
            }
            if ((tempFile = new File(path, name)).isDirectory()) {
                return true;
            }
            name = name.toLowerCase();
            boolean acceptName = true;
            String command = null;
            String param = null;
            int currPos = 0;
            for (int cmdPos = 0; cmdPos < this.pattern.size(); cmdPos += 2) {
                int nextPos;
                command = (String)this.pattern.elementAt(cmdPos);
                param = (String)this.pattern.elementAt(cmdPos + 1);
                if (command.equals("find")) {
                    if (param.equals("anything")) break;
                    nextPos = name.indexOf(param, currPos);
                    if (nextPos >= 0) {
                        currPos = nextPos + param.length();
                        continue;
                    }
                    acceptName = false;
                    break;
                }
                if (!command.equals("expect")) continue;
                if (param.equals("nothing")) {
                    if (currPos == name.length()) break;
                    acceptName = false;
                    break;
                }
                nextPos = name.indexOf(param, currPos);
                if (nextPos != currPos) {
                    acceptName = false;
                    break;
                }
                currPos += param.length();
            }
            return acceptName;
        }

        public String toString() {
            return this.wildPattern;
        }

        public String toPattern() {
            StringBuffer out = new StringBuffer();
            for (int i = 0; i < this.pattern.size(); i += 2) {
                out.append("(");
                out.append((String)this.pattern.elementAt(i));
                out.append(" ");
                out.append((String)this.pattern.elementAt(i + 1));
                out.append(") ");
            }
            return out.toString();
        }
    }

    public static class ExtensionFilter
    implements FilenameFilter {
        private final String extension;

        public ExtensionFilter(String extension) {
            if (extension.startsWith(".")) {
                extension = extension.substring(1);
            }
            this.extension = extension;
        }

        @Override
        public boolean accept(File dir, String name) {
            return FileUtil.getExtension(name).equals(this.extension);
        }
    }

    public static class FilesFilter
    implements FileFilter {
        @Override
        public boolean accept(File f) {
            return !f.isDirectory();
        }
    }

    public static class DirectoryPrefixFilter
    implements FileFilter {
        private String prefix = "";

        private DirectoryPrefixFilter() {
        }

        public DirectoryPrefixFilter(String prefix) {
            this.prefix = prefix;
        }

        @Override
        public boolean accept(File f) {
            String name = f.getName().toLowerCase();
            return f.isDirectory() && name.startsWith(this.prefix);
        }
    }

    public static class DirectoryFilter
    implements FileFilter {
        @Override
        public boolean accept(File f) {
            return f.isDirectory();
        }
    }
}

