/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.dnx;

import com.exlibris.core.infra.common.exceptions.logging.DescriptorConstants;
import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.core.infra.common.util.ResourceBundleUtil;
import com.exlibris.core.infra.svc.api.CodeTablesResourceBundle;
import com.exlibris.core.infra.svc.api.common.DateHandler;
import com.exlibris.core.sdk.consts.Enum;
import com.exlibris.core.sdk.storage.containers.StoredEntityMetaData;
import com.exlibris.core.sdk.strings.StringUtils;
import com.exlibris.digitool.common.dnx.DNXConstants;
import com.exlibris.digitool.common.dnx.DNXProfile;
import com.exlibris.digitool.common.dnx.DnxDocumentFactory;
import com.exlibris.digitool.common.dnx.DnxDocumentHelper;
import com.exlibris.digitool.common.dnx.DnxErrorReport;
import com.exlibris.digitool.common.dnx.DnxRecordKey;
import com.exlibris.digitool.common.dnx.DnxSection;
import com.exlibris.digitool.common.dnx.DnxSectionRecord;
import com.exlibris.digitool.common.dnx.DnxValidator;
import com.exlibris.digitool.common.dnx.DnxValidatorDefaultImpl;
import com.exlibris.digitool.common.storage.Fixity;
import com.exlibris.digitool.exceptions.DepositProcessingException;
import com.exlibris.digitool.exceptions.DigitoolException;
import com.exlibris.repository.persistence.HDeProvenance;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.ResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.dom4j.Document;
import org.dom4j.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DnxDocument
implements Serializable {
    protected static ExLogger log = ExLogger.getExLogger(DnxDocument.class);
    public static String ID = "id";
    public static String SECTION = "section";
    public static String RECORD = "record";
    public static String KEY = "key";
    public static String Q1 = "q1";
    public static String Q2 = "q2";
    public static final String FORMAT_NAME_VERSION_SEPARATOR = ":";
    private static final String VERSION_ATT = "version";
    private transient Document document = null;
    private String documentXml = null;
    private transient DNXProfile profile = null;
    private transient List<DnxSection> sectionsList = new ArrayList<DnxSection>();
    private transient DnxValidator validator = null;

    DnxDocument(Document document, DNXProfile profile) {
        this.document = document;
        this.profile = profile;
        this.validator = new DnxValidatorDefaultImpl(profile);
        this.documentXml = document.asXML();
    }

    public List<Fixity> getFixities() {
        DnxDocumentHelper dnxHelper = new DnxDocumentHelper(this);
        List<DnxDocumentHelper.FileFixity> fileFixities = dnxHelper.getFileFixitys();
        ArrayList<Fixity> fixities = new ArrayList<Fixity>();
        for (DnxDocumentHelper.FileFixity fileFixity : fileFixities) {
            fixities.add(new Fixity(fileFixity.getFixityType(), fileFixity.getFixityValue(), fileFixity.getPluginName()));
        }
        return fixities;
    }

    public StoredEntityMetaData toStoredEntityMetaData() {
        List<DnxSectionRecord> recordList;
        DnxSection internalId;
        StoredEntityMetaData storedEntityMetaData = new StoredEntityMetaData();
        try {
            storedEntityMetaData.setSizeInBytes("" + this.getDocumentXml().getBytes("UTF-8").length);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        String type = this.getSectionKeyValue(DNXConstants.OBJECTCHARACTERISTICS.OBJECTTYPE);
        if (type != null) {
            if (type.equals("INTELLECTUAL_ENTITY")) {
                storedEntityMetaData.setEntityType(StoredEntityMetaData.EntityType.IE);
            } else if (type.equals("FILE")) {
                storedEntityMetaData.setEntityType(StoredEntityMetaData.EntityType.FILE);
                storedEntityMetaData.setSizeInBytes(this.getSectionKeyValue(DNXConstants.GENERALFILECHARACTERISTICS.FILESIZEBYTES));
                storedEntityMetaData.setFileExstention(this.getSectionKeyValue(DNXConstants.GENERALFILECHARACTERISTICS.FILEEXTENSION));
            }
        }
        if ((internalId = this.getSectionById("internalIdentifier")) != null && (recordList = internalId.getRecordList()) != null) {
            for (DnxSectionRecord record : recordList) {
                String currType = record.getSectionKeyValue(DNXConstants.INTERNALIDENTIFIER.INTERNALIDENTIFIERTYPE.sectionKeyId);
                if (!currType.equals("PID")) continue;
                String value = record.getSectionKeyValue(DNXConstants.INTERNALIDENTIFIER.INTERNALIDENTIFIERVALUE.sectionKeyId);
                storedEntityMetaData.setEntityPid(value);
            }
        }
        return storedEntityMetaData;
    }

    private List<DnxErrorReport> validate(DnxDocumentType type) {
        Enum.ObjectType objtype = null;
        if (DnxDocumentType.IE.equals((Object)type)) {
            objtype = Enum.ObjectType.INTELLECTUAL_ENTITY;
        } else if (DnxDocumentType.REPRESENTATION.equals((Object)type)) {
            objtype = Enum.ObjectType.REPRESENTATION;
        } else if (DnxDocumentType.FILE.equals((Object)type)) {
            objtype = Enum.ObjectType.FILE;
        }
        this.getValidator().setType(objtype);
        return this.getValidator().validate(this);
    }

    public List<DnxErrorReport> validateForIE() {
        return this.validate(DnxDocumentType.IE);
    }

    public List<DnxErrorReport> validateForRep() {
        return this.validate(DnxDocumentType.REPRESENTATION);
    }

    public List<DnxErrorReport> validateForFile() {
        return this.validate(DnxDocumentType.FILE);
    }

    private void correct(DnxDocumentType type) {
    }

    public void correctForIE() {
        this.correct(DnxDocumentType.IE);
    }

    public void correctForREP() {
        this.correct(DnxDocumentType.REPRESENTATION);
    }

    public void correctForFILE() {
        this.correct(DnxDocumentType.FILE);
    }

    public DnxSection createSection(String sectionId) {
        if (sectionId == null) {
            System.err.println("section \"id\" must not be null...");
            sectionId = "null";
        }
        Element element = this.getDocument().getRootElement().addElement(SECTION);
        element.addAttribute(ID, sectionId);
        DnxSection dnxSection = new DnxSection(this, element);
        this.getSectionsList().add(dnxSection);
        return dnxSection;
    }

    public void deleteSection(String sectionId) {
        DnxSection section = this.getSectionById(sectionId);
        if (null == section) {
            return;
        }
        this.getDocument().getRootElement().remove(section.getElement());
        this.getSectionsList().remove(this.getSectionById(sectionId));
    }

    public String toString() {
        return this.getDocument().asXML();
    }

    public List<DnxSection> getSectionsList() {
        if (this.document == null) {
            this.deserialize();
        }
        return this.sectionsList;
    }

    public DnxSection getSectionById(String sectionId) {
        for (DnxSection section : this.getSectionsList()) {
            if (!section.getId().equals(sectionId)) continue;
            return section;
        }
        return null;
    }

    public String getSectionKeyValue(DNXConstants.SectionKey sectionKey) {
        return this.getSectionKeyValue(sectionKey.sectionId, sectionKey.sectionKeyId);
    }

    public String getSectionKeyValue(String sectionId, String sectionKeyId) {
        DnxSection section = this.getSectionById(sectionId);
        if (section == null) {
            return null;
        }
        return section.getSectionKeyValue(sectionKeyId);
    }

    public String getRecordSectionKeyValue(String sectionId, String sectionKeyId, String recordKeyType) {
        DnxSection section = this.getSectionById(sectionId);
        if (section == null) {
            return null;
        }
        DnxSectionRecord record = this.findRecordInSection(sectionId, sectionKeyId, recordKeyType);
        if (record == null) {
            return null;
        }
        String sectionKeyValue = sectionKeyId.endsWith("Type") ? sectionKeyId.substring(0, sectionKeyId.lastIndexOf("Type")) + "Value" : sectionKeyId;
        return record.getSectionKeyValue(sectionKeyValue);
    }

    public void updateSectionKey(DNXConstants.SectionKey sectionKey, String value) {
        this.updateSectionKey(sectionKey.sectionId, sectionKey.sectionKeyId, value);
    }

    public void updateSectionKey(String sectionId, String keyId, String value) {
        DnxSection section = this.getSectionById(sectionId);
        if (section == null) {
            section = this.createSection(sectionId);
        }
        section.updateSectionKey(keyId, value);
    }

    public void updateRecordSectionKey(String sectionId, String keyId, String type, String value) {
        DnxSectionRecord record;
        DnxSection section = this.getSectionById(sectionId);
        if (null == section) {
            section = this.createSection(sectionId);
        }
        if ((record = this.findRecordInSection(sectionId, keyId, type)) == null) {
            record = section.createRecord();
            record.updateKey(keyId, type);
            if (sectionId.equals("fileFixity")) {
                record.updateKey("fixityValue", value);
            } else {
                record.updateKey(sectionId + "Value", value);
            }
        } else if (sectionId.equals("fileFixity")) {
            record.updateKey("fixityValue", value);
        } else {
            record.updateKey(sectionId + "Value", value);
        }
    }

    public void updateRecordSectionKey(String sectionId, String keyId, String value) {
        DnxSectionRecord record;
        DnxSection section = this.getSectionById(sectionId);
        if (null == section) {
            section = this.createSection(sectionId);
        }
        if ((record = this.findRecordInSection(sectionId, keyId)) == null) {
            DnxSectionRecord dnxSectionRecord = record = section.getRecordList().isEmpty() ? null : section.getRecordList().get(0);
            if (record == null) {
                record = section.createRecord();
            }
            record.updateKey(keyId, value);
        } else {
            record.updateKey(keyId, value);
        }
        if (record.getKeylist().isEmpty()) {
            section.removeRecord(record);
            if (section.getRecordList().isEmpty()) {
                this.deleteSection(section.getId());
            }
        }
    }

    private DnxDocument filterSectionsByAmdType(AmdType amdType) {
        if (this.getProfile() == null) {
            System.out.println("no profile is assigned...");
            return DnxDocumentFactory.getInstance().createDnxDocument();
        }
        DnxDocument filteredDoc = DnxDocumentFactory.getInstance().createDnxDocument();
        List<DnxSection> list = this.getSectionsList();
        boolean hasVersion = true;
        for (DnxSection dnxSection : list) {
            if (dnxSection.getElement().getDocument().getRootElement().attributeValue(VERSION_ATT) == null) {
                hasVersion = false;
            }
            String sectionId = dnxSection.getId();
            if (amdType.equals((Object)AmdType.TECHMD) && this.getProfile().isRelevantForTechMD(sectionId)) {
                filteredDoc.copySectionIntoDoc(dnxSection);
            }
            if (amdType.equals((Object)AmdType.DIGIPROVMD) && this.getProfile().isRelevantForDigiprovMD(sectionId)) {
                filteredDoc.copySectionIntoDoc(dnxSection);
            }
            if (amdType.equals((Object)AmdType.RIGHTSMD) && this.getProfile().isRelevantForRightsMD(sectionId)) {
                filteredDoc.copySectionIntoDoc(dnxSection);
            }
            if (!amdType.equals((Object)AmdType.SOURCEMD) || !this.getProfile().isRelevantForSourceMD(sectionId)) continue;
            filteredDoc.copySectionIntoDoc(dnxSection);
        }
        if (!hasVersion && filteredDoc.getDocument().getRootElement().attribute(VERSION_ATT) != null) {
            filteredDoc.getDocument().getRootElement().attribute(VERSION_ATT).detach();
        }
        return filteredDoc;
    }

    private void copySectionIntoDoc(DnxSection sourceSection) {
        DnxSection targetSection = this.createSection(sourceSection.getId());
        List<DnxSectionRecord> recordList = sourceSection.getRecordList();
        for (DnxSectionRecord sourceRecord : recordList) {
            DnxSectionRecord targetRecord = targetSection.createRecord();
            List<DnxRecordKey> keyList = sourceRecord.getKeylist();
            for (DnxRecordKey sourceRecordKey : keyList) {
                targetRecord.createKey(sourceRecordKey.getId(), sourceRecordKey.getQ1(), sourceRecordKey.getQ2(), sourceRecordKey.getValue(), false);
            }
        }
    }

    public void parseXmlToEventSection(String eventRecordXml) throws DepositProcessingException, IOException {
        try {
            DnxSection eventSection = this.getSectionById("event");
            if (eventSection == null) {
                eventSection = this.createSection("event");
            }
            DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            InputSource is = new InputSource();
            is.setCharacterStream(new StringReader(eventRecordXml));
            org.w3c.dom.Document doc = documentBuilder.parse(is);
            NodeList recordList = doc.getElementsByTagName(RECORD);
            for (int i = 0; i < recordList.getLength(); ++i) {
                Node currentNode = recordList.item(i);
                DnxSectionRecord eventRecord = eventSection.createRecord();
                NodeList keyValueList = currentNode.getChildNodes();
                for (int j = 0; j < keyValueList.getLength(); ++j) {
                    Node keyValueNode = keyValueList.item(j);
                    if (!keyValueNode.getNodeName().equalsIgnoreCase(KEY) || !keyValueNode.getAttributes().item(0).getNodeName().equalsIgnoreCase(ID)) continue;
                    String key = keyValueNode.getAttributes().item(0).getNodeValue();
                    String value = keyValueNode.getTextContent();
                    eventRecord.updateKey(key, value);
                }
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            log.error("Failed parsing Event column content.", new String[0]);
            throw new DepositProcessingException(DescriptorConstants.DP_FailedConvertion, (Throwable)e);
        }
    }

    public void addEvent(HDeProvenance pEvent) {
        String description;
        DnxSection eventSection = this.getSectionById("event");
        if (eventSection == null) {
            eventSection = this.createSection("event");
        }
        DnxSectionRecord eventRecord = eventSection.createRecord();
        String eventDate = null;
        try {
            eventDate = DateHandler.getStringFormatFromCalendar(pEvent.getEventDateTime());
        }
        catch (Exception exception) {
            // empty catch block
        }
        eventRecord.updateKey(DNXConstants.EVENT.EVENTDATETIME.sectionKeyId, eventDate);
        eventRecord.updateKey(DNXConstants.EVENT.EVENTTYPE.sectionKeyId, pEvent.getEventType().toString());
        if (pEvent.getEventIdentifierType() != null) {
            eventRecord.updateKey(DNXConstants.EVENT.EVENTIDENTIFIERTYPE.sectionKeyId, pEvent.getEventIdentifierType());
        }
        if (pEvent.getEventIdentifierValue() != null) {
            eventRecord.updateKey(DNXConstants.EVENT.EVENTIDENTIFIERVALUE.sectionKeyId, pEvent.getEventIdentifierValue());
        }
        if (pEvent.getEventOutcome() != null) {
            eventRecord.updateKey(DNXConstants.EVENT.EVENTOUTCOME1.sectionKeyId, pEvent.getEventOutcome().toString());
        }
        if (pEvent.getEventOutcomeDetail() != null) {
            eventRecord.updateKey(DNXConstants.EVENT.EVENTOUTCOMEDETAIL1.sectionKeyId, pEvent.getEventOutcomeDetail());
        }
        if ((description = this.getDescription(pEvent)) != null) {
            eventRecord.updateKey(DNXConstants.EVENT.EVENTDESCRIPTION.sectionKeyId, description);
        }
        if (pEvent.getLinkingAgentIdentifierType() != null) {
            eventRecord.updateKey(DNXConstants.EVENT.LINKINGAGENTIDENTIFIERTYPE1.sectionKeyId, pEvent.getProvenanceLinkingAgentIdentifierType());
        }
        if (pEvent.getLinkingAgentIdentifierValue() != null) {
            if (pEvent.getLinkingAgentIdentifierValue1() != null) {
                eventRecord.updateKey(DNXConstants.EVENT.LINKINGAGENTIDENTIFIERVALUE1.sectionKeyId, pEvent.getLinkingAgentIdentifierValue1());
            } else {
                eventRecord.updateKey(DNXConstants.EVENT.LINKINGAGENTIDENTIFIERVALUE1.sectionKeyId, pEvent.getLinkingAgentIdentifierValue());
            }
        }
        if (pEvent.getLinkingAgentIdentifierValue2() != null) {
            eventRecord.updateKey(DNXConstants.EVENT.LINKINGAGENTIDENTIFIERVALUE2.sectionKeyId, pEvent.getLinkingAgentIdentifierValue2());
            eventRecord.updateKey(DNXConstants.EVENT.LINKINGAGENTIDENTIFIERTYPE2.sectionKeyId, pEvent.getProvenanceLinkingAgentIdentifierType());
        }
        if (pEvent.getLinkingAgentIdentifierValue3() != null) {
            eventRecord.updateKey(DNXConstants.EVENT.LINKINGAGENTIDENTIFIERVALUE3.sectionKeyId, pEvent.getLinkingAgentIdentifierValue3());
            eventRecord.updateKey(DNXConstants.EVENT.LINKINGAGENTIDENTIFIERTYPE3.sectionKeyId, pEvent.getProvenanceLinkingAgentIdentifierType());
        }
        if (pEvent.getLinkingAgentRole() != null) {
            eventRecord.updateKey(DNXConstants.EVENT.LINKINGAGENTROLE1.sectionKeyId, pEvent.getLinkingAgentRole());
        }
        if (pEvent.getEventParams().size() > 0) {
            eventRecord.updateKey(DNXConstants.EVENT.EVENTOUTCOMEDETAIL1.sectionKeyId, pEvent.getEventParamsStr());
        }
    }

    private void setLinkingAgentIdentifierType(HDeProvenance pEvent, DnxSectionRecord eventRecord) {
        String[] agents = pEvent.getProvenanceLinkingAgentIdentifierType().split(";");
        for (int i = 1; i < agents.length + 1; ++i) {
            eventRecord.updateKey(DNXConstants.EVENT.LINKINGAGENTIDENTIFIERTYPE.sectionKeyId + (i + 1), agents[i]);
        }
    }

    private String getDescription(HDeProvenance provenanceEvent) {
        String msg = "";
        String eventType = provenanceEvent.getEventIdentifierValue();
        if (!StringUtils.isEmptyString(eventType)) {
            String desc = "Event." + eventType;
            ResourceBundle bundle = CodeTablesResourceBundle.getDefaultBundle(null);
            msg = ResourceBundleUtil.getString(bundle, desc);
        } else if (provenanceEvent.getEventDescription() != null) {
            msg = provenanceEvent.getEventDescription();
        }
        return msg;
    }

    public DnxDocument getDnxDocumentForTechMd() {
        return this.filterSectionsByAmdType(AmdType.TECHMD);
    }

    public DnxDocument getDnxDocumentForDigiprovMd() {
        return this.filterSectionsByAmdType(AmdType.DIGIPROVMD);
    }

    public DnxDocument getDnxDocumentForRightshMd() {
        return this.filterSectionsByAmdType(AmdType.RIGHTSMD);
    }

    public DnxDocument getDnxDocumentForSourceMd() {
        return this.filterSectionsByAmdType(AmdType.SOURCEMD);
    }

    public DNXProfile getProfile() {
        if (this.document == null) {
            this.deserialize();
        }
        return this.profile;
    }

    public void setProfile(DNXProfile profile) {
        this.profile = profile;
    }

    public void mergeDnxDocuments(DnxDocument dnxRecordForTechMd, DnxDocument dnxRecordForDigiprovMd, DnxDocument dnxRecordForRightshMd, DnxDocument dnxRecordForSourceMd) {
        if (dnxRecordForTechMd != null) {
            this.mergeDnxDocument(dnxRecordForTechMd);
        }
        if (dnxRecordForDigiprovMd != null) {
            this.mergeDnxDocument(dnxRecordForDigiprovMd);
        }
        if (dnxRecordForRightshMd != null) {
            this.mergeDnxDocument(dnxRecordForRightshMd);
        }
        if (dnxRecordForSourceMd != null) {
            this.mergeDnxDocument(dnxRecordForSourceMd);
        }
    }

    public void mergeDnxDocument(DnxDocument dnxRecord) {
        List<DnxSection> list = dnxRecord.getSectionsList();
        for (DnxSection dnxSection : list) {
            this.copySectionIntoDoc(dnxSection);
        }
    }

    public static void main(String[] args) {
        DnxDocument doc = DnxDocumentFactory.getInstance().createDnxDocument();
        doc.updateSectionKey(DNXConstants.PRODUCER.ADDRESS1, "nesher 52");
        System.out.println("doc=" + doc.toString());
    }

    DnxSectionRecord findRecordInSection(String sectionId, String fieldName, String fieldValue) {
        if (null == sectionId || sectionId.trim().length() == 0) {
            return null;
        }
        if (null == fieldName || fieldName.trim().length() == 0) {
            return null;
        }
        DnxSection section = this.getSectionById(sectionId);
        if (null == section) {
            return null;
        }
        for (DnxSectionRecord record : section.getRecordList()) {
            if (!fieldValue.equals(record.getSectionKeyValue(fieldName))) continue;
            return record;
        }
        return null;
    }

    public DnxSectionRecord findRecordInSection(String sectionId, String fieldName) {
        if (null == sectionId || sectionId.trim().length() == 0) {
            return null;
        }
        if (null == fieldName || fieldName.trim().length() == 0) {
            return null;
        }
        DnxSection section = this.getSectionById(sectionId);
        if (null == section) {
            return null;
        }
        for (DnxSectionRecord record : section.getRecordList()) {
            if (record.getKeyById(fieldName) == null) continue;
            return record;
        }
        return null;
    }

    public void setFileFixity(String fixityAgent, String fixityType, String fixityValue) throws DigitoolException {
        DnxSectionRecord recordForGivenFixityType;
        DnxSection sectionFileFixity = this.getSectionById("fileFixity");
        if (null == sectionFileFixity) {
            sectionFileFixity = this.createSection("fileFixity");
        }
        if ((recordForGivenFixityType = this.findRecordInSection("fileFixity", DNXConstants.FILEFIXITY.FIXITYTYPE.sectionKeyId, fixityType)) == null) {
            recordForGivenFixityType = sectionFileFixity.createRecord();
            recordForGivenFixityType.updateKey(DNXConstants.FILEFIXITY.FIXITYTYPE.sectionKeyId, fixityType);
            recordForGivenFixityType.updateKey(DNXConstants.FILEFIXITY.FIXITYVALUE.sectionKeyId, fixityValue);
            return;
        }
        recordForGivenFixityType.updateKey(DNXConstants.FILEFIXITY.FIXITYTYPE.sectionKeyId, fixityType);
        recordForGivenFixityType.updateKey(DNXConstants.FILEFIXITY.FIXITYVALUE.sectionKeyId, fixityValue);
    }

    public List<String> getFileFixityTypes() {
        ArrayList<String> types = new ArrayList<String>();
        DnxSection sectionFileFixity = this.getSectionById("fileFixity");
        if (null != sectionFileFixity) {
            for (DnxSectionRecord record : sectionFileFixity.getRecordList()) {
                types.add(record.getSectionKeyValue(DNXConstants.FILEFIXITY.FIXITYTYPE.sectionKeyId));
            }
        }
        return types;
    }

    public void getFileFixityByType(String fixityType, StringBuffer fixityValue) {
        DnxSection sectionFileFixity = this.getSectionById("fileFixity");
        if (null == sectionFileFixity) {
            return;
        }
        DnxSectionRecord record = this.findRecordInSection("fileFixity", DNXConstants.FILEFIXITY.FIXITYTYPE.sectionKeyId, fixityType);
        if (null == record) {
            return;
        }
        fixityValue.append(record.getSectionKeyValue(DNXConstants.FILEFIXITY.FIXITYVALUE.sectionKeyId));
    }

    public void setVsOutcome(String type, String agent, String result, String resultDetails, String evaluation, String evaluationDetails) {
        DnxSectionRecord recordForGivenOutcomeType;
        String checkDate = DateHandler.getStringFormatFromCalendar(Calendar.getInstance());
        DnxSection sectionVsOutcome = this.getSectionById("vsOutcome");
        if (null == sectionVsOutcome) {
            sectionVsOutcome = this.createSection("vsOutcome");
        }
        if (null == (recordForGivenOutcomeType = this.findRecordInSection("vsOutcome", DNXConstants.VSOUTCOME.TYPE.sectionKeyId, type))) {
            recordForGivenOutcomeType = sectionVsOutcome.createRecord();
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.CHECKDATE.sectionKeyId, checkDate);
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.TYPE.sectionKeyId, type);
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.VSAGENT.sectionKeyId, agent);
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.RESULT.sectionKeyId, result);
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.RESULTDETAILS.sectionKeyId, resultDetails);
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.VSEVALUATION.sectionKeyId, evaluation);
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.VSEVALUATIONDETAILS.sectionKeyId, evaluationDetails);
        } else {
            String oldResult = recordForGivenOutcomeType.getSectionKeyValue(DNXConstants.VSOUTCOME.RESULT.sectionKeyId);
            if (!result.equals(oldResult)) {
                recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.CHECKDATE.sectionKeyId, checkDate);
            }
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.VSAGENT.sectionKeyId, agent);
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.RESULT.sectionKeyId, result);
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.RESULTDETAILS.sectionKeyId, resultDetails);
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.VSEVALUATION.sectionKeyId, evaluation);
            recordForGivenOutcomeType.updateKey(DNXConstants.VSOUTCOME.VSEVALUATIONDETAILS.sectionKeyId, evaluationDetails);
        }
    }

    public void getVsOutcomeByType(String outcomeType, StringBuffer agent, StringBuffer result, StringBuffer resultDetails, StringBuffer evaluation, StringBuffer evaluationDetails) {
        DnxSection sectionVsOutcome = this.getSectionById("vsOutcome");
        if (null == sectionVsOutcome) {
            return;
        }
        DnxSectionRecord record = this.findRecordInSection("vsOutcome", DNXConstants.VSOUTCOME.TYPE.sectionKeyId, outcomeType);
        if (null == record) {
            return;
        }
        agent.append(record.getSectionKeyValue(DNXConstants.VSOUTCOME.VSAGENT.sectionKeyId));
        result.append(record.getSectionKeyValue(DNXConstants.VSOUTCOME.RESULT.sectionKeyId));
        resultDetails.append(record.getSectionKeyValue(DNXConstants.VSOUTCOME.RESULTDETAILS.sectionKeyId));
        evaluation.append(record.getSectionKeyValue(DNXConstants.VSOUTCOME.VSEVALUATION.sectionKeyId));
        evaluationDetails.append(record.getSectionKeyValue(DNXConstants.VSOUTCOME.VSEVALUATIONDETAILS.sectionKeyId));
    }

    public void getFileValidation(StringBuffer agent, StringBuffer status, StringBuffer format, StringBuffer version, StringBuffer sigmatch, StringBuffer mimeType, StringBuffer profile, StringBuffer isValid, StringBuffer isWellFormed) {
        DnxSection sectionValidation = this.getSectionById("fileValidation");
        if (null == sectionValidation) {
            return;
        }
        agent.append(sectionValidation.getSectionKeyValue(DNXConstants.FILEVALIDATION.AGENT.sectionKeyId));
        status.append(sectionValidation.getSectionKeyValue(DNXConstants.FILEVALIDATION.STATUS.sectionKeyId));
        format.append(sectionValidation.getSectionKeyValue(DNXConstants.FILEVALIDATION.FORMAT.sectionKeyId));
        version.append(sectionValidation.getSectionKeyValue(DNXConstants.FILEVALIDATION.VERSION.sectionKeyId));
        mimeType.append(sectionValidation.getSectionKeyValue(DNXConstants.FILEVALIDATION.MIMETYPE.sectionKeyId));
        profile.append(sectionValidation.getSectionKeyValue(DNXConstants.FILEVALIDATION.PROFILE.sectionKeyId));
        isValid.append(sectionValidation.getSectionKeyValue(DNXConstants.FILEVALIDATION.ISVALID.sectionKeyId));
        isWellFormed.append(sectionValidation.getSectionKeyValue(DNXConstants.FILEVALIDATION.ISWELLFORMED.sectionKeyId));
    }

    public void setFileValidation(String agent, String status, String format, String version, String sigmatch, String mimeType, String profile, String isValid, String isWellFormed) {
        DnxSection sectionFileValidation = this.getSectionById("fileValidation");
        if (null != sectionFileValidation) {
            this.deleteSection("fileValidation");
        }
        sectionFileValidation = this.createSection("fileValidation");
        sectionFileValidation.updateSectionKey(DNXConstants.FILEVALIDATION.AGENT.sectionKeyId, agent);
        sectionFileValidation.updateSectionKey(DNXConstants.FILEVALIDATION.STATUS.sectionKeyId, status);
        sectionFileValidation.updateSectionKey(DNXConstants.FILEVALIDATION.FORMAT.sectionKeyId, format);
        sectionFileValidation.updateSectionKey(DNXConstants.FILEVALIDATION.VERSION.sectionKeyId, version);
        sectionFileValidation.updateSectionKey(DNXConstants.FILEVALIDATION.MIMETYPE.sectionKeyId, mimeType);
        sectionFileValidation.updateSectionKey(DNXConstants.FILEVALIDATION.PROFILE.sectionKeyId, profile);
        sectionFileValidation.updateSectionKey(DNXConstants.FILEVALIDATION.ISVALID.sectionKeyId, isValid);
        sectionFileValidation.updateSectionKey(DNXConstants.FILEVALIDATION.ISWELLFORMED.sectionKeyId, isWellFormed);
    }

    public void setFileFormat(String formatAgent, String formatLibraryId, String formatName, String formatVersion, String formatMimeType) throws DigitoolException {
        DnxSectionRecord recordForGivenFormatType;
        DnxSection sectionFileFormat = this.getSectionById("fileFormat");
        if (null == sectionFileFormat) {
            sectionFileFormat = this.createSection("fileFormat");
        }
        if (null == (recordForGivenFormatType = this.findRecordForFormatType(formatName, formatVersion))) {
            recordForGivenFormatType = sectionFileFormat.createRecord();
        }
        recordForGivenFormatType.updateKey(DNXConstants.FILEFORMAT.AGENT.sectionKeyId, formatAgent);
        recordForGivenFormatType.updateKey(DNXConstants.FILEFORMAT.FORMATREGISTRYID.sectionKeyId, formatLibraryId);
        recordForGivenFormatType.updateKey(DNXConstants.FILEFORMAT.FORMATNAME.sectionKeyId, formatName);
        recordForGivenFormatType.updateKey(DNXConstants.FILEFORMAT.FORMATVERSION.sectionKeyId, formatVersion);
        recordForGivenFormatType.updateKey(DNXConstants.FILEFORMAT.MIMETYPE.sectionKeyId, formatMimeType);
    }

    DnxSectionRecord findRecordForFormatType(String formatName, String formatVersion) {
        DnxSection sectionFileFormat = this.getSectionById("fileFormat");
        if (null == sectionFileFormat) {
            return null;
        }
        for (DnxSectionRecord record : sectionFileFormat.getRecordList()) {
            if (!formatName.equals(record.getSectionKeyValue(DNXConstants.FILEFORMAT.FORMATNAME.sectionKeyId)) || !formatVersion.equals(record.getSectionKeyValue(DNXConstants.FILEFORMAT.FORMATVERSION.sectionKeyId))) continue;
            return record;
        }
        return null;
    }

    public List<String> getFileFormatTypes() {
        ArrayList<String> types = new ArrayList<String>();
        DnxSection sectionFileFormat = this.getSectionById("fileFormat");
        if (null != sectionFileFormat) {
            for (DnxSectionRecord record : sectionFileFormat.getRecordList()) {
                types.add(record.getSectionKeyValue(DNXConstants.FILEFORMAT.FORMATNAME.sectionKeyId) + FORMAT_NAME_VERSION_SEPARATOR + record.getSectionKeyValue(DNXConstants.FILEFORMAT.FORMATVERSION.sectionKeyId));
            }
        }
        return types;
    }

    public void getFileFormatByType(String inFormatName, String inFormatVersion, StringBuffer formatLibraryId, StringBuffer formatName, StringBuffer formatVersion, StringBuffer mimeType) {
        DnxSectionRecord record = this.findRecordForFormatType(inFormatName, inFormatVersion);
        if (null == record) {
            return;
        }
        formatLibraryId.append(record.getSectionKeyValue(DNXConstants.FILEFORMAT.FORMATREGISTRYID.sectionKeyId));
        formatName.append(record.getSectionKeyValue(DNXConstants.FILEFORMAT.FORMATNAME.sectionKeyId));
        formatVersion.append(record.getSectionKeyValue(DNXConstants.FILEFORMAT.FORMATVERSION.sectionKeyId));
        mimeType.append(record.getSectionKeyValue(DNXConstants.FILEFORMAT.MIMETYPE.sectionKeyId));
    }

    public void setValidator(DnxValidator validator) {
        this.validator = validator;
    }

    public DnxValidator getValidator() {
        return this.validator;
    }

    public List<DnxSectionRecord> getSectionRecordsListById(String id) {
        DnxSection dnxSection = this.getSectionById(id);
        if (dnxSection == null) {
            return new ArrayList<DnxSectionRecord>();
        }
        return dnxSection.getRecordList();
    }

    private void deserialize() {
        if (this.documentXml != null) {
            DnxDocument tmp = null;
            try {
                tmp = DnxDocumentFactory.getInstance().parse(this.documentXml);
                this.document = tmp.getDocument();
                this.profile = tmp.getProfile();
                this.sectionsList = tmp.getSectionsList();
                this.validator = tmp.getValidator();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public Document getDocument() {
        if (this.document == null) {
            this.deserialize();
        }
        return this.document;
    }

    public void setDocument(Document document) {
        this.document = document;
    }

    public String getDocumentXml() {
        return this.documentXml;
    }

    public void setDocumentXml(String documentXml) {
        this.documentXml = documentXml;
    }

    public void setSectionsList(List<DnxSection> sectionsList) {
        this.sectionsList = sectionsList;
    }

    public void addSection(DnxSection section) {
        this.getSectionsList().add(section);
    }

    private static enum AmdType {
        TECHMD,
        DIGIPROVMD,
        RIGHTSMD,
        SOURCEMD;

    }

    private static enum DnxDocumentType {
        IE,
        REPRESENTATION,
        FILE;

    }
}

