/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.digitool.common.streams;

import com.exlibris.core.infra.common.exceptions.logging.ExLogger;
import com.exlibris.digitool.common.streams.FailedToHandlerStreamException;
import com.exlibris.digitool.common.streams.StreamHandler;
import magick.ImageInfo;
import magick.MagickException;
import magick.MagickImage;

public class ImageToThumStreamHandler
extends StreamHandler {
    private static ExLogger log = ExLogger.getExLogger(ImageToThumStreamHandler.class);
    private String density = null;
    private String geometry = null;

    public void setDensity(String density) {
        this.density = density;
    }

    public void setGeometry(String geometry) {
        this.geometry = geometry;
    }

    @Override
    public void handleStream() throws FailedToHandlerStreamException {
        log.debug((Object)"Entering handleStream()", new String[0]);
        if (this.density == null || this.density.trim().length() == 0) {
            this.density = "72x72";
        }
        if (this.geometry == null || this.geometry.trim().length() == 0) {
            this.geometry = "150x150";
        }
        String fileToRead = null;
        String fileToWrite = null;
        if (this.params == null || this.params.length != 2) {
            throw new FailedToHandlerStreamException("one of the following is missing: 'file to read', 'file to write'");
        }
        fileToRead = this.params[0];
        fileToWrite = this.params[1];
        try {
            log.debug((Object)("Reading file " + fileToRead), new String[0]);
            ImageInfo info = new ImageInfo(fileToRead);
            info.setDensity(this.density);
            log.debug((Object)("Creating new image file: " + fileToWrite), new String[0]);
            MagickImage newImage = new MagickImage(info);
            newImage.setFileName(fileToWrite);
            newImage.transformImage("", this.geometry);
            newImage.writeImage(info);
        }
        catch (MagickException e) {
            log.error(e);
            throw new FailedToHandlerStreamException("failed to create image using image magick: " + e.getMessage());
        }
    }
}

