/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.dps.model.collections;

import com.exlibris.core.infra.model.HPersistent;
import com.exlibris.repository.dps.model.collections.HDeCollection;
import com.exlibris.repository.persistence.digitalentity.HDeControl;
import javax.persistence.ColumnResult;
import javax.persistence.Entity;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.NamedNativeQueries;
import javax.persistence.NamedNativeQuery;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.SqlResultSetMapping;
import javax.persistence.SqlResultSetMappings;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;
import org.hibernate.annotations.Index;

@NamedQueries(value={@NamedQuery(name="deleteMember", query="delete from HDeCollectionMembers where collectionId =:collectionId and pid =:pid"), @NamedQuery(name="countByPidAndColletionId", query="select count(*) from HDeCollectionMembers where collectionId =:collectionId and pid =:pid"), @NamedQuery(name="membersByPid", query="from HDeCollectionMembers where pid =:pid"), @NamedQuery(name="hasMembers", query="from HDeCollectionMembers where collectionId=:collectionId")})
@SqlResultSetMappings(value={@SqlResultSetMapping(name="countScalar", columns={@ColumnResult(name="membersNumber")})})
@NamedNativeQueries(value={@NamedNativeQuery(name="countByColletionId", query="select count(HDeCollectionMembers.collectionId) as membersNumber from HDeCollectionMembers, HDeControl where HDeCollectionMembers.collectionId=:collectionId and HDeCollectionMembers.pid = HDeControl.pid and (HDeControl.lifeCycle = 'IN_PERMANENT_REPOSITORY' or 'true'=:ignoreNotInPer)", resultSetMapping="countScalar")})
@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"collectionId", "pid"})})
public class HDeCollectionMembers
extends HPersistent {
    public static final String COUNT_MEMBERS_BY_COLL_ID = "countByColletionId";
    private static final long serialVersionUID = 1L;
    private HDeCollection collection;
    private HDeControl control;

    public HDeCollectionMembers() {
    }

    public HDeCollectionMembers(HDeCollection collection, HDeControl control) {
        this.collection = collection;
        this.control = control;
    }

    @ManyToOne(targetEntity=HDeCollection.class)
    @JoinColumn(name="collectionId", referencedColumnName="id")
    @Index(name="COLLECTION_ID_IDX")
    public HDeCollection getCollection() {
        return this.collection;
    }

    @ManyToOne(targetEntity=HDeControl.class)
    @JoinColumn(name="pid", referencedColumnName="pid")
    @Index(name="HDECOLLECTIONMEMBERS_PID_IDX")
    public HDeControl getControl() {
        return this.control;
    }

    public void setCollection(HDeCollection collection) {
        this.collection = collection;
    }

    public void setControl(HDeControl control) {
        this.control = control;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.collection == null ? 0 : this.collection.hashCode());
        result = 31 * result + (this.control == null ? 0 : this.control.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HDeCollectionMembers other = (HDeCollectionMembers)obj;
        if (this.collection == null ? other.collection != null : !this.collection.equals(other.collection)) {
            return false;
        }
        return !(this.control == null ? other.control != null : !this.control.equals(other.control));
    }
}

