/*
 * Decompiled with CFR 0.152.
 */
package com.exlibris.repository.persistence.digitalentity;

import com.exlibris.digitool.repository.conf.xmlbeans.Metadata;
import com.exlibris.digitool.repository.conf.xmlbeans.SupportedSchemas;
import com.exlibris.repository.persistence.HPersistent;
import com.exlibris.repository.persistence.digitalentity.HDeMetadataSchemaDefinition;
import java.util.List;
import javax.persistence.AttributeOverride;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import javax.persistence.UniqueConstraint;

@Entity
@Table(uniqueConstraints={@UniqueConstraint(columnNames={"TYPE", "SUB_TYPE", "VERSION"})})
@AttributeOverride(name="id", column=@Column(name="mdid"))
@NamedQueries(value={@NamedQuery(name="findMetadataRegistryByType", query="from HDeMetadataRegistry where upper(type) = upper(:type)")})
public class HDeMetadataRegistry
extends HPersistent {
    public static final String FIND_METADATA_REGISTRY_BY_TYPE = "findMetadataRegistryByType";
    public static final String TYPE_DNX = "dnx";
    public static final String TYPE_DESCRIPTIVE = "descriptive";
    public static final String TYPE_RIGHTS = "rights";
    public static final String TYPE_POLICY = "policy";
    public static final String TYPE_LOCAL = "local";
    public static final String TYPE_METS_SECTION = "mets_section";
    public static final String TYPE_CMS = "CMS";
    public static final String TYPE_SOURCE = "source";
    public static final String SUBTYPE_DC = "dc";
    public static final String SUBTYPE_MARC = "marc";
    public static final String SUBTYPE_DNX = "dnx";
    public static final String SUBTYPE_METS_HEADER = "metsHdr";
    public static final String SUBTYPE_STRUCT_MAP = "structMap";
    public static final String SUBTYPE_ACCESS_RIGHTS = "accessrights";
    public static final String SUBTYPE_RETENTION = "retention";
    public static final String SUBTYPE_SOFTWARE_AGENTS = "softwareAgents";
    public static final String SUBTYPE_OTHER = "other";
    public static final Integer MDID_DC = 2;
    private static final long serialVersionUID = 1L;
    private String type;
    private String subType;
    private float version;
    private String nameSpace;
    private int mutexGroup;
    private boolean canBeAdded;
    private boolean canBeIndexed;
    private boolean canBeShared;
    private boolean canBeEdited;
    private String assignType;
    private boolean isExclusive;
    private boolean isIsolated;
    private boolean isRelevantToIE;
    private boolean isRelevantToRep;
    private boolean isRelevantToFile;
    private List<HDeMetadataSchemaDefinition> supportedSchemas;

    @Column(name="TYPE")
    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Column(name="SUB_TYPE")
    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    @Column(name="CAN_BE_SHARED")
    public boolean isCanBeShared() {
        return this.canBeShared;
    }

    public void setCanBeShared(boolean canBeShared) {
        this.canBeShared = canBeShared;
    }

    @Column(name="IS_EXCLUSIVE")
    public boolean isExclusive() {
        return this.isExclusive;
    }

    public void setExclusive(boolean isExclusive) {
        this.isExclusive = isExclusive;
    }

    @Column(name="IS_ISOLATED")
    public boolean isIsolated() {
        return this.isIsolated;
    }

    public void setIsolated(boolean isIsolated) {
        this.isIsolated = isIsolated;
    }

    @Column(name="VERSION")
    public float getVersion() {
        return this.version;
    }

    public void setVersion(float version) {
        this.version = version;
    }

    @Column(name="IS_RELEVANT_TO_IE")
    public boolean isRelevantToIE() {
        return this.isRelevantToIE;
    }

    public void setRelevantToIE(boolean isRelevantToIE) {
        this.isRelevantToIE = isRelevantToIE;
    }

    @Column(name="IS_RELEVANT_TO_REP")
    public boolean isRelevantToRep() {
        return this.isRelevantToRep;
    }

    public void setRelevantToRep(boolean isRelevantToRep) {
        this.isRelevantToRep = isRelevantToRep;
    }

    @Column(name="IS_RELEVANT_TO_FILE")
    public boolean isRelevantToFile() {
        return this.isRelevantToFile;
    }

    public void setRelevantToFile(boolean isRelevantToFile) {
        this.isRelevantToFile = isRelevantToFile;
    }

    @OneToMany(targetEntity=HDeMetadataSchemaDefinition.class, mappedBy="metadataTypeId", cascade={CascadeType.ALL}, fetch=FetchType.EAGER)
    public List<HDeMetadataSchemaDefinition> getSupportedSchemas() {
        return this.supportedSchemas;
    }

    public void setSupportedSchemas(List<HDeMetadataSchemaDefinition> supportedSchemas) {
        this.supportedSchemas = supportedSchemas;
    }

    public String toString() {
        return "MetadataType(" + this.getType() + ", " + this.getSubType() + ", version " + this.getVersion() + ")";
    }

    public Metadata export(Metadata md) {
        if (md == null) {
            md = Metadata.Factory.newInstance();
        }
        md.setId(this.getId().intValue());
        md.setName(this.getType());
        md.setType(this.getSubType());
        md.setAllowMultiple(this.isCanBeShared());
        md.setIsRelevantToIe(this.isRelevantToIE());
        md.setIsRelevantToRep(this.isRelevantToRep());
        md.setIsRelevantToFile(this.isRelevantToFile());
        SupportedSchemas[] schemas = new SupportedSchemas[]{};
        try {
            if (this.getSupportedSchemas() != null) {
                schemas = HDeMetadataSchemaDefinition.export(this.getSupportedSchemas());
            }
        }
        catch (Exception e) {
            System.err.println("getSupportedSchemas() threw: " + e.toString());
        }
        md.setSupportedSchemasArray(schemas);
        return md;
    }

    public static Metadata[] export(List<HDeMetadataRegistry> metadataTypes) {
        Metadata[] mds = new Metadata[metadataTypes.size()];
        for (int i = 0; i < metadataTypes.size(); ++i) {
            mds[i] = metadataTypes.get(i).export(mds[i]);
        }
        return mds;
    }

    public String getNameSpace() {
        return this.nameSpace;
    }

    public void setNameSpace(String nameSpace) {
        this.nameSpace = nameSpace;
    }

    public int getMutexGroup() {
        return this.mutexGroup;
    }

    public void setMutexGroup(int mutexGroup) {
        this.mutexGroup = mutexGroup;
    }

    public boolean isCanBeAdded() {
        return this.canBeAdded;
    }

    public void setCanBeAdded(boolean canBeAdded) {
        this.canBeAdded = canBeAdded;
    }

    public boolean isCanBeIndexed() {
        return this.canBeIndexed;
    }

    public void setCanBeIndexed(boolean canBeIndexed) {
        this.canBeIndexed = canBeIndexed;
    }

    public boolean isCanBeEdited() {
        return this.canBeEdited;
    }

    public void setCanBeEdited(boolean canBeEdited) {
        this.canBeEdited = canBeEdited;
    }

    public String getAssignType() {
        return this.assignType;
    }

    public void setAssignType(String assignType) {
        this.assignType = assignType;
    }
}

