/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.html;

import edu.harvard.hul.ois.jhove.module.html.HtmlAttributeDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlDocDesc;
import edu.harvard.hul.ois.jhove.module.html.HtmlSpecialToken;
import edu.harvard.hul.ois.jhove.module.html.HtmlTagDesc;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public abstract class Html4DocDesc
extends HtmlDocDesc {
    protected static String[] fontMarkup;
    protected static String[] phraseMarkup;
    protected static String[] specialMarkup;
    protected static String[] formMarkup;
    protected static String[] listMarkup;
    protected static List blockContent;
    protected static List flowContent;
    protected static List inlineContent;
    protected static List listContent;
    protected static List bodyContent;
    protected static List coreAttrs;
    protected static List i18nAttrs;
    protected static List eventAttrs;
    protected static List bigAttrs;
    protected static List biggerAttrs;
    protected static List reservedAttrs;
    protected static HtmlAttributeDesc halignAtt;
    protected static HtmlAttributeDesc valignAtt;
    protected static List thtdAtts;

    protected static void classInit4(Map stSupportedElements) {
        phraseMarkup = new String[]{"em", "strong", "dfn", "code", "samp", "kbd", "var", "cite", "abbr", "acronym"};
        formMarkup = new String[]{"input", "select", "textarea", "label", "button"};
        coreAttrs = new ArrayList(4);
        Html4DocDesc.addSimpleAttribute(coreAttrs, "id");
        Html4DocDesc.addSimpleAttribute(coreAttrs, "class");
        Html4DocDesc.addSimpleAttribute(coreAttrs, "style");
        Html4DocDesc.addSimpleAttribute(coreAttrs, "title");
        i18nAttrs = new ArrayList(2);
        Html4DocDesc.addSimpleAttribute(i18nAttrs, "lang");
        i18nAttrs.add(new HtmlAttributeDesc("id", new String[]{"ltr", "rtl"}, 4));
        eventAttrs = new ArrayList(10);
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onclick");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "ondblclick");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onmousedown");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onmouseup");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onmouseover");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onmousemove");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onmouseout");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onkeypress");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onkeydown");
        Html4DocDesc.addSimpleAttribute(eventAttrs, "onkeyup");
        bigAttrs = new ArrayList(coreAttrs.size() + i18nAttrs.size() + eventAttrs.size());
        bigAttrs.addAll(coreAttrs);
        bigAttrs.addAll(i18nAttrs);
        bigAttrs.addAll(eventAttrs);
        reservedAttrs = new ArrayList(3);
        Html4DocDesc.addSimpleAttribute(reservedAttrs, "datasrc");
        Html4DocDesc.addSimpleAttribute(reservedAttrs, "datafld");
        Html4DocDesc.addSimpleAttribute(reservedAttrs, "dataformatas");
        biggerAttrs = new ArrayList(bigAttrs.size() + 3);
        biggerAttrs.addAll(bigAttrs);
        biggerAttrs.addAll(reservedAttrs);
        halignAtt = new HtmlAttributeDesc("align", new String[]{"left", "center", "right", "justify", "char"}, 4);
        valignAtt = new HtmlAttributeDesc("valign", new String[]{"top", "middle", "bottom", "baseline"}, 4);
    }

    protected static void addAddressElement(Map stSupportedElements) {
        String name = "address";
        ArrayList<String> addressContent = new ArrayList<String>(36);
        addressContent.addAll(inlineContent);
        addressContent.add("p");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, addressContent, bigAttrs);
        stSupportedElements.put(name, td);
    }

    protected static void addBdoElement(Map stSupportedElements) {
        String name = "bdo";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(coreAttrs.size() + 2);
        atts.addAll(coreAttrs);
        Html4DocDesc.addSimpleAttribute(atts, "lang");
        atts.add(new HtmlAttributeDesc("dir", new String[]{"ltr", "rtl"}, 1));
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, inlineContent, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addBodyElement(Map stSupportedElements) {
        String name = "body";
        ArrayList atts = new ArrayList(bigAttrs.size() + 2);
        atts.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(atts, "onload");
        Html4DocDesc.addSimpleAttribute(atts, "onunload");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, bodyContent, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addColElement(Map stSupportedElements, List cellalignAttrs) {
        String name = "col";
        ArrayList atts = new ArrayList(bigAttrs.size() + 8);
        atts.addAll(bigAttrs);
        atts.addAll(cellalignAttrs);
        Html4DocDesc.addSimpleAttribute(atts, "span");
        Html4DocDesc.addSimpleAttribute(atts, "width");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, null, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addColgroupElement(Map stSupportedElements, List cellalignAttrs) {
        String name = "colgroup";
        ArrayList<String> content = new ArrayList<String>(1);
        content.add("col");
        ArrayList atts = new ArrayList(bigAttrs.size() + 8);
        atts.addAll(bigAttrs);
        atts.addAll(cellalignAttrs);
        Html4DocDesc.addSimpleAttribute(atts, "span");
        Html4DocDesc.addSimpleAttribute(atts, "width");
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, content, atts);
        stSupportedElements.put(name, td);
    }

    protected static void addDdElement(Map stSupportedElements) {
        String name = "dd";
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, flowContent, bigAttrs);
        stSupportedElements.put(name, td);
    }

    protected static void addDelElement(Map stSupportedElements) {
        String name = "del";
        ArrayList atts = new ArrayList(bigAttrs.size() + 2);
        atts.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(atts, "cite");
        Html4DocDesc.addSimpleAttribute(atts, "datetime");
        HtmlTagDesc td = new HtmlTagDesc("del", true, true, flowContent, atts);
        stSupportedElements.put("del", td);
    }

    protected static void addDtElement(Map stSupportedElements) {
        String name = "dt";
        HtmlTagDesc td = new HtmlTagDesc(name, true, false, inlineContent, bigAttrs);
        stSupportedElements.put(name, td);
    }

    protected static void addFieldsetElement(Map stSupportedElements) {
        String name = "fieldset";
        ArrayList<Object> content = new ArrayList<Object>(flowContent.size() + 3);
        content.addAll(flowContent);
        content.add(HtmlSpecialToken.PCDATA);
        content.add("legend");
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, content, bigAttrs);
        stSupportedElements.put(name, td);
    }

    protected static void addInsElement(Map stSupportedElements) {
        String name = "ins";
        ArrayList atts = new ArrayList(bigAttrs.size() + 2);
        atts.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(atts, "cite");
        Html4DocDesc.addSimpleAttribute(atts, "datetime");
        HtmlTagDesc td = new HtmlTagDesc("ins", true, true, flowContent, atts);
        stSupportedElements.put("ins", td);
    }

    protected static void addLabelElement(Map stSupportedElements) {
        String name = "label";
        ArrayList atts = new ArrayList(bigAttrs.size() + 4);
        atts.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(atts, "for");
        Html4DocDesc.addSimpleAttribute(atts, "accesskey");
        Html4DocDesc.addSimpleAttribute(atts, "onfocus");
        Html4DocDesc.addSimpleAttribute(atts, "onblur");
        HtmlTagDesc td = new HtmlTagDesc("label", true, true, inlineContent, atts);
        stSupportedElements.put("label", td);
    }

    protected static void addMapElement(Map stSupportedElements) {
        String name = "map";
        ArrayList atts = new ArrayList(bigAttrs.size() + 1);
        atts.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(atts, "name");
        ArrayList<String> mapContent = new ArrayList<String>(1);
        mapContent.addAll(blockContent);
        mapContent.add("area");
        HtmlTagDesc td = new HtmlTagDesc("map", true, true, mapContent, atts);
        stSupportedElements.put("map", td);
    }

    protected static void addMetaElement(Map stSupportedElements) {
        String name = "meta";
        ArrayList atts = new ArrayList(3);
        Html4DocDesc.addSimpleAttribute(atts, "http-equiv");
        Html4DocDesc.addSimpleAttribute(atts, "name");
        Html4DocDesc.addRequiredAttribute(atts, "content");
        HtmlTagDesc td = new HtmlTagDesc("meta", true, false, null, atts);
        stSupportedElements.put("meta", td);
    }

    protected static void addOptgroupElement(Map stSupportedElements) {
        String name = "option";
        ArrayList atts = new ArrayList(bigAttrs.size() + 2);
        atts.addAll(bigAttrs);
        Html4DocDesc.addSelfAttribute(atts, "selected");
        Html4DocDesc.addSimpleAttribute(atts, "label");
        ArrayList<String> content = new ArrayList<String>(1);
        content.add("option");
        HtmlTagDesc td = new HtmlTagDesc("option", true, true, content, atts);
        stSupportedElements.put("option", td);
    }

    protected static void addOptionElement(Map stSupportedElements) {
        String name = "option";
        ArrayList atts = new ArrayList(bigAttrs.size() + 4);
        atts.addAll(bigAttrs);
        Html4DocDesc.addSelfAttribute(atts, "selected");
        Html4DocDesc.addSelfAttribute(atts, "disabled");
        Html4DocDesc.addSimpleAttribute(atts, "label");
        Html4DocDesc.addSimpleAttribute(atts, "value");
        ArrayList<HtmlSpecialToken> content = new ArrayList<HtmlSpecialToken>(1);
        content.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc td = new HtmlTagDesc("option", true, true, content, atts);
        stSupportedElements.put("option", td);
    }

    protected static void addParamElement(Map stSupportedElements) {
        String name = "param";
        ArrayList<HtmlAttributeDesc> atts = new ArrayList<HtmlAttributeDesc>(2);
        Html4DocDesc.addRequiredAttribute(atts, "name");
        Html4DocDesc.addSimpleAttribute(atts, "value");
        atts.add(new HtmlAttributeDesc("valuetype", new String[]{"data", "ref", "object"}, 5));
        Html4DocDesc.addSimpleAttribute(atts, "type");
        HtmlTagDesc td = new HtmlTagDesc("param", true, false, null, atts);
        stSupportedElements.put("param", td);
    }

    protected static void addQElement(Map stSupportedElements) {
        String name = "q";
        ArrayList atts = new ArrayList(bigAttrs.size() + 1);
        atts.addAll(bigAttrs);
        Html4DocDesc.addSimpleAttribute(atts, "cite");
        HtmlTagDesc td = new HtmlTagDesc("q", true, true, inlineContent, atts);
        stSupportedElements.put("q", td);
    }

    protected static void addSelectElement(Map stSupportedElements) {
        String name = "select";
        ArrayList atts = new ArrayList(biggerAttrs.size() + 10);
        atts.addAll(biggerAttrs);
        Html4DocDesc.addSimpleAttribute(atts, "name");
        Html4DocDesc.addSimpleAttribute(atts, "size");
        Html4DocDesc.addSelfAttribute(atts, "multiple");
        Html4DocDesc.addSelfAttribute(atts, "disabled");
        Html4DocDesc.addSimpleAttribute(atts, "tabindex");
        Html4DocDesc.addSimpleAttribute(atts, "onfocus");
        Html4DocDesc.addSimpleAttribute(atts, "onblur");
        Html4DocDesc.addSimpleAttribute(atts, "onchange");
        ArrayList<String> content = new ArrayList<String>(2);
        content.add("option");
        content.add("optgroup");
        HtmlTagDesc td = new HtmlTagDesc("select", true, true, content, atts);
        stSupportedElements.put("select", td);
    }

    protected static void addSpanElement(Map stSupportedElements) {
        String name = "span";
        HtmlTagDesc td = new HtmlTagDesc("span", true, true, inlineContent, biggerAttrs);
        stSupportedElements.put("span", td);
    }

    protected static void addStyleElement(Map stSupportedElements) {
        String name = "style";
        ArrayList<HtmlSpecialToken> content = new ArrayList<HtmlSpecialToken>(1);
        content.add(HtmlSpecialToken.PCDATA);
        ArrayList atts = new ArrayList(6);
        atts.addAll(i18nAttrs);
        Html4DocDesc.addSimpleAttribute(atts, "type");
        Html4DocDesc.addSimpleAttribute(atts, "media");
        Html4DocDesc.addSimpleAttribute(atts, "title");
        HtmlTagDesc td = new HtmlTagDesc("style", true, true, content, atts);
        stSupportedElements.put("style", td);
    }

    protected static void addSubElement(Map stSupportedElements) {
        String name = "sub";
        HtmlTagDesc td = new HtmlTagDesc("sub", true, true, inlineContent, bigAttrs);
        stSupportedElements.put("sub", td);
    }

    protected static void addSupElement(Map stSupportedElements) {
        String name = "sup";
        HtmlTagDesc td = new HtmlTagDesc("sup", true, true, inlineContent, bigAttrs);
        stSupportedElements.put("sup", td);
    }

    protected static void addTextareaElement(Map stSupportedElements) {
        String name = "textarea";
        ArrayList atts = new ArrayList(biggerAttrs.size() + 12);
        Html4DocDesc.addSimpleAttribute(atts, "name");
        Html4DocDesc.addSimpleAttribute(atts, "rows");
        Html4DocDesc.addSimpleAttribute(atts, "cols");
        Html4DocDesc.addSelfAttribute(atts, "disabled");
        Html4DocDesc.addSelfAttribute(atts, "readonly");
        Html4DocDesc.addSimpleAttribute(atts, "tabindex");
        Html4DocDesc.addSimpleAttribute(atts, "accesskey");
        Html4DocDesc.addSimpleAttribute(atts, "onfocus");
        Html4DocDesc.addSimpleAttribute(atts, "onblur");
        Html4DocDesc.addSimpleAttribute(atts, "onselect");
        Html4DocDesc.addSimpleAttribute(atts, "onchange");
        ArrayList<HtmlSpecialToken> content = new ArrayList<HtmlSpecialToken>(1);
        content.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc td = new HtmlTagDesc("textarea", true, true, content, atts);
        stSupportedElements.put("textarea", td);
    }

    protected static void addTbodyElement(Map stSupportedElements, List cellalignAttrs) {
        String name = "tbody";
        ArrayList<String> content = new ArrayList<String>(1);
        content.add("tr");
        ArrayList atts = new ArrayList(bigAttrs.size() + 8);
        atts.addAll(bigAttrs);
        atts.addAll(cellalignAttrs);
        HtmlTagDesc td = new HtmlTagDesc("tbody", false, false, content, atts);
        stSupportedElements.put("tbody", td);
    }

    protected static void addTdElement(Map stSupportedElements) {
        String name = "td";
        HtmlTagDesc td = new HtmlTagDesc("td", true, false, flowContent, thtdAtts);
        stSupportedElements.put("td", td);
    }

    protected static void addTfootElement(Map stSupportedElements, List cellalignAttrs) {
        String name = "tfoot";
        ArrayList<String> content = new ArrayList<String>(1);
        content.add("tr");
        ArrayList atts = new ArrayList(bigAttrs.size() + 8);
        atts.addAll(bigAttrs);
        atts.addAll(cellalignAttrs);
        HtmlTagDesc td = new HtmlTagDesc("tfoot", true, false, content, atts);
        stSupportedElements.put("tfoot", td);
    }

    protected static void addThElement(Map stSupportedElements) {
        String name = "th";
        HtmlTagDesc td = new HtmlTagDesc("th", true, false, flowContent, thtdAtts);
        stSupportedElements.put("th", td);
    }

    protected static void addTheadElement(Map stSupportedElements, List cellalignAttrs) {
        String name = "thead";
        ArrayList<String> content = new ArrayList<String>(1);
        content.add("tr");
        ArrayList atts = new ArrayList(bigAttrs.size() + 8);
        atts.addAll(bigAttrs);
        atts.addAll(cellalignAttrs);
        HtmlTagDesc td = new HtmlTagDesc("thead", true, false, content, atts);
        stSupportedElements.put("thead", td);
    }

    protected static void addTitleElement(Map stSupportedElements) {
        String name = "title";
        ArrayList<HtmlSpecialToken> pcdataContent = new ArrayList<HtmlSpecialToken>(1);
        pcdataContent.add(HtmlSpecialToken.PCDATA);
        HtmlTagDesc td = new HtmlTagDesc(name, true, true, pcdataContent, i18nAttrs);
        stSupportedElements.put(name, td);
    }
}

