/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.wave;

import edu.harvard.hul.ois.jhove.AESAudioMetadata;
import edu.harvard.hul.ois.jhove.InfoMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.RepInfo;
import edu.harvard.hul.ois.jhove.module.WaveModule;
import edu.harvard.hul.ois.jhove.module.iff.Chunk;
import edu.harvard.hul.ois.jhove.module.iff.ChunkHeader;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.xml.bind.DatatypeConverter;

public class BroadcastExtChunk
extends Chunk {
    private static final int BASE_CHUNK_SIZE = 602;
    private static final int VER_0_RESERVED_LENGTH = 254;
    private static final int VER_1_RESERVED_LENGTH = 190;
    private static final int VER_2_RESERVED_LENGTH = 180;
    private static final int UNUSED_LOUDNESS_FIELD = Short.MAX_VALUE;

    public BroadcastExtChunk(ModuleBase module, ChunkHeader hdr, DataInputStream dstrm) {
        super(module, hdr, dstrm);
    }

    @Override
    public boolean readChunk(RepInfo info) throws IOException {
        WaveModule module = (WaveModule)this._module;
        byte[] buf256 = new byte[256];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf256, (ModuleBase)module);
        String description = this.byteBufString(buf256);
        byte[] buf32 = new byte[32];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf32, (ModuleBase)module);
        String originator = this.byteBufString(buf32);
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf32, (ModuleBase)module);
        String originatorRef = this.byteBufString(buf32);
        byte[] buf10 = new byte[10];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf10, (ModuleBase)module);
        String originationDate = this.byteBufString(buf10);
        byte[] buf8 = new byte[8];
        ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf8, (ModuleBase)module);
        String originationTime = this.byteBufString(buf8);
        long timeReference = module.readSignedLong(this._dstream);
        int version = module.readUnsignedShort(this._dstream);
        String umid = "";
        if (version >= 1) {
            byte[] buf64 = new byte[64];
            ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])buf64, (ModuleBase)module);
            umid = BroadcastExtChunk.formatUmid(buf64);
        }
        String loudnessValue = "";
        String loudnessRange = "";
        String maxTruePeakLevel = "";
        String maxMomentaryLoudness = "";
        String maxShortTermLoudness = "";
        if (version >= 2) {
            loudnessValue = BroadcastExtChunk.formatLoudness(module.readSignedShort(this._dstream));
            loudnessRange = BroadcastExtChunk.formatLoudness(module.readSignedShort(this._dstream));
            maxTruePeakLevel = BroadcastExtChunk.formatLoudness(module.readSignedShort(this._dstream));
            maxMomentaryLoudness = BroadcastExtChunk.formatLoudness(module.readSignedShort(this._dstream));
            maxShortTermLoudness = BroadcastExtChunk.formatLoudness(module.readSignedShort(this._dstream));
        }
        if (version == 0) {
            module.skipBytes(this._dstream, 254L, module);
        } else if (version == 1) {
            module.skipBytes(this._dstream, 190L, module);
        } else if (version == 2) {
            module.skipBytes(this._dstream, 180L, module);
        } else {
            module.skipBytes(this._dstream, 180L, module);
            info.setMessage((Message)new InfoMessage("Unrecognized BWF version: " + version));
        }
        String codingHistory = "";
        int codingHistorySize = (int)this.chunkSize - 602;
        if (codingHistorySize > 0) {
            byte[] bufCodingHistory = new byte[codingHistorySize];
            ModuleBase.readByteBuf((DataInputStream)this._dstream, (byte[])bufCodingHistory, (ModuleBase)module);
            codingHistory = this.byteBufString(bufCodingHistory);
        }
        ArrayList<Property> plist = new ArrayList<Property>(14);
        if (!description.isEmpty()) {
            plist.add(new Property("Description", PropertyType.STRING, (Object)description));
        }
        if (!originator.isEmpty()) {
            plist.add(new Property("Originator", PropertyType.STRING, (Object)originator));
        }
        if (!originatorRef.isEmpty()) {
            plist.add(new Property("OriginatorReference", PropertyType.STRING, (Object)originatorRef));
        }
        if (!originationDate.isEmpty()) {
            plist.add(new Property("OriginationDate", PropertyType.STRING, (Object)originationDate));
        }
        if (!originationTime.isEmpty()) {
            plist.add(new Property("OriginationTime", PropertyType.STRING, (Object)originationTime));
        }
        plist.add(new Property("TimeReference", PropertyType.LONG, (Object)timeReference));
        plist.add(new Property("Version", PropertyType.INTEGER, (Object)version));
        if (!umid.isEmpty()) {
            plist.add(new Property("UMID", PropertyType.STRING, (Object)umid));
        }
        if (!loudnessValue.isEmpty()) {
            plist.add(new Property("LoudnessValue", PropertyType.STRING, (Object)loudnessValue));
        }
        if (!loudnessRange.isEmpty()) {
            plist.add(new Property("LoudnessRange", PropertyType.STRING, (Object)loudnessRange));
        }
        if (!maxTruePeakLevel.isEmpty()) {
            plist.add(new Property("MaxTruePeakLevel", PropertyType.STRING, (Object)maxTruePeakLevel));
        }
        if (!maxMomentaryLoudness.isEmpty()) {
            plist.add(new Property("MaxMomentaryLoudness", PropertyType.STRING, (Object)maxMomentaryLoudness));
        }
        if (!maxShortTermLoudness.isEmpty()) {
            plist.add(new Property("MaxShortTermLoudness", PropertyType.STRING, (Object)maxShortTermLoudness));
        }
        if (!codingHistory.isEmpty()) {
            plist.add(new Property("CodingHistory", PropertyType.STRING, (Object)codingHistory));
        }
        module.addWaveProperty(new Property("BroadcastAudioExtension", PropertyType.PROPERTY, PropertyArity.LIST, plist));
        AESAudioMetadata aes = module.getAESMetadata();
        aes.setStartTime(timeReference);
        return true;
    }

    private static String formatUmid(byte[] umid) {
        String formattedUmid = "";
        byte[] basicUmid = Arrays.copyOfRange(umid, 0, 32);
        byte[] umidExtension = Arrays.copyOfRange(umid, 32, 64);
        boolean basicUmidExists = BroadcastExtChunk.hasValue(basicUmid);
        boolean extendedUmidExists = false;
        if (basicUmidExists) {
            extendedUmidExists = BroadcastExtChunk.hasValue(umidExtension);
        }
        if (extendedUmidExists) {
            formattedUmid = DatatypeConverter.printHexBinary((byte[])umid);
        } else if (basicUmidExists) {
            formattedUmid = DatatypeConverter.printHexBinary((byte[])basicUmid);
        }
        return formattedUmid;
    }

    private static boolean hasValue(byte[] byteArray) {
        for (byte b : byteArray) {
            if (b == 0) continue;
            return true;
        }
        return false;
    }

    private static String formatLoudness(int value) {
        String formattedValue = "";
        if (value != Short.MAX_VALUE) {
            formattedValue = String.format("%.2f", Float.valueOf((float)value / 100.0f));
        }
        return formattedValue;
    }
}

