/*
 * Decompiled with CFR 0.152.
 */
package org.icepdf.core.pobjects.acroform.signature;

import java.util.logging.Logger;
import org.bouncycastle.asn1.ASN1Sequence;
import org.icepdf.core.pobjects.HexStringObject;
import org.icepdf.core.pobjects.acroform.SignatureDictionary;
import org.icepdf.core.pobjects.acroform.SignatureFieldDictionary;
import org.icepdf.core.pobjects.acroform.signature.AbstractPkcsValidator;
import org.icepdf.core.pobjects.acroform.signature.exceptions.SignatureIntegrityException;
import org.icepdf.core.util.Utils;

public class Pkcs7Validator
extends AbstractPkcsValidator {
    private static final Logger logger = Logger.getLogger(Pkcs7Validator.class.toString());

    public Pkcs7Validator(SignatureFieldDictionary signatureFieldDictionary) throws SignatureIntegrityException {
        super(signatureFieldDictionary);
    }

    public void init() throws SignatureIntegrityException {
        SignatureDictionary signatureDictionary = this.signatureFieldDictionary.getSignatureDictionary();
        this.announceSignatureType(signatureDictionary);
        HexStringObject hexStringObject = signatureDictionary.getContents();
        byte[] cmsData = Utils.convertByteCharSequenceToByteArray(hexStringObject.getLiteralString());
        ASN1Sequence signedData = this.captureSignedData(cmsData);
        this.parseSignerData(signedData, cmsData);
        this.initialized = true;
    }

    public void validate() throws SignatureIntegrityException {
        this.validateDocument();
    }
}

