/*
 * Decompiled with CFR 0.152.
 */
package gov.loc.repository.bagit.conformance;

import gov.loc.repository.bagit.conformance.BagitWarning;
import gov.loc.repository.bagit.exceptions.InvalidBagMetadataException;
import gov.loc.repository.bagit.reader.MetadataReader;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MetadataChecker {
    private static final Logger logger = LoggerFactory.getLogger(MetadataChecker.class);
    private static final ResourceBundle messages = ResourceBundle.getBundle("MessageBundle");

    private MetadataChecker() {
    }

    public static void checkBagMetadata(Path bagitDir, Charset encoding, Set<BagitWarning> warnings, Collection<BagitWarning> warningsToIgnore) throws IOException, InvalidBagMetadataException {
        MetadataChecker.checkForPayloadOxumMetadata(bagitDir, encoding, warnings, warningsToIgnore);
    }

    private static void checkForPayloadOxumMetadata(Path bagitDir, Charset encoding, Set<BagitWarning> warnings, Collection<BagitWarning> warningsToIgnore) throws IOException, InvalidBagMetadataException {
        if (!warningsToIgnore.contains((Object)BagitWarning.PAYLOAD_OXUM_MISSING)) {
            List<AbstractMap.SimpleImmutableEntry<String, String>> metadata = MetadataReader.readBagMetadata(bagitDir, encoding);
            boolean containsPayloadOxum = false;
            for (AbstractMap.SimpleImmutableEntry<String, String> pair : metadata) {
                if (!"Payload-Oxum".equals(pair.getKey())) continue;
                containsPayloadOxum = true;
            }
            if (!containsPayloadOxum) {
                logger.warn(messages.getString("missing_payload_oxum_warning"));
                warnings.add(BagitWarning.PAYLOAD_OXUM_MISSING);
            }
        }
    }
}

