/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jimi.core.encoder.png;

import com.sun.jimi.core.JimiException;
import com.sun.jimi.core.compat.AdaptiveRasterImage;
import com.sun.jimi.core.encoder.png.PNGChunkUtil;
import com.sun.jimi.core.encoder.png.PNGConstants;
import com.sun.jimi.core.encoder.png.PNGEncoder;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.IOException;

class png_chunk_plte
implements PNGConstants {
    byte[] reds;
    byte[] greens;
    byte[] blues;
    int mapSize;
    IndexColorModel cm = null;
    PNGChunkUtil pcu;

    png_chunk_plte(AdaptiveRasterImage adaptiveRasterImage, PNGChunkUtil pNGChunkUtil, PNGEncoder pNGEncoder) throws JimiException {
        if (adaptiveRasterImage.getColorModel() instanceof IndexColorModel) {
            this.cm = (IndexColorModel)adaptiveRasterImage.getColorModel();
            this.mapSize = this.cm.getMapSize();
            this.reds = new byte[this.mapSize];
            this.greens = new byte[this.mapSize];
            this.blues = new byte[this.mapSize];
            this.cm.getReds(this.reds);
            this.cm.getBlues(this.blues);
            this.cm.getGreens(this.greens);
        }
        this.pcu = pNGChunkUtil;
    }

    void write(DataOutputStream dataOutputStream) throws IOException {
        if (this.cm != null) {
            dataOutputStream.writeInt(this.mapSize * 3);
            dataOutputStream.write(PNGConstants.png_PLTE);
            this.pcu.resetCRC();
            this.pcu.updateCRC(PNGConstants.png_PLTE);
            int n = 0;
            while (n < this.mapSize) {
                dataOutputStream.writeByte(this.reds[n]);
                dataOutputStream.writeByte(this.greens[n]);
                dataOutputStream.writeByte(this.blues[n]);
                this.pcu.updateCRC(this.reds[n]);
                this.pcu.updateCRC(this.greens[n]);
                this.pcu.updateCRC(this.blues[n]);
                ++n;
            }
            dataOutputStream.writeInt(this.pcu.getCRC());
        }
    }
}

