/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.edidoc;

import at.gv.e_government.reference.namespace.ediakt._20050504_.EdiaktType;
import ch.docuteam.mapping.edidoc.ByIntegerSequence;
import ch.docuteam.mapping.edidoc.ByMetadataProperty;
import ch.docuteam.mapping.edidoc.ContentXML;
import ch.docuteam.mapping.edidoc.ExportMode;
import ch.docuteam.mapping.edidoc.FolderNameGenerator;
import ch.docuteam.mapping.edidoc.IntegerSequenceFolderNameGenerator;
import ch.docuteam.mapping.edidoc.InvalidMappingException;
import ch.docuteam.mapping.edidoc.KeyValueEntry;
import ch.docuteam.mapping.edidoc.LevelType;
import ch.docuteam.mapping.edidoc.Mapping;
import ch.docuteam.mapping.edidoc.MatterhornFieldType;
import ch.docuteam.mapping.edidoc.MetadataPropertyFolderNameGenerator;
import ch.docuteam.mapping.edidoc.XmlFileFinder;
import ch.docuteam.mapping.edidoc.XpathMapper;
import ch.docuteam.tools.file.ResourceUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

public class MappingAdapter {
    private static final String CONTEXT_PATH_MAPPING = "ch.docuteam.mapping.edidoc";
    private final String saId;
    private final String dssId;
    private final Map<String, MatterhornFieldType> keyValueMap;
    private final Map<String, XpathMapper> xpathMapperMap;
    private final boolean outputSIPUnzipped;
    private final ContentXML contentXML;
    private final boolean useSteuerXml;
    private final Map<String, LevelType> levelMap;
    private final FolderNameGenerator folderNameGenerator;
    private final XmlFileFinder xmlFileFinder;
    private final Class<?> mappingClass;

    public MappingAdapter(String mappingFilePath) {
        try (InputStream mappingFileInputStream = ResourceUtil.getResourceAsStream((String)mappingFilePath);){
            Mapping mapping = this.getMappingConfiguration(mappingFileInputStream);
            this.saId = mapping.getSubmissionAgreement().getID();
            this.dssId = mapping.getSubmissionAgreement().getDssId();
            this.outputSIPUnzipped = this.getOutputUnzipped(mapping);
            this.useSteuerXml = this.getUseSteuerXml(mapping);
            this.contentXML = this.getContentXML(mapping);
            this.levelMap = this.getMappedLevels(mapping);
            this.keyValueMap = this.getKeyValueMapping(mapping);
            this.xpathMapperMap = this.getXpathMapperMap(mapping);
            this.folderNameGenerator = this.getFolderNameGenerator(mapping);
            Mode mode = this.getMode(mapping);
            this.xmlFileFinder = mode.getXmlFileFinder();
            this.mappingClass = mode.getMappingClass();
        }
        catch (IOException e) {
            throw new InvalidMappingException("mapping file not found at: " + mappingFilePath);
        }
    }

    private ContentXML getContentXML(Mapping mapping) {
        if (mapping.getContentXML() != null) {
            return mapping.getContentXML();
        }
        return null;
    }

    private boolean getUseSteuerXml(Mapping mapping) {
        if (mapping.getSteuerXML() != null) {
            return mapping.getSteuerXML().isUseSteuerXML();
        }
        return false;
    }

    private boolean getOutputUnzipped(Mapping mapping) {
        if (mapping.getOutputSIP() != null) {
            return mapping.getOutputSIP().isUnzipped();
        }
        return true;
    }

    private Mapping getMappingConfiguration(InputStream mappingFileInputStream) throws InvalidMappingException {
        if (mappingFileInputStream != null) {
            try {
                JAXBContext jaxbContext = JAXBContext.newInstance((String)CONTEXT_PATH_MAPPING);
                Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
                return (Mapping)jaxbUnmarshaller.unmarshal(mappingFileInputStream);
            }
            catch (JAXBException e) {
                throw new InvalidMappingException("cannot unmarshall mapping object due to: ", e);
            }
        }
        throw new InvalidMappingException("cannot find mapping file at: " + mappingFileInputStream);
    }

    private Map<String, LevelType> getMappedLevels(Mapping mapping) {
        return mapping.getLevel().stream().collect(Collectors.toUnmodifiableMap(LevelType::getJavaClass, Function.identity()));
    }

    private Map<String, MatterhornFieldType> getKeyValueMapping(Mapping mapping) {
        return mapping.getKeyValueMapping() == null ? Map.of() : mapping.getKeyValueMapping().getKeyValueEntry().stream().collect(Collectors.toUnmodifiableMap(KeyValueEntry::getKey, KeyValueEntry::getMatterhorn));
    }

    private Map<String, XpathMapper> getXpathMapperMap(Mapping mapping) {
        return mapping == null ? Map.of() : mapping.getXpathMapper().stream().collect(Collectors.toUnmodifiableMap(XpathMapper::getId, Function.identity()));
    }

    private FolderNameGenerator getFolderNameGenerator(Mapping mapping) {
        if (mapping.generateFolderName != null && mapping.generateFolderName.byMetadataPropertyOrByIntegerSequence != null) {
            Object folderNameGenerator = mapping.generateFolderName.byMetadataPropertyOrByIntegerSequence;
            if (folderNameGenerator instanceof ByMetadataProperty) {
                return new MetadataPropertyFolderNameGenerator();
            }
            if (folderNameGenerator instanceof ByIntegerSequence) {
                return new IntegerSequenceFolderNameGenerator(((ByIntegerSequence)folderNameGenerator).getNumberOfDigits());
            }
        }
        throw new InvalidMappingException("generateFolderName not defined");
    }

    private Mode getMode(Mapping mapping) {
        ExportMode mode = mapping.getMode() == null ? ExportMode.EDIDOC_MAPPING : mapping.getMode();
        switch (mode) {
            case EDIAKT_MAPPING: {
                return new Mode(sourcePath -> Files.list(sourcePath).findFirst().orElseThrow(), EdiaktType.class);
            }
        }
        return new Mode(sourcePath -> sourcePath.resolve("content.xml"), at.gv.e_government.reference.namespace.edidoc._20130808_.EdiaktType.class);
    }

    String getSaId() {
        return this.saId;
    }

    String getDssId() {
        return this.dssId;
    }

    boolean isOutputSIPUnzipped() {
        return this.outputSIPUnzipped;
    }

    boolean isUseSteuerXml() {
        return this.useSteuerXml;
    }

    ContentXML getContentXML() {
        return this.contentXML;
    }

    Map<String, LevelType> getMappedLevels() {
        return this.levelMap;
    }

    public XpathMapper getXpathMapper(String mapperId) {
        return this.xpathMapperMap.get(mapperId);
    }

    public Map<String, MatterhornFieldType> getKeyValueMap() {
        return this.keyValueMap;
    }

    public FolderNameGenerator getFolderNameGenerator() {
        return this.folderNameGenerator;
    }

    public Path findXmlForPath(Path path) throws IOException {
        return this.xmlFileFinder.findXmlFile(path);
    }

    public Class<?> getMappingClass() {
        return this.mappingClass;
    }

    private static class Mode {
        private final XmlFileFinder xmlFileFinder;
        private final Class<?> mappingClass;

        public Mode(XmlFileFinder xmlFileFinder, Class<?> mappingClass) {
            this.xmlFileFinder = xmlFileFinder;
            this.mappingClass = mappingClass;
        }

        public XmlFileFinder getXmlFileFinder() {
            return this.xmlFileFinder;
        }

        public Class<?> getMappingClass() {
            return this.mappingClass;
        }
    }
}

