/*
 * Decompiled with CFR 0.152.
 */
package ch.docuteam.mapping.util;

import ch.docuteam.darc.ead.C;
import ch.docuteam.darc.exceptions.MetadataElementIsNotAllowedException;
import ch.docuteam.darc.exceptions.MetadataElementIsNotDefinedException;
import ch.docuteam.darc.mdconfig.MetadataElement;
import ch.docuteam.darc.mdconfig.RDFMetadataValue;
import ch.docuteam.darc.mets.Document;
import ch.docuteam.darc.mets.amdsec.DigiprovWithPremis;
import ch.docuteam.darc.mets.filesec.File;
import ch.docuteam.darc.mets.filesec.FileSection;
import ch.docuteam.darc.mets.structmap.NodeAbstract;
import ch.docuteam.darc.sa.SubmissionAgreement;
import ch.docuteam.darc.sa.common.Contact;
import ch.docuteam.darc.sa.producer.Producer;
import ch.docuteam.tools.out.Logger;
import java.util.List;

public class MetsExportFacade {
    public static final String METADATA_ELEMENT_RETENTION_POLICY = "retentionPolicy";
    public static final String METADATA_ELEMENT_APPRAISAL_HOLD_RULE = "appraisalHoldRule";
    public static final String METADATA_ELEMENT_SUBJECT_GENERAL = "subjectGeneral";
    public static final String METADATA_ELEMENT_OBJECT_TYPE = "objectType";
    private static final String METADATA_ELEMENT_LANGUAGE = "language";
    private static final String METADATA_ELEMENT_ACCESS_RESTRICTION_STATUS = "accessRestrictionStatus";

    public static String getHeaderAdmId(Document metsDocument) {
        String headerAdmId = metsDocument.getHeader().getAdmId();
        return headerAdmId;
    }

    public static ch.docuteam.darc.premis.Object getHeaderPremisObject(Document metsDocument) {
        String headerAdmId = MetsExportFacade.getHeaderAdmId(metsDocument);
        ch.docuteam.darc.premis.Object premisObject = metsDocument.getAMDSection().getDigiprov(headerAdmId).getLastObject();
        return premisObject;
    }

    public static File getMetsFile(Document metsDocument, String id) {
        FileSection fileSection = metsDocument.getFileSection();
        return fileSection.getFile(id);
    }

    public static DigiprovWithPremis getDigiprovWithPremis(NodeAbstract nodeAbstract) {
        DigiprovWithPremis digiprov = nodeAbstract.getDocument().getAMDSection().getDigiprov(nodeAbstract.getAdmId());
        return digiprov;
    }

    public static ch.docuteam.darc.premis.Object getPremisObject(NodeAbstract nodeAbstract) {
        DigiprovWithPremis digiprov = MetsExportFacade.getDigiprovWithPremis(nodeAbstract);
        ch.docuteam.darc.premis.Object premisObject = digiprov.getLastObject();
        return premisObject;
    }

    public static C getEADComponent(NodeAbstract metsStructMapNode) {
        C eAD_C = metsStructMapNode.getMyDMDSectionWithEAD().getC();
        return eAD_C;
    }

    public static String getLanguage(NodeAbstract metsStructMapNode) {
        List languageList = MetsExportFacade.getEADComponent(metsStructMapNode).getLanguage();
        return MetsExportFacade.getEADMetadataElementValue(metsStructMapNode, languageList, METADATA_ELEMENT_LANGUAGE);
    }

    public static String getObjectType(NodeAbstract metsStructMapNode) {
        List objectTypeList = MetsExportFacade.getEADComponent(metsStructMapNode).getObjectType();
        return MetsExportFacade.getEADMetadataElementValue(metsStructMapNode, objectTypeList, METADATA_ELEMENT_OBJECT_TYPE);
    }

    public static String getSubjectGeneral(NodeAbstract metsStructMapNode) {
        List subjectGeneralList = MetsExportFacade.getEADComponent(metsStructMapNode).getSubjectGeneral();
        return MetsExportFacade.getEADMetadataElementValue(metsStructMapNode, subjectGeneralList, METADATA_ELEMENT_SUBJECT_GENERAL);
    }

    public static String getRententionPolicy(NodeAbstract metsStructMapNode) {
        List retentionPolicyList = MetsExportFacade.getEADComponent(metsStructMapNode).getRetentionPolicy();
        return MetsExportFacade.getEADMetadataElementValue(metsStructMapNode, retentionPolicyList, METADATA_ELEMENT_RETENTION_POLICY);
    }

    public static String getAppraisalHoldRule(NodeAbstract metsStructMapNode) {
        List appraisalHoldRuleList = MetsExportFacade.getEADComponent(metsStructMapNode).getAppraisalHoldRule();
        return MetsExportFacade.getEADMetadataElementValue(metsStructMapNode, appraisalHoldRuleList, METADATA_ELEMENT_APPRAISAL_HOLD_RULE);
    }

    public static String getAccessRestrictionStatus(NodeAbstract metsStructMapNode) {
        List accessRestrictionStatusList = MetsExportFacade.getEADComponent(metsStructMapNode).getAccessRestrictionStatus();
        return MetsExportFacade.getEADMetadataElementValue(metsStructMapNode, accessRestrictionStatusList, METADATA_ELEMENT_ACCESS_RESTRICTION_STATUS);
    }

    static String getEADMetadataElementValue(NodeAbstract metsStructMapNode, List<String> valueList, String metadataElementAccessorName) {
        String returnValue = null;
        if (valueList != null && valueList.size() > 0) {
            returnValue = RDFMetadataValue.getRDFValue((NodeAbstract)metsStructMapNode, (String)valueList.get(0), (String)metadataElementAccessorName);
        }
        return returnValue;
    }

    public static MetadataElement getMetadataElement(NodeAbstract metsStructMapNode, String name) {
        try {
            return metsStructMapNode.getLevel().getDynamicMetadataElement(name).getMetadataElement();
        }
        catch (MetadataElementIsNotAllowedException | MetadataElementIsNotDefinedException e) {
            Logger.error((Object)"getMetadataElement failed: ", (Throwable)e);
            return null;
        }
    }

    public static String getArchivalAgencyFromSubmissionAgreement(Document metsDocument) {
        SubmissionAgreement submissionAgreement = metsDocument.getSubmissionAgreement();
        return ((Contact)submissionAgreement.getArchive().getContacts().get(0)).getContactID();
    }

    public static String getTransferringAgencyFromSubmissionAgreement(Document metsDocument) {
        SubmissionAgreement submissionAgreement = metsDocument.getSubmissionAgreement();
        return ((Contact)((Producer)submissionAgreement.getProducers().get(0)).getContacts().get(0)).getContactID();
    }
}

